
package jp.gr.java_conf.koto.util;

import java.util.*;
import java.io.*;

public class CommandLineChecker {
    private CommandLineParameter[] parameters;
    
    public CommandLineChecker(CommandLineParameter[] params, String[] args) {
        this.parameters = params;
        
        arguments = new ArrayList(args.length);
        int i = 0;
        for (; i < args.length; i++) {
            String arg = args[i];
            if (arg.equals("--") ) {
                break;
            } else if (arg.startsWith("--") ) {
                String option = arg.substring(2);
                int j = 0;
                for (; j < params.length; j++) {
                    CommandLineParameter clp = params[j];
                    if (option.equals(clp.string)) {
                        clp.hitCount++;
                        if (clp.parameter != null) {
                            if (++i < args.length)
                                clp.argument = args[i];
                            else
                                System.err.println("argument of option '" + option + "' is missing, ignored.");
                        }
                        break;
                    }
                }
                if (j >= params.length)
                    arguments.add(arg);
            } else if (arg.startsWith("-") ) {
            loop:
                for (int j = 1; j < arg.length(); j++) {
                    char ch = arg.charAt(j);
                    int k = 0;
                    for (; k < params.length; k++) {
                        CommandLineParameter clp = params[k];
                        if (clp.character == ch) {
                            clp.hitCount++;
                            if (clp.parameter != null) {
                                if (++j < arg.length())
                                    clp.argument = arg.substring(j, arg.length());
                                else if (++i < args.length)
                                    clp.argument = args[i];
                                else
                                    System.err.println("argument of option '" + ch + "' is missing, ignored.");
                                break loop;
                            }
                            break;
                        }
                    }
                    if (k >= params.length)
                        System.err.println("unknown option '" + ch + "' in '" + arg + "', ignored.");
                }
            } else {
                arguments.add(arg);
            }
        }
        for (; i < args.length; i++) {
            String arg = args[i];
            arguments.add(arg);
        }
        
        optionCount = new HashMap();
        optionArguments = new HashMap();
        for (int k = 0; k < params.length; k++) {
            CommandLineParameter clp = params[k];
            optionCount.put(clp.string, new Integer(clp.hitCount));
            optionArguments.put(clp.string, clp.argument);
        }
    }
    
    private final List arguments;
    public List arguments() {
        return arguments;
    }
    
    private final Map optionCount;
    public int countOf(String option) throws NoSuchElementException {
        Integer result = (Integer) optionCount.get(option);
        if (result == null)
            throw new NoSuchElementException(option);
        return result.intValue();
    }
    
    private final Map optionArguments;
    public String argumentOf(String option) throws NoSuchElementException {
        return (String) optionArguments.get(option);
    }
    
    public void printOptionUsage(boolean printHiddenOptions) {
        PrintWriter writer = new PrintWriter(System.out);
        printOptionUsage(writer, printHiddenOptions);
        writer.flush();
    }
    public void printOptionUsage(PrintWriter writer, boolean printHiddenOptions) {
        if (parameters.length == 0)
            return;
        
        int maximumLength = 0;
        for (int i = 0; i < parameters.length; i++) {
            CommandLineParameter clp = parameters[i];
            if (printHiddenOptions || !clp.hidden) {
                int length = clp.string.length();
                if (clp.parameter != null)
                    length += clp.parameter.length() + 3;   // length of " <" and ">"
                maximumLength = Math.max(maximumLength, length);
            }
        }
        
        if (parameters.length == 1)
            writer.println("Option:");
        else
            writer.println("Options:");
        for (int i = 0; i < parameters.length; i++) {
            CommandLineParameter clp = parameters[i];
            if (!printHiddenOptions && clp.hidden)
                continue;
            
            writer.print("  ");
            if (clp.character != '\0') {
                writer.print("-");
                writer.print(clp.character);
                if (clp.string != null)
                    writer.print(", ");
                else
                    writer.print("  ");
            } else {
                writer.print("    ");
                //           "-x, "
            }
            int length = 0;
            if (clp.string != null) {
                writer.print("--");
                length = 2;     // length of "--"
                writer.print(clp.string);
                length += clp.string.length();
                if (clp.parameter != null) {
                    writer.print(" <");
                    writer.print(clp.parameter);
                    writer.print(">");
                    length += clp.parameter.length() + 3;   // length of " <" and ">"
                }
            }
            for (int j = length; j < maximumLength + 4; j++)
                writer.print(' ');
            
            writer.println(clp.message);
        }
    }
    
}

