
package jp.gr.java_conf.koto.notavacc.util;

import java.util.*;

public final class TreeStackSet extends AbstractSet {
    public static final TreeStackSet EMPTY_SET = new TreeStackSet(null, null, 0);
    
    private final TreeStackSet parent;
    private final Object value;
    private final int size;
    private TreeStackSet(TreeStackSet parent, Object value, int size) {
        this.parent = parent;
        this.value = value;
        this.size = size;
    }
    private TreeStackSet(TreeStackSet parent, Object value) {
        this(parent, value, parent.size() + 1);
    }
    
    public static TreeStackSet push(TreeStackSet stack, Object value) {
        if (stack.contains(value))
            return stack;
        return new TreeStackSet(stack, value);
    }
    
    public int size() {
        return size;
    }
    public Iterator iterator() {
        return new CascadeSetIterator(this);
    }
    
    private static class CascadeSetIterator implements Iterator {
        private TreeStackSet cursor;
        public CascadeSetIterator(TreeStackSet set) {
            this.cursor = set;
        }
        public boolean hasNext() {
            return !cursor.isEmpty();
        }
        public Object next() {
            Object result = cursor.value;
            cursor = cursor.parent;
            return result;
        }
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
    
    public static TreeStackSet pushAll(TreeStackSet stack, TreeStackSet data) {
        if (data.isEmpty())
            return stack;
        return push(pushAll(stack, data.parent), data.value);
    }
    
}
