
package jp.gr.java_conf.koto.notavacc.util;

import java.util.*;

public class TreeStack extends AbstractCollection {
    public static final TreeStack EMPTY_STACK = new TreeStack(null, null, 0);
    
    private final TreeStack parent;
    private final Object value;
    private final int hashCode;
    private final int size;
    private TreeStack(TreeStack parent, Object value, int size) {
        this.parent = parent;
        this.value = value;
        this.hashCode = (value == null) ? 0 : value.hashCode();
        this.size = size;
    }
    private TreeStack(TreeStack parent, Object value) {
        this(parent, value, parent.size() + 1);
    }
    
    public static TreeStack push(TreeStack stack, Object value) {
        return new TreeStack(stack, value);
    }
    public static TreeStack pushAll(TreeStack stack, Collection values) {
        Iterator it0 = values.iterator();
        while (it0.hasNext()) {
            Object value = (Object) it0.next();
            stack = push(stack, value);
        }
        return stack;
    }
    
    public static TreeStack append(TreeStack stack, TreeStack values) {
        if (values.isEmpty())
            return stack;
        return push(append(stack, values.parent), values.value);
    }
    
    public Object top() {
        assert !isEmpty();
        return value;
    }
    
    public static TreeStack pop(TreeStack stack) {
        return stack.parent;
    }
    
    public int count(Object value) {
        int result = 0;
        TreeStack stack = this;
        if (value == null) {
            while (stack.parent != null) {
                if (stack.value == null)
                    result++;
            }
        } else {
            int hashCode = value.hashCode();
            while (stack.parent != null) {
                if (hashCode == stack.hashCode && value.equals(stack.value))
                    result++;
                stack = stack.parent;
            }
        }
        return result;
    }
    
    public boolean contains(Object value) {
        TreeStack stack = this;
        if (value == null) {
            while (stack.parent != null) {
                if (stack.value == null)
                    return true;
            }
        } else {
            int hashCode = value.hashCode();
            while (stack.parent != null) {
                if (hashCode == stack.hashCode && value.equals(stack.value))
                    return true;
                stack = stack.parent;
            }
        }
        return false;
    }
    
    public int size() {
        return size;
    }
    public Iterator iterator() {
        return new TreeStackIterator(this);
    }
    
    private static class TreeStackIterator implements Iterator {
        private TreeStack cursor;
        public TreeStackIterator(TreeStack set) {
            this.cursor = set;
        }
        public boolean hasNext() {
            return !cursor.isEmpty();
        }
        public Object next() {
            Object result = cursor.value;
            cursor = cursor.parent;
            return result;
        }
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
    
}
