
package jp.gr.java_conf.koto.notavacc.util;

import java.util.*;

public class MultiMap extends LinkedHashMap {
    public MultiMap() {
    }
    public MultiMap(MultiMap master) {
        merge(master);
    }
    
    public boolean add(Object key, Object value) {
        Set set = (Set) this.get(key);
        if (set == null) {
            set = new LinkedHashSet();
            this.put(key, set);
        }
        return set.add(value);
    }
    public boolean addAll(Object key, Collection values) {
        if (values.isEmpty())
            return false;
        Set set = (Set) this.get(key);
        if (set == null) {
            set = new LinkedHashSet();
            this.put(key, set);
        }
        return set.addAll(values);
    }
    public boolean merge(MultiMap map) {
        boolean modified = false;
        Iterator it0 = map.entrySet().iterator();
        while (it0.hasNext()) {
            Map.Entry entry = (Map.Entry) it0.next();
            modified |= this.addAll(entry.getKey(), (Set) entry.getValue());
        }
        return modified;
    }
    
    public Set getValueSet(Object key) {
        return (Set) get(key);
    }
}


