
package jp.gr.java_conf.koto.notavacc.types;

import java.util.*;
import jp.gr.java_conf.koto.notavacc.*;
import jp.gr.java_conf.koto.notavacc.util.*;
import jp.gr.java_conf.koto.notavacc.lrg.*;
import jp.gr.java_conf.koto.notavacc.types.*;
import jp.gr.java_conf.koto.notavacc.parser.Parser.*;
import jp.gr.java_conf.koto.notavacc.parser.Original.*;
import jp.gr.java_conf.koto.notavacc.parser.Parser.Root;

public class TypeSystemGenerator extends Module {
    private final boolean tiger;
    public TypeSystemGenerator(Environment env, boolean tiger) {
        super(env);
        this.tiger = tiger;
    }
    
    private Root root;
    public TypeSystem generate(Root root, Set usedTypeNonterminals) {
        this.root = root;
        
        logger.verbose(environment.processingFile, "generating types.");
        
        // create objects.
        Map definitionToType = new LinkedHashMap();
        Iterator it0 = root.typeDefinitions().iterator();
        while (it0.hasNext()) {
            TypeDefinition definition = (TypeDefinition) it0.next();
            String name = root.getCanonicalName(definition);
            TypeNonterminal nonterminal = new TypeNonterminal(name);
            if (!usedTypeNonterminals.contains(nonterminal))
                nonterminal = null;
            GeneratedType type = new GeneratedType(definition.identifier(), name, nonterminal);
            definitionToType.put(definition, type);
        }
        
        // build inheritance tree.
        Iterator it1 = definitionToType.entrySet().iterator();
        while (it1.hasNext()) {
            Map.Entry entry = (Map.Entry) it1.next();
            TypeDefinition definition = (TypeDefinition) entry.getKey();
            GeneratedType type = (GeneratedType) entry.getValue();
            type.isProtected = (definition.protectedKeyword() != null);
            type.isPrivate = (definition.privateKeyword() != null);
            type.isProtectedParsable = (definition.protectedParsableKeyword() != null);
            type.isAbstract = (definition.abstractKeyword() != null);
            type.superTypes = new LinkedHashSet();
            //System.out.println("# " + type.getName() + " " + type.superTypes);
            
            if (definition.superTypes().isEmpty()) {
                type.superTypes.add(NodeType.INSTANCE);
            } else {
                Iterator it2 = definition.superTypes().iterator();
                while (it2.hasNext()) {
                    TypeName name = (TypeName) it2.next();
                    TypeDefinition superDefinition = root.getDefinition(name);
                    if (getSuperTypeDefinitions(superDefinition).contains(definition)) {
                        logger.error("{0} should not extend {1}.", name.identifier(), definition.identifier());
                    } else {
                        GeneratedType superType = (GeneratedType) definitionToType.get(superDefinition);
                        type.superTypes.add(superType);
                    }
                }
            }
        }
        if (logger.hasError())
            logger.fatal();
        
        // bind fields
        Iterator it3 = definitionToType.keySet().iterator();
        while (it3.hasNext()) {
            TypeDefinition definition = (TypeDefinition) it3.next();
            bindType(definition, definitionToType);
        }
        
        // build result object.
        Map nameToType = new LinkedHashMap();
        Iterator it18 = definitionToType.values().iterator();
        while (it18.hasNext()) {
            GeneratedType type = (GeneratedType) it18.next();
            nameToType.put(type.getName(), type);
        }
        
        logger.verbose(environment.processingFile, "generated.  {0} types.", new Integer(nameToType.size()));
        
        return new GeneratedTypeSystem(nameToType);
    }
    private Set getSuperTypeDefinitions(TypeDefinition definition) {
        Set result = new LinkedHashSet();
        getSuperTypeDefinitions(result, definition);
        return result;
    }
    private void getSuperTypeDefinitions(Set result, TypeDefinition definition) {
        if (result.add(definition)) {
            Iterator it2 = definition.superTypes().iterator();
            while (it2.hasNext()) {
                TypeName name = (TypeName) it2.next();
                TypeDefinition superDefinition = root.getDefinition(name);
                getSuperTypeDefinitions(result, superDefinition);
            }
        }
    }
    
    private static class GeneratedType extends UserDefinedType {
        public final Token hint;
        
        public GeneratedType(Token hint, String name, TypeNonterminal typeNonterminal) {
            this.hint = hint;
            this.name = name;
            this.typeNonterminal = typeNonterminal;
        }
        
        private final String name;
        public String getName() {
            return name;
        }
        
        private final TypeNonterminal typeNonterminal;
        public TypeNonterminal getTypeNonterminal() {
            return typeNonterminal;
        }
        
        private Set superTypes = null;
        public Set getDirectSuperTypes() {
            return superTypes;
        }
        public boolean isAbstract;
        public boolean isAbstract() {
            return isAbstract;
        }
        public boolean isProtected;
        public boolean isProtected() {
            return isProtected;
        }
        public boolean isPrivate;
        public boolean isPrivate() {
            return isPrivate;
        }
        public boolean isProtectedParsable;
        public boolean isProtectedParsable() {
            return isProtectedParsable;
        }
        private Set declaredFields = null;
        public Set getDeclaredFields() {
            return declaredFields;
        }
        private Map nameToField = null;
        public Map getMapNameToField() {
            return nameToField;
        }
    }
    
    private static class GeneratedField extends Field {
        public final Token hint;
        public GeneratedField(Type owner, String name, Type type, Token hint) {
            super(owner, name, type);
            this.hint = hint;
        }
    }
    
    private static class GeneratedTypeSystem implements TypeSystem {
        private Map nameToType;
        public GeneratedTypeSystem(Map nameToType) {
            this.nameToType = nameToType;
        }
        public Map getMapNameToType() {
            return nameToType;
        }
    }
    
    private Map fieldToHint = new HashMap();
    private void bindType(TypeDefinition definition, Map definitionToType) {
        GeneratedType target = (GeneratedType) definitionToType.get(definition);
        if (target.declaredFields != null)
            return;
        
        Iterator it2 = definition.superTypes().iterator();
        while (it2.hasNext()) {
            TypeName name = (TypeName) it2.next();
            TypeDefinition superDefinition = root.getDefinition(name);
            bindType(superDefinition, definitionToType);
        }
        
        //System.out.println(definition.identifier());
        
        Map labelToHint = new LinkedHashMap();
        MultiMap labelToTypes = new MultiMap();
        Map labelToCount = new HashMap();
        TreeStackSet EMPTY_SET = TreeStackSet.EMPTY_SET;
        getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, TreeStack.EMPTY_STACK, EMPTY_SET, EMPTY_SET, definition.expression(), EMPTY_SET, definitionToType);
        Map nameToHint = labelToHint;
        MultiMap nameToTypes = labelToTypes;
        Map nameToCount = labelToCount;
        
        MultiMap nameToInheritingTypes = new MultiMap();
        MultiMap nameToInheritingFields = new MultiMap();
        Iterator it9 = target.superTypes.iterator();
        while (it9.hasNext()) {
            Type superType = (Type) it9.next();
            Iterator it10 = superType.getMapNameToField().values().iterator();
            while (it10.hasNext()) {
                GeneratedField field = (GeneratedField) it10.next();
                String name = field.getName();
                nameToInheritingFields.add(name, field);
                Type type = field.getType();
                if (type instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType) type;
                    type = arrayType.getComponentType();
                    assert !(type instanceof ArrayType);
                    if (nameToTypes.containsKey(name)) {
                        nameToCount.put(name, new Integer(2));
                    }
                } else {
                    Integer integer = (Integer) nameToCount.get(name);
                    if (integer != null && integer.intValue() > 1) {
                        Token hint = (Token) nameToHint.get(name);
                        Object superTypeHint;
                        if (superType instanceof GeneratedType) {
                            GeneratedType gt = (GeneratedType) superType;
                            superTypeHint = gt.hint;
                        } else {
                            assert false;   // the only user-defined type has a field.
                            superTypeHint = superType;
                        }
                        logger.error("The label {0} in {1}, overriding {2} in {3}, can not accept more than one node.", hint, target.hint, field.hint, superTypeHint);
                    }
                }
                nameToInheritingTypes.add(name, type);
            }
        }
        
        
        target.declaredFields = new LinkedHashSet();
        
        Iterator it11 = nameToTypes.entrySet().iterator();
        while (it11.hasNext()) {
            Map.Entry entry = (Map.Entry) it11.next();
            String name = (String) entry.getKey();
            Set types = (Set) entry.getValue();
            assert !types.isEmpty();
            
            //System.out.println("* " + target.getName() + " " + name + "  : " + types);
            
            Integer countInteger = (Integer) nameToCount.get(name);
            boolean subclassable = tiger || (countInteger != null && countInteger.intValue() > 1);
            
            do {
                //System.out.println("types " + types);
                
                Set commonSuperTypes = null;
                Iterator it14 = types.iterator();
                while (it14.hasNext()) {
                    Type type = (Type) it14.next();
                    Set superTypes = new LinkedHashSet(type.getSuperTypes());
                    superTypes.add(type);
                    if (commonSuperTypes == null) {
                        commonSuperTypes = superTypes;
                    } else {
                        commonSuperTypes.retainAll(superTypes);
                    }
                }
                assert !commonSuperTypes.isEmpty();
                types = commonSuperTypes;
                
                //System.out.println("common types " + types);
                
                Set restricters = nameToInheritingTypes.getValueSet(name);
                if (restricters != null) {
                    Iterator it12 = restricters.iterator();
                    while (it12.hasNext()) {
                        Type restricter = (Type) it12.next();
                        Iterator it15 = types.iterator();
                        while (it15.hasNext()) {
                            Type type = (Type) it15.next();
                            if (subclassable) {
                                if (type.isSuperTypeOf(restricter))
                                    it15.remove();
                            } else {
                                if (!type.equals(restricter))
                                    it15.remove();
                            }
                        }
                    }
                }
                
                //System.out.println("restricted " + types);
                if (types.isEmpty())
                    break;
                
                Set removableSuperTypes = new LinkedHashSet();
                Iterator it13 = types.iterator();
                while (it13.hasNext()) {
                    Type type = (Type) it13.next();
                    removableSuperTypes.addAll(type.getSuperTypes());
                }
                types.removeAll(removableSuperTypes);
                //System.out.println("removed " + types);
            } while (types.size() > 1);
            
            if (types.isEmpty()) {
                Token hint = (Token) nameToHint.get(name);
                logger.error("The label {0} in {1}", hint, target.hint);
                Iterator it16 = nameToInheritingFields.getValueSet(name).iterator();
                while (it16.hasNext()) {
                    GeneratedField field = (GeneratedField) it16.next();
                    Type type = field.getType();
                    if (type instanceof ArrayType)
                        type = ((ArrayType) type).getComponentType();
                    Object ownerTypeHint;
                    if (field.getOwner() instanceof GeneratedType) {
                        GeneratedType gt = (GeneratedType) field.getOwner();
                        ownerTypeHint = gt.hint;
                    } else {
                        assert false;   // the only user-defined type has a field.
                        ownerTypeHint = field.getOwner();
                    }
                    logger.error("        is overriding {0} in {1} so should accept {2}.", field.hint, ownerTypeHint, type);
                }
                target.declaredFields.add(new GeneratedField(target, name, NodeType.INSTANCE, hint));
            } else {
                Type type = (Type) types.iterator().next();
                Token hint = (Token) nameToHint.get(name);
                Integer integer = (Integer) nameToCount.get(name);
                if (integer != null && integer.intValue() > 1)
                    target.declaredFields.add(new GeneratedField(target, name, new ArrayType(type), hint));
                else
                    target.declaredFields.add(new GeneratedField(target, name, type, hint));
            }
        }
        
        
        target.nameToField = new LinkedHashMap();
        
        Iterator it19 = target.declaredFields.iterator();
        while (it19.hasNext()) {
            GeneratedField field = (GeneratedField) it19.next();
            target.nameToField.put(field.getName(), field);
        }
        
        Iterator it17 = nameToInheritingTypes.entrySet().iterator();
        while (it17.hasNext()) {
            Map.Entry entry = (Map.Entry) it17.next();
            String name = (String) entry.getKey();
            Set types = (Set) entry.getValue();
            if (!target.nameToField.containsKey(name)) {
                // not declared explicitly, so inherit types.
                if (types.size() > 1) {
                    logger.error("{0} can not inherit conflicted labels ''{1}''.", target.hint, name);
                }
                GeneratedField field = (GeneratedField) nameToInheritingFields.getValueSet(name).iterator().next();
                target.nameToField.put(name, field);
            }
        }
    }
    
    private Set reportedError = new HashSet();
    private void getMapLabelToTypes(Map labelToHint, MultiMap labelToTypes, Map labelToCount, TreeStack opened, TreeStackSet argumentLabels, TreeStackSet labels, Expression expression, TreeStackSet typeRestrictors, Map definitionToType) {
        if (expression instanceof SelectiveExpression) {
            SelectiveExpression exp = (SelectiveExpression) expression;
            Set childLabels = new HashSet();
            List l2cMaps = new LinkedList();
            Iterator it4 = exp.operands().iterator();
            while (it4.hasNext()) {
                Expression operand = (Expression) it4.next();
                Map l2c = new LinkedHashMap();
                getMapLabelToTypes(labelToHint, labelToTypes, l2c, opened, argumentLabels, labels, operand, typeRestrictors, definitionToType);
                l2cMaps.add(l2c);
                childLabels.addAll(l2c.keySet());
            }
            Iterator it5 = childLabels.iterator();
            while (it5.hasNext()) {
                String label = (String) it5.next();
                int max = 0;
                Iterator it6 = l2cMaps.iterator();
                while (it6.hasNext()) {
                    Map l2c = (Map) it6.next();
                    Integer integer = (Integer) l2c.get(label);
                    if (integer != null)
                        max = Math.max(max, integer.intValue());
                }
                Integer integer = (Integer) labelToCount.get(label);
                if (integer != null)
                    max += integer.intValue();
                labelToCount.put(label, new Integer(max));
            }
            return;
        } else if (expression instanceof SequentialExpression) {
            SequentialExpression exp = (SequentialExpression) expression;
            Iterator it4 = exp.operands().iterator();
            while (it4.hasNext()) {
                Expression operand = (Expression) it4.next();
                getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, opened, argumentLabels, labels, operand, typeRestrictors, definitionToType);
            }
            return;
        } else if (expression instanceof PlusExpression) {
            PlusExpression exp = (PlusExpression) expression;
            Map l2c = new LinkedHashMap();
            getMapLabelToTypes(labelToHint, labelToTypes, l2c, opened, argumentLabels, labels, exp.operand(), typeRestrictors, definitionToType);
            Iterator it7 = l2c.entrySet().iterator();
            while (it7.hasNext()) {
                Map.Entry entry = (Map.Entry) it7.next();
                String label = (String) entry.getKey();
                Integer integer = (Integer) entry.getValue();
                int count = integer.intValue() * 2;
                integer = (Integer) labelToCount.get(label);
                if (integer != null)
                    count += integer.intValue();
                labelToCount.put(label, new Integer(count));
            }
            return;
        } else if (expression instanceof RestrictorExpression) {
            RestrictorExpression exp = (RestrictorExpression) expression;
            typeRestrictors = TreeStackSet.push(typeRestrictors, exp.typeRestrictor());
            getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, opened, argumentLabels, labels, exp.operand(), typeRestrictors, definitionToType);
            return;
        } else if (expression instanceof LabeledExpression) {
            LabeledExpression exp = (LabeledExpression) expression;
            String label = exp.label().getImage();
            if (label.equals("$label")) {
                labels = TreeStackSet.pushAll(labels, argumentLabels);
            } else {
                labels = TreeStackSet.push(labels, label);
                if (!labelToHint.containsKey(label))
                    labelToHint.put(label, exp.label());
            }
            getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, opened, argumentLabels, labels, exp.operand(), typeRestrictors, definitionToType);
            return;
        } else if (expression instanceof EmbedExpression) {
            EmbedExpression exp = (EmbedExpression) expression;
            getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, opened, argumentLabels, labels, exp.operand(), typeRestrictors, definitionToType);
            return;
        } else if (expression instanceof TagExpression) {
            TagExpression exp = (TagExpression) expression;
            getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, opened, argumentLabels, labels, exp.operand(), typeRestrictors, definitionToType);
            return;
        } else if (expression instanceof IdentifierExpression) {
            IdentifierExpression exp = (IdentifierExpression) expression;
            Definition def = root.getDefinition(exp.name());
            if (def instanceof TypeDefinition) {
                TypeDefinition d = (TypeDefinition) def;
                GeneratedType type = (GeneratedType) definitionToType.get(d);
                Set types = new LinkedHashSet();
                types.add(type);
                
                Iterator it20 = typeRestrictors.iterator();
                while (it20.hasNext()) {
                    TypeName typeRestrictor = (TypeName) it20.next();
                    TypeDefinition restrictorDefinition = root.getDefinition(typeRestrictor);
                    GeneratedType restrictor = (GeneratedType) definitionToType.get(restrictorDefinition);
                    if (restrictor.isSubTypeOf(type)) {
                        if (reportedError.add(Arrays.asList(new Object[] { typeRestrictor, exp }))) {
                            logger.error("The restrictor {0} should be a supertype of the restricted type {1}.", typeRestrictor.identifier(), exp.name().identifier());
                        }
                    }
                    
                    types.add(restrictor);
                }
                
                Iterator it8 = labels.iterator();
                while (it8.hasNext()) {
                    String label = (String) it8.next();
                    labelToTypes.addAll(label, types);
                    int count = 1;
                    Integer integer = (Integer) labelToCount.get(label);
                    if (integer != null)
                        count += integer.intValue();
                    labelToCount.put(label, new Integer(count));
                }
                return;
            } else if (def instanceof AliasDefinition) {
                AliasDefinition d = (AliasDefinition) def;
                List key = Arrays.asList(new Object[] { labels, d, typeRestrictors });
                if (opened.count(key) > 2)
                    return;
                
                /*StringBuffer bb = new StringBuffer();
                for (int ii = 0; ii < opened.size(); ii++) {
                    bb.append("  ");
                }
                bb.append(key);
                System.out.println(bb);*/
                
                opened = TreeStack.push(opened, key);
                if (root.hasExplicitParameterLabel(d)) {
                    argumentLabels = labels;
                    labels = TreeStackSet.EMPTY_SET;
                } else {
                    argumentLabels = TreeStackSet.EMPTY_SET;
                }
                
                getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, opened, argumentLabels, labels, d.expression(), typeRestrictors, definitionToType);
                return;
            }
            assert (def instanceof TokenReservation);
            // fall.
        } else {
            assert (expression instanceof StringExpression);
            // fall.
        }
        
        assert (expression instanceof StringExpression) || (root.getDefinition(((IdentifierExpression) expression).name()) instanceof TokenReservation);
        
        Iterator it8 = labels.iterator();
        while (it8.hasNext()) {
            String label = (String) it8.next();
            labelToTypes.add(label, TokenType.INSTANCE);
            int count = 1;
            Integer integer = (Integer) labelToCount.get(label);
            if (integer != null)
                count += integer.intValue();
            labelToCount.put(label, new Integer(count));
        }
    }
    
    
}

