
package jp.gr.java_conf.koto.notavacc.types;

import java.util.*;

public abstract class Type {
    /*public abstract int hashCode();
    public abstract boolean equals(Object rhs);
    public abstract String toString();*/
    
    public abstract Set getDirectSuperTypes();
    public abstract Set getDeclaredFields();
    public abstract Map getMapNameToField();
    
    
    private Map nameToDeclaredField = null;
    public Field getDeclaredField(String name) {
        if (nameToDeclaredField == null) {
            nameToDeclaredField = new LinkedHashMap();
            Iterator it0 = getDeclaredFields().iterator();
            while (it0.hasNext()) {
                Field field = (Field) it0.next();
                nameToDeclaredField.put(field.getName(), field);
            }
        }
        return (Field) nameToDeclaredField.get(name);
    }
    
    public Field getField(String name) {
        return (Field) getMapNameToField().get(name);
    }
    
    
    private Set superTypes = null;
    public Set getSuperTypes() {
        if (superTypes == null) {
            superTypes = new LinkedHashSet();
            Iterator it1 = getDirectSuperTypes().iterator();
            while (it1.hasNext()) {
                Type superType = (Type) it1.next();
                superTypes.add(superType);
                superTypes.addAll(superType.getSuperTypes());
            }
        }
        return superTypes;
    }
    
    public boolean isSuperTypeOf(Type type) {
        return type.getSuperTypes().contains(this);
    }
    public boolean isSubTypeOf(Type type) {
        return this.getSuperTypes().contains(type);
    }
    
}

