
package jp.gr.java_conf.koto.notavacc.types;

import java.util.*;

public final class TokenType extends Type {
    public static final TokenType INSTANCE = new TokenType();
    
    private TokenType() {
    }
    
    public int hashCode() {
        return TokenType.class.getName().hashCode();
    }
    public boolean equals(Object rhs) {
        if (rhs == null)
            return false;
        return getClass().equals(rhs.getClass());
    }
    
    public String toString() {
        return "Token";
    }
    
    public Set getDirectSuperTypes() {
        return Collections.singleton(NodeType.INSTANCE);
    }
    public Set getDeclaredFields() {
        return Collections.EMPTY_SET;
    }
    public Map getMapNameToField() {
        return Collections.EMPTY_MAP;
    }
}

