
package jp.gr.java_conf.koto.notavacc.types;

import java.util.*;

public final class ObjectType extends Type {
    public static final ObjectType INSTANCE = new ObjectType();
    
    private ObjectType() {
    }
    
    public int hashCode() {
        return ObjectType.class.getName().hashCode();
    }
    public boolean equals(Object rhs) {
        if (rhs == null)
            return false;
        return getClass().equals(rhs.getClass());
    }
    
    public String toString() {
        return "Object";
    }
    
    public Set getDirectSuperTypes() {
        return Collections.EMPTY_SET;
    }
    public Set getDeclaredFields() {
        return Collections.EMPTY_SET;
    }
    public Map getMapNameToField() {
        return Collections.EMPTY_MAP;
    }
}

