
package jp.gr.java_conf.koto.notavacc.types;

import java.util.*;

public final class NodeType extends Type {
    public static final NodeType INSTANCE = new NodeType();
    
    private NodeType() {
    }
    
    public int hashCode() {
        return NodeType.class.getName().hashCode();
    }
    public boolean equals(Object rhs) {
        if (rhs == null)
            return false;
        return getClass().equals(rhs.getClass());
    }
    
    public String toString() {
        return "Node";
    }
    
    public Set getDirectSuperTypes() {
        return Collections.singleton(ObjectType.INSTANCE);
    }
    public Set getDeclaredFields() {
        return Collections.EMPTY_SET;
    }
    public Map getMapNameToField() {
        return Collections.EMPTY_MAP;
    }
}

