
package jp.gr.java_conf.koto.notavacc.types;

import java.util.*;

public final class ArrayType extends Type {
    private Type componentType;
    public ArrayType(Type componentType) {
        this.componentType = componentType;
    }
    
    public Type getComponentType() {
        return componentType;
    }
    
    private static int baseHash = ArrayType.class.getName().hashCode();
    public int hashCode() {
        return baseHash + componentType.hashCode();
    }
    public final boolean equals(Object rhs) {
        if (this == rhs)
            return true;
        if (rhs instanceof ArrayType)
            return equals((ArrayType) rhs);
        return false;
    }
    public boolean equals(ArrayType rhs) {
        return componentType.equals(rhs.componentType);
    }
    
    public String toString() {
        return componentType + "[]";
    }
    public Set getDirectSuperTypes() {
        return Collections.singleton(ObjectType.INSTANCE);
    }
    public Set getDeclaredFields() {
        return Collections.EMPTY_SET;
    }
    public Map getMapNameToField() {
        return Collections.EMPTY_MAP;
    }
}

