
package jp.gr.java_conf.koto.notavacc.lrg;

public abstract class Terminal extends Symbol {
    public static final Terminal EOF = new EOFTerminal();
    
    private final String name;
    public Terminal(String name) {
        this.name = name;
    }
    public String getName() {
        return name;
    }
    
    private static final int hashCodeBase = Terminal.class.getName().hashCode();
    public int hashCode() {
        return hashCodeBase + name.hashCode();
    }
    public boolean equals(Object rhs) {
        if (rhs == null)
            return false;
        if (this.getClass().equals(rhs.getClass()))
            return equals((Terminal) rhs);
        return false;
    }
    public boolean equals(Terminal rhs) {
        return name.equals(rhs.name);
    }
}

