
package jp.gr.java_conf.koto.notavacc.lrg;

import java.util.*;
import jp.gr.java_conf.koto.notavacc.parser.Original.*;

public abstract class LRTable {
    public static interface LRState {
        public Map symbolToNextState();
        public Map symbolToReductions();
        public Token tag();
    }
    public abstract interface Reduction {
        public Nonterminal reducedSymbol();
        public List labelSetList();
    }
    
    public abstract Map symbolToInitialState();
    public abstract LRState finalState();
    
    
    private Set states = null;
    public final Set states() {
        if (states == null) {
            states = new LinkedHashSet();
            getStates(states, symbolToInitialState().values());
        }
        return states;
    }
    private void getStates(Set result, Collection states) {
        Iterator it0 = states.iterator();
        while (it0.hasNext()) {
            LRState state = (LRState) it0.next();
            if (result.add(state))
                getStates(result, state.symbolToNextState().values());
        }
    }
    
    private Set symbols = null;
    private Set symbols() {
        if (symbols == null) {
            symbols = new LinkedHashSet();
            Iterator it1 = states().iterator();
            while (it1.hasNext()) {
                LRState state = (LRState) it1.next();
                symbols.addAll(state.symbolToNextState().keySet());
                symbols.addAll(state.symbolToReductions().keySet());
            }
        }
        return symbols;
    }
    private Set typeNonterminals = null;
    public final Set getTypeNonterminals() {
        if (typeNonterminals == null) {
            typeNonterminals = new LinkedHashSet();
            Iterator it2 = symbols().iterator();
            while (it2.hasNext()) {
                Symbol symbol = (Symbol) it2.next();
                if (symbol instanceof TypeNonterminal)
                    typeNonterminals.add(symbol);
            }
        }
        return typeNonterminals;
    }
    private Set aliasNonterminals = null;
    public final Set getAliasNonterminals() {
        if (aliasNonterminals == null) {
            aliasNonterminals = new LinkedHashSet();
            Iterator it2 = symbols().iterator();
            while (it2.hasNext()) {
                Symbol symbol = (Symbol) it2.next();
                if (symbol instanceof AliasNonterminal)
                    aliasNonterminals.add(symbol);
            }
        }
        return aliasNonterminals;
    }
    private Set anonymousNonterminals = null;
    public final Set getAnonymousNonterminals() {
        if (anonymousNonterminals == null) {
            anonymousNonterminals = new LinkedHashSet();
            Iterator it2 = symbols().iterator();
            while (it2.hasNext()) {
                Symbol symbol = (Symbol) it2.next();
                if (symbol instanceof AnonymousNonterminal)
                    anonymousNonterminals.add(symbol);
            }
        }
        return anonymousNonterminals;
    }
    
    private Set reductions = null;
    public final Set getReductions() {
        if (reductions == null) {
            reductions = new LinkedHashSet();
            Iterator it1 = states().iterator();
            while (it1.hasNext()) {
                LRState state = (LRState) it1.next();
                Iterator it3 = state.symbolToReductions().values().iterator();
                while (it3.hasNext()) {
                    Set set = (Set) it3.next();
                    reductions.addAll(set);
                }
            }
        }
        return reductions;
    }
}

