package jp.gr.java_conf.koto.notavacc.generator;

import java.util.*;
import java.io.*;
import java.math.*;
import jp.gr.java_conf.koto.io.*;
import jp.gr.java_conf.koto.notavacc.*;
import jp.gr.java_conf.koto.notavacc.util.*;
import jp.gr.java_conf.koto.notavacc.dfa.*;
import jp.gr.java_conf.koto.notavacc.dfa.DeterministicFiniteAutomaton.*;
import jp.gr.java_conf.koto.notavacc.lrg.*;
import jp.gr.java_conf.koto.notavacc.lrg.LRTable.*;
import jp.gr.java_conf.koto.notavacc.types.*;
import jp.gr.java_conf.koto.notavacc.parser.Original.*;
import jp.gr.java_conf.koto.notavacc.parser.Parser.*;
import jp.gr.java_conf.koto.notavacc.parser.Parser.Root;

public class JavaCodeGenerator extends CodeGenerator {
    private Root root;
    private DeterministicFiniteAutomaton dfa;
    private LRTable lrTable;
    private double targetVersion;
    public JavaCodeGenerator(Environment env, Root root, DeterministicFiniteAutomaton dfa, LRTable lrTable, TypeSystem typeSystem, double targetVersion) {
        super(env, root, dfa, lrTable, typeSystem);
        this.root = root;
        this.dfa = dfa;
        this.lrTable = lrTable;
        this.targetVersion = targetVersion;
    }
    
    
    /*private static String toJavaConstantNameStyle(String name) {
        char prev = '_';
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < name.length(); i++) {
            char ch = name.charAt(i);
            
            if (Character.isUpperCase(ch)) {
                if (Character.isLowerCase(prev)) {
                    result.append('_');             // e.g. FooURL to FOO_URL
                } else if (Character.isUpperCase(prev)) {
                    if (i + 1 < name.length()) {
                        char nextChar = name.charAt(i + 1);
                        if (Character.isLowerCase(nextChar)) {
                            result.append('_');     // e.g. URLBar to URL_BAR
                        }
                    }
                }
            }
            
            result.append(Character.toUpperCase(ch));
            prev = ch;
        }
        return result.toString();
    }*/
    
    private static String encodeForHTML(String image) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < image.length(); i++) {
            char ch = image.charAt(i);
            result.append("&#" + ((int) ch) + ";");
        }
        return result.toString();
    }
    private static String toHexCode(char ch) {
        String hex = "000" + Integer.toString(ch, 16).toUpperCase(Locale.ENGLISH);
        hex = hex.substring(hex.length() - 4);
        return hex;
    }
    
    private static String quoted(char ch) {
        StringBuffer quoted = new StringBuffer("\'");
        quoted(quoted, ch);
        quoted.append("\'");
        return quoted.toString();
    }
    private static String quoted(String str) {
        return quoted(str, true);
    }
    private static String quoted(String str, boolean quote) {
        StringBuffer quoted = new StringBuffer();
        if (quote)
            quoted.append("\"");
        for (int i = 0; i < str.length(); i++) {
            char ch = str.charAt(i);
            quoted(quoted, ch);
        }
        if (quote)
            quoted.append("\"");
        return quoted.toString();
    }
    private static void quoted(StringBuffer result, char ch) {
        switch (ch) {
        default:
            if (0x0020 <= ch && ch <= 0x007E) {
                result.append(ch);
            } else {
                result.append("\\u").append(toHexCode(ch));
            }
            break;
        case '\n':   result.append("\\n");      break;
        case '\t':   result.append("\\t");      break;
        case '\b':   result.append("\\b");      break;
        case '\r':   result.append("\\r");      break;
        case '\f':   result.append("\\f");      break;
        case '\\':   result.append("\\\\");     break;
        case '\'':   result.append("\\\'");     break;
        case '\"':   result.append("\\\"");     break;
        }
    }
    
    
    private Map replacements = new HashMap();
    public void addReplacement(String word, String replacement) {
        replacements.put(word, replacement /*+ "_unique"*/);
    }
    public String replace(String str) {
        StringBuffer result = new StringBuffer();
        int index = 0;
        int mode = -1;  // -1 for initial state, 0 for identifiers, 1 for the other tokens.
        for (int i = 0;; i++) {
            char ch;
            if (i < str.length())
                ch = str.charAt(i);
            else
                ch = '\0';
            boolean identifierPart = Character.isJavaIdentifierPart(ch);
            int nextMode = identifierPart ? 0 : 1;
            if (mode != -1 && (ch == '\0' || nextMode != mode)) {
                String sub = str.substring(index, i);
                if (mode == 0) {
                    String newSequence = (String) replacements.get(sub);
                    if (newSequence != null)
                        sub = newSequence;
                }
                result.append(sub);
                index = i;
            }
            mode = nextMode;
            if (i >= str.length())
                break;
        }
        
        return result.toString();
    }
    
    
    private List storePrinted = new LinkedList();
    public void println(String str) {
        storePrinted.add(str);
    }
    
    public void flush() throws IOException {
        Iterator it = storePrinted.iterator();
        while (it.hasNext()) {
            String str = (String) it.next();
            it.remove();
            
            str = replace(str);
            outputLine(str);
        }
    }
    
    private SafePrintWriter writer;
    private int indent = 0;
    private int temporalIndent = -1;
    private void outputLine(String str) throws IOException {
        str = str.trim();
        
        if (str.startsWith("}"))
            indent--;
        
        if (temporalIndent == -1)
            temporalIndent = indent;
        
        if (str.startsWith("case ") || str.startsWith("default:") || str.startsWith("default "))
            temporalIndent--;
        
        for (int i = 0; i < temporalIndent; i++)
            writer.print("    ");
        writer.println(str);
        temporalIndent = -1;
        
        if (str.endsWith("{")) {
            indent++;
        } else {
            if (str.startsWith("if ") || str.startsWith("while ") || str.startsWith("do ") || str.startsWith("for ")
                        || str.startsWith("if(") || str.startsWith("while(") || str.startsWith("do(") || str.startsWith("for(")
                        || str.equals("else") || str.startsWith("else "))
                temporalIndent = indent + 1;
        }
    }
    
    
    private String getBaseName(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(".");
        if (index > 0)
            name = name.substring(0, index);
        return name;
    }
    
    protected void generateCode(File file, Tables tables, boolean dryRun) throws IOException {
        if (!dryRun) {
            writer = new SafePrintWriter(new FileOutputStream(file));
        } else {
            writer = new SafePrintWriter(new StringWriter());
        }
        try {
            String name = getBaseName(environment.processingFile);
            generateCode(file, name, tables);
            flush();
        } finally {
            writer.close();
        }
    }
    
    private Map typeToName = new HashMap();
    private String getTypeName(Type type) {
        String result = (String) typeToName.get(type);
        if (result == null) {
            if (type instanceof ArrayType) {
                if (targetVersion >= 1.5) {
                    ArrayType arrayType = (ArrayType) type;
                    result = "java.util.List<" + getTypeName(arrayType.getComponentType()) + ">";
                } else {
                    result = "java.util.List";
                }
            } else if (type instanceof NodeType) {
                result = "$Parser.$Node";
            } else if (type instanceof TokenType) {
                result = "$Parser.$Token";
            } else if (type instanceof ObjectType) {
                result = "java.lang.Object";
            } else {
                UserDefinedType userDefinedType = (UserDefinedType) type;
                result = "$Parser." + userDefinedType.getName();
            }
            typeToName.put(type, result);
        }
        return result;
    }
    
    private static final Object RESERVED_NAME = new Object();
    private void reserve(String name, MultiMap namespace) {
        namespace.add(name, RESERVED_NAME);
        addReplacement("$" + name, name);
    }
    private void allocate(String name, MultiMap namespace) {
        String alocatedName = "__" + name + "__notavacc_reserved";
        namespace.add(alocatedName, RESERVED_NAME);
        addReplacement("$" + name, alocatedName);
    }
    
    private void generateCode(File file, String topLevelClassName, Tables tables) throws IOException {
        MultiMap topTypeNamespace = new MultiMap();
        MultiMap topFieldNamespace = new MultiMap();
        MultiMap topMethodNamespace = new MultiMap();
        MultiMap nodeFieldNamespace = new MultiMap();
        MultiMap nodeNoArgumentMethodNamespace = new MultiMap();
        MultiMap nodeMethodNamespace = new MultiMap();
        
        final boolean visitorSupport = true;
        final boolean replacementSupport = true;
        
        String packageName = root.getPackageName();
        addReplacement("$packageName", packageName);
        addReplacement("$Parser", topLevelClassName);
        topTypeNamespace.add(topLevelClassName, topLevelClassName);
        topTypeNamespace.add("java", RESERVED_NAME);
        topFieldNamespace.add("java", RESERVED_NAME);
        topMethodNamespace.add("java", RESERVED_NAME);
        nodeFieldNamespace.add("java", RESERVED_NAME);
        nodeNoArgumentMethodNamespace.add("java", RESERVED_NAME);
        nodeMethodNamespace.add("java", RESERVED_NAME);
        if (targetVersion >= 1.4) {
            addReplacement("$CharSequence", "java.lang.CharSequence");
            addReplacement("$AssertionError", "java.lang.AssertionError");
            addReplacement("$subSequence", "subSequence");
            addReplacement("$final_avoid_jdk12_bug", "final");
            addReplacement("$protected_avoid_jdk12_bug", "protected");
            addReplacement("$assert", "assert");
        } else {
            addReplacement("$CharSequence", "java.lang.StringBuffer");
            addReplacement("$AssertionError", "java.lang.RuntimeException");
            addReplacement("$subSequence", "substring");
            addReplacement("$final_avoid_jdk12_bug", " ");
            addReplacement("$protected_avoid_jdk12_bug", "public");
            addReplacement("$assert", "// ");
        }
        
        final int labelWordCount = tables.labelWordCount();
        
]]<<
        #if (packageName != null)
            package $packageName;
        
        /**
         * A syntax representation, generated by notavaCC >>[[ Version.VERSION ]]<<.  Licensed under >>[[ Version.LICENSE ]]<<.
         * <p>
        #{
            #List parsableTypes = new ArrayList(tables.userDefinedTypes().size());
            #Iterator it1 = tables.userDefinedTypes().iterator();
            #while (it1.hasNext()) {
                #UserDefinedType type = (UserDefinedType) it1.next();
                #LRState initialState = (LRState) lrTable.symbolToInitialState().get(type.getTypeNonterminal());
                #if (initialState != null) {
                    #parsableTypes.add(type);
                #}
            #}
            #for (int i = 0; i < parsableTypes.size(); i++) {
                #UserDefinedType type = (UserDefinedType) parsableTypes.get(i);
                #if (i == parsableTypes.size() - 1) {
                     * {@link $Parser#parse>>[[ type.getName() ]]<<}
                #} else if (i == parsableTypes.size() - 2) {
                     * {@link $Parser#parse>>[[ type.getName() ]]<<} and
                #} else {
                     * {@link $Parser#parse>>[[ type.getName() ]]<<},
                #}
            #}
            #if (parsableTypes.size() == 1) {
                 * parses a text and generates an abstruct syntax tree.
            #} else if (parsableTypes.size() > 1) {
                 * parse a text and generates an abstruct syntax tree.
            #}
        #}
         * Nodes of the tree is sub-types of {@link $Node}.
         * <p>
         * The class and any nested classes in the class are <strong>not synchronized</strong>.
         * 
         */
        public class $Parser {
            #if (root.hasProtectedConstructor()) {
                /**
                 * Constructs a parser.
                 */
                $Parser() {
                }
            #}
            #Map symbolToWord = new LinkedHashMap();
            #{
                #Terminal traditionalWhiteTerminal = new NamedTerminal("$WHITE_TOKEN");
                #Symbol[] symbols = tables.symbols();
                #for (int i = 0; i < symbols.length; i++) {
                    #Symbol symbol = symbols[i];
                    #int index = tables.getIndexOfSymbol(symbol);
                    #if (symbol instanceof EOFTerminal) {
                        #java.lang.String word = "EOF_TOKEN";
                        #symbolToWord.put(symbol, word);
                        /** Describes the EOF. */
                        public static final int >>[[ word ]]<< = >>[[ index ]]<<;
                        #topFieldNamespace.add(word, symbol);
                    #} else if (symbol.equals(traditionalWhiteTerminal)) {
                        #java.lang.String word = "WHITE_TOKEN";
                        #symbolToWord.put(symbol, word);
                        /** Describes the white tokens, which are typically comments or white spaces. */
                        public static final int >>[[ word ]]<< = >>[[ index ]]<<;
                        #topFieldNamespace.add(word, symbol);
                    #} else if (symbol instanceof NamedTerminal) {
                        #NamedTerminal terminal = (NamedTerminal) symbol;
                        #java.lang.String word = "TOKEN_" + terminal.getName();
                        #symbolToWord.put(symbol, word);
                        /** Describes the terminal >>[[ symbol ]]<<. */
                        public static final int >>[[ word ]]<< = >>[[ index ]]<<;
                        #topFieldNamespace.add(word, symbol);
                    #} else if (symbol instanceof TypeNonterminal) {
                        #TypeNonterminal nonterminal = (TypeNonterminal) symbol;
                        #symbolToWord.put(symbol, nonterminal.getName() + ".$ID");
                    #} else {
                        #assert (symbol instanceof StringTerminal) || (symbol instanceof AliasNonterminal) || (symbol instanceof AnonymousNonterminal);
                        #symbolToWord.put(symbol, Integer.toString(tables.getIndexOfSymbol(symbol)));
                    #}
                #}
            #}
            
            #Map tagToWord = new LinkedHashMap();
            #{
                #java.lang.String[] tags = tables.tags();
                #for (int i = 0; i < tags.length; i++) {
                    #java.lang.String tag = (java.lang.String) tags[i];
                    #java.lang.String word = "TAG_" + tag;
                    #tagToWord.put(tag, word);
                    public static final int >>[[ word ]]<< = >>[[ i ]]<<;
                    #topFieldNamespace.add(word, tag);
                #}
            #}
            
            /**
             * Creates a node.  This is a <a href='http://www.google.com/search&#63;q=factory+method'>factory method</a>.
             * <p>
             * The type of the node to create is described by <code>symbolID</code> as follows.
             * <table border=1>
             * <tr><th><code>symbolID</code></th><th>type to create</th></tr>
            #{
                #Iterator it0 = tables.userDefinedTypes().iterator();
                #while (it0.hasNext()) {
                    #UserDefinedType type = (UserDefinedType) it0.next();
                    #TypeNonterminal nonterminal = type.getTypeNonterminal();
                    #if (nonterminal != null) {
                         * <tr>
                         *   <td><code>>>[[ symbolToWord.get(nonterminal) ]]<<</code></td>
                         *   <td>{@link >>[[ getTypeName(type) ]]<<}</td>
                         * </tr>
                    #}
                #}
            #}
             * </table>
             * <p>
             * The implementation by the <code>$Parser</code> is equivalent to <code>$createNode(symbolID, parameters, false)</code>.
             * 
             * @param   symbolID
             *            the kind of the node to create.
             * @param   parameters
             *            the parameters to initialize the node.
             * @return  a created node.
             * @since   notavaCC 1.0
             */
            #reserve("createNode", topMethodNamespace);
            protected $Node $createNode(int symbolID, $NodeInitializationParameters parameters) throws $ParseException {
                return $createNode(symbolID, parameters, false);
            }
            
            /**
             * Creates a node.  The created node is a instance of a class in {@link $Parser.$Default}.
             * 
             * @param   symbolID
             *      the kind of the node to create.  See {@link #$createNode(int, $Parser.$NodeInitializationParameters)}.
             * @param   parameters
             *      the parameters to initialize the node.
             * @param   compact
             *      create a compact node, which have only labeled children.
             * @return  a created node.
             * @since    notavaCC 1.0
             */
            #reserve("createNode", topMethodNamespace);
            protected final $Parser.$Default.$Node $createNode(int symbolID, $NodeInitializationParameters parameters, boolean compact) {
                switch(symbolID) {
                    #{
                        #Iterator it0 = tables.userDefinedTypes().iterator();
                        #while (it0.hasNext()) {
                            #UserDefinedType type = (UserDefinedType) it0.next();
                            #TypeNonterminal nonterminal = type.getTypeNonterminal();
                            #if (nonterminal != null) {
                                case >>[[ symbolToWord.get(nonterminal) ]]<<:
                                    return new $Parser.$Default.>>[[ type.getName() ]]<<(parameters, compact);
                            #}
                        #}
                    #}
                }
                throw new $AssertionError("A node creation was failed.");
            }
            
            #reserve("getCharSequence", topMethodNamespace);
            #if (targetVersion >= 1.4) {
                protected final $CharSequence $getCharSequence(java.io.File file, java.lang.String charsetName) throws java.io.IOException, $ParseException {
                    java.io.FileInputStream fis = null;
                    java.io.InputStreamReader reader = null;
                    java.nio.channels.FileChannel fc = null;
                    try {
                        fis = new java.io.FileInputStream(file);
                        if (charsetName == null)
                            reader = new java.io.InputStreamReader(fis);
                        else
                            reader = new java.io.InputStreamReader(fis, charsetName);
                        java.nio.charset.Charset charset;
                        try {
                            charset = java.nio.charset.Charset.forName(reader.getEncoding());
                        } catch(java.nio.charset.UnsupportedCharsetException x) {
                            charset = null;
                        }
                        if (charset != null) {
                            java.nio.charset.CharsetDecoder decoder = charset.newDecoder();
                            fc = fis.getChannel();
                            int size = (int) fc.size();
                            java.nio.MappedByteBuffer bb = fc.map(java.nio.channels.FileChannel.MapMode.READ_ONLY, 0, size);
                            return decoder.decode(bb);
                        } else {
                            long length = file.length();
                            if (length <= 0)
                                length = 1;
                            else if (length > Integer.MAX_VALUE)
                                length = Integer.MAX_VALUE;
                            java.lang.StringBuffer result = new java.lang.StringBuffer((int) length);
                            char[] buffer = new char[1024];
                            for(;;) {
                                int size = reader.read(buffer);
                                if (size < 0)
                                    break;
                                result.append(buffer, 0, size);
                            }
                            return result;
                        }
                    } finally {
                        if (fc != null)
                            fc.close();
                        if (reader != null)
                            reader.close();
                        else if (fis != null)
                            fis.close();
                    }
                }
            #} else {
                protected final $CharSequence $getCharSequence(java.io.File file, java.lang.String charsetName) throws java.io.IOException, $ParseException {
                    java.io.FileInputStream fis = null;
                    java.io.InputStreamReader reader = null;
                    try {
                        fis = new java.io.FileInputStream(file);
                        if (charsetName == null)
                            reader = new java.io.InputStreamReader(fis);
                        else
                            reader = new java.io.InputStreamReader(fis, charsetName);
                        long length = file.length();
                        if (length <= 0)
                            length = 1;
                        else if (length > Integer.MAX_VALUE)
                            length = Integer.MAX_VALUE;
                        java.lang.StringBuffer result = new java.lang.StringBuffer((int) length);
                        char[] buffer = new char[1024];
                        for(;;) {
                            int size = reader.read(buffer);
                            if (size < 0)
                                break;
                            result.append(buffer, 0, size);
                        }
                        return result;
                    } finally {
                        if (reader != null)
                            reader.close();
                        else if (fis != null)
                            fis.close();
                    }
                }
            #}
            #reserve("getCharSequence", topMethodNamespace);
            protected final $CharSequence $getCharSequence(java.io.Reader reader) throws java.io.IOException, $ParseException {
                java.lang.StringBuffer result = new java.lang.StringBuffer();
                char[] buffer = new char[1024];
                for(;;) {
                    int size = reader.read(buffer);
                    if (size < 0)
                        break;
                    result.append(buffer, 0, size);
                }
                return result;
            }
            
            #reserve("createLexicalAnalyzer", topMethodNamespace);
            protected $Parser.$LexicalAnalyzer $createLexicalAnalyzer(java.lang.String sourceName, $CharSequence text, int tabStop) throws $ParseException {
                return new $Parser.$Default.$LexicalAnalyzer(sourceName, text, tabStop);
            }
            
            /**
             * Contains private fields that is used in order to create a node.
             * <p>
             * 
             * @since   notavaCC 1.0
             */
            #reserve("NodeInitializationParameters", topTypeNamespace);
            $protected_avoid_jdk12_bug static class $NodeInitializationParameters {
                private $NodeInitializationParameters() {
                }
                private $Node[] childNodes;
                private java.util.List labelsIDList;
            }
            #if (visitorSupport) {
                
                
                /**
                 * A visitor of <a href="http://www.google.com/search&#63;q=visitor+design+pattern">the visitor design pattern</a>.
                 * <p>
                 * This class has no method to override because the visit methods are dispatched by reflection.
                 * 
                 * @see     $Parser.$Node#accept($Parser.$Visitor)
                 * @since   notavaCC 1.0
                 */
                #reserve("Visitor", topTypeNamespace);
                public static class $Visitor {
                    /*
                    public void visit($Parser.$Node node) {
                    }
                    public void visit($Parser.$Token node) {
                    }
                    #{
                        #Iterator it0 = tables.userDefinedTypes().iterator();
                        #while (it0.hasNext()) {
                            #UserDefinedType type = (UserDefinedType) it0.next();
                            public void visit(>>[[ getTypeName(type) ]]<< node) {
                            }
                        #}
                    #}
                    */
                    
                    private $final_avoid_jdk12_bug java.util.Map typeToMethod;
                    public $Visitor() {
                        typeToMethod = new java.util.HashMap();
                        java.lang.Class clazz = this.getClass();
                        java.lang.reflect.Method[] methods = clazz.getMethods();
                        for (int i = 0; i < methods.length; i++) {
                            java.lang.reflect.Method method = methods[i];
                            if (!method.getDeclaringClass().equals($Parser.$Visitor.class)) {
                                if ((method.getModifiers() & java.lang.reflect.Modifier.PUBLIC) != 0) {
                                    if (method.getName().equals("visit") && method.getExceptionTypes().length == 0) {
                                        java.lang.Class[] parameterTypes = method.getParameterTypes();
                                        if (parameterTypes.length == 1) {
                                            java.lang.Class parameterType = parameterTypes[0];
                                            if ($Parser.$Node.class.isAssignableFrom(parameterType)) {
                                                method.setAccessible(true);
                                                typeToMethod.put(parameterType, method);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        
                    }
                    private final void visitAll($Parser.$Node node) {
                        java.lang.Object[] args = null;
                        java.util.Iterator it = typeToMethod.entrySet().iterator();
                        while (it.hasNext()) {
                            java.util.Map.Entry entry = (java.util.Map.Entry) it.next();
                            java.lang.Class parameterType = (java.lang.Class) entry.getKey();
                            if (parameterType.isInstance(node)) {
                                java.lang.reflect.Method method = (java.lang.reflect.Method) entry.getValue();
                                if (args == null)
                                    args = new java.lang.Object[] { node };
                                try {
                                    //System.out.println(node.getClass() + " " + method);
                                    method.invoke(this, args);
                                } catch (java.lang.IllegalAccessException x) {
                                    throw new $AssertionError(method + " and the enclosing class(es) should be public or accessible from $Parser.$Visitor."
                                        + "  Note that anonymous classes are not public.");
                                } catch (java.lang.reflect.InvocationTargetException x) {
                                    java.lang.Throwable targetException = x.getTargetException();
                                    if (targetException instanceof Error) {
                                        throw (java.lang.Error) targetException;
                                    } else {
                                        throw (java.lang.RuntimeException) targetException;
                                    }
                                }
                            }
                        }
                    }
                }
            #}
            
            /**
             * A node of the abstract syntax tree that is the result of parsing.
             * <p>
             * 
             * @since   notavaCC 1.0
             */
            #reserve("Node", topTypeNamespace);
            public static interface $Node {
                /**
                 * Returns the list of the child nodes of <code>this</code>.
                 * <p>
                 * The list may or may not be modifiable (It is specified by the subclasses).
                 * The order of nodes is specified by the subclasses.
                 * 
                 * @return  the list of the child nodes of <code>this</code>.
                 * @since   notavaCC 1.0
                 */
                #reserve("getChildNodes", nodeNoArgumentMethodNamespace);
                public java.util.List $getChildNodes();
                
                #if (visitorSupport) {
                    /**
                     * Traverses the (sub-)tree whose root is <code>this</code> node.
                     * <p>
                     * <code>this</code> node is passed to the <code>visitor</code>,
                     * then the child nodes are traversed recursively (preorder traversal).
                     * A node is passed to the methods of the <code>visitor</code>, using reflection,
                     * that is public, whose name is <code>visit</code>,
                     * that have only one argument whose type is compatible with <code>this</code> node,
                     * and that have no throws clause.
                     * 
                     * @param   visitor
                     *      a visitor.
                     * @since    notavacc 1.0
                     */
                    #reserve("accept", nodeMethodNamespace);
                    public void $accept($Visitor visitor);
                #}
                
                /**
                 * Returns the parent node of <code>this</code>, or null if and only if <code>this</code> node is the root of the tree.
                 * <p>
                 * This method simply returns the value the method {@link $Parser.$Node#$setParentNode} set, so the above specification should be maintained by the user of <code>this</code> object.
                 * 
                 * @return  the parent node of <code>this</code>, or null if <code>this</code> node is the root of the tree.
                 * @since   notavaCC 1.0
                 */
                #reserve("getParentNode", nodeNoArgumentMethodNamespace);
                public $Node $getParentNode();
                /**
                 * Sets the returned value of {@link #$getParentNode}.
                 * <p>
                 * 
                 * 
                 * @since   notavaCC 1.0
                 */
                #reserve("setParentNode", nodeMethodNamespace);
                public void $setParentNode($Node parentNode);
            } // interface $Node
            
            /**
             * A token, which is a part of a parsed text.
             * <p>
             * A token is a leaf of an abstract syntax tree.
             * 
             * @since   notavaCC 1.0
             */
            #reserve("Token", topTypeNamespace);
            public static interface $Token extends $Node {
                /**
                 * Returns the kind of <code>this</code> token.
                 * <p>
                 * The result value should be one of the followings:</p>
                 * <table border=1>
                 * <tr><th>value</th><th>described token</th></tr>
                #{
                    #Symbol[] symbols = tables.symbols();
                    #for (int i = 0; i < tables.superiorIndexOfTerminals(); i++) {
                        # Symbol symbol = symbols[i];
                         * <tr>
                         *   <td><code>>>[[ symbolToWord.get(symbol) ]]<<</code></td>
                         *   <td><tt>>>[[ encodeForHTML(symbol.toString()) ]]<<</tt></td>
                         * </tr>
                    #}
                #}
                 * </table>
                 * 
                 * @return  the kind of <code>this</code> token.
                 * @since   notavaCC 1.0
                 */
                public int getSymbolID();
                
                /**
                 * Returnds <code>true</code> if <code>this</code> is a white token. I.e., returns <code>true</code> if and only if <code>getSymbolID()</code> is one of the following:
                 * <ul>
                #{
                    #Symbol[] symbols = tables.symbols();
                    #for (int i = tables.firstIndexOfWhiteTerminals(); i < tables.superiorIndexOfWhiteTerminals(); i++) {
                        # Symbol symbol = symbols[i];
                         *   <li><code>>>[[ symbolToWord.get(symbol) ]]<<</code></li>
                    #}
                #}
                 * </ul>
                 * 
                 */
                public boolean isWhite();
                
                /**
                 * Returns the string <code>this</code> token corresponds to.
                 * If the string contains some meta notation like Unicode escapes, the returned value is the string represented by the notations.  If not, the returned value is the same as {@link #getOriginalImage()}.
                 * 
                 * @return  the string <code>this</code> token corresponds to.
                 * @see     $Parser.$Token#getOriginalImage()
                 * @since   notavaCC 1.0
                 */
                public java.lang.String getImage();
                
                /**
                 * Returns the string <code>this</code> token corresponds to.
                 * If the string contains some meta notation like Unicode escapes, the returned value is the notation on the parsed text.  If not, the returned value is the same as {@link #getImage()}.
                 * 
                 * @return  the string <code>this</code> token corresponds to.
                 * @see     $Parser.$Token#getImage()
                 * @since   notavaCC 1.0
                 */
                public java.lang.String getOriginalImage();
                
                /**
                 * Returns the source name <code>this</code> token coressponds to.
                 * 
                 * @return  the source name <code>this</code> token coressponds to.  E.g. the canonical name of the file.
                 * @throws   java.lang.UnsupportedOperationException
                 *      if the method is not suported.
                 * @since   notavaCC 1.0
                 */
                public java.lang.String getSourceName() throws java.lang.UnsupportedOperationException;
                
                /**
                 * Returns the zero-based index number in the source where <code>this</code> token begins.
                 * 
                 * @return  the index number in the source where <code>this</code> token begins.
                 * @throws   java.lang.UnsupportedOperationException
                 *      if the method is not suported.
                 * @since   notavaCC 1.0
                 */
                public int getIndex() throws java.lang.UnsupportedOperationException;
                /**
                 * Returns the one-based line number in the source where <code>this</code> token begins.
                 * 
                 * @return  the line number in the source where <code>this</code> token begins.
                 * @throws   java.lang.UnsupportedOperationException
                 *      if the method is not suported.
                 * @since   notavaCC 1.0
                 */
                public int getLine() throws java.lang.UnsupportedOperationException;
                /**
                 * Returns the one-based column number in the source where <code>this</code> token begins.
                 * 
                 * @return  the column number in the source where <code>this</code> token begins.
                 * @throws   java.lang.UnsupportedOperationException
                 *      if the method is not suported.
                 * @since   notavaCC 1.0
                 */
                public int getColumn() throws java.lang.UnsupportedOperationException;
                
                /**
                 * Returns the {@linkplain #getOriginalImage image} and the parenthesized position of <code>this</code> token if supported.
                 * E.g. <code>"'identifier' (line 2, column 3)"</code> or <code>"'identifier'"</code>.
                 * 
                 * @return  the {@linkplain #getOriginalImage image} and the parenthesized position of <code>this</code> token.
                 * @since   notavaCC 1.0
                 */
                public java.lang.String toString();
            } // interface $Token
            
            
            #int publicParsableTypeCount = 0;
            #{
                #reserve("ID", nodeFieldNamespace);
                #Iterator it1 = tables.userDefinedTypes().iterator();
                #while (it1.hasNext()) {
                    #UserDefinedType type = (UserDefinedType) it1.next();
                    #String scope = type.isProtected() ? "protected" : type.isPrivate() ? "private" : "public";
                    #String methodScope = type.isProtectedParsable() ? "protected" : "public";
                    #LRState initialState = (LRState) lrTable.symbolToInitialState().get(type.getTypeNonterminal());
                    #if (initialState != null) {
                        #if (methodScope.equals("public"))
                            #publicParsableTypeCount++;
                        /**
                         * parses a <code>>>[[ type.getName() ]]<<</code>.
                         */
                        #topMethodNamespace.add("parse" + type.getName(), type);
                        >>[[ methodScope ]]<< >>[[ getTypeName(type) ]]<< parse>>[[ type.getName() ]]<<(java.io.File file) throws java.io.IOException, $ParseException {
                            return parse>>[[ type.getName() ]]<<(file.getName(), file, null, 8);
                        }
                        /**
                         * parses a <code>>>[[ type.getName() ]]<<</code>.
                         */
                        >>[[ methodScope ]]<< >>[[ getTypeName(type) ]]<< parse>>[[ type.getName() ]]<<(java.lang.String sourceName, java.io.File file, java.lang.String charsetName, int tabStop) throws java.io.IOException, $ParseException {
                            return parse>>[[ type.getName() ]]<<(sourceName, $getCharSequence(file, charsetName), tabStop);
                        }
                        /**
                         * parses a <code>>>[[ type.getName() ]]<<</code>.  <code>reader</code> will not be closed.
                         */
                        >>[[ methodScope ]]<< >>[[ getTypeName(type) ]]<< parse>>[[ type.getName() ]]<<(java.lang.String sourceName, java.io.Reader reader, int tabStop) throws java.io.IOException, $ParseException {
                            return parse>>[[ type.getName() ]]<<(sourceName, $getCharSequence(reader), tabStop);
                        }
                        /**
                         * parses a <code>>>[[ type.getName() ]]<<</code>.
                         */
                        >>[[ methodScope ]]<< >>[[ getTypeName(type) ]]<< parse>>[[ type.getName() ]]<<(java.lang.String sourceName, $CharSequence seq, int tabStop) throws $ParseException {
                            $Parser.$LexicalAnalyzer analyzer = $createLexicalAnalyzer(sourceName, seq, tabStop);
                            return parse>>[[ type.getName() ]]<<(analyzer);
                        }
                        /**
                         * parses a <code>>>[[ type.getName() ]]<<</code>.
                         */
                        >>[[ methodScope ]]<< >>[[ getTypeName(type) ]]<< parse>>[[ type.getName() ]]<<($Parser.$LexicalAnalyzer analyzer) throws $ParseException {
                            int initialState = >>[[ tables.getIndexOfState(initialState) ]]<<;
                            int classSymbolMaximum = >>[[ tables.superiorIndexOfClassNonterminals() - 1 ]]<<;
                            return (>>[[ getTypeName(type) ]]<<) $parse($Parser.$lrTable, $Parser.$reductionTable, $Parser.$tagTable, initialState, classSymbolMaximum, analyzer);
                        }
                    #}
                    #StringBuffer extendedTypes = new StringBuffer();
                    #{
                        #boolean first = true;
                        #Iterator inner = type.getDirectSuperTypes().iterator();
                        #while (inner.hasNext()) {
                            #Type superType = (Type) inner.next();
                            #if (first)
                                #first = false;
                            #else
                                #extendedTypes.append(", ");
                            #extendedTypes.append(getTypeName(superType));
                        #}
                    #}
                    /**
                     * An abstract-syntax-tree node <code>>>[[ type.getName() ]]<<</code>.
                     */
                    #topTypeNamespace.add(type.getName(), type);
                    >>[[ scope ]]<< static interface >>[[ type.getName() ]]<< extends >>[[ extendedTypes ]]<< {
                        #TypeNonterminal nonterminal = type.getTypeNonterminal();
                        #if (nonterminal != null) {
                            /** The ID value of the type. */
                            public static final int $ID = >>[[ tables.getIndexOfSymbol(nonterminal) ]]<<;
                        #}
                        #Iterator it2 = type.getDeclaredFields().iterator();
                        #while (it2.hasNext()) {
                            #Field field = (Field) it2.next();
                            #java.lang.String typeName = getTypeName(field.getType());
                            #java.lang.String name = field.getName();
                            #if (field.getType() instanceof ArrayType) {
                                #ArrayType at = (ArrayType) field.getType();
                                /**
                                 * Returns the child nodes labeled by <code>>>[[ name ]]<<</code> in the notavaCC source.
                                 * If there is not such a one, the resut <code>isEmpty</code>.
                                 * The element of the result list is {@link >>[[ getTypeName(at.getComponentType()) ]]<<}.
                                 */
                            #} else {
                                /**
                                 * Returns the child node labeled by <code>>>[[ name ]]<<</code> in the notavaCC source.
                                 * If there is not such a one, the resut is <code>null</code>.
                                 */
                            #}
                            #nodeNoArgumentMethodNamespace.add(name, name);
                            public >>[[ typeName ]]<< >>[[ name ]]<<();
                        #}
                    }
                #}
            #}
            
            
            /**
             * Describes a error of a parsing.
             * <p>
             * 
             * @since   notavaCC 1.0
             */
            #reserve("ParseException", topTypeNamespace);
            public static class $ParseException extends java.lang.Exception {
                private final java.lang.String sourceName;
                private final int index;
                private final int line;
                private final int column;
                
                /**
                 * Constructs an exception.
                 * 
                 * @param   sourceName
                 *            the source name where the exception occured, or null if not supported.
                 * @param   index
                 *            the index number where the exception occured, or -1 if not supported.
                 * @param   line
                 *            the line number where the exception occured, or -1 if not supported.
                 * @param   column
                 *            the column number where the exception occured, or -1 if not supported.
                 * @since   notavaCC 1.0
                 */
                public $ParseException(java.lang.String msg, java.lang.String sourceName, int index, int line, int column) {
                    super(msg);
                    this.sourceName = sourceName;
                    this.index = index;
                    this.line = line;
                    this.column = column;
                }
                public $ParseException(java.lang.String msg, $Parser.$Token position) {
                    super(msg);
                    
                    java.lang.String sourceName = null;
                    int index = -1;
                    int line = -1;
                    int column = -1;
                    
                    try {
                        sourceName = position.getSourceName();
                    } catch (java.lang.UnsupportedOperationException x) {
                    }
                    try {
                        index = position.getIndex();
                    } catch (java.lang.UnsupportedOperationException x) {
                    }
                    try {
                        line = position.getLine();
                    } catch (java.lang.UnsupportedOperationException x) {
                    }
                    try {
                        column = position.getColumn();
                    } catch (java.lang.UnsupportedOperationException x) {
                    }
                    
                    this.sourceName = sourceName;
                    this.index = index;
                    this.line = line;
                    this.column = column;
                }
                
                /**
                 * Returns the source name where the exception occured.
                 * 
                 * @return  the source name where the exception occured.
                 * @throws   java.lang.UnsupportedOperationException
                 *      if the method is not suported.
                 * @since   notavaCC 1.0
                 */
                public final java.lang.String getSourceName() throws java.lang.UnsupportedOperationException {
                    if (sourceName == null)
                        throw new java.lang.UnsupportedOperationException();
                    return sourceName;
                }
                
                /**
                 * Returns the index number where the exception occured.
                 * 
                 * @return  the index number where the exception occured.
                 * @throws   java.lang.UnsupportedOperationException
                 *      if the method is not suported.
                 * @since   notavaCC 1.0
                 */
                public final int getIndex() throws java.lang.UnsupportedOperationException {
                    if (index == -1)
                        throw new java.lang.UnsupportedOperationException();
                    return index;
                }
                
                /**
                 * Returns the line number where the exception occured.
                 * 
                 * @return  the line number where the exception occured.
                 * @throws   java.lang.UnsupportedOperationException
                 *      if the method is not suported.
                 * @since   notavaCC 1.0
                 */
                public final int getLine() throws java.lang.UnsupportedOperationException {
                    if (line == -1)
                        throw new java.lang.UnsupportedOperationException();
                    return line;
                }
                
                /**
                 * Returns the column number where the exception occured.
                 * 
                 * @return  the column number where the exception occured.
                 * @throws   java.lang.UnsupportedOperationException
                 *      if the method is not suported.
                 * @since   notavaCC 1.0
                 */
                public final int getColumn() throws java.lang.UnsupportedOperationException {
                    if (column == -1)
                        throw new java.lang.UnsupportedOperationException();
                    return column;
                }
                
                /**
                 * Returns the GNU-Compiler-Collection-style string that describes the position of the error.
                 * <p>
                 * Throws an UnsupportedOperationException if getSourceName() is not supported.
                 * Otherwise, returns <code>getSourceName()</code> if getLine() is not supported.
                 * Otherwise, returns <code>getSourceName() + ":" + getLine()</code>.
                 * 
                 * @return
                 *      the GCC-style string describing the position of the error.
                 * @throws   UnsupportedOperationException
                 *      getSourceName() was not suppoted.
                 * @since   notavaCC 1.0
                 */
                public final String getGCCStylePositionString() throws java.lang.UnsupportedOperationException {
                    if (line == -1) {
                        return getSourceName();
                    } else {
                        return getSourceName() + ":" + line;
                    }
                }
                
                /**
                 * Indicates the source of the notavaCC, which generates this Java program, have ambiguity.
                 */
                public static class AmbiguousGrammarError extends $AssertionError {
                    public AmbiguousGrammarError(String message) {
                        super(message);
                    }
                }
            } // class $ParseException
            
            
            /**
             * Generates a sequence of {@linkplain $Parser.$Token tokens}.
             * 
             * @since   notavaCC 1.0
             */
            #reserve("LexicalAnalyzer", topTypeNamespace);
            public static abstract class $LexicalAnalyzer {
                /**
                 * Returns the next token in the sequence.
                 * If there is no tokens, the {@linkplain $Parser.$Token#getSymbolID() symbol ID} of the returned value should be {@link $Parser#EOF_TOKEN}, but the {@linkplain $Parser.$Token#getImage() image} or the {@linkplain $Parser.$Token#getIndex() index} etc. are not specified (may be {@linkplain java.lang.UnsupportedOperationException unsupported}).
                 * 
                 * @return  the next token in the sequence.
                 * @since   notavaCC 1.0
                 */
                public abstract $Token next() throws $ParseException;
            } // $LexicalAnalyzer
            
            
            /**
             * A namespace for the default implementations of the user-defined types.
             * 
             * @since   notavaCC 1.0
             */
            #reserve("Default", topTypeNamespace);
            public static interface $Default {
                #{
                    /**
                     * Provides a simple implementation of {@link $Parser.$Node}.
                     * 
                     * @since   notavaCC 1.0
                     */
                    public static abstract class $Node implements $Parser.$Node {
                        private java.util.List childNodes;
                        /**
                         * Constucts an instance.
                         * <p>
                         * The parent node of <code>childNodes</code> is set to <code>this</code>.
                         * 
                         * @param   childNodes
                         *            a list of child nodes, which is not copied and returned by {@link #$getChildNodes()}.
                         * @since   notavaCC 1.0
                         */
                        public $Node(java.util.List childNodes) {
                            this.childNodes = childNodes;
                            
                            java.util.Iterator it = childNodes.iterator();
                            while (it.hasNext()) {
                                $Parser.$Node node = ($Parser.$Node) it.next();
                                node.$setParentNode(this);
                            }
                        }
                        /**
                         * Returns the list given by the constructor.
                         *
                         * @since   notavaCC 1.0
                         */
                        public java.util.List $getChildNodes() {
                            return this.childNodes;
                        }
                        #if (visitorSupport) {
                            
                            public final void $accept($Visitor visitor) {
                                visitor.visitAll(this);
                                java.util.Iterator it = $getChildNodes().iterator();
                                while (it.hasNext()) {
                                    $Parser.$Node node = ($Parser.$Node) it.next();
                                    node.$accept(visitor);
                                }
                            }
                        #}
                        
                        private $Parser.$Node parentNode;
                        public $Parser.$Node $getParentNode() {
                            return parentNode;
                        }
                        public void $setParentNode($Parser.$Node parentNode) {
                            this.parentNode = parentNode;
                        }
                        
                        /**
                         * Replaces the child node <code>oldChild</code> with <code>newChild</code>.
                         * Correctly, the method replaces the sub-tree whose root is <code>oldChild</code>
                         * with the sub-tree whose root is <code>newChild</code>.
                         * <p>
                         * The method dose not replace only the element of {@link $Parser.$Node#$getChildNodes},
                         * but also the values returned by the methods that are
                         * defined by the classes in {@link $Parser}
                         * and that return the child node(s) labeled in the notavaCC source.
                         * <p>
                         * The method calls <code>newChild.$setParentNode(this)</code> and <code>oldChild.$setParentNode(null)</code>.
                         * 
                         * @param   oldChild
                         *            a replaced child node.
                         * @param   newChild
                         *            a child node to replace <code>oldChild</code>.
                         * @since   notavaCC 1.0
                         */
                        #reserve("replaceChild", nodeMethodNamespace);
                        protected void $replaceChild($Parser.$Node oldChild, $Parser.$Node newChild) {
                            if (oldChild != null)
                                oldChild.$setParentNode(null);
                            $replaceAll($getChildNodes(), oldChild, newChild);
                            if (newChild != null)
                                newChild.$setParentNode(this);
                        }
                        
                        /**
                         * Replaces the sub-tree whose root is <code>oldNode</code> with the sub-tree whose root is <code>this</code>.
                         * <p>
                         * The method calls <code>this.$setParentNode</code> and <code>oldNode.$setParentNode(null)</code>.
                         * <p>
                         * Precondition: <code>(oldNode.$getParentNode() instanceof $Default.$Node)</code> sould be <code>true</code>.
                         * 
                         * @param   oldNode
                         *            a node to replace.
                         * @throws  java.lang.IllegalStateException
                         *            <code>parent == null || !(parent instanceof $Default.$Node)</code>
                         * @since   notavaCC 1.0
                         */
                        #reserve("replace", nodeMethodNamespace);
                        public void $replace($Parser.$Node oldNode) throws java.lang.IllegalStateException {
                            $Parser.$Node newNode = this;
                            
                            $Parser.$Node parent = oldNode.$getParentNode();
                            if (parent == null || !(parent instanceof $Default.$Node))
                                throw new java.lang.IllegalStateException("oldNode.$getParentNode() should be a $Default.$Node.");
                            
                            $Default.$Node p = ($Default.$Node) parent;
                            p.$replaceChild(oldNode, newNode);
                        }
                        
                        public java.lang.String toString() {
                            java.io.StringWriter buffer = new java.io.StringWriter();
                            java.io.PrintWriter writer = new java.io.PrintWriter(buffer);
                            
                            $Parser.$Node node = this;
                            while (!(node instanceof $Parser.$Token)) {
                                if (node.getChildNodes().isEmpty()) {
                                    node = null;
                                    break;
                                }
                                node = ($Parser.$Node) node.getChildNodes().get(0);
                            }
                            if (node != null) {
                                $Parser.$Token token = ($Parser.$Token) node;
                                try {
                                    writer.print(token.getSourceName() + ":");
                                    writer.print(token.getLine() + ":");
                                    writer.println(token.getOriginalImage());
                                } catch (UnsupportedOperationException x) {
                                }
                            }
                            
                            toString(this, 0, writer);
                            writer.close();
                            if (writer.checkError())
                                throw new RuntimeException();
                            return buffer.toString();
                        }
                        private static void toString($Parser.$Node node, int indent, java.io.PrintWriter writer) {
                            for (int i = 0; i < indent; i++)
                                writer.print("  ");
                            
                            if (node instanceof $Token) {
                                $Token token = ($Token) node;
                                writer.println("token: " + token.getOriginalImage());
                            } else {
                                java.lang.String binaryName = node.getClass().getName();
                                binaryName = binaryName.substring(binaryName.lastIndexOf(".") + 1);
                                binaryName = binaryName.substring(binaryName.lastIndexOf("$") + 1);
                                writer.println(binaryName);
                                indent++;
                                java.util.Iterator it = node.$getChildNodes().iterator();
                                while (it.hasNext()) {
                                    $Parser.$Node n = ($Parser.$Node) it.next();
                                    toString(n, indent, writer);
                                }
                            }
                        }
                    } // $Default.$Node
                    
                    /**
                     * Provides a simple implementation of {@link $Parser.$Token}.
                     * 
                     * @since   notavaCC 1.0
                     */
                    public static class $Token extends $Default.$Node implements $Parser.$Token {
                        private final int symbolID;
                        private final java.lang.String image;
                        private final java.lang.String originalImage;
                        private final java.lang.String sourceName;
                        private final int index;
                        private final int line;
                        private final int column;
                        public $Token(int symbolID, java.lang.String image) {
                            this(symbolID, image, image, null, -1, -1, -1);
                        }
                        
                        /**
                         * Constructs a token.
                         * <p>
                         * 
                         * @param   symbolID
                         *      the symbol ID of the token, returned by <code>getSymbolID</code>.
                         * @param   image
                         *      the image string, returned by <code>getImage</code>.
                         * @param   originalImage
                         *      the image string, returned by <code>getOriginalImage</code>.
                         * @param   sourceName
                         *      the source name returned by <code>getSourceName</code>, or null if not supported.
                         * @param   index
                         *      the index returned by <code>getIndex</code>, or -1 if not supported.
                         * @param   line
                         *      the line number returned by <code>getLine</code>, or -1 if not supported.
                         * @param   column
                         *      the column number returned by <code>getColumn</code>, or -1 if not supported.
                         * @since   notavaCC 1.0
                         */
                        public $Token(int symbolID, java.lang.String image, java.lang.String originalImage, java.lang.String sourceName, int index, int line, int column) {
                            super(java.util.Collections.EMPTY_LIST);
                            this.symbolID = symbolID;
                            this.image = image;
                            this.originalImage = originalImage;
                            this.sourceName = sourceName;
                            this.index = index;
                            this.line = line;
                            this.column = column;
                        }
                        public $Token(int symbolID, java.lang.String image, java.lang.String originalImage, $Parser.$Token token) {
                            super(java.util.Collections.EMPTY_LIST);
                            String sourceName = null;
                            int index = -1;
                            int line = -1;
                            int column = -1;
                            try {
                                sourceName = token.getSourceName();
                            } catch (UnsupportedOperationException x) {
                            }
                            try {
                                index = token.getIndex();
                            } catch (UnsupportedOperationException x) {
                            }
                            try {
                                line = token.getLine();
                            } catch (UnsupportedOperationException x) {
                            }
                            try {
                                column = token.getColumn();
                            } catch (UnsupportedOperationException x) {
                            }
                            
                            this.symbolID = symbolID;
                            this.image = image;
                            this.originalImage = originalImage;
                            this.sourceName = sourceName;
                            this.index = index;
                            this.line = line;
                            this.column = column;
                        }
                        public int getSymbolID() {
                            return symbolID;
                        }
                        public boolean isWhite() {
                            return >>[[ tables.firstIndexOfWhiteTerminals() ]]<< <= symbolID && symbolID < >>[[ tables.superiorIndexOfWhiteTerminals() ]]<<;
                        }
                        public java.lang.String getImage() {
                            return image;
                        }
                        public java.lang.String getOriginalImage() {
                            return originalImage;
                        }
                        
                        
                        public java.lang.String getSourceName() throws java.lang.UnsupportedOperationException {
                            if (sourceName == null)
                                throw new java.lang.UnsupportedOperationException();
                            return sourceName;
                        }
                        public int getIndex() throws java.lang.UnsupportedOperationException {
                            if (index == -1)
                                throw new java.lang.UnsupportedOperationException();
                            return index;
                        }
                        public int getLine() throws java.lang.UnsupportedOperationException {
                            if (line == -1)
                                throw new java.lang.UnsupportedOperationException();
                            return line;
                        }
                        public int getColumn() throws java.lang.UnsupportedOperationException {
                            if (column == -1)
                                throw new java.lang.UnsupportedOperationException();
                            return column;
                        }
                        
                        public java.lang.String toString() {
                            java.lang.StringBuffer result = new java.lang.StringBuffer();
                            result.append("'");
                            result.append(getOriginalImage());
                            result.append("'");
                            
                            if (column != -1 || line != -1) {
                                result.append(" (");
                                if (line != -1) {
                                    result.append("line ");
                                    result.append(getLine());
                                    if (column != -1)
                                        result.append(", ");
                                }
                                if (column != -1) {
                                    result.append("column ");
                                    result.append(getColumn());
                                }
                                result.append(")");
                            }
                            return result.toString();
                        }
                    } // class $Default.$Token
                    
                    public static class $LexicalAnalyzer extends $Parser.$LexicalAnalyzer {
                        /** The sourceName given to the constructor. */
                        protected final java.lang.String sourceName;
                        /** The text given to the constructor. */
                        protected final $CharSequence text;
                        /** The end index of the target {@link #text} region. */
                        protected final int end;
                        /** The tabStop given to the constructor. */
                        protected final int tabStop;
                        /** The table given to the constructor. */
                        private final int[][] table;
                        /** The initialState given to the constructor. */
                        private final int initialState;
                        /** The zero-based index the {@linkplain #next() next} token begins at. */
                        protected int index;
                        /** The zero-based line number the {@linkplain #next() next} token begins at. */
                        protected int line;
                        /** The zero-based column number the {@linkplain #next() next} token begins at. */
                        protected int column;
                        /**
                         * Constructs a lexical analyzer with a given table.
                         * <p>
                         * 
                         * @param   sourceName
                         *      the name of the text.
                         * @param   text
                         *      the text to parse.
                         * @param   tabStop
                         *      the count of columns the tab character expands to.
                         * @since    notavaCC 1.0
                         */
                        public $LexicalAnalyzer(java.lang.String sourceName, $CharSequence text, int tabStop) {
                            this(sourceName, text, tabStop, 0, text.length(), 0, 0);
                        }
                        public $LexicalAnalyzer(java.lang.String sourceName, $CharSequence text, int tabStop, int start, int end, int line, int column) {
                            this(sourceName, text, tabStop, start, end, line, column, $Parser.$dfaTable, >>[[ tables.getIndexOfState(dfa.initialState()) ]]<<);
                        }
                        private $LexicalAnalyzer(java.lang.String sourceName, $CharSequence text, int tabStop, int start, int end, int line, int column, int[][] table, int initialState) {
                            this.sourceName = sourceName;
                            this.text = text;
                            this.end = end;
                            this.tabStop = tabStop;
                            this.table = table;
                            this.initialState = initialState;
                            this.index = start;
                            this.line = line;
                            this.column = column;
                        }
                        public $Parser.$Token next() throws $ParseException {
                            if (index >= end)
                                return new $Parser.$Default.$Token(EOF_TOKEN, "", "", sourceName, index, -1, -1);
                            
                            int state = initialState;
                            
                            final int startIndex = index;
                            final int startLine = line;
                            final int startColumn = column;
                            int lastHitID = -1;
                            int lastHitIndex = -1;
                            int lastHitLine = -1;
                            int lastHitColumn = -1;
                            int lastHitImageLength = 0;
                            StringBuffer image = new StringBuffer();
                            
                            try {
                            dfa:
                                while (index < end) {
                                    char ch = nextChar();
                                    image.append(ch);
                                    
                                    int[] map = table[state];
                                    int base = 1;
                                    int width = (map.length - 1) / 3;
                                    #java.lang.String dfaLinearSearchThreshold = environment.parameters.getProperty("JavaCodeGenerator.dfaLinearSearchThreshold", "3");
                                    while (width > >>[[ dfaLinearSearchThreshold ]]<<) {
                                        int halfWidth = width >> 1;
                                        int mid = base + halfWidth * 3;
                                        if (ch >= map[mid]) {
                                            base = mid;
                                            width -= halfWidth;
                                        } else {
                                            width = halfWidth;
                                        }
                                    }
                                    int i = 0;
                                    for (;;) {
                                        if (i++ >= width)
                                            break dfa;
                                        if (map[base] <= ch & ch <= map[base + 1]) {
                                            state = map[base + 2];
                                            break;
                                        }
                                        base += 3;
                                    }
                                    int hitID = table[state][0];
                                    if (hitID != -1) {
                                        lastHitID = hitID;
                                        lastHitIndex = index;
                                        lastHitLine = line;
                                        lastHitColumn = column;
                                        lastHitImageLength = image.length();
                                    }
                                }
                                
                                if (lastHitID == -1) {
                                    throw new $ParseException("An invalid character sequence starting with '" + text.$subSequence(startIndex, index) + "' (line " + (startLine + 1) + ", column " + (startColumn + 1) + ")", sourceName, startIndex, startLine + 1, startColumn + 1);
                                }
                            } finally {
                                index = startIndex;
                                line = startLine;
                                column = startColumn;
                            }
                            
                            $Parser.$Token result = new $Parser.$Default.$Token(lastHitID, image.substring(0, lastHitImageLength).intern(), text.$subSequence(startIndex, lastHitIndex).toString().intern(), sourceName, startIndex, startLine + 1, startColumn + 1);
                            
                            index = lastHitIndex;
                            line = lastHitLine;
                            column = lastHitColumn;
                            
                            return result;
                        } // next()
                        /**
                         * Returns the next character in the sequence.
                         * <p>
                         * This method returns the character starting at {@link #index} in the sequence and updates {@link #index}, {@link #line}, and {@link #column} to point the next character of the returned character.  This method is overridden in order to deal with a string as a character through the input sequence like Unicode escapes of Java.
                         * 
                         * @return  the next character in the sequence.
                         * @throws  java.lang.IndexOutOfBoundsException  if <code>index >= end</code>
                         * @since   notavaCC 1.0
                         */
                        protected char nextChar() throws $ParseException, java.lang.IndexOutOfBoundsException {
                            return nextExactChar();
                        }
                        protected final char nextUnicodeEscapedChar() throws ParseException, java.lang.IndexOutOfBoundsException {
                            int startIndex = index;
                            int startLine = line;
                            int startColumn = column;
                            int index = startIndex;
                            if (text.charAt(index) == '\\' && index + 1 < end && text.charAt(index + 1) == 'u') {
                                int count = 0;
                                while (index >= 0 && text.charAt(index--) == '\\')
                                    count++;
                                if (count % 2 == 0)
                                    return nextExactChar();
                            } else {
                                return nextExactChar();
                            }
                            
                            char ch = nextExactChar();
                            $assert (ch =='\\');
                            ch = nextExactChar();
                            $assert (ch == 'u');
                            try {
                                do {
                                    ch = nextExactChar();
                                } while (ch == 'u');
                                StringBuffer number = new StringBuffer(4);
                                number.append(ch);
                                number.append(nextExactChar());
                                number.append(nextExactChar());
                                number.append(nextExactChar());
                                int code = Integer.parseInt(number.toString(), 16);
                                return (char) code;
                            } catch (NumberFormatException x) {
                            } catch (IndexOutOfBoundsException x) {
                            }
                            throw new ParseException("illigal Unicode escape: " + text.$subSequence(startIndex, index), sourceName, startIndex, startLine, startColumn);
                        }
                        private final char nextExactChar() throws $ParseException, java.lang.IndexOutOfBoundsException {
                            if (index >= end)
                                throw new java.lang.IndexOutOfBoundsException();
                            char ch = text.charAt(index++);
                            switch (ch) {
                            case '\r':
                                if (index < end && text.charAt(index) == '\n')
                                    break;
                            case '\n':
                                line++;
                                column = 0;
                                break;
                            case '\t':
                                if (tabStop >= 1)
                                    column = column - (column % tabStop) + tabStop;
                                break;
                            default:
                                column++;
                                break;
                            }
                            return ch;
                        }
                    } // class $Default.$LexicalAnalyzer
                    
                    
                    #// user-defined types
                    #Set defaultClasses = new HashSet();
                    #Iterator outer = tables.userDefinedTypes().iterator();
                    #while (outer.hasNext()) {
                        #Type type = (Type) outer.next();
                        #TypeNonterminal nonterminal = ((UserDefinedType) type).getTypeNonterminal();
                        #if (nonterminal != null) {
                            #for (;;) {
                                #if (defaultClasses.add(type)) {
                                    #type = (Type) type.getDirectSuperTypes().iterator().next();
                                    #if (type instanceof UserDefinedType)
                                        #continue;
                                #}
                                #break;
                            #}
                        #}
                    #}
                    #outer = tables.userDefinedTypes().iterator();
                    #while (outer.hasNext()) {
                        #UserDefinedType type = (UserDefinedType) outer.next();
                        #if (defaultClasses.contains(type)) {
                            #boolean isAbstract = (type.getTypeNonterminal() == null);
                            #java.lang.String identifier = type.getName();
                            #Type superType = (Type) type.getDirectSuperTypes().iterator().next();
                            #String superTypeString;
                            #if (superType instanceof UserDefinedType) {
                                #superTypeString = ((UserDefinedType) superType).getName();
                            #} else {
                                #superTypeString = "$Node";
                            #}
                            /**
                             * An implementation of <code>>>[[ identifier ]]<<</code> node.
                             */
                            public >>[[ isAbstract ? "abstract " : "" ]]<<static class >>[[ identifier ]]<< extends $Default.>>[[ superTypeString ]]<< implements >>[[ getTypeName(type) ]]<< {
                                #Iterator it7 = type.getMapNameToField().values().iterator();
                                #while (it7.hasNext()) {
                                    #Field field = (Field) it7.next();
                                    #Type fieldType = field.getType();
                                    #Field superField = superType.getField(field.getName());
                                    #if (superField == null) {
                                        #if (fieldType instanceof ArrayType) {
                                            private >>[[ getTypeName(fieldType) ]]<< >>[[ field.getName() ]]<< = new java.util.LinkedList();
                                        #} else {
                                            private >>[[ getTypeName(fieldType) ]]<< >>[[ field.getName() ]]<< = null;
                                        #}
                                        public >>[[ getTypeName(fieldType) ]]<< >>[[ field.getName() ]]<<() {
                                            return >>[[ field.getName() ]]<<;
                                        }
                                    #} else if (!fieldType.equals(superField.getType())) {
                                        public >>[[ getTypeName(fieldType) ]]<< >>[[ field.getName() ]]<<() {
                                            return (>>[[ getTypeName(fieldType) ]]<<) super.>>[[ field.getName() ]]<<();
                                        }
                                    #}
                                #}
                                
                                /**
                                 * Constructs a instance with the child nodes given by <code>source.$getChildNodes()</code> etc.
                                 * 
                                 * @param   source
                                 *            the source.
                                 */
                                public >>[[ identifier ]]<<(>>[[ getTypeName(type) ]]<< source) {
                                    #if (superType instanceof UserDefinedType) {
                                        super(($Parser.>>[[ superTypeString ]]<<) source);
                                    #} else {
                                        super(new java.util.LinkedList(source.$getChildNodes()));
                                    #}
                                    
                                    #Iterator it8 = type.getMapNameToField().values().iterator();
                                    #while (it8.hasNext()) {
                                        #Field field = (Field) it8.next();
                                        #if (superType.getField(field.getName()) == null) {
                                            #Type fieldType = field.getType();
                                            #if (fieldType instanceof ArrayType) {
                                                this.>>[[ field.getName() ]]<< = new java.util.LinkedList(source.>>[[ field.getName() ]]<<());
                                            #} else {
                                                this.>>[[ field.getName() ]]<< = source.>>[[ field.getName() ]]<<();
                                            #}
                                        #}
                                    #}
                                }
                                
                                /**
                                 * Constructs a instance with the child nodes given by <code>parameters</code>.
                                 * <p>
                                 * {@link $Parser.$Node#$getChildNodes} of the node is modifiable and ordered by the position in the parsed text.
                                 * 
                                 * @param   parameters
                                 *            the parameters for initialization.
                                 * @param   compact
                                 *            remove the children that is not labeled.
                                 */
                                public >>[[ identifier ]]<<($Parser.$NodeInitializationParameters parameters, boolean compact) {
                                    #if (superType instanceof UserDefinedType) {
                                        super(parameters, compact);
                                    #} else {
                                        super(new java.util.LinkedList());
                                    #}
                                    
                                    $Parser.$Node[] childNodes = parameters.childNodes;
                                    java.util.List labelsIDList = parameters.labelsIDList;
                                    
                                    java.util.Iterator it = labelsIDList.iterator();
                                    int size = labelsIDList.size();
                                    for (int i = 0; i < size; i++) {
                                        #if (labelWordCount == 1) {
                                            java.lang.Integer number = (java.lang.Integer) it.next();
                                            int no = number.intValue();
                                        #} else {
                                            java.math.BigInteger number = (java.math.BigInteger) it.next();
                                        #}
                                        #if (!(superType instanceof UserDefinedType)) {
                                            #if (labelWordCount == 1) {
                                                if (!compact || no != 0)
                                                    $getChildNodes().add(childNodes[i]);
                                            #} else {
                                                if (!compact || !number.equals(java.math.BigInteger.ZERO))
                                                    $getChildNodes().add(childNodes[i]);
                                            #}
                                            childNodes[i].$setParentNode(this);
                                        #}
                                        #Iterator it9 = type.getDeclaredFields().iterator();
                                        #while (it9.hasNext()) {
                                            #Field field = (Field) it9.next();
                                            #if (superType.getField(field.getName()) == null) {
                                                #java.lang.String fiedlTypeName = getTypeName(field.getType());
                                                
                                                #int labelNo = tables.getIndexOfLabel(field.getName());
                                                #java.lang.String match;
                                                #if (labelWordCount == 1) {
                                                    #match = "(no & (1 << " + labelNo + ")) != 0";
                                                #} else {
                                                    #match = "number.testBit(" + labelNo + ")";
                                                #}
                                                if (>>[[ match ]]<<) {
                                                    #if (field.getType() instanceof ArrayType) {
                                                        this.>>[[ field.getName() ]]<<.add(childNodes[i]);
                                                    #} else {
                                                        this.>>[[ field.getName() ]]<< = (>>[[ fiedlTypeName ]]<<) childNodes[i];
                                                    #}
                                                }
                                            #}
                                        #}
                                    }
                                }
                                
                                protected void $replaceChild($Parser.$Node oldChild, $Parser.$Node newChild) {
                                    #Iterator it10 = type.getMapNameToField().values().iterator();
                                    #while (it10.hasNext()) {
                                        #Field field = (Field) it10.next();
                                        #if (superType.getField(field.getName()) == null) {
                                            #java.lang.String fiedlTypeName = getTypeName(field.getType());
                                            #if (field.getType() instanceof ArrayType) {
                                                $replaceAll(this.>>[[ field.getName() ]]<<, oldChild, newChild);
                                            #} else {
                                                if (oldChild == null ? this.>>[[ field.getName() ]]<< == null : oldChild.equals(this.>>[[ field.getName() ]]<<))
                                                    this.>>[[ field.getName() ]]<< = (>>[[ fiedlTypeName ]]<<) newChild;
                                            #}
                                        #}
                                    #}
                                    super.$replaceChild(oldChild, newChild);
                                }
                            } // class >>[[ identifier ]]<<
                        #}
                    #}
                    
                    
                #}
            } // $Default
            
            #{
                #allocate("IntegerStack", topTypeNamespace);
                private static class $IntegerStack {
                    public static $IntegerStack EMPTY_STACK = new $IntegerStack(null, 0);
                    
                    private $IntegerStack previous;
                    private int value;
                    private $IntegerStack($IntegerStack previous, int value) {
                        this.previous = previous;
                        this.value = value;
                    }
                    public boolean isEmpty() {
                        return previous == null;
                    }
                    public static $IntegerStack push($IntegerStack stack, int value) {
                        return new $IntegerStack(stack, value);
                    }
                    public int top() {
                        return value;
                    }
                    public static $IntegerStack pop($IntegerStack stack) {
                        return stack.previous;
                    }
                }
                #allocate("State", topTypeNamespace);
                private static class $State {
                    public $IntegerStack stateStack;
                    public $IntegerStack shiftReduceHistory;
                    public $State($IntegerStack stateStack, $IntegerStack shiftReduceHistory) {
                        this.stateStack = stateStack;
                        this.shiftReduceHistory = shiftReduceHistory;
                    }
                }
                
                #if (tables.tags().length > 0) {
                    #reserve("taggedTokenShifted", topMethodNamespace);
                    protected void $taggedTokenShifted($Parser.$LexicalAnalyzer analyzer, $Parser.$Token token, int tag) {
                    }
                #}
                
                #allocate("parse", topMethodNamespace);
                private $Node $parse(int[][] lrTable, int[][] reductions, int[] tagTable, int initialState, int classSymbolMaximum, $LexicalAnalyzer analyzer) throws $ParseException {
                    final int labelWordCount = >>[[ labelWordCount ]]<<;
                    final int firstIndexOfWhiteTerminals = >>[[ tables.firstIndexOfWhiteTerminals() ]]<<;
                    final int superiorIndexOfWhiteTerminals = >>[[ tables.superiorIndexOfWhiteTerminals() ]]<<;
                    java.util.LinkedList tokens = new java.util.LinkedList();
                    int SHIFT = -1;
                    java.util.ArrayList states = new java.util.ArrayList();
                    {
                        // phase 1:  stamp.
                        java.util.ArrayList nextStates = new java.util.ArrayList();
                        states.add(new $State($IntegerStack.push($IntegerStack.EMPTY_STACK, initialState), $IntegerStack.EMPTY_STACK));
                    tokenLoop:
                        for (;;) {
                            $Token nextToken;
                            int nextTokenID;
                            do {
                                nextToken = analyzer.next();
                                nextTokenID = nextToken.getSymbolID();
                                if (nextTokenID != EOF_TOKEN)
                                    tokens.addLast(nextToken);
                            } while (firstIndexOfWhiteTerminals <= nextTokenID && nextTokenID < superiorIndexOfWhiteTerminals);
                            
                            int initialStatesSize = states.size();
                        reduceLoop:
                            for (int i = 0; i < states.size(); i++) {
                                final $State state = ($State) states.get(i);
                                final int stateID = state.stateStack.top();
                                //System.out.print(stateID + ", ");
                                int[] tokenIDToReductionID = lrTable[stateID * 3 + 2];
                                int j = $binarySearch(tokenIDToReductionID, nextTokenID);
                                for (; j < tokenIDToReductionID.length; j += 2) {
                                    if (tokenIDToReductionID[j] > nextTokenID) {
                                        break;
                                    } else if (tokenIDToReductionID[j] == nextTokenID) {
                                        final int reductionID = tokenIDToReductionID[j + 1];
                                        final int[] reduction = reductions[reductionID];
                                        final int nextSymbolID = reduction[0];
                                        
                                        $IntegerStack stateStack = state.stateStack;
                                        for (int k = reduction.length - 1; k >= 1; k -= labelWordCount)
                                            stateStack = $IntegerStack.pop(stateStack);
                                        
                                        $IntegerStack shiftReduceHistory = state.shiftReduceHistory;
                                        shiftReduceHistory = $IntegerStack.push(shiftReduceHistory, reductionID);
                                        
                                        final int returnedStateID = stateStack.top();
                                        final int[] symbolIDToNextState = lrTable[returnedStateID * 3 + 1];
                                        int k = $binarySearch(symbolIDToNextState, nextSymbolID);
                                        for (; k < symbolIDToNextState.length; k += 2) {
                                            if (symbolIDToNextState[k] > nextSymbolID) {
                                                break;
                                            } else if (symbolIDToNextState[k] == nextSymbolID) {
                                                final int nextStateID = symbolIDToNextState[k + 1];
                                                states.add(new $State($IntegerStack.push(stateStack, nextStateID), shiftReduceHistory));
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                            //System.out.println();
                            
                        shiftLoop:
                            for (int i = 0; i < states.size(); i++) {
                                final $State state = ($State) states.get(i);
                                final int stateID = state.stateStack.top();
                                
                                final int[] symbolIDToNextState = lrTable[stateID * 3 + 0];
                                int k = $binarySearch(symbolIDToNextState, nextTokenID);
                                for (; k < symbolIDToNextState.length; k += 2) {
                                    if (symbolIDToNextState[k] > nextTokenID) {
                                        break;
                                    } else if (symbolIDToNextState[k] == nextTokenID) {
                                        final int nextStateID = symbolIDToNextState[k + 1];
                                        $IntegerStack stateStack = state.stateStack;
                                        stateStack = $IntegerStack.push(stateStack, nextStateID);
                                        
                                        $IntegerStack shiftReduceHistory = state.shiftReduceHistory;
                                        shiftReduceHistory = $IntegerStack.push(shiftReduceHistory, SHIFT);
                                        
                                        nextStates.add(new $State(stateStack, shiftReduceHistory));
                                    }
                                }
                            }
                            
                            if (nextStates.isEmpty()) {
                                if (nextTokenID != EOF_TOKEN)
                                    tokens.removeLast();
                                states.subList(initialStatesSize, states.size()).clear();
                                $error(analyzer, lrTable, states, nextToken);
                                continue tokenLoop;
                            }
                            
                            #if (tables.tags().length > 0) {
                                for (int i = 0; i < nextStates.size(); i++) {
                                    $State state = ($State) nextStates.get(i);
                                    int stateID = state.stateStack.top();
                                    for (int j = 0; j < tagTable.length; j += 2) {
                                        if (tagTable[j] == stateID) {
                                            if (nextStates.size() > 1)
                                                throw new $ParseException.AmbiguousGrammarError(>>[[ quoted(file.getName()) ]]<< + " has ambiguous tags.");
                                            else
                                                $taggedTokenShifted(analyzer, nextToken, tagTable[j + 1]);
                                            break;
                                        }
                                    }
                                }
                            #}
                            
                            if (nextTokenID == EOF_TOKEN) {
                                states = nextStates;
                                break tokenLoop;
                            }
                            
                            java.util.ArrayList tmp = states;
                            states = nextStates;
                            nextStates = tmp;
                            nextStates.clear();
                        }
                    }
                    
                    if (states.size() != 1)
                        throw new $ParseException.AmbiguousGrammarError(>>[[ quoted(file.getName()) ]]<< + " is ambiguous.");
                    $State state = ($State) states.get(0);
                    
                    // phase 2:  build a tree.
                    {
                        $IntegerStack shiftReduceHistory = state.shiftReduceHistory;
                        {
                            shiftReduceHistory = $IntegerStack.pop(shiftReduceHistory); // remove the last shift for EOF.
                            $IntegerStack tracer = $IntegerStack.EMPTY_STACK;
                            while (!shiftReduceHistory.isEmpty()) {
                                tracer = $IntegerStack.push(tracer, shiftReduceHistory.top());
                                shiftReduceHistory = $IntegerStack.pop(shiftReduceHistory);
                            }
                            shiftReduceHistory = tracer;
                        }
                        #if (labelWordCount == 1) {
                            final java.lang.Integer ZERO = new java.lang.Integer(0);
                        #} else {
                            final java.math.BigInteger ZERO = java.math.BigInteger.ZERO;
                        #}
                        
                        java.util.Iterator it = tokens.iterator();
                        java.util.LinkedList stack = new java.util.LinkedList();
                    mainLoop:
                        while (!shiftReduceHistory.isEmpty()) {
                            int shiftReduce = shiftReduceHistory.top();
                            shiftReduceHistory = $IntegerStack.pop(shiftReduceHistory);
                            if (shiftReduce == SHIFT) {
                                $Token token;
                                do {
                                    token = ($Token) it.next();
                                    stack.addLast(token);
                                } while (firstIndexOfWhiteTerminals <= token.getSymbolID() && token.getSymbolID() < superiorIndexOfWhiteTerminals);
                            } else {
                                final int[] reduction = reductions[shiftReduce];
                                boolean isFinal = shiftReduceHistory.isEmpty();
                                if (isFinal) {
                                    while (it.hasNext())
                                        stack.addLast(it.next());
                                }
                                java.util.LinkedList list = new java.util.LinkedList();
                                for (int j = reduction.length - 1; j >= 1; j -= labelWordCount) {
                                    java.lang.Object node;
                                    for (;;) {
                                        node = stack.removeLast();
                                        if (node instanceof $Token) {
                                            $Token token = ($Token) node;
                                            if (firstIndexOfWhiteTerminals <= token.getSymbolID() && token.getSymbolID() < superiorIndexOfWhiteTerminals) {
                                                list.addFirst(ZERO);
                                                list.addFirst(node);
                                                continue;
                                            }
                                        }
                                        break;
                                    }
                                    #if (labelWordCount == 1) {
                                        list.addFirst(new java.lang.Integer(reduction[j]));
                                    #} else {
                                        java.math.BigInteger no = java.math.BigInteger.ZERO;
                                        for (int k = 0; k < labelWordCount; k++)
                                            no = no.or(java.math.BigInteger.valueOf(0xFFFFFFFFL & reduction[j - k]).shiftLeft(k * 32));
                                        list.addFirst(no);
                                    #}
                                    list.addFirst(node);
                                }
                                if (isFinal) {
                                    while (!stack.isEmpty()) {
                                        java.lang.Object node = stack.removeLast();
                                        list.addFirst(ZERO);
                                        list.addFirst(node);
                                    }
                                }
                                int nodeID = reduction[0];
                                java.lang.Object node;
                                if (nodeID <= classSymbolMaximum) {
                                    node = $createNode(nodeID, list);
                                } else {
                                    node = list;
                                }
                                stack.addLast(node);
                            }
                        }
                        return ($Node) stack.getFirst();
                    }
                }
                #allocate("binarySearch", topMethodNamespace);
                private static int $binarySearch(int[] table, int key) {
                    // Returns the index where table[i] < key for all i < index
                    int base = 0;
                    int width = table.length >> 1;
                    #java.lang.String lrgLinearSearchThreshold = environment.parameters.getProperty("JavaCodeGenerator.lrgLinearSearchThreshold", "3");
                    while (width > >>[[ lrgLinearSearchThreshold ]]<<) {
                        int halfWidth = width >> 1;
                        int mid = base + width & ~1;    // base + halfWidth * 2
                        if (key <= table[mid]) {
                            width = halfWidth;
                        } else {
                            base = mid;
                            width -= halfWidth;
                        }
                    }
                    return base;
                }
                
                #reserve("createNode", topMethodNamespace);
                private $Node $createNode(int symbolID, java.util.List data) throws $ParseException {
                    java.util.List nodeList = new java.util.LinkedList();
                    java.util.List labelsIDList = new java.util.LinkedList();
                    #if (labelWordCount == 1) {
                        $flatNodes(0, nodeList, labelsIDList, data);
                    #} else {
                        $flatNodes(java.math.BigInteger.ZERO, nodeList, labelsIDList, data);
                    #}
                    $Node[] childNodes = ($Node[]) nodeList.toArray(new $Node[nodeList.size()]);
                    $NodeInitializationParameters parameters = new $NodeInitializationParameters();
                    parameters.childNodes = childNodes;
                    parameters.labelsIDList = labelsIDList;
                    $Node result = $createNode(symbolID, parameters);
                    return result;
                }
                
                #allocate("flatNodes", topMethodNamespace);
                #if (labelWordCount == 1) {
                    private static void $flatNodes(int labels, java.util.List nodeList, java.util.List labelsIDList, java.util.List data) {
                        java.util.Iterator it = data.iterator();
                        while (it.hasNext()) {
                            java.lang.Object node = it.next();
                            java.lang.Integer labelsID = (java.lang.Integer) it.next();
                            int mergedLabelsID = labelsID.intValue();
                            if ((mergedLabelsID & 1) != 0) {
                                mergedLabelsID &= ~1;
                                mergedLabelsID |= labels;
                            }
                            if (node instanceof java.util.List) {
                                $flatNodes(mergedLabelsID, nodeList, labelsIDList, (java.util.List) node);
                            } else {
                                nodeList.add(node);
                                labelsIDList.add(new java.lang.Integer(mergedLabelsID));
                            }
                        }
                    }
                #} else {
                    private static void $flatNodes(java.math.BigInteger labels, java.util.List nodeList, java.util.List labelsIDList, java.util.List data) {
                        java.util.Iterator it = data.iterator();
                        while (it.hasNext()) {
                            java.lang.Object node = it.next();
                            java.math.BigInteger labelsID = (java.math.BigInteger) it.next();
                            java.math.BigInteger mergedLabelsID = labelsID;
                            if (mergedLabelsID.testBit(0)) {
                                mergedLabelsID = mergedLabelsID.clearBit(0);
                                mergedLabelsID = mergedLabelsID.or(labels);
                            }
                            if (node instanceof java.util.List) {
                                $flatNodes(mergedLabelsID, nodeList, labelsIDList, (java.util.List) node);
                            } else {
                                nodeList.add(node);
                                labelsIDList.add(mergedLabelsID);
                            }
                        }
                    }
                #}
                
                #allocate("error", topMethodNamespace);
                private static void $error($LexicalAnalyzer analyzer, int[][] lrTable, java.util.List states, $Token errorNextToken) throws $ParseException {
                    java.util.Set nextTokens = new java.util.TreeSet();
                    java.util.Iterator it = states.iterator();
                    while (it.hasNext()) {
                        $State state = ($State) it.next();
                        int stateID = state.stateStack.top();
                        
                        int[] tokenIDToNextState = lrTable[stateID * 3 + 0];
                        for (int i = 0; i < tokenIDToNextState.length; i += 2) {
                            nextTokens.add(new java.lang.Integer(tokenIDToNextState[i]));
                        }
                        int[] tokenIDToReductionID = lrTable[stateID * 3 + 2];
                        for (int i = 0; i < tokenIDToReductionID.length; i += 2) {
                            nextTokens.add(new java.lang.Integer(tokenIDToReductionID[i]));
                        }
                    }
                    int[] selectableTokens = new int[nextTokens.size()];
                    int index = 0;
                    java.util.Iterator it11 = nextTokens.iterator();
                    while (it11.hasNext()) {
                        java.lang.Integer i = (java.lang.Integer) it11.next();
                        selectableTokens[index++] = i.intValue();
                    }
                    $error(analyzer, errorNextToken, selectableTokens);
                }
                /**
                 * Throws or recovers a error.
                 * <p>
                 * This method is called when a token is not shiftable.
                 * If the error is not recoverable, this method throws $ParseException.
                 * To recover the error, this method dose not throw anything,
                 * then syntax analyzers ignore the <code>errorNextToken</code>,
                 * i.e. the last <code>analyzer.{@link $Parser.$LexicalAnalyzer#next() next()}</code> call.
                 * The next <code>analyzer.{@link $Parser.$LexicalAnalyzer#next() next()}</code> can return a better token.
                 * 
                 * @param   analyzer
                 *      the lexical analyzer of the parsing.
                 * @param   errorNextToken
                 *      the unshiftable token the last <code>analyzer.{@link $Parser.$LexicalAnalyzer#next() next()}</code> returned.
                 * @param   selectableNextTokens
                 *      the shiftable tokens at the situation.
                 * @throws   $ParseException
                 *      if the error is not recoverable.
                 * @since    notavaCC 1.0
                 */
                #allocate("error", topMethodNamespace);
                private static void $error($LexicalAnalyzer analyzer, $Token errorNextToken, int[] selectableNextTokens) throws $ParseException {
                    java.io.StringWriter buffer = new java.io.StringWriter();
                    java.io.PrintWriter writer = new java.io.PrintWriter(buffer);
                    
                    if (errorNextToken.getSymbolID() != EOF_TOKEN) {
                        writer.println("The token " + errorNextToken + " should be one of the followings.");
                    } else {
                        writer.println("The EOF should be one of the followings.");
                    }
                    
                    final java.lang.String[] tokenStrings = {
                        #{
                            #Symbol[] symbols = tables.symbols();
                            #for (int i = 0; i < tables.superiorIndexOfTerminals(); i++) {
                                #Symbol symbol = symbols[i];
                                >>[[ quoted(symbol.toString()) ]]<<,
                            #}
                        #}
                    };
                    
                    for (int i = 0; i < selectableNextTokens.length; i++) {
                        int selectableNextToken = selectableNextTokens[i];
                        writer.print("        ");
                        writer.println(tokenStrings[selectableNextToken]);
                    }
                    
                    writer.close();
                    if (writer.checkError())
                        throw new RuntimeException();
                    throw new $ParseException(buffer.toString(), errorNextToken);
                }
            #}
            
            #{
                #// DFA table
                #final int unit = 50;
                #DFAState[] states = tables.dfaStates();
                private static $final_avoid_jdk12_bug int[][] $dfaTable;
                #allocate("dfaTable", topFieldNamespace);
                static {
                    $dfaTable = new int[>>[[ states.length ]]<<][];
                    #for (int i = 0; i < states.length; i += unit) {
                        initializeDFATable>>[[ i ]]<<();
                    #}
                }
                #for (int i = 0; i < states.length; i += unit) {
                    #topMethodNamespace.add("initializeDFATable" + i, RESERVED_NAME);
                    private static void initializeDFATable>>[[ i ]]<<() {
                        #for (int j = i; j < i + unit && j < states.length; j++) {
                            #DFAState state = states[j];
                            $dfaTable[>>[[ j ]]<<] = new int[] {
                                #Terminal symbol = state.hitSymbol();
                                #if (symbol == null)
                                    -1,
                                #else
                                    >>[[ symbolToWord.get(symbol) ]]<<,
                                #Iterator it = state.getMapInputToNextStates().entrySet().iterator();
                                #while (it.hasNext()) {
                                    #Map.Entry entry = (Map.Entry) it.next();
                                    #DFAInput input = (DFAInput) entry.getKey();
                                    #DFAState nextState = (DFAState) entry.getValue();
                                    >>[[ quoted(input.lower) ]]<<, >>[[ quoted(input.upper) ]]<<, >>[[ tables.getIndexOfState(nextState) ]]<<, 
                                #}
                            };
                        #}
                    }
                #}
            #}
            
            #{
                #// LALR(1) table
                #final int unit = 20;
                #LRState[] states = tables.lrStates();
                private static $final_avoid_jdk12_bug int[][] $lrTable;
                #allocate("lrTable", topFieldNamespace);
                static {
                    $lrTable = new int[>>[[ states.length ]]<< * 3][];
                    #for (int i = 0; i < states.length; i += unit) {
                        initializeLRTable>>[[ i ]]<<();
                    #}
                }
                #for (int i = 0; i < states.length; i += unit) {
                    #topMethodNamespace.add("initializeLRTable" + i, RESERVED_NAME);
                    private static void initializeLRTable>>[[ i ]]<<() {
                        #for (int j = i; j < i + unit && j < states.length; j++) {
                            #LRState state = states[j];
                            #Map teminalToNextState = tables.getMapTeminalToNextState(state);
                            #Map nonteminalToNextState = tables.getMapNonteminalToNextState(state);
                            #Map symbolToReductions = tables.getMapSymbolToReduction(state);
                            // LRState >>[[ tables.getIndexOfState(state) ]]<<
                            $lrTable[>>[[j]]<< * 3 + 0] = new int[] {
                                #Iterator it3 = teminalToNextState.entrySet().iterator();
                                #while (it3.hasNext()) {
                                    #Map.Entry entry = (Map.Entry) it3.next();
                                    #Symbol symbol = (Symbol) entry.getKey();
                                    #LRState nextState = (LRState) entry.getValue();
                                    >>[[ symbolToWord.get(symbol) ]]<<, >>[[ tables.getIndexOfState(nextState) ]]<<,
                                #}
                            };
                            $lrTable[>>[[j]]<< * 3 + 1] = new int[] {
                                #Iterator it4 = nonteminalToNextState.entrySet().iterator();
                                #while (it4.hasNext()) {
                                    #Map.Entry entry = (Map.Entry) it4.next();
                                    #Symbol symbol = (Symbol) entry.getKey();
                                    #LRState nextState = (LRState) entry.getValue();
                                    >>[[ symbolToWord.get(symbol) ]]<<, >>[[ tables.getIndexOfState(nextState) ]]<<,
                                #}
                            };
                            $lrTable[>>[[j]]<< * 3 + 2] = new int[] {
                                #Iterator it5 = symbolToReductions.entrySet().iterator();
                                #while (it5.hasNext()) {
                                    #Map.Entry entry = (Map.Entry) it5.next();
                                    #Symbol symbol = (Symbol) entry.getKey();
                                    #Set reductions = (Set) entry.getValue();
                                    #Iterator it6 = reductions.iterator();
                                    #while (it6.hasNext()) {
                                        #Reduction reduction = (Reduction) it6.next();
                                        >>[[ symbolToWord.get(symbol) ]]<<, >>[[ tables.getIndexOfReduction(reduction) ]]<<,
                                    #}
                                #}
                            };
                        #}
                    }
                #}
            #}
            
            #{
                #// reduction table
                #Reduction[] reductions = tables.reductions();
                #allocate("reductionTable", topFieldNamespace);
                private static final int[][] $reductionTable = {
                    #for (int i = 0; i < reductions.length; i++) {
                        #Reduction reduction = reductions[i];
                        
                        #java.lang.StringBuffer result = new java.lang.StringBuffer();
                        #Iterator it = reduction.labelSetList().iterator();
                        #while (it.hasNext()) {
                            #Set labels = (Set) it.next();
                            #BigInteger no = BigInteger.ZERO;
                            #Iterator innest = labels.iterator();
                            #while (innest.hasNext()) {
                                #java.lang.String label = (String) innest.next();
                                #no = no.setBit(tables.getIndexOfLabel(label));
                            #}
                            #String hex = no.toString(16).toUpperCase(Locale.ENGLISH);
                            #while (hex.length() < labelWordCount * 8) {
                                #hex = '0' + hex;
                            #}
                            #for (int j = 0; j < labelWordCount; j++) {
                                #result.append("0x").append(hex.substring(j * 8, j * 8 + 8)).append(",");
                            #}
                            #result.append(" ");
                        #}
                        { >>[[ symbolToWord.get(reduction.reducedSymbol()) ]]<<,  >>[[ result ]]<<},
                    #}
                };
            #}
            
            #{
                #// tag table
                #allocate("tagTable", topFieldNamespace);
                private static final int[] $tagTable = {
                    #LRState[] states = tables.lrStates();
                    #for (int i = 0; i < states.length; i++) {
                        #LRState state = states[i];
                        #if (state.tag() != null)
                            >>[[ i ]]<<, >>[[ tagToWord.get(state.tag().getImage()) ]]<<,
                    #}
                };
            #}
            
            #allocate("replaceAll", topMethodNamespace);
            private static void $replaceAll(java.util.List list, $Node oldValue, $Node newValue) {
                #if (targetVersion >= 1.4) {
                    java.util.Collections.replaceAll(list, oldValue, newValue);
                #} else {
                    java.util.ListIterator it = list.listIterator();
                    if (oldValue == null) {
                        while (it.hasNext()) {
                            java.lang.Object old = it.next();
                            if (oldValue == old)
                                it.set(newValue);
                        }
                    } else {
                        while (it.hasNext()) {
                            java.lang.Object old = it.next();
                            if (oldValue.equals(old))
                                it.set(newValue);
                        }
                    }
                #}
            }
            
            #allocate("toHexCode", topMethodNamespace);
            private static java.lang.String $toHexCode(char ch) {
                java.lang.String hex = "000" + java.lang.Integer.toString(ch, 16).toUpperCase(java.util.Locale.ENGLISH);
                hex = hex.substring(hex.length() - 4);
                return hex;
            }
#//            #allocate("quoted", topMethodNamespace);
#//            private static java.lang.String $quoted(java.lang.String str, boolean quote) {
#//                java.lang.StringBuffer quoted = new java.lang.StringBuffer();
#//                if (quote)
#//                    quoted.append("\"");
#//                for (int i = 0; i < str.length(); i++) {
#//                    char ch = str.charAt(i);
#//                    $quoted(quoted, ch);
#//                }
#//                if (quote)
#//                    quoted.append("\"");
#//                return quoted.toString();
#//            }
#//            #allocate("quoted", topMethodNamespace);
#//            private static void $quoted(java.lang.StringBuffer result, char ch) {
#//                switch (ch) {
#//                default:
#//                    if (0x0020 <= ch && ch <= 0x007E) {
#//                        result.append(ch);
#//                    } else {
#//                        result.append("\\u").append($toHexCode(ch));
#//                    }
#//                    break;
#//                case '\n':   result.append("\\n");      break;
#//                case '\t':   result.append("\\t");      break;
#//                case '\b':   result.append("\\b");      break;
#//                case '\r':   result.append("\\r");      break;
#//                case '\f':   result.append("\\f");      break;
#//                case '\\':   result.append("\\\\");     break;
#//                case '\'':   result.append("\\\'");     break;
#//                case '\"':   result.append("\\\"");     break;
#//                }
#//            }
            
            #if (!root.hasProtectedConstructor() && publicParsableTypeCount == 1) {
                /**
                 * Parses the given file(s) and prints the abstract syntax tree(s) generated.
                 * 
                 * @since   notavaCC 1.0
                 */
                #reserve("main", topMethodNamespace);
                public static void $main(java.lang.String[] args) {
                    try {
                        $Parser p = new $Parser();
                        for (int i = 0; i < args.length; i++) {
                            java.io.File file = new java.io.File(args[i]);
                            System.out.println(file);
                            
                            #Iterator it12 = tables.userDefinedTypes().iterator();
                            #while (it12.hasNext()) {
                                #UserDefinedType type = (UserDefinedType) it12.next();
                                #LRState initialState = (LRState) lrTable.symbolToInitialState().get(type.getTypeNonterminal());
                                #if (initialState != null) {
                                    System.out.println(p.parse>>[[ type.getName() ]]<<(file));
                                    #break;
                                #}
                            #}
                        }
                    } catch(java.lang.Exception x) {
                        x.printStackTrace();
                    }
                }
            #}
        } // class $Parser
>>[[
        
        logger.verbosest(environment.processingFile, "checking topTypeNamespace");
        checkDuplex(topTypeNamespace);
        logger.verbosest(environment.processingFile, "checking topFieldNamespace");
        checkDuplex(topFieldNamespace);
        logger.verbosest(environment.processingFile, "checking topMethodNamespace");
        checkDuplex(topMethodNamespace);
        logger.verbosest(environment.processingFile, "checking nodeFieldNamespace");
        checkDuplex(nodeFieldNamespace);
        logger.verbosest(environment.processingFile, "checking nodeNoArgumentMethodNamespace");
        checkDuplex(nodeNoArgumentMethodNamespace);
        logger.verbosest(environment.processingFile, "checking nodeMethodNamespace");
        checkDuplex(nodeMethodNamespace);
        if (logger.hasError())
            logger.fatal();
    } // generateCode
    public void checkDuplex(MultiMap namespace) {
        Iterator it13 = namespace.entrySet().iterator();
        while (it13.hasNext()) {
            Map.Entry entry = (Map.Entry) it13.next();
            String name = (String) entry.getKey();
            Set reservers = (Set) entry.getValue();
            if (reservers.contains(RESERVED_NAME))
                logger.verbosest(environment.processingFile, "checking the reserved name {0}.", name);
            if (reservers.size() >= 2) {
                Iterator it14 = reservers.iterator();
                while (it14.hasNext()) {
                    Object reserver = (Object) it14.next();
                    if (reserver.equals(RESERVED_NAME)) {
                        // ignore.
                    } else if (reserver instanceof Symbol) {
                        logger.error(environment.processingFile, "The reserved name {0} is used.", reserver);
                    } else if (reserver instanceof Type) {
                        logger.error(environment.processingFile, "The reserved name {0} is used.", reserver);
                    } else {
                        logger.error(environment.processingFile, "The reserved name {0} is used.", reserver);
                    }
                }
            }
        }
    }
} // JavaCodeGenerator

