
package jp.gr.java_conf.koto.notavacc.dfa;

import java.util.*;
import jp.gr.java_conf.koto.notavacc.lrg.*;
import jp.gr.java_conf.koto.notavacc.parser.Parser.*;
import jp.gr.java_conf.koto.notavacc.parser.Original.*;

public abstract class DeterministicFiniteAutomaton {
    public abstract DFAState initialState();
    
    public static interface DFAState {
        public Terminal hitSymbol();
        public SortedMap getMapInputToNextStates();
    }
    
    public abstract Terminal getTerminal(StringExpression exp);
    
    
    
    private Set states = null;
    public final Set states() {
        if (states == null) {
            states = new LinkedHashSet();
            getStates(states, initialState());
        }
        return states;
    }
    private void getStates(Set result, DFAState state) {
        if (result.add(state)) {
            Iterator it0 = state.getMapInputToNextStates().values().iterator();
            while (it0.hasNext()) {
                DFAState s = (DFAState) it0.next();
                getStates(result, s);
            }
        }
    }
    
    private Set terminals = null;
    public final Set getTerminals() {
        if (terminals == null) {
            terminals = new LinkedHashSet();
            Iterator it1 = states().iterator();
            while (it1.hasNext()) {
                DFAState state = (DFAState) it1.next();
                if (state.hitSymbol() != null)
                    terminals.add(state.hitSymbol());
            }
        }
        return terminals;
    }
}

