
package jp.gr.java_conf.koto.notavacc.dfa;

import java.util.*;

public class DFAInput implements Comparable {
    public final char lower;
    public final char upper;
    
    public DFAInput(int code) {
        this(code, code);
    }
    public DFAInput(int lower, int upper) {
        assert Character.MIN_VALUE <= lower && lower <= upper && upper <= Character.MAX_VALUE;
        this.lower = (char) lower;
        this.upper = (char) upper;
    }
    
    private String toString(char ch) {
        switch (ch) {
        default:
            if (0x0020 <= ch && ch <= 0x007E) {
                return Character.toString(ch);
            } else {
                String hex = "000" + Integer.toString(ch, 16);
                hex = hex.toUpperCase(Locale.ENGLISH).substring(hex.length() - 4);
                return "\\u" + hex;
            }
        case '\n':   return "\\n";
        case '\t':   return "\\t";
        case '\b':   return "\\b";
        case '\r':   return "\\r";
        case '\f':   return "\\f";
        case '\\':   return "\\\\";
        case '\'':   return "\\\'";
        case '\"':   return "\\\"";
        }
    }
    public String toString() {
        if (lower == upper) {
            return "'" + toString(lower) + "'";
        } else {
            return "'" + toString(lower) + "'..'" + toString(upper) + "'";
        }
    }
    
    public int hashCode() {
        return lower | upper << 16;
    }
    public boolean equals(Object rhs) {
        if (this == rhs)
            return true;
        if (rhs instanceof DFAInput)
            return equals((DFAInput) rhs);
        return false;
    }
    public boolean equals(DFAInput rhs) {
        return this.lower == rhs.lower && this.upper == rhs.upper;
    }
    public int compareTo(Object rhs) {
        if (rhs == null)
            return +1;
        return compareTo((DFAInput) rhs);
    }
    public int compareTo(DFAInput rhs) {
        if (this.lower != rhs.lower)
            return this.lower - rhs.lower;
        return this.upper - rhs.upper;
    }
    
}
