
package jp.gr.java_conf.koto.notavacc;

import java.util.*;
import java.io.*;
import jp.gr.java_conf.koto.util.*;
import jp.gr.java_conf.koto.notavacc.parser.*;

public class Environment {
    public final Properties parameters;
    public final Logger logger;
    public final CommandLineChecker commandLine;
    public File processingFile;
    public Environment(Logger logger, CommandLineChecker commandLine) {
        this.parameters = new Properties();
        InputStream parametersStream = new BufferedInputStream(Environment.class.getResourceAsStream("parameters.properties"));
        try {
            parameters.load(parametersStream);
            parametersStream.close();
        } catch (IOException x) {
            throw new RuntimeException(x);
        }
        
        this.logger = logger;
        this.commandLine = commandLine;
    }
}

