
package jp.gr.java_conf.koto.notavacc;

import java.util.*;
import java.io.*;
import org.apache.tools.ant.*;
import org.apache.tools.ant.types.*;
import org.apache.tools.ant.taskdefs.*;
import org.apache.tools.ant.util.*;

public class AntTask extends MatchingTask {
    private File base;
    public void setSrcdir(File dir) {
        base = dir;
    }
    
    public void setCaseSensitive(boolean value) {
        fileset.setCaseSensitive(value);
    }
    
    private File destination;
    public void setDestdir(File dir) {
        destination = dir;
    }
    
    private Commandline cmdl = new Commandline();
    public Commandline.Argument createArg() {
        return cmdl.createArgument();
    }
    
    public void execute() throws BuildException {
        if (base == null)
            throw new BuildException("'srcdir' attribute required.");
        
        List arguments = new LinkedList(Arrays.asList(cmdl.getArguments()));
        try {
            arguments.add("--source-path");
            arguments.add(base.getCanonicalPath());
            
            if (destination != null) {
                arguments.add("--destination-path");
                arguments.add(destination.getCanonicalPath());
            }
            
            String[] filenames = getDirectoryScanner(base).getIncludedFiles();
            GlobPatternMapper mapper = new GlobPatternMapper();
            mapper.setFrom("*.notavacc");
            mapper.setTo("*.java");
            filenames = new SourceFileScanner(this).restrict(filenames, base, (destination != null) ? destination : base, mapper);
            if (filenames.length == 0)
                return;
            for (int i = 0; i < filenames.length; i++) {
                String filename = filenames[i];
                File src = new File(base, filename);
                arguments.add(src.getCanonicalPath());
            }
        } catch (Exception x) {
            if (x instanceof BuildException) {
                throw (BuildException) x;
            } else {
                throw new BuildException(x);
            }
        }
        
        Throwable result = Main.process((String[]) arguments.toArray(new String[arguments.size()]));
        if (result != null) {
            throw new BuildException(result);
        }
    }
}


