
package jp.gr.java_conf.koto.notava;

public class Alphabet {
    private static final String select(String[] alternatives) {
        int i = 0;
        for (; i < alternatives.length - 1; i++) {
            String str = alternatives[i];
            try {
                String decoded = new String(str.getBytes());
                if (str.equals(decoded))
                    return str;
            } catch (RuntimeException x) {
                // ignore.
            }
        }
        return alternatives[i];
    }
    
    // from math signs
    public static final String A = select(new String[] { "<" });
    public static final String B = select(new String[] { "\u221E", "oo" });
        // \infty: infinity
    public static final String C = select(new String[] { "\u222A", "\u22C3", "U" });
        // \cup: union, n-ary union
    public static final String H = select(new String[] { "\u2260", "\u003D\u0338", "!=" });
        // \neq: not equal to
    public static final String I = select(new String[] { "-" });
    public static final String J = select(new String[] { "\u00AC", "\uFFE2", "~" });
        // \lnot: not sign, fullwidth not sign
    public static final String K = select(new String[] { "\u22BB", "_V" });
        // \ underline{\lor}: xor
    public static final String L = select(new String[] { "\u230B", "\u300D", "_|" });
        // \rfloor: right floor, right corner bracket
    public static final String M = select(new String[] { "\u2211", "\u03A3", "\u01A9", "E" });
        // \sum: n-ary summation, greek capital letter sigma, latin capital letter esh
    public static final String N = select(new String[] { "\u2286", "Z" });
        // \subseteq: subset of or equal to
    public static final String O = select(new String[] { "\u2218", "\u25E6", "\uFFEE", "o" });
        // \circ: ring operator, white bullet, halfwidth white circle
    public static final String R = select(new String[] { "\u2243", "~-" });
        // \simeq: asymptotically equal to
    public static final String S = select(new String[] { "\u223D", "\u301C", "\u223D", "un" });
        // \backsim: reversed tilde (lazy S), wave dash
    public static final String T = select(new String[] { "\u22A2", "|-" });
        // \vdash: right tack
    public static final String U = select(new String[] { "\u2283", ")" });
        // \supset: superset of
    public static final String V = select(new String[] { ">" });
    public static final String W = select(new String[] { "\u220B", "\u220D", "B" });
        // \ni: contains as member, small contains as member
    public static final String X = select(new String[] { "\u00D7", "X" });
        // \times: multiplication sign
    public static final String Y = select(new String[] { "\u227B", ">-" });
        // \succ: succeeds
    public static final String Z = select(new String[] { "\u2135", "\u05D0", "N" });
        // \aleph: alef symbol, hebrew letter alef
    /*public static final String HYPHEN = select(new String[] { "\u2223", "|" });
        // \vert: vertical line, divides
    public static final String SLASH = select(new String[] { "\u2216", "\uFF3C", "\\" });
        // \setminus: set minus, reverse solidus, fullwidth reverse solidus
    */
    
    // from greek letters
    public static final String D = select(new String[] { "\u0394", "\u25B3", "\u25B4", "^" });
        // \delta: greek capital letter delta, white up-pointing triangle
    public static final String E = select(new String[] { "\u03C9", "w" });
        // \omega: greek small letter omega
    public static final String F = select(new String[] { "\u03BC", "\u00B5", "|L" });
        // \mu: greek small letter mu, micro sign
    public static final String G = select(new String[] { "\u03C6", "U'" });
        // \verphi: greek small letter phi
    public static final String P = select(new String[] { "\u03F1", "O_" });
        // \varrho: greek rho symbol
    public static final String Q = select(new String[] { "\u03C3", "O'" });
        // \sigma: greek small letter sigma
    
    public static final String NORMAL_COPYRIGHT = select(new String[] { "\u00A9", "(c)" });
}

