
package jp.gr.java_conf.koto.io;

import java.util.*;
import java.io.*;

public class SafePrintWriter extends Writer {
    protected final Writer out;
    private final boolean autoFlush;
    private final String lineSeparator;
    private final int lineNumber = 1;
    
    public SafePrintWriter(Writer out) {
        this(out, false);
    }
    public SafePrintWriter(Writer out, boolean autoFlush) {
        super(out);
        this.out = out;
        this.autoFlush = autoFlush;
        lineSeparator = (String) java.security.AccessController.doPrivileged(new sun.security.action.GetPropertyAction("line.separator"));
    }
    public SafePrintWriter(OutputStream out) {
        this(out, false);
    }
    public SafePrintWriter(OutputStream out, boolean autoFlush) {
        this(new OutputStreamWriter(out instanceof FileOutputStream ? (OutputStream) new BufferedOutputStream(out) : out), autoFlush);
    }
    
    public void flush() throws IOException {
        out.flush();
    }
    public void close() throws IOException {
        out.close();
    }
    
    public void write(int c) throws IOException {
        out.write(c);
        if (autoFlush) {
            if (c == '\n' || c == '\r') {
                flush();
            }
        }
    }
    public void write(char[] cbuf, int off, int len) throws IOException {
        out.write(cbuf, off, len);
        if (autoFlush) {
            for (int i = 0; i < len; i++) {
                char ch = cbuf[i + off];
                if (ch == '\n' || ch == '\r') {
                    flush();
                    return;
                }
            }
        }
    }
    public void write(char buf[]) throws IOException{
        write(buf, 0, buf.length);
    }
    public void write(String s, int off, int len) throws IOException {
        out.write(s, off, len);
        if (autoFlush) {
            for (int i = 0; i < len; i++) {
                char ch = s.charAt(i + off);
                if (ch == '\n' || ch == '\r') {
                    flush();
                    return;
                }
            }
        }
    }
    public void write(String s) throws IOException {
        write(s, 0, s.length());
    }
    
    public void print(boolean b) throws IOException {
        out.write(String.valueOf(b));
    }
    public void print(char c) throws IOException {
        write((int) c);
    }
    public void print(int i) throws IOException {
        out.write(String.valueOf(i));
    }
    public void print(long l) throws IOException {
        out.write(String.valueOf(l));
    }
    public void print(float f) throws IOException {
        out.write(String.valueOf(f));
    }
    public void print(double d) throws IOException {
        out.write(String.valueOf(d));
    }
    public void print(char[] s) throws IOException {
        write(s);
    }
    public void print(String s) throws IOException {
        write(s);
    }
    public void print(Object obj) throws IOException {
        write(obj.toString());
    }
    
    public void println() throws IOException {
        out.write(lineSeparator);
        if (autoFlush) {
            flush();
        }
    }
    public void println(boolean x) throws IOException {
        print(x);
        println();
    }
    public void println(char x) throws IOException {
        print(x);
        println();
    }
    public void println(int x) throws IOException {
        print(x);
        println();
    }
    public void println(long x) throws IOException {
        print(x);
        println();
    }
    public void println(float x) throws IOException {
        print(x);
        println();
    }
    public void println(double x) throws IOException {
        print(x);
        println();
    }
    public void println(char[] x) throws IOException {
        print(x);
        println();
    }
    public void println(String x) throws IOException {
        print(x);
        println();
    }
    public void println(Object x) throws IOException {
        print(x);
        println();
    }
}


