
package parser;

import java.io.*;
import java.util.*;

public class Parser extends Syntax {
    protected Node createNode(int symbolID, NodeInitializationParameters parameters) {
        switch (symbolID) {
        case InlineExpression.ID:
            return new InlineExpressionReplacement(parameters);
        }
        Node result = super.createNode(symbolID, parameters, true);
        if (result instanceof RestrictorExpression) {
            return ((RestrictorExpression) result).operand();
        } else if (result instanceof LabeledExpression) {
            return ((LabeledExpression) result).operand();
        } else if (result instanceof EmbedExpression) {
            return ((EmbedExpression) result).operand();
        } else if (result instanceof TagExpression) {
            return ((TagExpression) result).operand();
        }
        return result;
    }
    
    protected LexicalAnalyzer createLexicalAnalyzer(String sourceName, CharSequence text, int tabStop) throws ParseException {
        return new Default.LexicalAnalyzer(sourceName, text, tabStop) {
            protected char nextChar() throws ParseException {
                return super.nextUnicodeEscapedChar();
            }
            public Token next() throws ParseException {
                Token result = super.next();
                if (result.getSymbolID() == TOKEN_IDENTIFIER) {
                    String image = result.getImage();
                    int i = 0;
                    for (; i < image.length(); i++) {
                        char ch = image.charAt(i);
                        if (i == 0) {
                            if (!Character.isJavaIdentifierStart(ch))
                                break;
                        } else {
                            if (!Character.isJavaIdentifierPart(ch))
                                break;
                        }
                    }
                    if (i < image.length())
                        throw new ParseException("The " + i + "th letter \\u" + Integer.toHexString(image.charAt(i)) +  " of the token " + result + " cannot be used.", result);
                }
                return result;
            }
        };
    }
    
    private class InlineExpressionReplacement extends Default.InlineExpression {
        public InlineExpressionReplacement(NodeInitializationParameters parameters) {
            super(parameters, true);
            name = new SymbolNameReplacement();
        }
        
        private final SymbolName name;
        public SymbolName name() {
            return name;
        }
        
        private class SymbolNameReplacement extends Default.Node implements SymbolName {
            public SymbolNameReplacement() {
                super(Collections.EMPTY_LIST);
            }
            public Token identifier() {
                return typeDefinition().identifier();
            }
        }
    }
    
}

