
package parser;

public class JavaLikeParser extends JavaLikeSyntax {
    public static void main(java.lang.String[] args) {
        try {
            JavaLikeParser p = new JavaLikeParser();
            for (int i = 0; i < args.length; i++) {
                java.io.File file = new java.io.File(args[i]);
                System.out.println(file);
                
                System.out.println(p.parseTest(file));
            }
        } catch(java.lang.Exception x) {
            x.printStackTrace();
        }
    }
    
    protected LexicalAnalyzer createLexicalAnalyzer(String sourceName, CharSequence text, int tabStop) throws ParseException {
        return new Default.LexicalAnalyzer(sourceName, text, tabStop) {
            protected char nextChar() throws ParseException {
                return super.nextUnicodeEscapedChar();
            }
            public Token next() throws ParseException {
                Token result = super.next();
                if (result.getSymbolID() == TOKEN_IDENTIFIER) {
                    String image = result.getImage();
                    int i = 0;
                    for (; i < image.length(); i++) {
                        char ch = image.charAt(i);
                        if (i == 0) {
                            if (!Character.isJavaIdentifierStart(ch))
                                break;
                        } else {
                            if (!Character.isJavaIdentifierPart(ch))
                                break;
                        }
                    }
                    if (i < image.length())
                        throw new ParseException("The " + i + "th letter \\u" + Integer.toHexString(image.charAt(i)) +  " of the token " + result + " cannot be used.", result);
                }
                return result;
            }
        };
    }
    
    private static aspect Aspect {
        public long IntegerLiteral.value() {
            String image = token().getImage();
            char last = image.charAt(image.length() - 1);
            if (last == 'l' || last == 'L') {
                image = image.substring(0, image.length() - 1);
            }
            if (image.length() <= 1 || image.charAt(0) != '0') {
                return Long.parseLong(image);
            }
            char second = image.charAt(1);
            if (second == 'x' || second == 'X') {
                return Long.parseLong(image.substring(2), 16);
            } else {
                return Long.parseLong(image, 8);
            }
        }
        public double FloatingPointLiteral.value() {
            String image = token().getImage();
            char last = image.charAt(image.length() - 1);
            if (last == 'f' || last == 'F' || last == 'd' || last == 'D') {
                image = image.substring(0, image.length() - 1);
            }
            return Double.parseDouble(image);
        }
        public boolean BooleanLiteral.value() {
            if (token().getImage().equals("true")) {
                return true;
            } else {
                assert token().getImage().equals("false");
                return false;
            }
        }
        public char CharacterLiteral.value() {
            String image = token().getImage();
            char ch = image.charAt(1);
            if (ch != '\\') {
                return ch;
            }
            
            ch = image.charAt(2);
            switch(ch) {
            case 'n':   return '\n';
            case 't':   return '\t';
            case 'b':   return '\b';
            case 'r':   return '\r';
            case 'f':   return '\f';
            
            case '\\':
            case '\'':
            case '\"':
                return ch;
            
            default:
                assert Character.digit(ch, 8) != -1;
                String octal = image.substring(2, image.length() - 1);
                return (char) Integer.parseInt(octal, 8);
            }
        }
        
        private String StringLiteral.value = null;
        public String StringLiteral.value() {
            if (this.value != null)
                return this.value;
            
            StringBuffer result = new StringBuffer();
            String image = token().getImage();
            int maz = image.length() - 1;
            for (int i = 1; i < maz;) {
                char ch = image.charAt(i++);
                if (ch != '\\') {
                    result.append(ch);
                } else {
                    assert i < maz;
                    ch = image.charAt(i++);
                    switch(ch) {
                    case 'n':   result.append('\n');    break;
                    case 't':   result.append('\t');    break;
                    case 'b':   result.append('\b');    break;
                    case 'r':   result.append('\r');    break;
                    case 'f':   result.append('\f');    break;
                    
                    case '\\':
                    case '\'':
                    case '\"':
                        result.append(ch);
                        break;
                    
                    default:
                        assert Character.digit(ch, 8) != -1;
                        {
                            StringBuffer octal = new StringBuffer();
                            octal.append(ch);
                            int max = ('0' <= ch && ch <= '3') ? 3 : 2;
                            while (--max > 0) {
                                if (i >= maz)
                                    break;
                                ch = image.charAt(i);
                                if (Character.digit(ch, 8) == -1)
                                    break;
                                octal.append(ch);
                                i++;
                            }
                            result.append((char) Integer.parseInt(octal.toString(), 8));
                        }
                        break;
                    }
                }
            }
            this.value = result.toString();
            return this.value;
        }
    }
}

