
import java.io.*;
import junit.framework.*;

public class TigerParser_Test extends TestCase {
    public TigerParser_Test(String name) {
        super(name);
    }
    
    private static void parse(TigerParser p, File file) throws IOException, TigerParser.ParseException {
        if (file.isDirectory()) {
            //System.out.println(file);
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; i++) {
                parse(p, files[i]);
            }
        } else {
            String filename = file.toString();
            if (filename.endsWith("LogManager.java")) {
                System.out.println(file + " -- skiped.");
            } else if (!filename.endsWith(".java")) {
                boolean parsed = false;
                try {
                    p.parseCompilationUnit(file);
                    parsed = true;
                } catch (TigerParser.ParseException x) {
                }
                if (parsed) {
                    System.out.println(file);
                    throw new RuntimeException("test failed.");
                }
            } else {
                boolean parsed = false;
                try {
                    p.parseCompilationUnit(file);
                    parsed = true;
                } finally {
                    if (!parsed)
                        System.out.println(file);
                }
            }
        }
    }
    
    public void test() throws IOException, TigerParser.ParseException {
        TigerParser p = new TigerParser(true);
        String jdkHome = System.getProperty("JDK_HOME");
        assertTrue(jdkHome != null);
        File file = new File(jdkHome, "src");
        //System.out.println("quick.test=" + System.getProperty("quick.test", "not defined"));
        //file = new File(new File(new File(jdkHome, "src"), "java"), "lang");
        if ("true".equals(System.getProperty("quick.test", "false")))
            file = new File(new File(new File(jdkHome, "src"), "java"), "lang");
        System.out.println(file);
        parse(p, file);
        
        String buildFile = System.getProperty("ant.file");
        file = new File(new File(new File(buildFile).getParentFile(), "_private"), "examples");
        if (file.exists()) {
            System.out.println(file);
            parse(p, file);
        }
    }
}
