
public class TigerParser extends TigerSyntax {
    private final boolean supportAssertion;
    public TigerParser(boolean supportAssertion) {
        this.supportAssertion = supportAssertion;
    }
    
    protected LexicalAnalyzer createLexicalAnalyzer(String sourceName, CharSequence text, int tabStop) throws ParseException {
        return new Default.LexicalAnalyzer(sourceName, text, tabStop) {
            protected char nextChar() throws ParseException {
                return super.nextUnicodeEscapedChar();
            }
            public Token next() throws ParseException {
                Token result = super.next();
                if (!supportAssertion && result.getSymbolID() == TOKEN_ASSERT) {
                    result = new Default.Token(TOKEN_IDENTIFIER, result.getImage(), result.getOriginalImage(), result);
                }
                if (result.getSymbolID() == TOKEN_IDENTIFIER) {
                    String image = result.getImage();
                    int i = 0;
                    for (; i < image.length(); i++) {
                        char ch = image.charAt(i);
                        if (i == 0) {
                            if (!Character.isJavaIdentifierStart(ch))
                                break;
                        } else {
                            if (!Character.isJavaIdentifierPart(ch))
                                break;
                        }
                    }
                    if (i < image.length())
                        throw new ParseException("The " + i + "th letter \\u" + Integer.toHexString(image.charAt(i)) +  " of the token " + result + " cannot be used.", result);
                }
                return result;
            }
        };
    }
    
    public static void main(String[] args) {
        try {
            CompilationUnit root = new TigerParser(true).parseCompilationUnit(new java.io.File(args[0]));
            System.out.println(root);
        } catch(Exception x) {
            x.printStackTrace();
        }
    }
}

