
public class JavaParser extends JavaSyntax {
    private final boolean supportAssertion;
    public JavaParser(boolean supportAssertion) {
        this.supportAssertion = supportAssertion;
    }
    
    protected LexicalAnalyzer createLexicalAnalyzer(String sourceName, CharSequence text, int tabStop) throws ParseException {
        return new Default.LexicalAnalyzer(sourceName, text, tabStop) {
            public Token next() throws ParseException {
                Token result = super.next();
                if (!supportAssertion && result.getSymbolID() == TOKEN_ASSERT) {
                    result = new Default.Token(TOKEN_IDENTIFIER, result.getImage(), result.getOriginalImage(), result);
                }
                return result;
            }
            protected char nextChar() throws ParseException {
                int startIndex = super.index;
                int startLine = super.line;
                int startColumn = super.column;
                int index = startIndex;
                if (text.charAt(index) == '\\' && index + 1 < end && text.charAt(index + 1) == 'u') {
                    int count = 0;
                    while (index >= 0 && text.charAt(index--) == '\\')
                        count++;
                    if (count % 2 == 0)
                        return super.nextChar();
                } else {
                    return super.nextChar();
                }
                
                char ch = super.nextChar();
                assert ch =='\\';
                ch = super.nextChar();
                assert ch == 'u';
                try {
                    do {
                        ch = super.nextChar();
                    } while (ch == 'u');
                    StringBuffer number = new StringBuffer(4);
                    number.append(ch);
                    number.append(super.nextChar());
                    number.append(super.nextChar());
                    number.append(super.nextChar());
                    int code = Integer.parseInt(number.toString(), 16);
                    return (char) code;
                } catch (NumberFormatException x) {
                } catch (IndexOutOfBoundsException x) {
                }
                throw new ParseException("illigal Unicode escape: " + text.subSequence(startIndex, super.index), super.sourceName, startIndex, startLine, startColumn);
            }
        };
    }
    
    public static void main(String[] args) {
        try {
            CompilationUnit root = new JavaParser(true).parseCompilationUnit(new java.io.File(args[0]));
            System.out.println(root);
        } catch(Exception x) {
            x.printStackTrace();
        }
    }
}

