
import java.io.*;
import junit.framework.*;
import parser.ExpressionParser;
import parser.ExpressionParser.Root;

public class Example_Test extends TestCase {
    public Example_Test(String name) {
        super(name);
    }
    
    private String expressionImage = "1 + 2 * 3 + 4 / (5 - 6)";
    private int value = 1 + 2 * 3 + 4 / (5 - 6);
    
    public void test1() throws ExpressionParser.ParseException {
        int result = Example1.evaluate(new ExpressionParser().parseRoot("test", expressionImage, 8).expression());
        assertTrue(result == value);
    }
    
    public void test2() throws ExpressionParser.ParseException {
        Root root = new Example2().parseRoot("test", expressionImage, 8);
        Example2.Expression expression = (Example2.Expression) root.expression();
        int result = expression.evaluate();
        assertTrue(result == value);
    }
}
