
import parser.ExpressionParser;
import parser.ExpressionParser.*;

public class Example2 extends ExpressionParser {
    protected Node createNode(int symbolID, NodeInitializationParameters parameters) throws ParseException {
        switch(symbolID) {
        case Addition.ID:
            return new Addition(parameters);
        case Subtraction.ID:
            return new Subtraction(parameters);
        case Multiplication.ID:
            return new Multiplication(parameters);
        case Division.ID:
            return new Division(parameters);
        case Number.ID:
            return new Number(parameters);
        }
        return super.createNode(symbolID, parameters);
    }
    
    public static interface Expression {
        int evaluate();
    }
    
    public class Addition extends Default.Addition implements Expression {
        public Addition(NodeInitializationParameters parameters) {
            super(parameters, false);
        }
        public int evaluate() {
            Expression operand1 = (Expression) operand1();
            Expression operand2 = (Expression) operand2();
            return operand1.evaluate() + operand2.evaluate();
        }
    }
    public class Subtraction extends Default.Subtraction implements Expression {
        public Subtraction(NodeInitializationParameters parameters) {
            super(parameters, false);
        }
        public int evaluate() {
            Expression operand1 = (Expression) operand1();
            Expression operand2 = (Expression) operand2();
            return operand1.evaluate() - operand2.evaluate();
        }
    }
    public class Multiplication extends Default.Multiplication implements Expression {
        public Multiplication(NodeInitializationParameters parameters) {
            super(parameters, false);
        }
        public int evaluate() {
            Expression operand1 = (Expression) operand1();
            Expression operand2 = (Expression) operand2();
            return operand1.evaluate() * operand2.evaluate();
        }
    }
    public class Division extends Default.Division implements Expression {
        public Division(NodeInitializationParameters parameters) {
            super(parameters, false);
        }
        public int evaluate() {
            Expression operand1 = (Expression) operand1();
            Expression operand2 = (Expression) operand2();
            return operand1.evaluate() / operand2.evaluate();
        }
    }
    public class Number extends Default.Number implements Expression {
        public Number(NodeInitializationParameters parameters) {
            super(parameters, false);
        }
        public int evaluate() {
            return Integer.parseInt(value().getImage());
        }
    }
    
    public static void main(String[] args) {
        try {
            Root root = new Example2().parseRoot(new java.io.File(args[0]));
            Expression expression = (Expression) root.expression();
            System.out.println(expression.evaluate());
            //System.out.println(root);
        } catch(Exception x) {
            x.printStackTrace();
        }
    }
}

