
import parser.ExpressionParser;
import parser.ExpressionParser.*;
import parser.ExpressionParser.Number;

public class Example1 {
    public static int evaluate(Expression expression) {
        if (expression instanceof Addition) {
            Addition x = (Addition) expression;
            return evaluate(x.operand1()) + evaluate(x.operand2());
        } else if (expression instanceof Subtraction) {
            Subtraction x = (Subtraction) expression;
            return evaluate(x.operand1()) - evaluate(x.operand2());
        } else if (expression instanceof Multiplication) {
            Multiplication x = (Multiplication) expression;
            return evaluate(x.operand1()) * evaluate(x.operand2());
        } else if (expression instanceof Division) {
            Division x = (Division) expression;
            return evaluate(x.operand1()) / evaluate(x.operand2());
        } else if (expression instanceof Number) {
            Number x = (Number) expression;
            return Integer.parseInt(x.value().getImage());
        } else {
            throw new RuntimeException();
        }
    }
    
    public static void main(String[] args) {
        try {
            Root root = new ExpressionParser().parseRoot(new java.io.File(args[0]));
            Expression expression = root.expression();
            System.out.println(evaluate(expression));
            //System.out.println(root);
        } catch(Exception x) {
            x.printStackTrace();
        }
    }
}

