
package parser;

import java.util.*;

public class CParser extends CSyntax {
    protected CSyntax.LexicalAnalyzer createLexicalAnalyzer(String sourceName, CharSequence text, int tabStop) {
        return new LexicalAnalyzer(sourceName, text, tabStop);
    }
    
    private static class LexicalAnalyzer extends Default.LexicalAnalyzer {
        public LexicalAnalyzer(String sourceName, CharSequence text, int tabStop) {
            super(sourceName, text, tabStop);
        }
        
        private final LinkedList stack;
        {
            stack = new LinkedList();
            stack.addFirst(new LinkedHashMap());
        }
        public Token next() throws ParseException {
            Token token = super.next();
            Boolean typedef = null;
            Iterator it0 = stack.iterator();
            while (it0.hasNext()) {
                Map map = (Map) it0.next();
                typedef = (Boolean) map.get(token.getImage());
                if (typedef != null)
                    break;
            }
            
            if (typedef != null && typedef.equals(Boolean.TRUE)) {
                return new Default.Token(TOKEN_TYPEDEF_NAME, token.getImage(), token.getOriginalImage(), token);
            }
            return token;
        }
        
        private boolean typedef;
        private Map preparedMap;
        private boolean paramClosed;
        private void init() {
            init(true);
        }
        private void init(boolean clearTypedef) {
            if (clearTypedef)
                typedef = false;
            preparedMap = null;
            paramClosed = false;
        }
        {
            init();
        }
        private int abstractCount = 0;
        private int structCount = 0;
        private int paramCount = 0;
        private void taggedTokenShifted(Token token, int tag) {
            Map map = (Map) stack.getFirst();
            switch (tag) {
            default:
                assert false;
            
            case TAG_TYPEDEF:
                typedef = true;
                break;
            
            case TAG_STRUCT_BEGIN:
                structCount++;
                break;
            case TAG_STRUCT_END:
                structCount--;
                break;
            
            case TAG_ENUMERATOR:
                map.put(token.getImage(), new Boolean(false));
                break;
            
            case TAG_PARAM_BEGIN:
                if (preparedMap == null)
                    preparedMap = new LinkedHashMap();
                paramCount++;
                break;
            case TAG_PARAM_END:
                paramCount--;
                if (paramCount == 0)
                    paramClosed = true;
                break;
            
            case TAG_DECLARED_IDENTIFIER:
                if (abstractCount > 0) {
                    // a parameter name of a function type.
                } else if (structCount > 0) {
                    // a member of a struct.
                } else if (paramClosed) {
                    // a parameter name of a function type, or an already-registered parameter name of a function.
                } else if (paramCount > 1) {
                    // a parameter name of a function type.
                } else if (paramCount == 1) {
                    preparedMap.put(token.getImage(), new Boolean(false));
                } else {
                    map.put(token.getImage(), new Boolean(typedef));
                }
                break;
            
            case TAG_DECLARATOR_SEPARATOR:
                init(false);
                break;
            
            case TAG_DECLARATION_END:
                init();
                break;
            
            case TAG_BLOCK_BEGIN:
                if (preparedMap != null)
                    stack.addFirst(preparedMap);
                else
                    stack.addFirst(new LinkedHashMap());
                init();
                break;
            case TAG_BLOCK_END:
                stack.removeFirst();
                break;
            
            case TAG_ABSTRACT_BEGIN:
                abstractCount++;
                break;
            case TAG_ABSTRACT_END:
                abstractCount--;
                break;
            
            }
        }
    }
    
    protected void taggedTokenShifted(CSyntax.LexicalAnalyzer analyzer, Token token, int tag) {
        LexicalAnalyzer a = (LexicalAnalyzer) analyzer;
        a.taggedTokenShifted(token, tag);
    }
    
    
    public static void main(java.lang.String[] args) {
        try {
            CParser p = new CParser();
            for (int i = 0; i < args.length; i++) {
                java.io.File file = new java.io.File(args[i]);
                System.out.println(file);
                
                System.out.println(p.parseTranslationUnit(file));
                break;
            }
        } catch(java.lang.Exception x) {
            x.printStackTrace();
        }
    }
    
}

