
import java.util.*;
import java.util.regex.*;
import java.io.*;
import org.apache.tools.ant.*;
import org.apache.tools.ant.taskdefs.*;
import org.apache.tools.ant.util.*;
import pnuts.lang.*;
import pnuts.lang.Property;
import pnuts.lang.Package;

public class MetaTextTask extends MatchingTask {
    private File base;
    public void setSrcdir(File dir) {
        base = dir;
    }
    
    private File destination;
    public void setDestdir(File dir) {
        destination = dir;
    }
    
    public void execute() throws BuildException {
        try {
            String[] filenames = getDirectoryScanner(base).getIncludedFiles();
            FileNameMapper mapper = new FileNameMapper() {
                public void setFrom(String from) {
                }
                public void setTo(String to) {
                }
                private String[] EMPTY = new String[0];
                public String[] mapFileName(String filename) {
                    String str = ".meta.";
                    int index = filename.indexOf(str);
                    if (index < 0)
                        return EMPTY;
                    for (;;) {
                        filename = filename.substring(0, index) + "." + filename.substring(index + str.length());
                        index = filename.indexOf(str);
                        if (index < 0)
                            break;
                    }
                    return new String[] { filename };
                }
            };
            filenames = new SourceFileScanner(this).restrict(filenames, base, destination, mapper);
            if (filenames.length > 0) {
                for (int i = 0; i < filenames.length; i++) {
                    String filename = filenames[i];
                    File src = new File(base, filename);
                    File dst = new File(destination, mapper.mapFileName(filename)[0]);
                    System.out.println("from " + src + " to " + dst);
                    new MetaText(src, dst, getOwningTarget().getProject().getProperties());
                }
            }
        } catch (Exception x) {
            x.printStackTrace();
            if (x instanceof BuildException) {
                throw (BuildException) x;
            } else {
                throw new BuildException(x);
            }
        }
    }
    
    public static void main(String[] args) {
        try {
            if (args.length != 2)
                System.out.println("usage: MetaText <input file> <output file>");
            else
                new MetaText(new File(args[0]), new File(args[1]), System.getProperties());
        } catch (Exception x) {
            x.printStackTrace();
        }
        //try{System.in.read();}catch(Exception e){e.printStackTrace();}
    }
}

class MetaText {
    public MetaText(File input, File output, Map properties) throws IOException {
        Context context = new Context();
        Package p = new Package("metatext");
        context.setCurrentPackage(p);
        p.set("properties", new MapProperty(properties), context);
        p.set("docfile", input, context);
        p.set("docfiledir", input.getParentFile(), context);
        
        Reader reader = null;
        Writer writer = null;
        boolean good = false;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(input), "SJIS"));
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(output), "SJIS"));
            
            StringBuffer buffer = new StringBuffer((int) input.length());
            for (;;) {
                int ch = reader.read();
                if (ch < 0)
                    break;
                if (ch =='\u00A5')
                    ch = '\\';
                buffer.append((char) ch);
            }
            
            // replace <!--Pnuts ... -->
            String head = "<!--Pnuts";
            String tail = "-->";
            int index = 0;
            for (;;) {
                index = buffer.indexOf(head, index);
                if (index < 0)
                    break;
                
                int lastIndex = buffer.indexOf(tail, index);
                if (lastIndex < 0)
                    throw new RuntimeException("error: " + tail + " missing");
                lastIndex += tail.length();
                
                String text = buffer.substring(index + head.length(), lastIndex - tail.length());
                String replacement = (String) Pnuts.eval(text, context);
                
                buffer.replace(index, lastIndex, replacement.toString());
                index += replacement.length();
            }
            
            final String meta = ".meta.";
            // replace <... .meta. ...>
            boolean inTag = false;
            for (int i = 0; i < buffer.length(); i++) {
                char ch = buffer.charAt(i);
                if (ch == '<') {
                    inTag = true;
                } else if (ch == '>') {
                    inTag = false;
                }
                int end = Math.min(buffer.length(), i + meta.length());
                if (buffer.substring(i, end).equals(meta)) {
                    buffer.replace(i, i + meta.length(), ".");
                }
            }
            
            writer.write(embedCData(buffer.toString()));
            good = true;
        } finally {
            if (reader != null)
                reader.close();
            if (writer != null)
                writer.close();
            if (!good) {
                if (output.exists())
                    output.delete();
            }
        }
    }
    
    public static class MapProperty implements Property {
        private final Map map;
        public MapProperty(Map map) {
            this.map = map;
        }
        public void set(String name, Object value, Context context) {
            throw new UnsupportedOperationException("can not set(" + name + ", " + value + ")");
        }
        public Object get(String name, Context context) {
            return get(name);
        }
        public Object get(String name) {
            String value = (String) map.get(name);
            if (value == null)
                throw new NoSuchElementException(name + " not found.");
            return value;
        }
    }
    
    private String embedCData(String master) {
        StringBuffer buffer = new StringBuffer(master);
        String head = "<![CDATA[";
        String tail = "]]>";
        int index = 0;
        for (;;) {
            index = buffer.indexOf(head, index);
            if (index < 0)
                break;
            
            int lastIndex = buffer.indexOf(tail, index);
            if (lastIndex < 0)
                throw new RuntimeException("error: " + tail + " missing");
            lastIndex += tail.length();
            
            String text = buffer.substring(index + head.length(), lastIndex - tail.length());
            buffer.delete(index, lastIndex);
            for (int i = 0; i < text.length(); i++) {
                char ch = text.charAt(i);
                final String replacement;
                if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9') {
                    replacement = Character.toString(ch);
                } else {
                    switch (ch) {
                    default:
                        replacement = "&#" + (int) ch + ";";
                        break;
                    case '\n':
                    case '\r':
                    case ' ':
                    case '\t':
                        replacement = Character.toString(ch);
                        break;
                    }
                }
                buffer.insert(index, replacement);
                index += replacement.length();
            }
        }
        return buffer.toString();
    }
}

