
import java.util.*;
import java.io.*;
import org.apache.tools.ant.*;
import org.apache.tools.ant.taskdefs.*;
import org.apache.tools.ant.util.*;

public class MetaJavaTask extends MatchingTask {
    private File base;
    public void setSrcdir(File dir) {
        base = dir;
    }
    
    private File destination;
    public void setDestdir(File dir) {
        destination = dir;
    }
    
    public void execute() throws BuildException {
        try {
            String[] filenames = getDirectoryScanner(base).getIncludedFiles();
            GlobPatternMapper mapper = new GlobPatternMapper();
            mapper.setFrom("*.meta.java");
            mapper.setTo("*.java");
            filenames = new SourceFileScanner(this).restrict(filenames, base, destination, mapper);
            if (filenames.length > 0) {
                for (int i = 0; i < filenames.length; i++) {
                    String filename = filenames[i];
                    File src = new File(base, filename);
                    File dst = new File(destination, mapper.mapFileName(filename)[0]);
                    System.out.println("from " + src + " to " + dst);
                    new MetaJava(src, dst);
                }
            }
        } catch (Exception x) {
            if (x instanceof BuildException) {
                throw (BuildException) x;
            } else {
                throw new BuildException(x);
            }
        }
    }
    
    public static void main(String[] args) {
        try {
            if (args.length != 2)
                System.out.println("usage: metajava <input file> <output file>");
            else
                new MetaJava(new File(args[0]), new File(args[1]));
        } catch (Exception x) {
            x.printStackTrace();
        }
        //try{System.in.read();}catch(Exception e){e.printStackTrace();}
    }
}

class MetaJava {
    private PrintWriter writer = null;
    public MetaJava(File input, File output) throws IOException {
        try {
            output.getParentFile().mkdirs();
            writer = new PrintWriter(new FileWriter(output));
            output(input);
        } finally {
            if (writer != null) {
                writer.close();
                if (writer.checkError())
                    throw new IOException();
            }
        }
    }
    private void output(File input) throws IOException {
        String canonicalPath = input.getCanonicalPath();
        LineNumberReader reader = new LineNumberReader(new FileReader(input));
        try {
            final String RAW = "]]<<";
            final String WAR = ">>[[";
            boolean raw = false;
            String line;
            while ((line = reader.readLine()) != null) {
                int lineNumber = reader.getLineNumber();
                line = line.trim();
                if (line.equals(RAW)) {
                    raw = true;
                    outputLine(canonicalPath, lineNumber, "");
                } else if (line.equals(WAR)) {
                    raw = false;
                    outputLine(canonicalPath, lineNumber, "");
                } else if (raw) {
                    int index = line.indexOf(WAR);
                    if (line.trim().startsWith("#")) {
                        outputLine(canonicalPath, lineNumber, line.trim().substring(1));
                    } else {
                        if (index < 0) {
                            outputLine(canonicalPath, lineNumber, "println(" + quoted(line.trim()) + ");");
                        } else {
                            StringBuffer exp = new StringBuffer("\"\"");
                            for (;;) {
                                index = line.indexOf(WAR);
                                if (index < 0) {
                                    exp.append(") + (").append(quoted(line));
                                    break;
                                }
                                CharSequence s = line.subSequence(0, index);
                                exp.append(") + (").append(quoted(s));
                                line = line.substring(index + WAR.length());
                                
                                index = line.indexOf(RAW);
                                if (index < 0) {
                                    exp.append(") + (").append(line);
                                    raw = false;
                                    break;
                                }
                                exp.append(") + (").append(line.subSequence(0, index));
                                line = line.substring(index + RAW.length());
                            }
                            outputLine(canonicalPath, lineNumber, "println((" + exp + "));");
                        }
                    }
                } else {
                    int index = line.indexOf(RAW);
                    if (index < 0) {
                        outputLine(canonicalPath, lineNumber, line);
                    } else {
                        StringBuffer exp = new StringBuffer();
                        for (;;) {
                            index = line.indexOf(RAW);
                            if (index < 0) {
                                exp.append(line);
                                break;
                            }
                            CharSequence s = line.subSequence(0, index);
                            exp.append(s);
                            line = line.substring(index + RAW.length());
                            
                            index = line.indexOf(WAR);
                            if (index < 0) {
                                exp.append(quoted(line.trim()));
                                raw = true;
                                break;
                            }
                            exp.append(quoted(line.substring(0, index).trim()));
                            line = line.substring(index + WAR.length());
                        }
                        outputLine(canonicalPath, lineNumber, "println((" + exp + "));");
                    }
                }
            }
        } finally {
            reader.close();
        }
    }
    
    private int indent = 0;
    private int temporalIndent = -1;
    private void outputLine(String canonicalPath, int lineNumber, String str) {
        str = str.trim();
        
        if (str.startsWith("}"))
            indent--;
        if (temporalIndent == -1)
            temporalIndent = indent;
        
        if (str.startsWith("case ") || str.startsWith("default:") || str.startsWith("default "))
            temporalIndent--;
        
        //writer.println("/*");
        //writer.println(canonicalPath + ":" + lineNumber + "  */");
        for (int i = 0; i < temporalIndent; i++)
            writer.print("    ");
        writer.println(str);
        
        temporalIndent = -1;
        if (str.endsWith("{")) {
            indent++;
        } else {
            if (str.startsWith("if ") || str.startsWith("while ") || str.startsWith("do ") || str.startsWith("for ")
                        || str.startsWith("if(") || str.startsWith("while(") || str.startsWith("do(") || str.startsWith("for(")
                        || str.equals("else") || str.startsWith("else "))
                temporalIndent = indent + 1;
        }
    }
    
    private CharSequence quoted(CharSequence str) {
        StringBuffer quoted = new StringBuffer("\"");
        for (int i = 0; i < str.length(); i++) {
            char ch = str.charAt(i);
            switch (ch) {
            default:
                if (0x0020 <= ch && ch <= 0x007E) {
                    quoted.append(ch);
                } else {
                    String hex = "000" + Integer.toString(ch, 16);
                    hex = hex.toUpperCase(Locale.ENGLISH).substring(hex.length() - 4);
                    quoted.append("\\u").append(hex);
                }
                break;
            case '\n':   quoted.append("\\n");      break;
            case '\t':   quoted.append("\\t");      break;
            case '\b':   quoted.append("\\b");      break;
            case '\r':   quoted.append("\\r");      break;
            case '\f':   quoted.append("\\f");      break;
            case '\\':   quoted.append("\\\\");     break;
            //case '\'':   quoted.append("\\\'");     break;
            case '\"':   quoted.append("\\\"");     break;
            }
        }
        quoted.append("\"");
        return quoted;
    }
}

