
import java.util.*;
import java.io.*;
import org.apache.tools.ant.*;

public class LoggerGeneratorTask extends Task {
    private File outputDir;
    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }
    
    public void execute() throws BuildException {
        try {
            if (outputDir == null)
                throw new BuildException("Invalid outputDir: " + outputDir);
            
            File output = outputDir;
            String[] children = { "jp", "gr", "java_conf", "koto", "notavacc", "Logger.java" };
            for (int i = 0; i < children.length; i++)
                output = new File(output, children[i]);
            if (output.exists())
                return;
            
            System.out.println("outputting " + output);
            new LoggerGenerator(output);
        } catch (Exception x) {
            if (x instanceof BuildException) {
                throw (BuildException) x;
            } else {
                throw new BuildException(x);
            }
        }
    }
}


class LoggerGenerator {
    private PrintWriter writer = null;
    public LoggerGenerator(File output) throws IOException {
        try {
            output.getParentFile().mkdirs();
            writer = new PrintWriter(new FileWriter(output));
            generate();
        } finally {
            if (writer != null) {
                writer.close();
                if (writer.checkError())
                    throw new IOException();
            }
        }
    }
    
    
    private int indent = 0;
    private void println(String str) {
        str = str.trim();
        if (str.length() == 0) {
            return;
        }
        
        if (str.startsWith("}")) {
            indent--;
        }
        for (int i = 0; i < indent; i++) {
            writer.print("    ");
        }
        writer.println(str);
        
        if (str.endsWith("{")) {
            indent++;
        }
    }
    
    private void generate() {
        String[] lebelNames = { "LEVEL_FATAL", "LEVEL_ERROR", "LEVEL_WARNING", "LEVEL_INFORMATION", "LEVEL_VERBOSE", "LEVEL_VERBOSEST" };
        String[] methodNames = { "fatal", "error", "warn", "inform", "verbose", "verbosest" };
        
]]<<
        package jp.gr.java_conf.koto.notavacc;
        
        import java.util.*;
        import java.io.*;
        import java.text.*;
        import jp.gr.java_conf.koto.io.*;
        import jp.gr.java_conf.koto.notavacc.parser.Original.*;
        
        public final class Logger {
            #for (int i = 0; i < lebelNames.length; i++) {
                public static final int >>[[ lebelNames[i] ]]<< = >>[[ i ]]<<;
            #}
            private final String[] informationTypeStrings = new String[] {
                "",
                "",
                "warning: ",
                "",
                "verbose information: ",
                "verboser information: ",
            };
            
            private final boolean withoutParentPath;
            private final int verboseLevel;
            private final ResourceBundle boundle;
            private final PrintWriter writer;
            
            private boolean hasError = false;
            public boolean hasError() {
                return hasError;
            }
            
            public Logger() {
                this(false, 0, null, null);
            }
            public Logger(boolean withoutParentPath, int verboseLevel, Writer writer) {
                this(withoutParentPath, verboseLevel, null, writer);
            }
            public Logger(boolean withoutParentPath, int verboseLevel, ResourceBundle boundle, Writer writer) {
                this.withoutParentPath = withoutParentPath;
                this.verboseLevel = verboseLevel;
                this.boundle = boundle;
                if (writer == null) {
                    this.writer = new PrintWriter(System.out, true);
                } else if (writer instanceof PrintWriter) {
                    this.writer = (PrintWriter) writer;
                } else {
                    this.writer = new PrintWriter(writer, true);
                }
                
                if (verboseLevel < LEVEL_VERBOSEST) {
                    informationTypeStrings[LEVEL_VERBOSE] = "";
                }
            }
            public void close() throws IOException {
                writer.flush();
                if (writer.checkError())
                    throw new IOException();
            }
            protected void finalize() throws IOException {
                close();
            }
            
            public int verboseLevel() {
                return verboseLevel;
            }
            
            private String lineSeparator = System.getProperty("line.separator", "\n");
            private Map formatCache = new HashMap();
            public void report(int level, String sourceName, int line, String message, Object[] params) {
                if (verboseLevel >= level) {
                    boolean printed = false;
                    
                    // print the name of the source.
                    if (sourceName != null) {
                        if (sourceName.indexOf(':') < 0 && sourceName.indexOf(' ') < 0) {
                            writer.print(sourceName);
                        } else {
                            writer.print('"' + sourceName + '"');
                        }
                        writer.print(":");
                        printed = true;
                    }
                    
                    // print the line.
                    if (line > 0) {
                        writer.print(line);
                        writer.print(":");
                        printed = true;
                    }
                    
                    if (printed) {
                        writer.print(' ');
                    }
                    
                    // print the message type.
                    writer.print(informationTypeStrings[level]);
                    
                    // print the detail.
                    MessageFormat format = (MessageFormat) formatCache.get(message);
                    if (format == null) {
                        String s = message;
                        if (boundle != null) {
                            try {
                                s = boundle.getString(s);
                            } catch(MissingResourceException ignored) {
                            } catch(ClassCastException ignored) {
                            }
                        }
                        StringBuffer buffer = new StringBuffer();
                        for (int i = 0; i < s.length(); i++) {
                            char ch = s.charAt(i);
                            if (ch == '\n') {
                                buffer.append(lineSeparator);
                            } else {
                                buffer.append(ch);
                            }
                        }
                        format = new MessageFormat(buffer.toString());
                        formatCache.put(message, format);
                    }
                    writer.print(format.format(params));
                    
                    // the end of line.
                    writer.println();
                }
                if (level <= LEVEL_ERROR) {
                    hasError = true;
                }
                if (level <= LEVEL_FATAL) {
                    fatal();
                }
            }
            public void report(int level, Token token, String message, Object[] params) {
                String sourceName = null;
                try {
                    sourceName = token.getSourceName();
                } catch (UnsupportedOperationException x) {
                    // ignore.
                }
                int line = -1;
                try {
                    line = token.getLine();
                } catch (UnsupportedOperationException x) {
                    // ignore.
                }
                report(level, sourceName, line, message, params);
            }
            
            public void fatal() {
                throw new FatalErrorException();
            }
            
            public static class FatalErrorException extends RuntimeException {
                private FatalErrorException() {
                    super("fatal error");
                }
            }
            
            private static final Object[] EMPTY_ARRAY = new Object[0];
            #for (int i = -1; i < methodNames.length; i++) {
                #String methodName = (i == -1) ? "report" : methodNames[i];
                #String labelName = (i == -1) ? "level" : lebelNames[i];
                #String level = (i == -1) ? "int level, " : "";
                #for (int j = -1; j <= 4; j++) {
                    #StringBuffer params = new StringBuffer();
                    #StringBuffer params2 = new StringBuffer();
                    #StringBuffer args = new StringBuffer();
                    #if (j == -1) {
                        #params.append(", Object[] params");
                        #params2 = null;
                        #args.append("params");
                    #} else if (j == 0) {
                        #params2 = null;
                        #args.append("EMPTY_ARRAY");
                    #} else {
                        #args.append("new Object[] { ");
                        #for (int k = 1; k <= j; k++) {
                            #params.append(", Object p").append(k);
                            #if (k == 1) {
                                #params2.append(", Token p").append(k);
                            #} else {
                                #params2.append(", Object p").append(k);
                            #}
                            #args.append("p").append(k).append(", ");
                        #}
                        #args.append("}");
                    #}
                    public void >>[[ methodName ]]<<(>>[[ level ]]<<String message>>[[ params ]]<<) {
                        report(>>[[ labelName ]]<<, (String) null, -1, message, >>[[ args ]]<<);
                    }
                    public void >>[[ methodName ]]<<(>>[[ level ]]<<File file, String message>>[[ params ]]<<) {
                        report(>>[[ labelName ]]<<, Main.getFileName(file, withoutParentPath), -1, message, >>[[ args ]]<<);
                    }
                    public void >>[[ methodName ]]<<(>>[[ level ]]<<File file, int line, String message>>[[ params ]]<<) {
                        report(>>[[ labelName ]]<<, Main.getFileName(file, withoutParentPath), line, message, >>[[ args ]]<<);
                    }
                    #if (i != -1 || j != -1) {
                        public void >>[[ methodName ]]<<(>>[[ level ]]<<String sourceName, int line, String message>>[[ params ]]<<) {
                            report(>>[[ labelName ]]<<, sourceName, line, message, >>[[ args ]]<<);
                        }
                        public void >>[[ methodName ]]<<(>>[[ level ]]<<Token token, String message>>[[ params ]]<<) {
                            report(>>[[ labelName ]]<<, token, message, >>[[ args ]]<<);
                        }
                    #}
                    #if (j > 0) {
                        public void >>[[ methodName ]]<<(>>[[ level ]]<<String message>>[[ params2 ]]<<) {
                            report(>>[[ labelName ]]<<, p1, message, >>[[ args ]]<<);
                        }
                    #}
                #}
            #}
        }
>>[[
    }
}

