/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import jp.gr.java_conf.koto.util.CommandLineParameter;

public class CommandLineChecker {
    private CommandLineParameter[] parameters;
    private final List arguments;
    private final Map optionCount;
    private final Map optionArguments;

    public CommandLineChecker(CommandLineParameter[] params, String[] args) {
        String arg;
        this.parameters = params;
        this.arguments = new ArrayList(args.length);
        int i = 0;
        while (i < args.length) {
            block19: {
                arg = args[i];
                if (arg.equals("--")) break;
                if (arg.startsWith("--")) {
                    String option = arg.substring(2);
                    int j = 0;
                    while (j < params.length) {
                        CommandLineParameter clp = params[j];
                        if (option.equals(clp.string)) {
                            ++clp.hitCount;
                            if (clp.parameter == null) break;
                            if (++i < args.length) {
                                clp.argument = args[i];
                                break;
                            }
                            System.err.println("argument of option '" + option + "' is missing, ignored.");
                            break;
                        }
                        ++j;
                    }
                    if (j >= params.length) {
                        this.arguments.add(arg);
                    }
                } else if (arg.startsWith("-")) {
                    int j = 1;
                    while (j < arg.length()) {
                        char ch = arg.charAt(j);
                        int k = 0;
                        while (k < params.length) {
                            CommandLineParameter clp = params[k];
                            if (clp.character == ch) {
                                ++clp.hitCount;
                                if (clp.parameter == null) break;
                                if (++j < arg.length()) {
                                    clp.argument = arg.substring(j, arg.length());
                                } else if (++i < args.length) {
                                    clp.argument = args[i];
                                } else {
                                    System.err.println("argument of option '" + ch + "' is missing, ignored.");
                                }
                                break block19;
                            }
                            ++k;
                        }
                        if (k >= params.length) {
                            System.err.println("unknown option '" + ch + "' in '" + arg + "', ignored.");
                        }
                        ++j;
                    }
                } else {
                    this.arguments.add(arg);
                }
            }
            ++i;
        }
        while (i < args.length) {
            arg = args[i];
            this.arguments.add(arg);
            ++i;
        }
        this.optionCount = new HashMap();
        this.optionArguments = new HashMap();
        int k = 0;
        while (k < params.length) {
            CommandLineParameter clp = params[k];
            this.optionCount.put(clp.string, new Integer(clp.hitCount));
            this.optionArguments.put(clp.string, clp.argument);
            ++k;
        }
    }

    public List arguments() {
        return this.arguments;
    }

    public int countOf(String option) throws NoSuchElementException {
        Integer result = (Integer)this.optionCount.get(option);
        if (result == null) {
            throw new NoSuchElementException(option);
        }
        return result;
    }

    public String argumentOf(String option) throws NoSuchElementException {
        return (String)this.optionArguments.get(option);
    }

    public void printOptionUsage(boolean printHiddenOptions) {
        PrintWriter writer = new PrintWriter(System.out);
        this.printOptionUsage(writer, printHiddenOptions);
        writer.flush();
    }

    public void printOptionUsage(PrintWriter writer, boolean printHiddenOptions) {
        if (this.parameters.length == 0) {
            return;
        }
        int maximumLength = 0;
        int i = 0;
        while (i < this.parameters.length) {
            CommandLineParameter clp = this.parameters[i];
            if (printHiddenOptions || !clp.hidden) {
                int length = clp.string.length();
                if (clp.parameter != null) {
                    length += clp.parameter.length() + 3;
                }
                maximumLength = Math.max(maximumLength, length);
            }
            ++i;
        }
        if (this.parameters.length == 1) {
            writer.println("Option:");
        } else {
            writer.println("Options:");
        }
        int i2 = 0;
        while (i2 < this.parameters.length) {
            CommandLineParameter clp = this.parameters[i2];
            if (printHiddenOptions || !clp.hidden) {
                writer.print("  ");
                if (clp.character != '\u0000') {
                    writer.print("-");
                    writer.print(clp.character);
                    if (clp.string != null) {
                        writer.print(", ");
                    } else {
                        writer.print("  ");
                    }
                } else {
                    writer.print("    ");
                }
                int length = 0;
                if (clp.string != null) {
                    writer.print("--");
                    length = 2;
                    writer.print(clp.string);
                    length += clp.string.length();
                    if (clp.parameter != null) {
                        writer.print(" <");
                        writer.print(clp.parameter);
                        writer.print(">");
                        length += clp.parameter.length() + 3;
                    }
                }
                int j = length;
                while (j < maximumLength + 4) {
                    writer.print(' ');
                    ++j;
                }
                writer.println(clp.message);
            }
            ++i2;
        }
    }
}

