/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.notavacc.util;

import java.util.AbstractSet;
import java.util.Iterator;

public final class TreeStackSet
extends AbstractSet {
    public static final TreeStackSet EMPTY_SET = new TreeStackSet(null, null, 0);
    private final TreeStackSet parent;
    private final Object value;
    private final int size;

    private TreeStackSet(TreeStackSet parent, Object value, int size) {
        this.parent = parent;
        this.value = value;
        this.size = size;
    }

    private TreeStackSet(TreeStackSet parent, Object value) {
        this(parent, value, parent.size() + 1);
    }

    public static TreeStackSet push(TreeStackSet stack, Object value) {
        if (stack.contains(value)) {
            return stack;
        }
        return new TreeStackSet(stack, value);
    }

    public int size() {
        return this.size;
    }

    public Iterator iterator() {
        return new CascadeSetIterator(this);
    }

    public static TreeStackSet pushAll(TreeStackSet stack, TreeStackSet data) {
        if (data.isEmpty()) {
            return stack;
        }
        return TreeStackSet.push(TreeStackSet.pushAll(stack, data.parent), data.value);
    }

    private static class CascadeSetIterator
    implements Iterator {
        private TreeStackSet cursor;

        public CascadeSetIterator(TreeStackSet set) {
            this.cursor = set;
        }

        public boolean hasNext() {
            return !this.cursor.isEmpty();
        }

        public Object next() {
            Object result = this.cursor.value;
            this.cursor = this.cursor.parent;
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

