/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.notavacc.types;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.gr.java_conf.koto.notavacc.Environment;
import jp.gr.java_conf.koto.notavacc.Module;
import jp.gr.java_conf.koto.notavacc.lrg.TypeNonterminal;
import jp.gr.java_conf.koto.notavacc.parser.Original;
import jp.gr.java_conf.koto.notavacc.parser.Parser;
import jp.gr.java_conf.koto.notavacc.types.ArrayType;
import jp.gr.java_conf.koto.notavacc.types.Field;
import jp.gr.java_conf.koto.notavacc.types.NodeType;
import jp.gr.java_conf.koto.notavacc.types.TokenType;
import jp.gr.java_conf.koto.notavacc.types.Type;
import jp.gr.java_conf.koto.notavacc.types.TypeSystem;
import jp.gr.java_conf.koto.notavacc.types.UserDefinedType;
import jp.gr.java_conf.koto.notavacc.util.MultiMap;
import jp.gr.java_conf.koto.notavacc.util.TreeStack;
import jp.gr.java_conf.koto.notavacc.util.TreeStackSet;

public class TypeSystemGenerator
extends Module {
    private final boolean tiger;
    private Parser.Root root;
    private Map fieldToHint = new HashMap();
    private Set reportedError = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$jp$gr$java_conf$koto$notavacc$types$TypeSystemGenerator;

    public TypeSystemGenerator(Environment env, boolean tiger) {
        super(env);
        this.tiger = tiger;
    }

    public TypeSystem generate(Parser.Root root, Set usedTypeNonterminals) {
        Original.TypeDefinition definition;
        GeneratedType type;
        this.root = root;
        this.logger.verbose(this.environment.processingFile, "generating types.");
        LinkedHashMap<Original.TypeDefinition, GeneratedType> definitionToType = new LinkedHashMap<Original.TypeDefinition, GeneratedType>();
        Iterator it0 = root.typeDefinitions().iterator();
        while (it0.hasNext()) {
            Original.TypeDefinition definition2 = (Original.TypeDefinition)it0.next();
            String name = root.getCanonicalName(definition2);
            TypeNonterminal nonterminal = new TypeNonterminal(name);
            if (!usedTypeNonterminals.contains(nonterminal)) {
                nonterminal = null;
            }
            type = new GeneratedType(definition2.identifier(), name, nonterminal);
            definitionToType.put(definition2, type);
        }
        Iterator it1 = definitionToType.entrySet().iterator();
        while (it1.hasNext()) {
            Map.Entry entry = it1.next();
            definition = (Original.TypeDefinition)entry.getKey();
            type = (GeneratedType)entry.getValue();
            type.isProtected = definition.protectedKeyword() != null;
            type.isPrivate = definition.privateKeyword() != null;
            type.isProtectedParsable = definition.protectedParsableKeyword() != null;
            type.isAbstract = definition.abstractKeyword() != null;
            type.superTypes = new LinkedHashSet();
            if (definition.superTypes().isEmpty()) {
                type.superTypes.add(NodeType.INSTANCE);
                continue;
            }
            Iterator it2 = definition.superTypes().iterator();
            while (it2.hasNext()) {
                Original.TypeName name = (Original.TypeName)it2.next();
                Original.TypeDefinition superDefinition = root.getDefinition(name);
                if (this.getSuperTypeDefinitions(superDefinition).contains(definition)) {
                    this.logger.error("{0} should not extend {1}.", name.identifier(), (Object)definition.identifier());
                    continue;
                }
                GeneratedType superType = (GeneratedType)definitionToType.get(superDefinition);
                type.superTypes.add(superType);
            }
        }
        if (this.logger.hasError()) {
            this.logger.fatal();
        }
        Iterator it3 = definitionToType.keySet().iterator();
        while (it3.hasNext()) {
            definition = (Original.TypeDefinition)it3.next();
            this.bindType(definition, definitionToType);
        }
        LinkedHashMap<String, GeneratedType> nameToType = new LinkedHashMap<String, GeneratedType>();
        Iterator it18 = definitionToType.values().iterator();
        while (it18.hasNext()) {
            GeneratedType type2 = (GeneratedType)it18.next();
            nameToType.put(type2.getName(), type2);
        }
        this.logger.verbose(this.environment.processingFile, "generated.  {0} types.", (Object)new Integer(nameToType.size()));
        return new GeneratedTypeSystem(nameToType);
    }

    private Set getSuperTypeDefinitions(Original.TypeDefinition definition) {
        LinkedHashSet result = new LinkedHashSet();
        this.getSuperTypeDefinitions(result, definition);
        return result;
    }

    private void getSuperTypeDefinitions(Set result, Original.TypeDefinition definition) {
        if (result.add(definition)) {
            Iterator it2 = definition.superTypes().iterator();
            while (it2.hasNext()) {
                Original.TypeName name = (Original.TypeName)it2.next();
                Original.TypeDefinition superDefinition = this.root.getDefinition(name);
                this.getSuperTypeDefinitions(result, superDefinition);
            }
        }
    }

    private void bindType(Original.TypeDefinition definition, Map definitionToType) {
        Original.Token hint;
        GeneratedField field;
        GeneratedType target = (GeneratedType)definitionToType.get(definition);
        if (target.declaredFields != null) {
            return;
        }
        Iterator it2 = definition.superTypes().iterator();
        while (it2.hasNext()) {
            Original.TypeName name = (Original.TypeName)it2.next();
            Original.TypeDefinition superDefinition = this.root.getDefinition(name);
            this.bindType(superDefinition, definitionToType);
        }
        LinkedHashMap labelToHint = new LinkedHashMap();
        MultiMap labelToTypes = new MultiMap();
        HashMap<String, Integer> labelToCount = new HashMap<String, Integer>();
        TreeStackSet EMPTY_SET = TreeStackSet.EMPTY_SET;
        this.getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, TreeStack.EMPTY_STACK, EMPTY_SET, EMPTY_SET, definition.expression(), EMPTY_SET, definitionToType);
        LinkedHashMap nameToHint = labelToHint;
        MultiMap nameToTypes = labelToTypes;
        HashMap<String, Integer> nameToCount = labelToCount;
        MultiMap nameToInheritingTypes = new MultiMap();
        MultiMap nameToInheritingFields = new MultiMap();
        Iterator it9 = target.superTypes.iterator();
        while (it9.hasNext()) {
            Type superType = (Type)it9.next();
            Iterator it10 = superType.getMapNameToField().values().iterator();
            while (it10.hasNext()) {
                field = (GeneratedField)it10.next();
                String name = field.getName();
                nameToInheritingFields.add(name, field);
                Type type = field.getType();
                if (type instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)type;
                    type = arrayType.getComponentType();
                    if (!$assertionsDisabled && type instanceof ArrayType) {
                        throw new AssertionError();
                    }
                    if (nameToTypes.containsKey(name)) {
                        nameToCount.put(name, new Integer(2));
                    }
                } else {
                    Integer integer = (Integer)nameToCount.get(name);
                    if (integer != null && integer > 1) {
                        Object superTypeHint;
                        hint = (Original.Token)nameToHint.get(name);
                        if (superType instanceof GeneratedType) {
                            GeneratedType gt = (GeneratedType)superType;
                            superTypeHint = gt.hint;
                        } else {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            superTypeHint = superType;
                        }
                        this.logger.error("The label {0} in {1}, overriding {2} in {3}, can not accept more than one node.", hint, (Object)target.hint, (Object)field.hint, superTypeHint);
                    }
                }
                nameToInheritingTypes.add(name, type);
            }
        }
        target.declaredFields = new LinkedHashSet();
        Iterator it11 = nameToTypes.entrySet().iterator();
        while (it11.hasNext()) {
            Map.Entry entry = it11.next();
            String name = (String)entry.getKey();
            Set types = (Set)entry.getValue();
            if (!$assertionsDisabled && types.isEmpty()) {
                throw new AssertionError();
            }
            Integer countInteger = (Integer)nameToCount.get(name);
            boolean subclassable = this.tiger || countInteger != null && countInteger > 1;
            do {
                LinkedHashSet<Type> commonSuperTypes = null;
                Iterator it14 = types.iterator();
                while (it14.hasNext()) {
                    Type type = (Type)it14.next();
                    LinkedHashSet<Type> superTypes = new LinkedHashSet<Type>(type.getSuperTypes());
                    superTypes.add(type);
                    if (commonSuperTypes == null) {
                        commonSuperTypes = superTypes;
                        continue;
                    }
                    commonSuperTypes.retainAll(superTypes);
                }
                if (!$assertionsDisabled && commonSuperTypes.isEmpty()) {
                    throw new AssertionError();
                }
                types = commonSuperTypes;
                Set restricters = nameToInheritingTypes.getValueSet(name);
                if (restricters != null) {
                    Iterator it12 = restricters.iterator();
                    while (it12.hasNext()) {
                        Type restricter = (Type)it12.next();
                        Iterator it15 = types.iterator();
                        while (it15.hasNext()) {
                            Type type = (Type)it15.next();
                            if (subclassable) {
                                if (!type.isSuperTypeOf(restricter)) continue;
                                it15.remove();
                                continue;
                            }
                            if (type.equals(restricter)) continue;
                            it15.remove();
                        }
                    }
                }
                if (types.isEmpty()) break;
                LinkedHashSet removableSuperTypes = new LinkedHashSet();
                Iterator it13 = types.iterator();
                while (it13.hasNext()) {
                    Type type = (Type)it13.next();
                    removableSuperTypes.addAll(type.getSuperTypes());
                }
                types.removeAll(removableSuperTypes);
            } while (types.size() > 1);
            if (types.isEmpty()) {
                hint = (Original.Token)nameToHint.get(name);
                this.logger.error("The label {0} in {1}", hint, (Object)target.hint);
                Iterator it16 = nameToInheritingFields.getValueSet(name).iterator();
                while (it16.hasNext()) {
                    Object ownerTypeHint;
                    GeneratedField field2 = (GeneratedField)it16.next();
                    Type type = field2.getType();
                    if (type instanceof ArrayType) {
                        type = ((ArrayType)type).getComponentType();
                    }
                    if (field2.getOwner() instanceof GeneratedType) {
                        GeneratedType gt = (GeneratedType)field2.getOwner();
                        ownerTypeHint = gt.hint;
                    } else {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        ownerTypeHint = field2.getOwner();
                    }
                    this.logger.error("        is overriding {0} in {1} so should accept {2}.", field2.hint, ownerTypeHint, (Object)type);
                }
                target.declaredFields.add(new GeneratedField(target, name, NodeType.INSTANCE, hint));
                continue;
            }
            Type type = (Type)types.iterator().next();
            Original.Token hint2 = (Original.Token)nameToHint.get(name);
            Integer integer = (Integer)nameToCount.get(name);
            if (integer != null && integer > 1) {
                target.declaredFields.add(new GeneratedField(target, name, new ArrayType(type), hint2));
                continue;
            }
            target.declaredFields.add(new GeneratedField(target, name, type, hint2));
        }
        target.nameToField = new LinkedHashMap();
        Iterator it19 = target.declaredFields.iterator();
        while (it19.hasNext()) {
            field = (GeneratedField)it19.next();
            target.nameToField.put(field.getName(), field);
        }
        Iterator it17 = nameToInheritingTypes.entrySet().iterator();
        while (it17.hasNext()) {
            Map.Entry entry = it17.next();
            String name = (String)entry.getKey();
            Set types = (Set)entry.getValue();
            if (target.nameToField.containsKey(name)) continue;
            if (types.size() > 1) {
                this.logger.error("{0} can not inherit conflicted labels ''{1}''.", target.hint, (Object)name);
            }
            GeneratedField field3 = (GeneratedField)nameToInheritingFields.getValueSet(name).iterator().next();
            target.nameToField.put(name, field3);
        }
    }

    private void getMapLabelToTypes(Map labelToHint, MultiMap labelToTypes, Map labelToCount, TreeStack opened, TreeStackSet argumentLabels, TreeStackSet labels, Original.Expression expression, TreeStackSet typeRestrictors, Map definitionToType) {
        if (expression instanceof Original.SelectiveExpression) {
            Original.SelectiveExpression exp = (Original.SelectiveExpression)expression;
            HashSet childLabels = new HashSet();
            LinkedList l2cMaps = new LinkedList();
            Iterator it4 = exp.operands().iterator();
            while (it4.hasNext()) {
                Original.Expression operand = (Original.Expression)it4.next();
                LinkedHashMap l2c = new LinkedHashMap();
                this.getMapLabelToTypes(labelToHint, labelToTypes, l2c, opened, argumentLabels, labels, operand, typeRestrictors, definitionToType);
                l2cMaps.add(l2c);
                childLabels.addAll(l2c.keySet());
            }
            Iterator it5 = childLabels.iterator();
            while (it5.hasNext()) {
                String label = (String)it5.next();
                int max = 0;
                Iterator it6 = l2cMaps.iterator();
                while (it6.hasNext()) {
                    Map l2c = (Map)it6.next();
                    Integer integer = (Integer)l2c.get(label);
                    if (integer == null) continue;
                    max = Math.max(max, integer);
                }
                Integer integer = (Integer)labelToCount.get(label);
                if (integer != null) {
                    max += integer.intValue();
                }
                labelToCount.put(label, new Integer(max));
            }
            return;
        }
        if (expression instanceof Original.SequentialExpression) {
            Original.SequentialExpression exp = (Original.SequentialExpression)expression;
            Iterator it4 = exp.operands().iterator();
            while (it4.hasNext()) {
                Original.Expression operand = (Original.Expression)it4.next();
                this.getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, opened, argumentLabels, labels, operand, typeRestrictors, definitionToType);
            }
            return;
        }
        if (expression instanceof Original.PlusExpression) {
            Original.PlusExpression exp = (Original.PlusExpression)expression;
            LinkedHashMap l2c = new LinkedHashMap();
            this.getMapLabelToTypes(labelToHint, labelToTypes, l2c, opened, argumentLabels, labels, exp.operand(), typeRestrictors, definitionToType);
            Iterator it7 = l2c.entrySet().iterator();
            while (it7.hasNext()) {
                Map.Entry entry = it7.next();
                String label = (String)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                int count = integer * 2;
                integer = (Integer)labelToCount.get(label);
                if (integer != null) {
                    count += integer.intValue();
                }
                labelToCount.put(label, new Integer(count));
            }
            return;
        }
        if (expression instanceof Original.RestrictorExpression) {
            Original.RestrictorExpression exp = (Original.RestrictorExpression)expression;
            typeRestrictors = TreeStackSet.push(typeRestrictors, exp.typeRestrictor());
            this.getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, opened, argumentLabels, labels, exp.operand(), typeRestrictors, definitionToType);
            return;
        }
        if (expression instanceof Original.LabeledExpression) {
            Original.LabeledExpression exp = (Original.LabeledExpression)expression;
            String label = exp.label().getImage();
            if (label.equals("$label")) {
                labels = TreeStackSet.pushAll(labels, argumentLabels);
            } else {
                labels = TreeStackSet.push(labels, label);
                if (!labelToHint.containsKey(label)) {
                    labelToHint.put(label, exp.label());
                }
            }
            this.getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, opened, argumentLabels, labels, exp.operand(), typeRestrictors, definitionToType);
            return;
        }
        if (expression instanceof Original.EmbedExpression) {
            Original.EmbedExpression exp = (Original.EmbedExpression)expression;
            this.getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, opened, argumentLabels, labels, exp.operand(), typeRestrictors, definitionToType);
            return;
        }
        if (expression instanceof Original.TagExpression) {
            Original.TagExpression exp = (Original.TagExpression)expression;
            this.getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, opened, argumentLabels, labels, exp.operand(), typeRestrictors, definitionToType);
            return;
        }
        if (expression instanceof Original.IdentifierExpression) {
            Original.IdentifierExpression exp = (Original.IdentifierExpression)expression;
            Original.Definition def = this.root.getDefinition(exp.name());
            if (def instanceof Original.TypeDefinition) {
                Original.TypeDefinition d = (Original.TypeDefinition)def;
                GeneratedType type = (GeneratedType)definitionToType.get(d);
                LinkedHashSet<GeneratedType> types = new LinkedHashSet<GeneratedType>();
                types.add(type);
                Iterator it20 = typeRestrictors.iterator();
                while (it20.hasNext()) {
                    Original.TypeName typeRestrictor = (Original.TypeName)it20.next();
                    Original.TypeDefinition restrictorDefinition = this.root.getDefinition(typeRestrictor);
                    GeneratedType restrictor = (GeneratedType)definitionToType.get(restrictorDefinition);
                    if (restrictor.isSubTypeOf(type) && this.reportedError.add(Arrays.asList(typeRestrictor, exp))) {
                        this.logger.error("The restrictor {0} should be a supertype of the restricted type {1}.", typeRestrictor.identifier(), (Object)exp.name().identifier());
                    }
                    types.add(restrictor);
                }
                Iterator it8 = labels.iterator();
                while (it8.hasNext()) {
                    String label = (String)it8.next();
                    labelToTypes.addAll(label, types);
                    int count = 1;
                    Integer integer = (Integer)labelToCount.get(label);
                    if (integer != null) {
                        count += integer.intValue();
                    }
                    labelToCount.put(label, new Integer(count));
                }
                return;
            }
            if (def instanceof Original.AliasDefinition) {
                Original.AliasDefinition d = (Original.AliasDefinition)def;
                List<Object> key = Arrays.asList(labels, d, typeRestrictors);
                if (opened.count(key) > 2) {
                    return;
                }
                opened = TreeStack.push(opened, key);
                if (this.root.hasExplicitParameterLabel(d)) {
                    argumentLabels = labels;
                    labels = TreeStackSet.EMPTY_SET;
                } else {
                    argumentLabels = TreeStackSet.EMPTY_SET;
                }
                this.getMapLabelToTypes(labelToHint, labelToTypes, labelToCount, opened, argumentLabels, labels, d.expression(), typeRestrictors, definitionToType);
                return;
            }
            if (!$assertionsDisabled && !(def instanceof Original.TokenReservation)) {
                throw new AssertionError();
            }
        } else if (!$assertionsDisabled && !(expression instanceof Original.StringExpression)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || expression instanceof Original.StringExpression || this.root.getDefinition(((Original.IdentifierExpression)expression).name()) instanceof Original.TokenReservation)) {
            throw new AssertionError();
        }
        Iterator it8 = labels.iterator();
        while (it8.hasNext()) {
            String label = (String)it8.next();
            labelToTypes.add(label, TokenType.INSTANCE);
            int count = 1;
            Integer integer = (Integer)labelToCount.get(label);
            if (integer != null) {
                count += integer.intValue();
            }
            labelToCount.put(label, new Integer(count));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$types$TypeSystemGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$types$TypeSystemGenerator = TypeSystemGenerator.class$("jp.gr.java_conf.koto.notavacc.types.TypeSystemGenerator")) : class$jp$gr$java_conf$koto$notavacc$types$TypeSystemGenerator).desiredAssertionStatus();
    }

    private static class GeneratedTypeSystem
    implements TypeSystem {
        private Map nameToType;

        public GeneratedTypeSystem(Map nameToType) {
            this.nameToType = nameToType;
        }

        public Map getMapNameToType() {
            return this.nameToType;
        }
    }

    private static class GeneratedField
    extends Field {
        public final Original.Token hint;

        public GeneratedField(Type owner, String name, Type type, Original.Token hint) {
            super(owner, name, type);
            this.hint = hint;
        }
    }

    private static class GeneratedType
    extends UserDefinedType {
        public final Original.Token hint;
        private final String name;
        private final TypeNonterminal typeNonterminal;
        private Set superTypes = null;
        public boolean isAbstract;
        public boolean isProtected;
        public boolean isPrivate;
        public boolean isProtectedParsable;
        private Set declaredFields = null;
        private Map nameToField = null;

        public GeneratedType(Original.Token hint, String name, TypeNonterminal typeNonterminal) {
            this.hint = hint;
            this.name = name;
            this.typeNonterminal = typeNonterminal;
        }

        public String getName() {
            return this.name;
        }

        public TypeNonterminal getTypeNonterminal() {
            return this.typeNonterminal;
        }

        public Set getDirectSuperTypes() {
            return this.superTypes;
        }

        public boolean isAbstract() {
            return this.isAbstract;
        }

        public boolean isProtected() {
            return this.isProtected;
        }

        public boolean isPrivate() {
            return this.isPrivate;
        }

        public boolean isProtectedParsable() {
            return this.isProtectedParsable;
        }

        public Set getDeclaredFields() {
            return this.declaredFields;
        }

        public Map getMapNameToField() {
            return this.nameToField;
        }
    }
}

