/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.notavacc.types;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jp.gr.java_conf.koto.notavacc.types.Field;

public abstract class Type {
    private Map nameToDeclaredField = null;
    private Set superTypes = null;

    public abstract Set getDirectSuperTypes();

    public abstract Set getDeclaredFields();

    public abstract Map getMapNameToField();

    public Field getDeclaredField(String name) {
        if (this.nameToDeclaredField == null) {
            this.nameToDeclaredField = new LinkedHashMap();
            Iterator it0 = this.getDeclaredFields().iterator();
            while (it0.hasNext()) {
                Field field = (Field)it0.next();
                this.nameToDeclaredField.put(field.getName(), field);
            }
        }
        return (Field)this.nameToDeclaredField.get(name);
    }

    public Field getField(String name) {
        return (Field)this.getMapNameToField().get(name);
    }

    public Set getSuperTypes() {
        if (this.superTypes == null) {
            this.superTypes = new LinkedHashSet();
            Iterator it1 = this.getDirectSuperTypes().iterator();
            while (it1.hasNext()) {
                Type superType = (Type)it1.next();
                this.superTypes.add(superType);
                this.superTypes.addAll(superType.getSuperTypes());
            }
        }
        return this.superTypes;
    }

    public boolean isSuperTypeOf(Type type) {
        return type.getSuperTypes().contains(this);
    }

    public boolean isSubTypeOf(Type type) {
        return this.getSuperTypes().contains(type);
    }
}

