/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.notavacc.parser;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.gr.java_conf.koto.notavacc.Logger;
import jp.gr.java_conf.koto.notavacc.parser.Original;

public class Parser
extends Original {
    private Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$jp$gr$java_conf$koto$notavacc$parser$Parser;

    protected Original.Node createNode(int symbolID, Original.NodeInitializationParameters parameters) {
        switch (symbolID) {
            case 48: {
                return new Root(this.logger, parameters);
            }
            case 88: {
                return new InlineExpressionReplacement(parameters);
            }
        }
        return super.createNode(symbolID, parameters, true);
    }

    protected void taggedTokenShifted(Original.Token token, int tag) {
        switch (tag) {
            case 0: {
                this.logger.warn("{0} is obsolete.  Use ''$white $token IDENTIFIER = ... ;''", token);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    protected Original.LexicalAnalyzer createLexicalAnalyzer(String sourceName, CharSequence text, int tabStop) throws Original.ParseException {
        return new Original.Default.LexicalAnalyzer(sourceName, text, tabStop){

            protected char nextChar() throws Original.ParseException {
                return super.nextUnicodeEscapedChar();
            }

            public Original.Token next() throws Original.ParseException {
                Original.Token result = super.next();
                if (result.getSymbolID() == 4) {
                    String image = result.getImage();
                    int i = 0;
                    while (i < image.length()) {
                        char ch = image.charAt(i);
                        if (i == 0 ? !Character.isJavaIdentifierStart(ch) : !Character.isJavaIdentifierPart(ch)) break;
                        ++i;
                    }
                    if (i < image.length()) {
                        throw new Original.ParseException("The " + i + "th letter \\u" + Integer.toHexString(image.charAt(i)) + " of the token " + result + " cannot be used.", result);
                    }
                }
                return result;
            }
        };
    }

    public Parser(Logger logger) {
        this.logger = logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$parser$Parser == null ? (class$jp$gr$java_conf$koto$notavacc$parser$Parser = Parser.class$("jp.gr.java_conf.koto.notavacc.parser.Parser")) : class$jp$gr$java_conf$koto$notavacc$parser$Parser).desiredAssertionStatus();
    }

    private class InlineExpressionReplacement
    extends Original.Default.InlineExpression {
        private final Original.SymbolName name;

        public InlineExpressionReplacement(Original.NodeInitializationParameters parameters) {
            super(parameters, true);
            this.name = new SymbolNameReplacement();
            this.getChildNodes().add(0, this.name);
        }

        public Original.SymbolName name() {
            return this.name;
        }

        private class SymbolNameReplacement
        extends Original.Default.Node
        implements Original.SymbolName {
            public SymbolNameReplacement() {
                super(Collections.EMPTY_LIST);
            }

            public Original.Token identifier() {
                return InlineExpressionReplacement.this.typeDefinition().identifier();
            }
        }
    }

    public static class Root
    extends Original.Default.Root {
        private Logger logger;
        private String packageName = null;
        private List typeDefinitions = null;
        private Map canonicalNameToDefinition;
        private Map nameToDefinition;
        private Set definitionsHavingExplicitParameterLabel;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Root(Logger logger, Original.NodeInitializationParameters parameters) {
            super(parameters, true);
            this.logger = logger;
            this.buildDefinitionMap();
            this.bindNames();
            this.buildSetOfDefinitionsHavingExplicitParameterLabel();
        }

        public String getPackageName() {
            if (this.packageName != null) {
                return this.packageName;
            }
            Original.PackageOption po = this.packageOption();
            if (po == null) {
                return null;
            }
            StringBuffer result = new StringBuffer();
            Iterator it0 = po.value().identifiers().iterator();
            while (it0.hasNext()) {
                Original.Token identifier = (Original.Token)it0.next();
                result.append(identifier.getImage());
                if (!it0.hasNext()) continue;
                result.append(".");
            }
            this.packageName = result.toString();
            return this.packageName;
        }

        public boolean hasProtectedConstructor() {
            return this.constructorScope() != null;
        }

        public List typeDefinitions() {
            if (this.typeDefinitions == null) {
                this.typeDefinitions = new LinkedList();
                this.accept(new Original.Visitor(this){
                    private final /* synthetic */ Root this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void visit(Original.TypeDefinition def) {
                        Root.access$000(this.this$0).add(def);
                    }
                });
            }
            return this.typeDefinitions;
        }

        public String getCanonicalName(Original.Definition definition) {
            return definition.identifier().getImage();
        }

        private void buildDefinitionMap() {
            this.canonicalNameToDefinition = new LinkedHashMap();
            LinkedHashMap duplexNames = new LinkedHashMap();
            this.accept(new Original.Visitor(this, duplexNames){
                private final /* synthetic */ Map val$duplexNames;
                private final /* synthetic */ Root this$0;
                {
                    this.this$0 = this$0;
                    this.val$duplexNames = val$duplexNames;
                }

                public void visit(Original.Definition def) {
                    String canonicalName = this.this$0.getCanonicalName(def);
                    Original.Definition olddef = Root.access$100(this.this$0).put(canonicalName, def);
                    if (olddef != null) {
                        LinkedList<Original.Definition> definitions = (LinkedList<Original.Definition>)this.val$duplexNames.get(canonicalName);
                        if (definitions == null) {
                            definitions = new LinkedList<Original.Definition>();
                            this.val$duplexNames.put(canonicalName, definitions);
                            definitions.add(olddef);
                        }
                        definitions.add(def);
                    }
                }
            });
            if (!duplexNames.isEmpty()) {
                Iterator it = duplexNames.values().iterator();
                while (it.hasNext()) {
                    List list = (List)it.next();
                    Iterator it2 = list.iterator();
                    while (it2.hasNext()) {
                        Original.Definition def = (Original.Definition)it2.next();
                        this.logger.error("{0} defined twice or more.", def.identifier());
                    }
                }
            }
            if (this.logger.hasError()) {
                this.logger.fatal();
            }
        }

        private void bindNames() {
            this.nameToDefinition = new LinkedHashMap();
            this.accept(new Original.Visitor(this){
                static final /* synthetic */ boolean $assertionsDisabled;
                private final /* synthetic */ Root this$0;
                {
                    this.this$0 = this$0;
                }

                public void visit(Original.Name name) {
                    String image = name.identifier().getImage();
                    Original.Definition def = (Original.Definition)Root.access$100(this.this$0).get(image);
                    Root.access$200(this.this$0).put(name, def);
                    if (def == null) {
                        Root.access$300(this.this$0).error("{0} is not defined.", name.identifier());
                    } else if (name instanceof Original.TypeName) {
                        if (!(def instanceof Original.TypeDefinition)) {
                            Root.access$300(this.this$0).error("{0} should be a type name.", name.identifier());
                        }
                    } else if (name instanceof Original.SubtokenName) {
                        if (!(def instanceof Original.SubtokenDefinition)) {
                            Root.access$300(this.this$0).error("{0} should be a token name or a subtoken name.", name.identifier());
                        }
                    } else {
                        if (!$assertionsDisabled && !(name instanceof Original.SymbolName)) {
                            throw new AssertionError();
                        }
                        boolean ok = false;
                        if (def instanceof Original.TokenReservation) {
                            if (!(def instanceof Original.WhiteTokenDefinition)) {
                                ok = true;
                            }
                        } else if (def instanceof Original.TypeDefinition) {
                            ok = true;
                        } else if (def instanceof Original.AliasDefinition) {
                            ok = true;
                        }
                        if (!ok) {
                            Root.access$300(this.this$0).error("{0} should be a token/type/alias name.", name.identifier());
                        }
                    }
                }

                static {
                    $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$parser$Parser == null ? (class$jp$gr$java_conf$koto$notavacc$parser$Parser = Parser.class$("jp.gr.java_conf.koto.notavacc.parser.Parser")) : class$jp$gr$java_conf$koto$notavacc$parser$Parser).desiredAssertionStatus();
                }
            });
            if (this.logger.hasError()) {
                this.logger.fatal();
            }
        }

        public Original.Definition getDefinition(Original.Name name) {
            Original.Definition result = (Original.Definition)this.nameToDefinition.get(name);
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError((Object)("A definition missing for " + name.identifier()));
            }
            return result;
        }

        public Original.TypeDefinition getDefinition(Original.TypeName name) {
            return (Original.TypeDefinition)this.getDefinition((Original.Name)name);
        }

        public Original.SubtokenDefinition getDefinition(Original.SubtokenName name) {
            return (Original.SubtokenDefinition)this.getDefinition((Original.Name)name);
        }

        private void buildSetOfDefinitionsHavingExplicitParameterLabel() {
            this.definitionsHavingExplicitParameterLabel = new LinkedHashSet();
            Iterator it = this.aliasDefinitions().iterator();
            while (it.hasNext()) {
                Original.AliasDefinition def = (Original.AliasDefinition)it.next();
                def.accept(new Original.Visitor(this, def){
                    private final /* synthetic */ Original.AliasDefinition val$def;
                    private final /* synthetic */ Root this$0;
                    {
                        this.this$0 = this$0;
                        this.val$def = val$def;
                    }

                    public void visit(Original.LabeledExpression exp) {
                        if (exp.label().getImage().equals("$label")) {
                            Root.access$400(this.this$0).add(this.val$def);
                        }
                    }
                });
            }
        }

        public boolean hasExplicitParameterLabel(Original.AliasDefinition definition) {
            return this.definitionsHavingExplicitParameterLabel.contains(definition);
        }

        public String getValue(Original.StringLiteral literal) {
            StringBuffer result = new StringBuffer();
            String image = literal.token().getImage();
            int maz = image.length() - 1;
            int i = 1;
            while (i < maz) {
                char ch;
                if ((ch = image.charAt(i++)) != '\\') {
                    result.append(ch);
                    continue;
                }
                if (!$assertionsDisabled && i >= maz) {
                    throw new AssertionError();
                }
                ch = image.charAt(i++);
                switch (ch) {
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        break;
                    }
                    case 'b': {
                        result.append('\b');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    case 'f': {
                        result.append('\f');
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        result.append(ch);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled && Character.digit(ch, 8) == -1) {
                            throw new AssertionError();
                        }
                        StringBuffer octal = new StringBuffer();
                        octal.append(ch);
                        int max = '0' <= ch && ch <= '3' ? 3 : 2;
                        while (--max > 0) {
                            if (i >= maz || Character.digit(ch = image.charAt(i), 8) == -1) break;
                            octal.append(ch);
                            ++i;
                        }
                        result.append((char)Integer.parseInt(octal.toString(), 8));
                    }
                }
            }
            return result.toString();
        }

        public char getValue(Original.CharacterLiteral literal) {
            String image = literal.token().getImage();
            char ch = image.charAt(1);
            if (ch != '\\') {
                return ch;
            }
            ch = image.charAt(2);
            switch (ch) {
                case 'n': {
                    return '\n';
                }
                case 't': {
                    return '\t';
                }
                case 'b': {
                    return '\b';
                }
                case 'r': {
                    return '\r';
                }
                case 'f': {
                    return '\f';
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    return ch;
                }
            }
            if (!$assertionsDisabled && Character.digit(ch, 8) == -1) {
                throw new AssertionError();
            }
            String octal = image.substring(2, image.length() - 1);
            return (char)Integer.parseInt(octal, 8);
        }

        static /* synthetic */ List access$000(Root x0) {
            return x0.typeDefinitions;
        }

        static /* synthetic */ Map access$100(Root x0) {
            return x0.canonicalNameToDefinition;
        }

        static /* synthetic */ Map access$200(Root x0) {
            return x0.nameToDefinition;
        }

        static /* synthetic */ Logger access$300(Root x0) {
            return x0.logger;
        }

        static /* synthetic */ Set access$400(Root x0) {
            return x0.definitionsHavingExplicitParameterLabel;
        }

        static {
            $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$parser$Parser == null ? (class$jp$gr$java_conf$koto$notavacc$parser$Parser = Parser.class$("jp.gr.java_conf.koto.notavacc.parser.Parser")) : class$jp$gr$java_conf$koto$notavacc$parser$Parser).desiredAssertionStatus();
        }
    }
}

