/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.notavacc.lrg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.gr.java_conf.koto.notavacc.Environment;
import jp.gr.java_conf.koto.notavacc.Module;
import jp.gr.java_conf.koto.notavacc.dfa.DeterministicFiniteAutomaton;
import jp.gr.java_conf.koto.notavacc.lrg.AliasNonterminal;
import jp.gr.java_conf.koto.notavacc.lrg.AnonymousNonterminal;
import jp.gr.java_conf.koto.notavacc.lrg.LRTable;
import jp.gr.java_conf.koto.notavacc.lrg.NamedTerminal;
import jp.gr.java_conf.koto.notavacc.lrg.Nonterminal;
import jp.gr.java_conf.koto.notavacc.lrg.Symbol;
import jp.gr.java_conf.koto.notavacc.lrg.Terminal;
import jp.gr.java_conf.koto.notavacc.lrg.TypeNonterminal;
import jp.gr.java_conf.koto.notavacc.parser.Original;
import jp.gr.java_conf.koto.notavacc.parser.Parser;
import jp.gr.java_conf.koto.notavacc.util.MultiMap;
import jp.gr.java_conf.koto.notavacc.util.TreeStack;
import jp.gr.java_conf.koto.notavacc.util.TreeStackSet;

public final class LRTableGenerator
extends Module {
    private Parser.Root root;
    private DeterministicFiniteAutomaton dfa;
    private Map nonterminalToHint = new LinkedHashMap();
    private static final Set LABEL_INHERITOR;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator;

    public LRTableGenerator(Environment env) {
        super(env);
    }

    public LRTable generate(Parser.Root root, DeterministicFiniteAutomaton dfa) {
        Original.Definition def;
        this.root = root;
        this.dfa = dfa;
        this.logger.verbose(this.environment.processingFile, "generating an extended CFG.");
        Map<AliasNonterminal, DeterministicState> symbolToInitialState = new LinkedHashMap<TypeNonterminal, DeterministicState>();
        NondeterministicState finalState = new NondeterministicState();
        Iterator it = root.typeDefinitions().iterator();
        while (it.hasNext()) {
            def = (Original.TypeDefinition)it.next();
            if (def.abstractKeyword() != null) continue;
            TypeNonterminal symbol = this.getNonterminal((Original.TypeDefinition)def);
            NondeterministicState initialState = new NondeterministicState();
            this.link(initialState, def.expression(), finalState);
            DeterministicConverter converter = new DeterministicConverter();
            DeterministicState s = converter.createDeterministicState(Collections.singleton(initialState), finalState);
            s = this.buildMinimalForm(s);
            symbolToInitialState.put((AliasNonterminal)((Object)symbol), s);
        }
        it = root.aliasDefinitions().iterator();
        while (it.hasNext()) {
            def = (Original.AliasDefinition)it.next();
            TreeStackSet argumentLabels = TreeStackSet.EMPTY_SET;
            TreeStackSet labels = TreeStackSet.EMPTY_SET;
            if (root.hasExplicitParameterLabel((Original.AliasDefinition)def)) {
                argumentLabels = TreeStackSet.push(argumentLabels, "$label");
            } else {
                labels = TreeStackSet.push(labels, "$label");
            }
            AliasNonterminal symbol = this.getNonterminal((Original.AliasDefinition)def);
            NondeterministicState initialState = new NondeterministicState();
            this.link(false, TreeStackSet.EMPTY_SET, argumentLabels, labels, initialState, def.expression(), finalState);
            DeterministicConverter converter = new DeterministicConverter();
            DeterministicState s = converter.createDeterministicState(Collections.singleton(initialState), finalState);
            s = this.buildMinimalForm(s);
            symbolToInitialState.put(symbol, s);
        }
        if (this.logger.hasError()) {
            this.logger.fatal();
        }
        Set allStates = this.allStates(symbolToInitialState);
        this.logger.verbose(this.environment.processingFile, "generated.  {0} states.", (Object)new Integer(allStates.size()));
        this.logger.verbose(this.environment.processingFile, "generating a CFG.");
        symbolToInitialState = this.buildCFG(symbolToInitialState, allStates);
        allStates = this.allStates(symbolToInitialState);
        this.logger.verbose(this.environment.processingFile, "generated.  {0} states.", (Object)new Integer(allStates.size()));
        this.reportStates(symbolToInitialState, allStates);
        HashMap initialStateToSymbol = new HashMap(symbolToInitialState.size());
        Iterator it25 = symbolToInitialState.entrySet().iterator();
        while (it25.hasNext()) {
            Map.Entry entry = it25.next();
            initialStateToSymbol.put(entry.getValue(), entry.getKey());
        }
        if (!$assertionsDisabled && initialStateToSymbol.size() != symbolToInitialState.size()) {
            throw new AssertionError();
        }
        this.logger.verbose(this.environment.processingFile, "generating LR states.");
        DeterministicState extendedFinalState = new DeterministicState();
        allStates.add(extendedFinalState);
        LinkedHashMap<TypeNonterminal, LRState> symbolToInitialLRState = new LinkedHashMap<TypeNonterminal, LRState>();
        LRStateBuilder builder = new LRStateBuilder(symbolToInitialState);
        LinkedHashSet<Original.TypeDefinition> definitions = new LinkedHashSet<Original.TypeDefinition>();
        Iterator it2 = root.typeDefinitions().iterator();
        while (it2.hasNext()) {
            Original.TypeDefinition def2 = (Original.TypeDefinition)it2.next();
            if (def2.parsableKeyword() == null) continue;
            definitions.add(def2);
        }
        LinkedHashMap kernelCoresToLRState = new LinkedHashMap();
        it2 = definitions.iterator();
        while (it2.hasNext()) {
            Original.TypeDefinition def3 = (Original.TypeDefinition)it2.next();
            TypeNonterminal symbol = this.getNonterminal(def3);
            DeterministicState initialState = (DeterministicState)symbolToInitialState.get(symbol);
            DeterministicState extendedInitialState = new DeterministicState();
            DeterministicState extendedMediumState = new DeterministicState();
            extendedInitialState.linkToState.put(new Link(Collections.EMPTY_SET, symbol, def3.identifier()), extendedMediumState);
            allStates.add(extendedInitialState);
            extendedMediumState.linkToState.put(new Link(Collections.EMPTY_SET, Terminal.EOF, def3.identifier()), extendedFinalState);
            allStates.add(extendedMediumState);
            LRState state = builder.createLRState(Collections.singleton(extendedInitialState));
            symbolToInitialLRState.put(symbol, state);
        }
        LRState finalState2 = builder.createLRState(Collections.singleton(extendedFinalState));
        LRHelper lrHelper = new LRHelper(symbolToInitialLRState, finalState2);
        this.logger.verbose(this.environment.processingFile, "generated.  {0} states.", (Object)new Integer(lrHelper.allLRStates().size()));
        this.logger.verbose(this.environment.processingFile, "tagging.");
        this.tagLRStates(lrHelper, initialStateToSymbol);
        this.logger.verbose(this.environment.processingFile, "tagged.");
        this.logger.verbose(this.environment.processingFile, "delivering look-ahead terminals.");
        LookaheadDeliverer deliverer = new LookaheadDeliverer(symbolToInitialState, allStates);
        deliverer.deliverLookahead(lrHelper);
        this.logger.verbose(this.environment.processingFile, "delivered.");
        this.logger.verbose(this.environment.processingFile, "generating reductions.");
        ReductionGenerator generator = new ReductionGenerator(symbolToInitialState, initialStateToSymbol, allStates);
        Set conflictedStates = generator.generateReductions(lrHelper);
        this.logger.verbose(this.environment.processingFile, "generated.  {0} LALR(1)-conflicted state(s).", (Object)new Integer(conflictedStates.size()));
        this.reportLRStates(lrHelper);
        if (!conflictedStates.isEmpty()) {
            this.logger.verbose(this.environment.processingFile, "chasing conflicts.");
            ConflictChaser chaser = new ConflictChaser(lrHelper, generator, initialStateToSymbol);
            int count = chaser.chaseConflicts(conflictedStates);
            this.logger.verbose(this.environment.processingFile, "chased.  {0} maybe-conflicted state(s).", (Object)new Integer(count));
        }
        this.logger.verbose(this.environment.processingFile, "generating LR table.");
        LRTable result = this.buildLRTable(lrHelper);
        this.logger.verbose(this.environment.processingFile, "generated.");
        return result;
    }

    private AliasNonterminal getNonterminal(Original.AliasDefinition definition) {
        AliasNonterminal result = new AliasNonterminal(this.root.getCanonicalName(definition));
        this.nonterminalToHint.put(result, definition.identifier());
        return result;
    }

    private Original.Token getHint(AliasNonterminal nonterminal) {
        return (Original.Token)this.nonterminalToHint.get(nonterminal);
    }

    private TypeNonterminal getNonterminal(Original.TypeDefinition definition) {
        TypeNonterminal result = new TypeNonterminal(this.root.getCanonicalName(definition));
        this.nonterminalToHint.put(result, definition.identifier());
        return result;
    }

    private Original.Token getHint(TypeNonterminal nonterminal) {
        return (Original.Token)this.nonterminalToHint.get(nonterminal);
    }

    private Original.Token getHint(Nonterminal nonterminal) {
        if (nonterminal instanceof TypeNonterminal) {
            return this.getHint((TypeNonterminal)nonterminal);
        }
        return this.getHint((AliasNonterminal)nonterminal);
    }

    private void link(NondeterministicState initialState, Original.Expression expression, NondeterministicState finalState) {
        this.link(false, TreeStackSet.EMPTY_SET, TreeStackSet.EMPTY_SET, TreeStackSet.EMPTY_SET, initialState, expression, finalState);
    }

    private void link(boolean embed, TreeStackSet openedAlias, TreeStackSet argumentLabels, TreeStackSet labels, NondeterministicState initialState, Original.Expression expression, NondeterministicState finalState) {
        if (expression instanceof Original.SelectiveExpression) {
            Original.SelectiveExpression exp = (Original.SelectiveExpression)expression;
            Iterator it = exp.operands().iterator();
            while (it.hasNext()) {
                Original.Expression operand = (Original.Expression)it.next();
                this.link(embed, openedAlias, argumentLabels, labels, initialState, operand, finalState);
            }
        } else if (expression instanceof Original.SequentialExpression) {
            Original.SequentialExpression exp = (Original.SequentialExpression)expression;
            if (exp.operands().isEmpty()) {
                initialState.epsilonLink(finalState);
            } else {
                Iterator it = exp.operands().iterator();
                while (it.hasNext()) {
                    Original.Expression operand = (Original.Expression)it.next();
                    NondeterministicState tmp = it.hasNext() ? new NondeterministicState() : finalState;
                    this.link(embed, openedAlias, argumentLabels, labels, initialState, operand, tmp);
                    initialState = tmp;
                }
            }
        } else if (expression instanceof Original.PlusExpression) {
            Original.PlusExpression exp = (Original.PlusExpression)expression;
            NondeterministicState tmp1 = new NondeterministicState();
            NondeterministicState tmp2 = new NondeterministicState();
            initialState.epsilonLink(tmp1);
            this.link(embed, openedAlias, argumentLabels, labels, tmp1, exp.operand(), tmp2);
            tmp2.epsilonLink(finalState);
            tmp2.epsilonLink(tmp1);
        } else if (expression instanceof Original.RestrictorExpression) {
            Original.RestrictorExpression exp = (Original.RestrictorExpression)expression;
            this.link(embed, openedAlias, argumentLabels, labels, initialState, exp.operand(), finalState);
        } else if (expression instanceof Original.LabeledExpression) {
            Original.LabeledExpression exp = (Original.LabeledExpression)expression;
            labels = exp.label().getImage().equals("$label") ? TreeStackSet.pushAll(labels, argumentLabels) : TreeStackSet.push(labels, exp.label().getImage());
            this.link(embed, openedAlias, argumentLabels, labels, initialState, exp.operand(), finalState);
        } else if (expression instanceof Original.EmbedExpression) {
            Original.EmbedExpression exp = (Original.EmbedExpression)expression;
            this.link(true, openedAlias, argumentLabels, labels, initialState, exp.operand(), finalState);
        } else if (expression instanceof Original.TagExpression) {
            Original.TagExpression exp = (Original.TagExpression)expression;
            NondeterministicState tmp = new NondeterministicState();
            tmp.tag = exp.tag();
            Original.Expression operand = exp.operand();
            if (operand instanceof Original.StringExpression) {
                this.link(false, openedAlias, argumentLabels, labels, initialState, operand, tmp);
            } else {
                Original.IdentifierExpression x = (Original.IdentifierExpression)operand;
                Original.Definition def = this.root.getDefinition(x.name());
                if (!(def instanceof Original.TokenReservation)) {
                    this.logger.error("{0} can''t tag the nonterminal {1}.", exp.tag(), (Object)def.identifier());
                }
                this.link(false, openedAlias, argumentLabels, labels, initialState, x, tmp);
            }
            tmp.epsilonLink(finalState);
        } else if (expression instanceof Original.StringExpression) {
            Original.StringExpression exp = (Original.StringExpression)expression;
            Terminal terminal = this.dfa.getTerminal(exp);
            Link link = new Link(labels, terminal, exp.string().token());
            initialState.link(link, finalState);
        } else {
            Original.IdentifierExpression exp = (Original.IdentifierExpression)expression;
            this.link(embed, openedAlias, argumentLabels, labels, initialState, exp, finalState);
        }
    }

    private void link(boolean embed, TreeStackSet openedAlias, TreeStackSet argumentLabels, TreeStackSet labels, NondeterministicState initialState, Original.IdentifierExpression exp, NondeterministicState finalState) {
        Original.Definition def = this.root.getDefinition(exp.name());
        Original.Token hint = exp.name().identifier();
        if (def instanceof Original.TypeDefinition) {
            Original.TypeDefinition d = (Original.TypeDefinition)def;
            if (d.abstractKeyword() != null) {
                this.logger.error("The type {0} is abstract.", exp.name().identifier());
            }
            Link link = new Link(labels, this.getNonterminal(d), hint);
            initialState.link(link, finalState);
        } else if (def instanceof Original.AliasDefinition) {
            Original.AliasDefinition d = (Original.AliasDefinition)def;
            if (!embed || openedAlias.contains(d)) {
                Link link = new Link(labels, this.getNonterminal(d), hint);
                initialState.link(link, finalState);
            } else {
                openedAlias = TreeStackSet.push(openedAlias, d);
                if (this.root.hasExplicitParameterLabel(d)) {
                    argumentLabels = labels;
                    labels = TreeStackSet.EMPTY_SET;
                } else {
                    argumentLabels = TreeStackSet.EMPTY_SET;
                }
                this.link(false, openedAlias, argumentLabels, labels, initialState, d.expression(), finalState);
            }
        } else {
            Original.TokenReservation d = (Original.TokenReservation)def;
            Link link = new Link(labels, new NamedTerminal(this.root.getCanonicalName(d)), hint);
            initialState.link(link, finalState);
        }
    }

    private Set allStates(Map symbolToInitialState) {
        LinkedHashSet result = new LinkedHashSet();
        this.allStates(result, symbolToInitialState.values());
        return result;
    }

    private void allStates(Set result, Collection states) {
        Iterator it4 = states.iterator();
        while (it4.hasNext()) {
            DeterministicState state = (DeterministicState)it4.next();
            if (!result.add(state)) continue;
            this.allStates(result, state.linkToState.values());
        }
    }

    private void reportStates(Map symbolToInitialState, Set allStates) {
        if (this.logger.verboseLevel() < 5) {
            return;
        }
        this.logger.verbosest(this.environment.processingFile, "----States Report----");
        Iterator it = symbolToInitialState.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Symbol symbol = (Symbol)entry.getKey();
            DeterministicState state = (DeterministicState)entry.getValue();
            this.logger.verbosest("{0} => x{1}", symbol, (Object)state);
        }
        it = allStates.iterator();
        while (it.hasNext()) {
            DeterministicState state = (DeterministicState)((Object)it.next());
            this.logger.verbosest("-- {0} --", state);
            if (state.isFinal) {
                this.logger.verbosest("    FINAL STATE");
            }
            if (state.tag != null) {
                this.logger.verbosest("    TAG: " + state.tag);
            }
            Iterator it2 = state.linkToState.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                Link link = (Link)entry.getKey();
                DeterministicState s = (DeterministicState)entry.getValue();
                this.logger.verbosest("        {0} ==> x{1}", link, (Object)s);
            }
        }
    }

    private DeterministicState buildMinimalForm(DeterministicState initialState) {
        Map symbolToInitialState = Collections.singletonMap(null, initialState);
        Set allStates = this.allStates(symbolToInitialState);
        symbolToInitialState = this.buildMinimalForm(symbolToInitialState, allStates);
        return (DeterministicState)symbolToInitialState.get(null);
    }

    private Map buildMinimalForm(Map symbolToInitialState, Set allStates) {
        HashSet initialStates = new HashSet(symbolToInitialState.values());
        ArrayList<List> groups = new ArrayList<List>(allStates.size());
        HashMap<DeterministicState, Integer> stateToGroupID = new HashMap<DeterministicState, Integer>();
        LinkedHashMap<List<Object>, Integer> tagAndFinalToGroupID = new LinkedHashMap<List<Object>, Integer>();
        Iterator it = allStates.iterator();
        while (it.hasNext()) {
            Integer groupID;
            DeterministicState state = (DeterministicState)it.next();
            String tag = state.tag == null ? null : state.tag.getImage();
            List<Object> key = Arrays.asList(tag, new Boolean(state.isFinal));
            if (initialStates.contains(state)) {
                groupID = new Integer(groups.size());
                groups.add(new LinkedList());
            } else {
                groupID = (Integer)tagAndFinalToGroupID.get(key);
                if (groupID == null) {
                    groupID = new Integer(groups.size());
                    groups.add(new LinkedList());
                    tagAndFinalToGroupID.put(key, groupID);
                }
            }
            List states = (List)groups.get(groupID);
            states.add(state);
            stateToGroupID.put(state, groupID);
        }
        int lastMoodifiedIndex = -1;
        int index = 0;
        while (true) {
            if (index >= groups.size()) {
                if (lastMoodifiedIndex == -1) break;
                index -= groups.size();
            }
            List group = (List)groups.get(index);
            if (!$assertionsDisabled && group.isEmpty()) {
                throw new AssertionError();
            }
            if (group.size() <= 1) {
                if (index == lastMoodifiedIndex) {
                    break;
                }
            } else {
                Iterator it2;
                LinkedHashMap keyToStateList = new LinkedHashMap();
                Iterator<Object> it3 = group.iterator();
                while (it3.hasNext()) {
                    DeterministicState state = (DeterministicState)it3.next();
                    HashSet<List<Object>> key = new HashSet<List<Object>>();
                    it2 = state.linkToState.entrySet().iterator();
                    while (it2.hasNext()) {
                        Map.Entry entry = it2.next();
                        Link link = (Link)entry.getKey();
                        DeterministicState nextState = (DeterministicState)entry.getValue();
                        key.add(Arrays.asList(link.symbol, link.labels, stateToGroupID.get(nextState)));
                    }
                    LinkedList<DeterministicState> list = (LinkedList<DeterministicState>)keyToStateList.get(key);
                    if (list == null) {
                        list = new LinkedList<DeterministicState>();
                        keyToStateList.put(key, list);
                    }
                    list.add(state);
                }
                if (keyToStateList.size() <= 1) {
                    if (index == lastMoodifiedIndex) {
                        break;
                    }
                } else {
                    lastMoodifiedIndex = index;
                    it3 = keyToStateList.values().iterator();
                    while (it3.hasNext()) {
                        List states = (List)it3.next();
                        if (it3.hasNext()) {
                            Integer newID = new Integer(groups.size());
                            groups.add(states);
                            it2 = states.iterator();
                            while (it2.hasNext()) {
                                DeterministicState state = (DeterministicState)((Object)it2.next());
                                stateToGroupID.put(state, newID);
                            }
                            continue;
                        }
                        groups.set(index, states);
                    }
                }
            }
            ++index;
        }
        DeterministicState[] result = new DeterministicState[groups.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = new DeterministicState();
            ++i;
        }
        int i2 = 0;
        while (i2 < result.length) {
            List group = (List)groups.get(i2);
            DeterministicState hot = result[i2];
            DeterministicState old = (DeterministicState)group.get(0);
            hot.tag = old.tag;
            hot.isFinal = old.isFinal;
            Iterator it46 = old.linkToState.entrySet().iterator();
            while (it46.hasNext()) {
                Map.Entry entry = it46.next();
                Link link = (Link)entry.getKey();
                DeterministicState nextState = (DeterministicState)entry.getValue();
                Integer nextGroupID = (Integer)stateToGroupID.get(nextState);
                DeterministicState hotNext = result[nextGroupID];
                hot.linkToState.put(link, hotNext);
            }
            ++i2;
        }
        LinkedHashMap<Symbol, DeterministicState> resultMap = new LinkedHashMap<Symbol, DeterministicState>();
        Iterator it4 = symbolToInitialState.entrySet().iterator();
        while (it4.hasNext()) {
            Map.Entry entry = it4.next();
            Symbol symbol = (Symbol)entry.getKey();
            DeterministicState state = (DeterministicState)entry.getValue();
            Integer groupID = (Integer)stateToGroupID.get(state);
            resultMap.put(symbol, result[groupID]);
        }
        return resultMap;
    }

    private Map stateToMapPreviousStateToLinks(Set allStates) {
        LinkedHashMap<DeterministicState, MultiMap> result = new LinkedHashMap<DeterministicState, MultiMap>();
        Iterator it13 = allStates.iterator();
        while (it13.hasNext()) {
            DeterministicState state = (DeterministicState)it13.next();
            Iterator it47 = state.linkToState.entrySet().iterator();
            while (it47.hasNext()) {
                Map.Entry entry = it47.next();
                Link link = (Link)entry.getKey();
                DeterministicState nextState = (DeterministicState)entry.getValue();
                MultiMap map = (MultiMap)result.get(nextState);
                if (map == null) {
                    map = new MultiMap();
                    result.put(nextState, map);
                }
                map.add(state, link);
            }
        }
        return result;
    }

    private Map buildCFG(Map symbolToInitialState, Set allStates) {
        LinkedHashMap<AnonymousNonterminal, DeterministicState> result = new LinkedHashMap<AnonymousNonterminal, DeterministicState>(symbolToInitialState);
        Map stateToMapPreviousStateToLinks = this.stateToMapPreviousStateToLinks(allStates);
        Iterator it17 = stateToMapPreviousStateToLinks.entrySet().iterator();
        while (it17.hasNext()) {
            Map.Entry entry = it17.next();
            DeterministicState state = (DeterministicState)entry.getKey();
            MultiMap map = (MultiMap)entry.getValue();
            int count = 0;
            Iterator it18 = map.entrySet().iterator();
            while (it18.hasNext()) {
                Map.Entry entry2 = it18.next();
                Set links = (Set)entry2.getValue();
                count += links.size();
            }
            if (count <= true) continue;
            AnonymousNonterminal anony = new AnonymousNonterminal();
            boolean used = false;
            Iterator it19 = map.entrySet().iterator();
            while (it19.hasNext()) {
                Map.Entry entry2 = it19.next();
                DeterministicState prevState = (DeterministicState)entry2.getKey();
                Set links = (Set)entry2.getValue();
                Iterator it20 = links.iterator();
                while (it20.hasNext()) {
                    Link link = (Link)it20.next();
                    DeterministicState newState = new DeterministicState();
                    prevState.linkToState.put(link, newState);
                    newState.tag = state.tag;
                    if (state.isFinal) {
                        newState.isFinal = true;
                    }
                    if (state.linkToState.isEmpty()) continue;
                    DeterministicState finalState = new DeterministicState();
                    newState.linkToState.put(new Link(LABEL_INHERITOR, anony, link.hint), finalState);
                    finalState.isFinal = true;
                    used = true;
                }
            }
            state.tag = null;
            state.isFinal = false;
            if (!used) continue;
            result.put(anony, state);
        }
        return result;
    }

    private void reportLRStates(LRHelper lrHelper) {
        if (this.logger.verboseLevel() < 5) {
            return;
        }
        this.logger.verbosest(this.environment.processingFile, "----LRStates Report----");
        Iterator it = lrHelper.symbolToInitialLRState().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Symbol symbol = (Symbol)entry.getKey();
            LRState state = (LRState)entry.getValue();
            this.logger.verbosest("{0} => x{1}", symbol, (Object)state);
        }
        it = lrHelper.allLRStates().iterator();
        while (it.hasNext()) {
            LRState state = (LRState)((Object)it.next());
            this.logger.verbosest("-- {0} --", state);
            if (state.tag != null) {
                this.logger.verbosest("        TAG: " + state.tag);
            }
            Iterator it2 = state.symbolToNextState.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                Symbol symbol = (Symbol)entry.getKey();
                LRState s = (LRState)entry.getValue();
                this.logger.verbosest("        {0} ==> x{1}", symbol, (Object)s);
            }
            this.logger.verbosest("    -- items --");
            Iterator it34 = state.items.iterator();
            while (it34.hasNext()) {
                Item item = (Item)it34.next();
                this.logger.verbosest("        x{0}", item);
                if (item.core.isFinal) {
                    this.logger.verbosest("            FINAL STATE");
                }
                Iterator it35 = item.core.linkToState.entrySet().iterator();
                while (it35.hasNext()) {
                    Map.Entry entry = it35.next();
                    Link link = (Link)entry.getKey();
                    DeterministicState s = (DeterministicState)entry.getValue();
                    this.logger.verbosest("            {0} ==> x{1}", link, (Object)s);
                }
            }
            if (state.symbolToReductions == null) continue;
            this.logger.verbosest("    -- reductions --");
            Iterator it14 = state.symbolToReductions.entrySet().iterator();
            while (it14.hasNext()) {
                Map.Entry entry = it14.next();
                Symbol symbol = (Symbol)entry.getKey();
                Set reductions = (Set)entry.getValue();
                this.logger.verbosest("        {0} ==>", symbol);
                Iterator it15 = reductions.iterator();
                while (it15.hasNext()) {
                    Reduction reduction = (Reduction)it15.next();
                    this.logger.verbosest("            {0}", reduction);
                }
            }
        }
    }

    private void tagLRStates(LRHelper lrHelper, Map initialStateToSymbol) {
        Iterator it7 = lrHelper.allLRStates().iterator();
        while (it7.hasNext()) {
            LRState s = (LRState)it7.next();
            LinkedHashSet<Original.Token> tags = new LinkedHashSet<Original.Token>();
            LinkedHashSet<String> tagImages = new LinkedHashSet<String>();
            Iterator it10 = s.kernelItems.iterator();
            while (it10.hasNext()) {
                Item kernelItem = (Item)it10.next();
                Original.Token tag = kernelItem.core.tag;
                tags.add(tag);
                tagImages.add(tag == null ? null : tag.getImage());
            }
            s.tag = (Original.Token)tags.iterator().next();
            if (tagImages.size() <= 1) continue;
            Iterator it = LRTableGenerator.getExamplePath(s, lrHelper, initialStateToSymbol).iterator();
            Nonterminal nonterminal = (Nonterminal)it.next();
            it.next();
            boolean hasNoTagging = tags.remove(null);
            StringBuffer buffer = new StringBuffer();
            while (it.hasNext()) {
                Symbol symbol = (Symbol)it.next();
                it.next();
                buffer.append(symbol);
                if (!it.hasNext()) continue;
                buffer.append(' ');
            }
            Original.Token hint = this.getHint(nonterminal);
            this.logger.error("ambiguous tag: {0} with the input", hint);
            this.logger.error(hint, "        {0}", (Object)buffer);
            this.logger.error(hint, "    has the different tagging:");
            if (hasNoTagging) {
                this.logger.error(hint, "        no tagging");
            }
            Iterator it11 = tags.iterator();
            while (it11.hasNext()) {
                Original.Token tag = (Original.Token)it11.next();
                this.logger.error("        {0}", tag);
            }
        }
    }

    private LRTable buildLRTable(LRHelper lrHelper) {
        return new GeneratedLRTable(lrHelper.symbolToInitialLRState(), lrHelper.finalState());
    }

    private static MultiMap getBackstep(SimpleState initialState) {
        MultiMap result = new MultiMap();
        LinkedList<SimpleState> undone = new LinkedList<SimpleState>();
        undone.add(initialState);
        HashSet<SimpleState> done = new HashSet<SimpleState>();
        while (!undone.isEmpty()) {
            SimpleState state = (SimpleState)undone.removeFirst();
            if (!done.add(state)) continue;
            Iterator it23 = state.symbolToNextState().values().iterator();
            while (it23.hasNext()) {
                SimpleState s = (SimpleState)it23.next();
                result.add(s, state);
                undone.add(s);
            }
        }
        return result;
    }

    private static String getPathInRegularExpression(SimpleState startState, SimpleState lastState) {
        MultiMap backstep = LRTableGenerator.getBackstep(startState);
        HashSet<SimpleState> allStates = new HashSet<SimpleState>();
        LinkedList<Object> undone = new LinkedList<Object>();
        undone.add(lastState);
        while (!undone.isEmpty()) {
            Set set;
            SimpleState state = (SimpleState)undone.removeFirst();
            if (!allStates.add(state) || (set = backstep.getValueSet(state)) == null) continue;
            undone.addAll(set);
        }
        if (!allStates.contains(startState)) {
            return null;
        }
        undone = new LinkedList();
        undone.add(TreeStack.push(TreeStack.EMPTY_STACK, startState));
        MultiMap stateToRepeatableRoutes = new MultiMap();
        LinkedHashSet<TreeStack> routes = new LinkedHashSet<TreeStack>();
        while (!undone.isEmpty()) {
            TreeStack route = (TreeStack)undone.removeFirst();
            System.out.println(route);
            SimpleState state = (SimpleState)route.top();
            if (state.equals(lastState)) {
                routes.add(TreeStack.pop(TreeStack.pushAll(TreeStack.EMPTY_STACK, route)));
            }
            Iterator it68 = state.symbolToNextState().entrySet().iterator();
            while (it68.hasNext()) {
                Map.Entry entry = it68.next();
                Symbol symbol = (Symbol)entry.getKey();
                SimpleState nextState = (SimpleState)entry.getValue();
                if (!allStates.contains(nextState)) continue;
                if (route.contains(nextState)) {
                    SimpleState s;
                    TreeStack stack = TreeStack.push(TreeStack.EMPTY_STACK, nextState);
                    Iterator it = route.iterator();
                    while (!(s = (SimpleState)it.next()).equals(nextState)) {
                        TreeStack.push(stack, s);
                    }
                    stateToRepeatableRoutes.add(nextState, stack);
                    continue;
                }
                undone.add(TreeStack.push(route, nextState));
            }
        }
        StringBuffer result = new StringBuffer();
        LRTableGenerator.getPathInRegularExpression(result, TreeStack.EMPTY_STACK, startState, routes, stateToRepeatableRoutes);
        return result.toString();
    }

    private static void getPathInRegularExpression(StringBuffer result, TreeStack stack, SimpleState state, Set routes, MultiMap stateToRepeatableRoutes) {
        if (stack.contains(state)) {
            return;
        }
        stack = TreeStack.push(stack, state);
        System.out.println(state);
        if (!$assertionsDisabled && routes.isEmpty()) {
            throw new AssertionError();
        }
        Set repeatableRoutes = stateToRepeatableRoutes.getValueSet(state);
        if (repeatableRoutes != null) {
            result.append("( ");
            LRTableGenerator.getPathInRegularExpressionNoRepeat(result, stack, state, repeatableRoutes, stateToRepeatableRoutes);
            result.append(")* ");
        }
        LRTableGenerator.getPathInRegularExpressionNoRepeat(result, stack, state, routes, stateToRepeatableRoutes);
    }

    private static void getPathInRegularExpressionNoRepeat(StringBuffer result, TreeStack stack, SimpleState state, Set routes, MultiMap stateToRepeatableRoutes) {
        SimpleState nextState;
        boolean hitEmpty = false;
        MultiMap nextStateToRoutes = new MultiMap();
        Iterator it40 = routes.iterator();
        while (it40.hasNext()) {
            TreeStack route = (TreeStack)it40.next();
            if (route.isEmpty()) {
                hitEmpty = true;
                continue;
            }
            SimpleState s = (SimpleState)route.top();
            nextStateToRoutes.add(s, route);
        }
        if (nextStateToRoutes.isEmpty()) {
            return;
        }
        MultiMap nextStateToSymbols = new MultiMap();
        Iterator it90 = state.symbolToNextState().entrySet().iterator();
        while (it90.hasNext()) {
            Map.Entry entry = it90.next();
            Symbol symbol = (Symbol)entry.getKey();
            nextState = (SimpleState)entry.getValue();
            nextStateToSymbols.add(nextState, symbol);
        }
        if (hitEmpty) {
            result.append("[ ");
        } else if (nextStateToSymbols.size() > 1) {
            result.append("( ");
        }
        Iterator outer = nextStateToRoutes.entrySet().iterator();
        while (outer.hasNext()) {
            Map.Entry entry = outer.next();
            nextState = (SimpleState)entry.getKey();
            Set nextRoutes = (Set)entry.getValue();
            Set symbols = nextStateToSymbols.getValueSet(nextState);
            if (symbols.size() > 1) {
                result.append("( ");
            }
            Iterator inner = symbols.iterator();
            while (inner.hasNext()) {
                Symbol symbol = (Symbol)inner.next();
                result.append(symbol);
                if (!inner.hasNext()) continue;
                result.append(" | ");
            }
            if (symbols.size() > 1) {
                result.append(" )");
            }
            result.append(' ');
            LinkedHashSet<TreeStack> subRoutes = new LinkedHashSet<TreeStack>();
            Iterator it92 = nextRoutes.iterator();
            while (it92.hasNext()) {
                TreeStack route = (TreeStack)it92.next();
                SimpleState s = (SimpleState)route.top();
                subRoutes.add(TreeStack.pop(route));
            }
            LRTableGenerator.getPathInRegularExpression(result, stack, nextState, subRoutes, stateToRepeatableRoutes);
            if (!outer.hasNext()) continue;
            result.append(" | ");
        }
        if (hitEmpty) {
            result.append(" ]");
        } else if (nextStateToSymbols.size() > 1) {
            result.append(" )");
        }
    }

    private static List getExamplePath(LRState state, LRHelper lrHelper, Map initialStateToSymbol) {
        LinkedList<Object> result = new LinkedList<Object>();
        Map stateToAscendedStateAndSymbol = lrHelper.stateToAscendedStateAndSymbol();
        LRState focusedState = state;
        LinkedHashSet<Item> focusedKernelItems = focusedState.kernelItems;
        boolean beamed = false;
        block0: while (true) {
            Item item;
            result.addFirst(focusedState);
            Symbol symbol = (Symbol)lrHelper.initialLRStateToSymbol().get(focusedState);
            if (symbol != null) {
                result.addFirst(symbol);
                break;
            }
            Object[] ascendedStateAndSymbol = (Object[])stateToAscendedStateAndSymbol.get(focusedState);
            if (!$assertionsDisabled && ascendedStateAndSymbol == null) {
                throw new AssertionError();
            }
            LRState ascendedState = (LRState)ascendedStateAndSymbol[0];
            Symbol symbol2 = (Symbol)ascendedStateAndSymbol[1];
            result.addFirst(symbol2);
            LinkedHashSet<Item> ascendedItems = new LinkedHashSet<Item>();
            Iterator it51 = ascendedState.items.iterator();
            while (it51.hasNext()) {
                Item previousItem = (Item)it51.next();
                Set items = previousItem.symbolToNextItems.getValueSet(symbol2);
                if (items == null) continue;
                Iterator it52 = items.iterator();
                while (it52.hasNext()) {
                    Item item2 = (Item)it52.next();
                    if (!focusedKernelItems.contains(item2)) continue;
                    ascendedItems.add(previousItem);
                }
            }
            if (!$assertionsDisabled && ascendedItems.isEmpty()) {
                throw new AssertionError();
            }
            if (ascendedItems.size() == 1) {
                beamed = true;
            }
            if (beamed) {
                Iterator it43 = ascendedItems.iterator();
                while (it43.hasNext()) {
                    item = (Item)it43.next();
                    Symbol s = (Symbol)initialStateToSymbol.get(item.core);
                    if (!(s instanceof TypeNonterminal) && !(s instanceof AliasNonterminal)) continue;
                    result.addFirst(ascendedState);
                    result.addFirst(s);
                    break block0;
                }
            }
            Iterator it41 = new ArrayList(ascendedItems).iterator();
            while (it41.hasNext()) {
                item = (Item)it41.next();
                Set tmp = lrHelper.getGeneratorKernels(item);
                if (tmp == null) continue;
                ascendedItems.addAll(tmp);
            }
            ascendedItems.retainAll(ascendedState.kernelItems);
            if (!$assertionsDisabled && ascendedItems.isEmpty()) {
                throw new AssertionError();
            }
            if (ascendedItems.size() == 1) {
                beamed = true;
            }
            focusedState = ascendedState;
            focusedKernelItems = ascendedItems;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator = LRTableGenerator.class$("jp.gr.java_conf.koto.notavacc.lrg.LRTableGenerator")) : class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator).desiredAssertionStatus();
        LABEL_INHERITOR = Collections.singleton("$label");
    }

    private static class GeneratedLRTable
    extends LRTable {
        private final Map symbolToInitialState;
        private final LRTable.LRState finalState;

        public GeneratedLRTable(Map symbolToInitialState, LRTable.LRState finalState) {
            this.symbolToInitialState = Collections.unmodifiableMap(symbolToInitialState);
            this.finalState = finalState;
        }

        public Map symbolToInitialState() {
            return this.symbolToInitialState;
        }

        public LRTable.LRState finalState() {
            return this.finalState;
        }
    }

    private class ConflictChaser {
        private LRHelper lrHelper;
        private ReductionGenerator generator;
        private Map initialStateToSymbol;
        private Map nextLRStatesCache = new HashMap();
        private Map nextLRStatesBusy = new HashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        public ConflictChaser(LRHelper lrHelper, ReductionGenerator generator, Map initialStateToSymbol) {
            this.lrHelper = lrHelper;
            this.generator = generator;
            this.initialStateToSymbol = initialStateToSymbol;
        }

        public int chaseConflicts(Set conflictedStates) {
            int result = 0;
            Iterator it67 = conflictedStates.iterator();
            while (it67.hasNext()) {
                LRState conflictedState = (LRState)it67.next();
                if (!this.chaseConflict(conflictedState)) continue;
                ++result;
            }
            return result;
        }

        private boolean chaseConflict(LRState conflictedState) {
            boolean result = false;
            LinkedHashSet<Symbol> nextSymbols = new LinkedHashSet<Symbol>();
            Set shiftableSymbols = conflictedState.symbolToNextState.keySet();
            Iterator it26 = conflictedState.symbolToReductions.entrySet().iterator();
            while (it26.hasNext()) {
                Map.Entry entry = it26.next();
                Symbol symbol = (Symbol)entry.getKey();
                Set reductions = (Set)entry.getValue();
                if (!shiftableSymbols.contains(symbol) && reductions.size() <= 1) continue;
                nextSymbols.add(symbol);
            }
            Set<List<Symbol>> safeLookaheadPaths = new LinkedHashSet();
            LinkedHashSet<List> lookaheadPaths = new LinkedHashSet<List>();
            Iterator it = nextSymbols.iterator();
            while (it.hasNext()) {
                Symbol lookahead = (Symbol)it.next();
                List maybeConfictPath = this.getMaybeConflictPath(conflictedState, lookahead);
                if (maybeConfictPath == null) {
                    it.remove();
                    safeLookaheadPaths.add(Collections.singletonList(lookahead));
                    continue;
                }
                result = true;
                lookaheadPaths.add(maybeConfictPath);
            }
            if (LRTableGenerator.this.logger.verboseLevel() < 4) {
                safeLookaheadPaths = Collections.EMPTY_SET;
            }
            if (nextSymbols.size() + safeLookaheadPaths.size() > 0) {
                this.reportConflict(conflictedState, this.lrHelper, lookaheadPaths, safeLookaheadPaths);
            }
            return result;
        }

        public List getMaybeConflictPath(LRState lrState, Symbol lookahead) {
            MultiMap labelToLRStates = new MultiMap();
            Iterator it55 = lrState.items.iterator();
            while (it55.hasNext()) {
                Item item = (Item)it55.next();
                if (!item.core.isFinal) continue;
                Reduction reduction = this.generator.getReduction(item);
                Set nextLRStates = this.backstep(lrState, reduction.labelSetList().size());
                nextLRStates = this.getNextLRStates(nextLRStates, reduction.reducedSymbol());
                nextLRStates = this.getNextLRStates(nextLRStates, lookahead);
                labelToLRStates.addAll(reduction, nextLRStates);
            }
            Set nextLRStates = this.shiftSavingMemory(Collections.singleton(lrState), lookahead);
            labelToLRStates.addAll(null, nextLRStates);
            ChasedState initialState = new ChasedState(labelToLRStates);
            HashMap<ChasedState, TreeStack> chasedStateToPath = new HashMap<ChasedState, TreeStack>();
            chasedStateToPath.put(initialState, TreeStack.push(TreeStack.EMPTY_STACK, lookahead));
            LinkedList<ChasedState> undone = new LinkedList<ChasedState>();
            undone.add(initialState);
            while (!undone.isEmpty()) {
                ChasedState cs = (ChasedState)undone.removeFirst();
                if (cs.labelToLRStates.size() <= 1) continue;
                TreeStack path = (TreeStack)chasedStateToPath.get(cs);
                ArrayList list = new ArrayList(cs.labelToLRStates.values());
                int i = 0;
                while (i < list.size()) {
                    Set set1 = (Set)list.get(i);
                    int j = i + 1;
                    while (j < list.size()) {
                        Set set2 = (Set)list.get(j);
                        if (set1.equals(set2)) {
                            return new ArrayList(TreeStack.pushAll(TreeStack.EMPTY_STACK, path));
                        }
                        ++j;
                    }
                    ++i;
                }
                Iterator it62 = cs.symbolToNextState().entrySet().iterator();
                while (it62.hasNext()) {
                    Map.Entry entry = it62.next();
                    Symbol symbol = (Symbol)entry.getKey();
                    ChasedState nextState = (ChasedState)entry.getValue();
                    if (chasedStateToPath.containsKey(nextState)) continue;
                    chasedStateToPath.put(nextState, TreeStack.push(path, symbol));
                    undone.add(nextState);
                }
            }
            return null;
        }

        private Set backstep(LRState lrState, int count) {
            return this.backstep(Collections.singleton(lrState), count);
        }

        private Set backstep(Set lrStates, int count) {
            if (count == 0) {
                return lrStates;
            }
            if (lrStates.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            LinkedHashSet result = new LinkedHashSet();
            Iterator it60 = lrStates.iterator();
            while (it60.hasNext()) {
                LRState lrState = (LRState)it60.next();
                result.addAll(this.lrHelper.backstep(lrState));
            }
            return this.backstep(result, count - 1);
        }

        private Set getNextLRStates(Set lrStates, Symbol nextSymbol) {
            List<Object> key = Arrays.asList(lrStates, nextSymbol);
            Set result = (Set)this.nextLRStatesCache.get(key);
            if (result == null) {
                result = this.getNextLRStatesPrivate(lrStates, nextSymbol);
                this.nextLRStatesCache.put(key, result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set getNextLRStatesPrivate(Set lrStates, Symbol nextSymbol) {
            Set set;
            List<Object> key = Arrays.asList(lrStates, nextSymbol);
            Set result = (Set)this.nextLRStatesCache.get(key);
            if (result != null) {
                return result;
            }
            result = (Set)this.nextLRStatesBusy.get(key);
            if (result != null) {
                return result;
            }
            this.nextLRStatesBusy.put(key, Collections.EMPTY_SET);
            try {
                set = this.shiftSavingMemory(this.reduceAllSavingMemory(lrStates, nextSymbol), nextSymbol);
                Object var7_6 = null;
                this.nextLRStatesBusy.remove(key);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.nextLRStatesBusy.remove(key);
                throw throwable;
            }
            return set;
        }

        private Set reduceAllSavingMemory(Set lrStates, Symbol lookahead) {
            LinkedHashSet<LRState> result = new LinkedHashSet<LRState>();
            LinkedList undone = new LinkedList(lrStates);
            while (!undone.isEmpty()) {
                Set nextStates;
                Reduction reduction;
                LRState lrState = (LRState)undone.removeFirst();
                if (!result.add(lrState)) continue;
                if (lookahead != null) {
                    Set reductions = (Set)lrState.symbolToReductions.get(lookahead);
                    if (reductions == null) continue;
                    Iterator it56 = reductions.iterator();
                    while (it56.hasNext()) {
                        reduction = (Reduction)it56.next();
                        nextStates = this.backstep(lrState, reduction.labelSetList().size());
                        nextStates = this.getNextLRStatesPrivate(nextStates, reduction.reducedSymbol());
                        undone.addAll(nextStates);
                    }
                    continue;
                }
                Iterator it5 = lrState.items.iterator();
                while (it5.hasNext()) {
                    Item item = (Item)it5.next();
                    if (!item.core.isFinal) continue;
                    reduction = this.generator.getReduction(item);
                    nextStates = this.backstep(lrState, reduction.labelSetList().size());
                    nextStates = this.getNextLRStatesPrivate(nextStates, reduction.reducedSymbol());
                    undone.addAll(nextStates);
                }
            }
            return result;
        }

        private Set shiftSavingMemory(Set lrStates, Symbol lookahead) {
            LinkedHashSet<LRState> result = new LinkedHashSet<LRState>();
            Iterator it58 = lrStates.iterator();
            while (it58.hasNext()) {
                LRState lrState = (LRState)it58.next();
                LRState nextLRState = (LRState)lrState.symbolToNextState.get(lookahead);
                if (nextLRState == null) continue;
                result.add(nextLRState);
            }
            return result;
        }

        private void reportConflict(LRState state, LRHelper lrHelper, Set lookaheadPaths, Set safelookaheadPaths) {
            List path = LRTableGenerator.getExamplePath(state, lrHelper, this.initialStateToSymbol);
            TreeStack stack = TreeStack.pushAll(TreeStack.EMPTY_STACK, path);
            Iterator it = path.iterator();
            Nonterminal nonterminal = (Nonterminal)it.next();
            it.next();
            StringBuffer buffer = new StringBuffer();
            while (it.hasNext()) {
                Symbol symbol = (Symbol)it.next();
                it.next();
                if (symbol instanceof AnonymousNonterminal) {
                    buffer.append("...");
                } else {
                    buffer.append(symbol);
                }
                if (!it.hasNext()) continue;
                buffer.append(' ');
            }
            ArrayList paths = new ArrayList(lookaheadPaths.size() + safelookaheadPaths.size());
            paths.addAll(lookaheadPaths);
            paths.addAll(safelookaheadPaths);
            int level = !lookaheadPaths.isEmpty() ? 2 : 4;
            Original.Token hint = LRTableGenerator.this.getHint(nonterminal);
            LRTableGenerator.this.logger.report(level, hint, "LALR(1) conflicts: One of the input to the conflicted state is");
            LRTableGenerator.this.logger.report(level, hint, "        {1}, to parse {0}.", (Object)hint, (Object)buffer);
            int i = 0;
            while (i < paths.size()) {
                List lookaheadPath = (List)paths.get(i);
                Symbol lookahead = (Symbol)lookaheadPath.get(0);
                level = i < lookaheadPaths.size() ? 2 : 4;
                LRTableGenerator.this.logger.report(level, hint, "    For the look-ahead {0},", (Object)lookahead);
                if (lookaheadPath.size() > 1) {
                    StringBuffer lookaheadPathString = new StringBuffer();
                    Iterator it63 = lookaheadPath.iterator();
                    while (it63.hasNext()) {
                        Symbol s = (Symbol)it63.next();
                        if (s instanceof AnonymousNonterminal) {
                            lookaheadPathString.append("...");
                        } else {
                            lookaheadPathString.append(s);
                        }
                        if (!it63.hasNext()) continue;
                        lookaheadPathString.append(' ');
                    }
                    LRTableGenerator.this.logger.verbose(hint, "        (or {0},)", (Object)lookaheadPathString);
                }
                LRTableGenerator.this.logger.report(level, hint, "    the reducible nonterminals are");
                boolean shiftReduceConflict = state.symbolToNextState.containsKey(lookahead);
                Iterator it28 = state.symbolToReductions.getValueSet(lookahead).iterator();
                while (it28.hasNext()) {
                    Reduction reduction = (Reduction)it28.next();
                    TreeStack tail = TreeStack.EMPTY_STACK;
                    this.reportConflictReduction(level, stack, reduction, 0, tail, lookahead);
                }
                if (shiftReduceConflict) {
                    LRTableGenerator.this.logger.report(level, hint, "        also shiftable.");
                }
                ++i;
            }
        }

        private void reportConflictReduction(int level, TreeStack stack, Reduction reduction, int ignoreCount, TreeStack tail, Symbol lookahead) {
            Nonterminal reducedSymbol = reduction.reducedSymbol();
            List labelSetList = reduction.labelSetList();
            int i = labelSetList.size() - 1 - ignoreCount;
            while (i >= 0) {
                stack = TreeStack.pop(stack);
                Symbol symbol = (Symbol)stack.top();
                stack = TreeStack.pop(stack);
                tail = TreeStack.push(tail, symbol);
                tail = TreeStack.push(tail, labelSetList.get(i));
                --i;
            }
            if (reducedSymbol instanceof AnonymousNonterminal) {
                LRState state = (LRState)stack.top();
                state = (LRState)state.symbolToNextState.get(reducedSymbol);
                this.reportConflictReduction(level, stack, state, tail, lookahead);
            } else {
                StringBuffer buffer = new StringBuffer();
                if (tail.isEmpty()) {
                    buffer.append("(empty)");
                } else {
                    Iterator it45 = tail.iterator();
                    while (it45.hasNext()) {
                        Set labelSet = (Set)it45.next();
                        if (labelSet == null) {
                            buffer.append("...");
                            if (!$assertionsDisabled && it45.hasNext()) {
                                throw new AssertionError();
                            }
                            break;
                        }
                        Symbol symbol = (Symbol)it45.next();
                        Iterator it22 = labelSet.iterator();
                        while (it22.hasNext()) {
                            String label = (String)it22.next();
                            if (label.equals("$label")) continue;
                            buffer.append(label);
                            buffer.append(":");
                        }
                        if (symbol instanceof AnonymousNonterminal) {
                            buffer.append("...");
                        } else {
                            buffer.append(symbol);
                        }
                        if (!it45.hasNext()) continue;
                        buffer.append(' ');
                    }
                }
                Original.Token hint = LRTableGenerator.this.getHint(reducedSymbol);
                LRTableGenerator.this.logger.report(level, "        {0} from {1}", hint, (Object)buffer);
            }
        }

        private void reportConflictReduction(int level, TreeStack stack, LRState state, TreeStack tail, Symbol lookahead) {
            Set reductions;
            if (lookahead != null) {
                reductions = state.symbolToReductions.getValueSet(lookahead);
            } else {
                reductions = new LinkedHashSet();
                Iterator it42 = state.symbolToReductions.values().iterator();
                while (it42.hasNext()) {
                    Set set = (Set)it42.next();
                    reductions.addAll(set);
                }
            }
            Iterator it28 = reductions.iterator();
            while (it28.hasNext()) {
                Reduction reduction = (Reduction)it28.next();
                this.reportConflictReduction(level, stack, reduction, 1, tail, lookahead);
            }
        }

        static {
            $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator = LRTableGenerator.class$("jp.gr.java_conf.koto.notavacc.lrg.LRTableGenerator")) : class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator).desiredAssertionStatus();
        }

        private class ChasedState
        implements SimpleState {
            public final MultiMap labelToLRStates;
            public final int hashCode;
            private Map symbolToNextState = null;

            public ChasedState(MultiMap labelToLRStates) {
                this.labelToLRStates = labelToLRStates;
                this.hashCode = labelToLRStates.hashCode();
            }

            public int hashCode() {
                return this.hashCode;
            }

            public final boolean equals(Object rhs) {
                if (this == rhs) {
                    return true;
                }
                if (rhs instanceof ChasedState) {
                    return this.equals((ChasedState)rhs);
                }
                return false;
            }

            public boolean equals(ChasedState rhs) {
                return this.hashCode == rhs.hashCode && this.labelToLRStates.equals(rhs.labelToLRStates);
            }

            public String toString() {
                return this.labelToLRStates.toString();
            }

            public Map symbolToNextState() {
                if (this.symbolToNextState == null) {
                    LinkedHashMap<Symbol, MultiMap> resultMaps = new LinkedHashMap<Symbol, MultiMap>();
                    Iterator it57 = this.labelToLRStates.entrySet().iterator();
                    while (it57.hasNext()) {
                        Map.Entry entry = it57.next();
                        Object label = entry.getKey();
                        Set lrStates = (Set)entry.getValue();
                        lrStates = ConflictChaser.this.reduceAllSavingMemory(lrStates, null);
                        Iterator it61 = lrStates.iterator();
                        while (it61.hasNext()) {
                            LRState lrState = (LRState)it61.next();
                            Iterator it65 = lrState.symbolToNextState.entrySet().iterator();
                            while (it65.hasNext()) {
                                Map.Entry entry2 = it65.next();
                                Symbol symbol = (Symbol)entry2.getKey();
                                LRState nextLRState = (LRState)entry2.getValue();
                                MultiMap resultMap = (MultiMap)resultMaps.get(symbol);
                                if (resultMap == null) {
                                    resultMap = new MultiMap();
                                    resultMaps.put(symbol, resultMap);
                                }
                                resultMap.add(label, nextLRState);
                            }
                        }
                    }
                    this.symbolToNextState = new LinkedHashMap();
                    Iterator it49 = resultMaps.entrySet().iterator();
                    while (it49.hasNext()) {
                        Map.Entry entry = it49.next();
                        Symbol symbol = (Symbol)entry.getKey();
                        MultiMap resultMap = (MultiMap)entry.getValue();
                        this.symbolToNextState.put(symbol, new ChasedState(resultMap));
                    }
                }
                return this.symbolToNextState;
            }
        }
    }

    private class ReductionGenerator {
        private Map initialStateToSymbol;
        private Map stateToMapPreviousStateToLinks;
        private Map stateToReduction = new HashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        public ReductionGenerator(Map symbolToInitialState, Map initialStateToSymbol, Set allStates) {
            this.initialStateToSymbol = initialStateToSymbol;
            this.stateToMapPreviousStateToLinks = LRTableGenerator.this.stateToMapPreviousStateToLinks(allStates);
        }

        public Set generateReductions(LRHelper lrHelper) {
            LinkedHashSet<LRState> conflictedStates = new LinkedHashSet<LRState>();
            Iterator it21 = lrHelper.allLRStates().iterator();
            while (it21.hasNext()) {
                LRState state = (LRState)it21.next();
                if (!$assertionsDisabled && state.symbolToReductions != null) {
                    throw new AssertionError();
                }
                state.symbolToReductions = new MultiMap();
                boolean conflicted = false;
                if (state.containsFinal) {
                    Iterator it5 = state.items.iterator();
                    while (it5.hasNext()) {
                        Item item = (Item)it5.next();
                        if (!item.core.isFinal) continue;
                        Reduction reduction = this.getReduction(item);
                        Iterator it24 = item.lookaheads.iterator();
                        while (it24.hasNext()) {
                            Symbol lookahead = (Symbol)it24.next();
                            state.symbolToReductions.add(lookahead, reduction);
                        }
                    }
                    if (!conflicted) {
                        Set shiftableSymbol = state.symbolToNextState.keySet();
                        Iterator it26 = state.symbolToReductions.entrySet().iterator();
                        while (it26.hasNext()) {
                            Map.Entry entry = it26.next();
                            Symbol symbol = (Symbol)entry.getKey();
                            Set reductions = (Set)entry.getValue();
                            if (!shiftableSymbol.contains(symbol) && reductions.size() <= 1) continue;
                            conflicted = true;
                        }
                    }
                }
                if (!conflicted) continue;
                conflictedStates.add(state);
            }
            return conflictedStates;
        }

        private Reduction getReduction(Item item) {
            return this.getReduction(item.core);
        }

        private Reduction getReduction(DeterministicState finalState) {
            DeterministicState state = finalState;
            Reduction result = (Reduction)this.stateToReduction.get(finalState);
            if (result == null) {
                Nonterminal symbol;
                LinkedList<Set> labelsList = new LinkedList<Set>();
                while (true) {
                    if ((symbol = (Nonterminal)this.initialStateToSymbol.get(state)) != null) break;
                    MultiMap map = (MultiMap)this.stateToMapPreviousStateToLinks.get(state);
                    if (!$assertionsDisabled && map.size() != 1) {
                        throw new AssertionError();
                    }
                    state = (DeterministicState)map.keySet().iterator().next();
                    Set links = (Set)map.values().iterator().next();
                    if (!$assertionsDisabled && links.size() != 1) {
                        throw new AssertionError();
                    }
                    Link link = (Link)links.iterator().next();
                    labelsList.addFirst(link.labels);
                }
                result = new Reduction(symbol, labelsList);
                this.stateToReduction.put(finalState, result);
            }
            return result;
        }

        static {
            $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator = LRTableGenerator.class$("jp.gr.java_conf.koto.notavacc.lrg.LRTableGenerator")) : class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator).desiredAssertionStatus();
        }
    }

    private class LookaheadDeliverer {
        private Map symbolToInitialState;
        private Set allStates;
        private Set emptyAcceptable;
        private MultiMap stateToFirstSet;
        static final /* synthetic */ boolean $assertionsDisabled;

        public LookaheadDeliverer(Map symbolToInitialState, Set allStates) {
            this.symbolToInitialState = symbolToInitialState;
            this.allStates = allStates;
            this.buildEmptyAcceptableSet();
            this.buildFirstSet();
        }

        private void buildEmptyAcceptableSet() {
            this.emptyAcceptable = new HashSet();
            LinkedHashSet unfixed = new LinkedHashSet(this.allStates);
            boolean modified = true;
            while (!unfixed.isEmpty() && modified) {
                modified = false;
                Iterator outer = unfixed.iterator();
                while (outer.hasNext()) {
                    DeterministicState state = (DeterministicState)outer.next();
                    int check = -1;
                    if (state.isFinal) {
                        check = 1;
                    } else {
                        Iterator inner = state.linkToState.entrySet().iterator();
                        while (inner.hasNext()) {
                            Map.Entry entry = inner.next();
                            Link link = (Link)entry.getKey();
                            Symbol symbol = link.symbol;
                            if (!(symbol instanceof Nonterminal)) continue;
                            DeterministicState nextState = (DeterministicState)entry.getValue();
                            DeterministicState s = (DeterministicState)this.symbolToInitialState.get(symbol);
                            if (unfixed.contains(nextState) || unfixed.contains(s)) {
                                check = 0;
                                continue;
                            }
                            if (!this.emptyAcceptable.contains(nextState) || !this.emptyAcceptable.contains(s)) continue;
                            check = 1;
                            break;
                        }
                    }
                    if (check == 0) continue;
                    outer.remove();
                    modified = true;
                    if (check != 1) continue;
                    this.emptyAcceptable.add(state);
                }
            }
        }

        public boolean isEmptyAcceptable(DeterministicState state) {
            return this.emptyAcceptable.contains(state);
        }

        public boolean isEmptyAcceptable(Nonterminal symbol) {
            DeterministicState state = (DeterministicState)this.symbolToInitialState.get(symbol);
            return this.isEmptyAcceptable(state);
        }

        public boolean isEmptyAcceptable(Symbol symbol) {
            if (symbol instanceof Terminal) {
                return false;
            }
            return this.isEmptyAcceptable((Nonterminal)symbol);
        }

        private void buildFirstSet() {
            this.stateToFirstSet = new MultiMap();
            Iterator it0 = this.allStates.iterator();
            while (it0.hasNext()) {
                DeterministicState state = (DeterministicState)it0.next();
                this.stateToFirstSet.put(state, new LinkedHashSet());
            }
            LinkedHashSet unfixed = new LinkedHashSet(this.allStates);
            boolean modified = true;
            while (!unfixed.isEmpty() && modified) {
                modified = false;
                Iterator outer = unfixed.iterator();
                while (outer.hasNext()) {
                    DeterministicState state = (DeterministicState)outer.next();
                    Set first = this.stateToFirstSet.getValueSet(state);
                    boolean fixed = true;
                    Iterator inner = state.linkToState.entrySet().iterator();
                    while (inner.hasNext()) {
                        Map.Entry entry = inner.next();
                        Link link = (Link)entry.getKey();
                        if (link.symbol instanceof Terminal) {
                            modified |= first.add(link.symbol);
                            continue;
                        }
                        DeterministicState ds = (DeterministicState)this.symbolToInitialState.get(link.symbol);
                        modified |= first.addAll(this.stateToFirstSet.getValueSet(ds));
                        if (unfixed.contains(ds)) {
                            fixed = false;
                        }
                        if (!this.isEmptyAcceptable(ds)) continue;
                        ds = (DeterministicState)entry.getValue();
                        modified |= first.addAll(this.stateToFirstSet.getValueSet(ds));
                        if (!unfixed.contains(ds)) continue;
                        fixed = false;
                    }
                    if (!fixed) continue;
                    outer.remove();
                    modified = true;
                }
            }
        }

        public Set first(DeterministicState state) {
            return this.stateToFirstSet.getValueSet(state);
        }

        public void deliverLookahead(LRHelper lrHelper) {
            Item item;
            Iterator it36 = lrHelper.allLRStates().iterator();
            while (it36.hasNext()) {
                LRState state = (LRState)it36.next();
                Iterator it37 = state.items.iterator();
                while (it37.hasNext()) {
                    Item item2 = (Item)it37.next();
                    if (!$assertionsDisabled && item2.lookaheads != null) {
                        throw new AssertionError();
                    }
                    item2.lookaheads = new LinkedHashSet();
                }
            }
            LinkedList<Object[]> jobs = new LinkedList<Object[]>();
            MultiMap itemToLookaheadDependencies = new MultiMap();
            LinkedList<Item> undone = new LinkedList<Item>();
            Iterator it4 = lrHelper.symbolToInitialLRState().values().iterator();
            while (it4.hasNext()) {
                LRState state = (LRState)it4.next();
                undone.addAll(state.kernelItems);
            }
            HashSet<Item> done = new HashSet<Item>();
            while (!undone.isEmpty()) {
                item = (Item)undone.removeFirst();
                if (!done.add(item)) continue;
                Iterator it3 = item.symbolToNextItems.entrySet().iterator();
                while (it3.hasNext()) {
                    Map.Entry entry = it3.next();
                    Symbol symbol = (Symbol)entry.getKey();
                    Set nextItems = (Set)entry.getValue();
                    Iterator it50 = nextItems.iterator();
                    while (it50.hasNext()) {
                        Item nextItem = (Item)it50.next();
                        itemToLookaheadDependencies.add(item, nextItem);
                        undone.add(nextItem);
                        if (!(symbol instanceof Nonterminal)) continue;
                        DeterministicState core = (DeterministicState)this.symbolToInitialState.get(symbol);
                        Item deliveredItem = (Item)item.owner.coreToItem.get(core);
                        jobs.add(new Object[]{deliveredItem, this.first(nextItem.core)});
                        undone.add(deliveredItem);
                        if (!this.isEmptyAcceptable(nextItem.core)) continue;
                        itemToLookaheadDependencies.add(item, deliveredItem);
                    }
                }
            }
            Iterator it1 = jobs.iterator();
            while (it1.hasNext()) {
                Object[] job = (Object[])it1.next();
                item = (Item)job[0];
                Set lookaheads = (Set)job[1];
                this.deliverLookahead(itemToLookaheadDependencies, item, lookaheads);
            }
        }

        private void deliverLookahead(MultiMap itemToLookaheadDependencies, Item item, Set lookaheads) {
            Set dependencies;
            if (item.lookaheads.addAll(lookaheads) && (dependencies = itemToLookaheadDependencies.getValueSet(item)) != null) {
                Iterator it6 = dependencies.iterator();
                while (it6.hasNext()) {
                    Item dependency = (Item)it6.next();
                    this.deliverLookahead(itemToLookaheadDependencies, dependency, lookaheads);
                }
            }
        }

        static {
            $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator = LRTableGenerator.class$("jp.gr.java_conf.koto.notavacc.lrg.LRTableGenerator")) : class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator).desiredAssertionStatus();
        }
    }

    private class LRStateBuilder {
        private Map symbolToInitialState;
        private Map kernelCoresToLRState = new HashMap();

        public LRStateBuilder(Map symbolToInitialState) {
            this.symbolToInitialState = symbolToInitialState;
        }

        private LRState createLRState(Set kernelCores) {
            LRState result = (LRState)this.kernelCoresToLRState.get(kernelCores);
            if (result != null) {
                return result;
            }
            result = new LRState();
            this.kernelCoresToLRState.put(kernelCores, result);
            Iterator it = kernelCores.iterator();
            while (it.hasNext()) {
                DeterministicState kernelCore = (DeterministicState)it.next();
                Item kernel = new Item(result, kernelCore, true);
                result.kernelItems.add(kernel);
                result.coreToItem.put(kernelCore, kernel);
            }
            MultiMap symbolToNextKernelCores = new MultiMap();
            LinkedList<Item> undone = new LinkedList<Item>(result.kernelItems);
            while (!undone.isEmpty()) {
                Item item = (Item)undone.removeFirst();
                result.items.add(item);
                if (item.core.isFinal) {
                    result.containsFinal = true;
                }
                Iterator it2 = item.core.linkToState.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry entry = it2.next();
                    Link link = (Link)entry.getKey();
                    DeterministicState nextKernelCore = (DeterministicState)entry.getValue();
                    Symbol symbol = link.symbol;
                    symbolToNextKernelCores.add(symbol, nextKernelCore);
                    if (!(symbol instanceof Nonterminal)) continue;
                    DeterministicState core = (DeterministicState)this.symbolToInitialState.get(symbol);
                    Item deliveredItem = (Item)result.coreToItem.get(core);
                    if (deliveredItem == null) {
                        deliveredItem = new Item(result, core, false);
                        result.coreToItem.put(core, deliveredItem);
                        undone.add(deliveredItem);
                    }
                    item.deliveredItems.add(deliveredItem);
                }
            }
            Iterator it3 = symbolToNextKernelCores.entrySet().iterator();
            while (it3.hasNext()) {
                Map.Entry entry = it3.next();
                Symbol symbol = (Symbol)entry.getKey();
                Set nextKernelCores = (Set)entry.getValue();
                LRState nextState = this.createLRState(nextKernelCores);
                result.symbolToNextState.put(symbol, nextState);
            }
            Iterator it16 = result.items.iterator();
            while (it16.hasNext()) {
                Item item = (Item)it16.next();
                Iterator it48 = item.core.linkToState.entrySet().iterator();
                while (it48.hasNext()) {
                    Map.Entry entry = it48.next();
                    Link link = (Link)entry.getKey();
                    DeterministicState nextCore = (DeterministicState)entry.getValue();
                    LRState nextState = (LRState)result.symbolToNextState.get(link.symbol);
                    Item nextItem = (Item)nextState.coreToItem.get(nextCore);
                    item.symbolToNextItems.add(link.symbol, nextItem);
                }
            }
            return result;
        }
    }

    private class LRHelper {
        private Map symbolToInitialLRState;
        private LRState finalState;
        private MultiMap backsteps = null;
        private Set allLRStates = null;
        private Map initialLRStateToSymbol = null;
        private MultiMap itemToGeneratorKernels = null;
        private Map stateToAscendedStateAndSymbol = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        public LRHelper(Map symbolToInitialLRState, LRState finalState) {
            this.symbolToInitialLRState = symbolToInitialLRState;
            this.finalState = finalState;
        }

        public Map symbolToInitialLRState() {
            return this.symbolToInitialLRState;
        }

        public LRState finalState() {
            return this.finalState;
        }

        public Set backstep(LRState state) {
            this.allLRStates();
            Set result = this.backsteps.getValueSet(state);
            if (result == null) {
                result = Collections.EMPTY_SET;
                this.backsteps.put(state, result);
            }
            return result;
        }

        public Set allLRStates() {
            if (this.allLRStates == null) {
                this.backsteps = new MultiMap();
                this.allLRStates = new LinkedHashSet();
                this.allLRStates.add(this.finalState);
                LinkedList undone = new LinkedList(this.symbolToInitialLRState.values());
                while (!undone.isEmpty()) {
                    LRState state = (LRState)undone.removeFirst();
                    if (!this.allLRStates.add(state)) continue;
                    Iterator it59 = state.symbolToNextState.values().iterator();
                    while (it59.hasNext()) {
                        LRState nextState = (LRState)it59.next();
                        this.backsteps.add(nextState, state);
                    }
                    undone.addAll(state.symbolToNextState.values());
                }
            }
            return this.allLRStates;
        }

        public Map initialLRStateToSymbol() {
            if (this.initialLRStateToSymbol == null) {
                this.initialLRStateToSymbol = new LinkedHashMap();
                Iterator it44 = this.symbolToInitialLRState.entrySet().iterator();
                while (it44.hasNext()) {
                    Map.Entry entry = it44.next();
                    this.initialLRStateToSymbol.put(entry.getValue(), entry.getKey());
                }
                if (!$assertionsDisabled && this.initialLRStateToSymbol.size() != this.symbolToInitialLRState.size()) {
                    throw new AssertionError();
                }
            }
            return this.initialLRStateToSymbol;
        }

        public MultiMap itemToGeneratorKernels() {
            if (this.itemToGeneratorKernels == null) {
                this.itemToGeneratorKernels = new MultiMap();
                Iterator it12 = this.allLRStates().iterator();
                while (it12.hasNext()) {
                    LRState state = (LRState)it12.next();
                    Iterator it31 = state.kernelItems.iterator();
                    while (it31.hasNext()) {
                        Item kernel = (Item)it31.next();
                        HashSet<Item> done = new HashSet<Item>();
                        LinkedList<Item> undone = new LinkedList<Item>();
                        undone.add(kernel);
                        while (!undone.isEmpty()) {
                            Item item = (Item)undone.removeFirst();
                            if (!done.add(item)) continue;
                            Iterator it33 = item.deliveredItems.iterator();
                            while (it33.hasNext()) {
                                Item deliveredItem = (Item)it33.next();
                                this.itemToGeneratorKernels.add(deliveredItem, kernel);
                                undone.add(deliveredItem);
                            }
                        }
                    }
                }
            }
            return this.itemToGeneratorKernels;
        }

        public Set getGeneratorKernels(Item item) {
            return this.itemToGeneratorKernels().getValueSet(item);
        }

        public Map stateToAscendedStateAndSymbol() {
            if (this.stateToAscendedStateAndSymbol == null) {
                LRState state;
                this.stateToAscendedStateAndSymbol = new LinkedHashMap();
                LinkedList<LRState> undone = new LinkedList<LRState>();
                Iterator it39 = this.symbolToInitialLRState.values().iterator();
                while (it39.hasNext()) {
                    state = (LRState)it39.next();
                    this.stateToAscendedStateAndSymbol.put(state, null);
                    undone.add(state);
                }
                while (!undone.isEmpty()) {
                    state = (LRState)undone.removeFirst();
                    Iterator it38 = state.symbolToNextState.entrySet().iterator();
                    while (it38.hasNext()) {
                        Map.Entry entry = it38.next();
                        Symbol symbol = (Symbol)entry.getKey();
                        LRState nextState = (LRState)entry.getValue();
                        if (this.stateToAscendedStateAndSymbol.containsKey(nextState)) continue;
                        this.stateToAscendedStateAndSymbol.put(nextState, new Object[]{state, symbol});
                        undone.add(nextState);
                    }
                }
            }
            return this.stateToAscendedStateAndSymbol;
        }

        static {
            $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator = LRTableGenerator.class$("jp.gr.java_conf.koto.notavacc.lrg.LRTableGenerator")) : class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator).desiredAssertionStatus();
        }
    }

    public static class Reduction
    implements LRTable.Reduction {
        private Nonterminal reducedSymbol;
        private List labelSetList;

        public Reduction(Nonterminal reducedSymbol, List labelSetList) {
            this.reducedSymbol = reducedSymbol;
            this.labelSetList = labelSetList;
        }

        public Nonterminal reducedSymbol() {
            return this.reducedSymbol;
        }

        public List labelSetList() {
            return this.labelSetList;
        }

        public int hashCode() {
            return this.reducedSymbol.hashCode() + this.labelSetList.hashCode();
        }

        public final boolean equals(Object rhs) {
            if (rhs instanceof Reduction) {
                return this.equals((Reduction)rhs);
            }
            return false;
        }

        public boolean equals(Reduction rhs) {
            return this.reducedSymbol.equals(rhs.reducedSymbol) && this.labelSetList.equals(rhs.labelSetList);
        }

        public String toString() {
            return this.reducedSymbol + " : " + this.labelSetList;
        }
    }

    private static class Item {
        public final LRState owner;
        public final DeterministicState core;
        public final boolean kernel;
        public Set lookaheads = null;
        public MultiMap symbolToNextItems = new MultiMap();
        public Set deliveredItems = new LinkedHashSet();
        static final /* synthetic */ boolean $assertionsDisabled;

        public Item(LRState owner, DeterministicState core, boolean kernel) {
            if (!($assertionsDisabled || owner != null && core != null)) {
                throw new AssertionError();
            }
            this.owner = owner;
            this.core = core;
            this.kernel = kernel;
        }

        public String toString() {
            String k = this.kernel ? " (kernel)" : "";
            String f = this.core.isFinal ? " (FINAL)" : "";
            return this.core + f + " ; " + this.lookaheads + k;
        }

        static {
            $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator = LRTableGenerator.class$("jp.gr.java_conf.koto.notavacc.lrg.LRTableGenerator")) : class$jp$gr$java_conf$koto$notavacc$lrg$LRTableGenerator).desiredAssertionStatus();
        }
    }

    private static class LRState
    implements LRTable.LRState,
    SimpleState {
        public Map symbolToNextState = new LinkedHashMap();
        public MultiMap symbolToReductions = null;
        public Original.Token tag;
        public Set kernelItems = new LinkedHashSet();
        public Set items = new LinkedHashSet();
        public Map coreToItem = new LinkedHashMap();
        public boolean containsFinal = false;
        private static int numberOfInstance = 0;
        public final int idNumber = numberOfInstance++;

        private LRState() {
        }

        public Map symbolToNextState() {
            return this.symbolToNextState;
        }

        public Map symbolToReductions() {
            return this.symbolToReductions;
        }

        public Original.Token tag() {
            return this.tag;
        }

        public String toString() {
            return "LRState" + this.idNumber;
        }
    }

    private static interface SimpleState {
        public Map symbolToNextState();
    }

    private class DeterministicConverter {
        private Map substatesToState = new LinkedHashMap();

        private DeterministicConverter() {
        }

        private DeterministicState createDeterministicState(Set substates, NondeterministicState finalState) {
            DeterministicState result = (DeterministicState)this.substatesToState.get(substates);
            if (result == null) {
                result = new DeterministicState();
                this.substatesToState.put(substates, result);
                this.bind(substates, finalState, result);
            }
            return result;
        }

        private void bind(Set substates, NondeterministicState finalState, DeterministicState target) {
            Map.Entry entry;
            Set closure = this.getEpsilonClosure(substates);
            LinkedHashSet<Original.Token> tags = new LinkedHashSet<Original.Token>();
            Iterator it = substates.iterator();
            while (it.hasNext()) {
                NondeterministicState s = (NondeterministicState)it.next();
                tags.add(s.tag);
            }
            if (!tags.isEmpty()) {
                if (tags.size() == 1) {
                    target.tag = (Original.Token)tags.iterator().next();
                } else {
                    boolean first = true;
                    it = tags.iterator();
                    while (it.hasNext()) {
                        Original.Token tag = (Original.Token)it.next();
                        if (tag == null) continue;
                        if (first) {
                            LRTableGenerator.this.logger.error(tag, "An unified state has different tag(s):");
                            first = false;
                        }
                        LRTableGenerator.this.logger.error("        {0}", tag);
                    }
                }
            }
            target.isFinal = closure.contains(finalState);
            MultiMap pairToLinks = new MultiMap();
            MultiMap pairToSubstates = new MultiMap();
            Iterator it29 = closure.iterator();
            while (it29.hasNext()) {
                NondeterministicState substate = (NondeterministicState)it29.next();
                Iterator it3 = substate.linkToStates.entrySet().iterator();
                while (it3.hasNext()) {
                    entry = it3.next();
                    Link link = (Link)entry.getKey();
                    Set states = (Set)entry.getValue();
                    List<Object> pair = Arrays.asList(link.labels, link.symbol);
                    pairToLinks.add(pair, link);
                    pairToSubstates.addAll(pair, states);
                }
            }
            MultiMap linkToSubstates = new MultiMap();
            Iterator it30 = pairToLinks.entrySet().iterator();
            while (it30.hasNext()) {
                entry = it30.next();
                List pair = (List)entry.getKey();
                Set links = (Set)entry.getValue();
                Set states = pairToSubstates.getValueSet(pair);
                DeterministicState newState = this.createDeterministicState(states, finalState);
                target.linkToState.put((Link)links.iterator().next(), newState);
            }
        }

        private Set getEpsilonClosure(Set states) {
            LinkedHashSet result = new LinkedHashSet();
            this.getEpsilonClosure(result, states);
            return result;
        }

        private void getEpsilonClosure(Set result, Set states) {
            Iterator it1 = states.iterator();
            while (it1.hasNext()) {
                NondeterministicState state = (NondeterministicState)it1.next();
                if (!result.add(state)) continue;
                this.getEpsilonClosure(result, state.epsilonMoveStates);
            }
        }
    }

    private static class DeterministicState {
        public Original.Token tag;
        public boolean isFinal = false;
        public Map linkToState = new LinkedHashMap();
        private static int numberOfInstance = 0;
        public final int idNumber = numberOfInstance++;

        private DeterministicState() {
        }

        public String toString() {
            return "State" + this.idNumber;
        }
    }

    private static class NondeterministicState {
        public Original.Token tag;
        public MultiMap linkToStates = new MultiMap();
        public Set epsilonMoveStates = new LinkedHashSet();

        private NondeterministicState() {
        }

        public void link(Link link, NondeterministicState state) {
            this.linkToStates.add(link, state);
        }

        public void epsilonLink(NondeterministicState state) {
            this.epsilonMoveStates.add(state);
        }
    }

    private static class Link {
        public Set labels;
        public Symbol symbol;
        public Original.Token hint;

        public Link(Set labels, Symbol symbol, Original.Token hint) {
            this.labels = labels;
            this.symbol = symbol;
            this.hint = hint;
        }

        public int hashCode() {
            return this.labels.hashCode() ^ this.symbol.hashCode() ^ this.hint.hashCode();
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            if (rhs instanceof Link) {
                this.equals((Link)rhs);
            }
            return false;
        }

        public boolean equals(Link rhs) {
            return this.labels.equals(rhs.labels) && this.symbol.equals(rhs.symbol) && this.hint.equals(rhs.hint);
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.labels.iterator();
            while (it.hasNext()) {
                String label = (String)it.next();
                result.append(label);
                result.append(':');
            }
            result.append(this.symbol);
            return result.toString();
        }
    }
}

