/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.notavacc.lrg;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.gr.java_conf.koto.notavacc.lrg.AliasNonterminal;
import jp.gr.java_conf.koto.notavacc.lrg.AnonymousNonterminal;
import jp.gr.java_conf.koto.notavacc.lrg.Nonterminal;
import jp.gr.java_conf.koto.notavacc.lrg.Symbol;
import jp.gr.java_conf.koto.notavacc.lrg.TypeNonterminal;
import jp.gr.java_conf.koto.notavacc.parser.Original;

public abstract class LRTable {
    private Set states = null;
    private Set symbols = null;
    private Set typeNonterminals = null;
    private Set aliasNonterminals = null;
    private Set anonymousNonterminals = null;
    private Set reductions = null;

    public abstract Map symbolToInitialState();

    public abstract LRState finalState();

    public final Set states() {
        if (this.states == null) {
            this.states = new LinkedHashSet();
            this.getStates(this.states, this.symbolToInitialState().values());
        }
        return this.states;
    }

    private void getStates(Set result, Collection states) {
        Iterator it0 = states.iterator();
        while (it0.hasNext()) {
            LRState state = (LRState)it0.next();
            if (!result.add(state)) continue;
            this.getStates(result, state.symbolToNextState().values());
        }
    }

    private Set symbols() {
        if (this.symbols == null) {
            this.symbols = new LinkedHashSet();
            Iterator it1 = this.states().iterator();
            while (it1.hasNext()) {
                LRState state = (LRState)it1.next();
                this.symbols.addAll(state.symbolToNextState().keySet());
                this.symbols.addAll(state.symbolToReductions().keySet());
            }
        }
        return this.symbols;
    }

    public final Set getTypeNonterminals() {
        if (this.typeNonterminals == null) {
            this.typeNonterminals = new LinkedHashSet();
            Iterator it2 = this.symbols().iterator();
            while (it2.hasNext()) {
                Symbol symbol = (Symbol)it2.next();
                if (!(symbol instanceof TypeNonterminal)) continue;
                this.typeNonterminals.add(symbol);
            }
        }
        return this.typeNonterminals;
    }

    public final Set getAliasNonterminals() {
        if (this.aliasNonterminals == null) {
            this.aliasNonterminals = new LinkedHashSet();
            Iterator it2 = this.symbols().iterator();
            while (it2.hasNext()) {
                Symbol symbol = (Symbol)it2.next();
                if (!(symbol instanceof AliasNonterminal)) continue;
                this.aliasNonterminals.add(symbol);
            }
        }
        return this.aliasNonterminals;
    }

    public final Set getAnonymousNonterminals() {
        if (this.anonymousNonterminals == null) {
            this.anonymousNonterminals = new LinkedHashSet();
            Iterator it2 = this.symbols().iterator();
            while (it2.hasNext()) {
                Symbol symbol = (Symbol)it2.next();
                if (!(symbol instanceof AnonymousNonterminal)) continue;
                this.anonymousNonterminals.add(symbol);
            }
        }
        return this.anonymousNonterminals;
    }

    public final Set getReductions() {
        if (this.reductions == null) {
            this.reductions = new LinkedHashSet();
            Iterator it1 = this.states().iterator();
            while (it1.hasNext()) {
                LRState state = (LRState)it1.next();
                Iterator it3 = state.symbolToReductions().values().iterator();
                while (it3.hasNext()) {
                    Set set = (Set)it3.next();
                    this.reductions.addAll(set);
                }
            }
        }
        return this.reductions;
    }

    public static interface Reduction {
        public Nonterminal reducedSymbol();

        public List labelSetList();
    }

    public static interface LRState {
        public Map symbolToNextState();

        public Map symbolToReductions();

        public Original.Token tag();
    }
}

