/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.notavacc.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jp.gr.java_conf.koto.io.SafePrintWriter;
import jp.gr.java_conf.koto.notavacc.Environment;
import jp.gr.java_conf.koto.notavacc.dfa.DFAInput;
import jp.gr.java_conf.koto.notavacc.dfa.DeterministicFiniteAutomaton;
import jp.gr.java_conf.koto.notavacc.generator.CodeGenerator;
import jp.gr.java_conf.koto.notavacc.lrg.AliasNonterminal;
import jp.gr.java_conf.koto.notavacc.lrg.AnonymousNonterminal;
import jp.gr.java_conf.koto.notavacc.lrg.EOFTerminal;
import jp.gr.java_conf.koto.notavacc.lrg.LRTable;
import jp.gr.java_conf.koto.notavacc.lrg.NamedTerminal;
import jp.gr.java_conf.koto.notavacc.lrg.StringTerminal;
import jp.gr.java_conf.koto.notavacc.lrg.Symbol;
import jp.gr.java_conf.koto.notavacc.lrg.Terminal;
import jp.gr.java_conf.koto.notavacc.lrg.TypeNonterminal;
import jp.gr.java_conf.koto.notavacc.parser.Parser;
import jp.gr.java_conf.koto.notavacc.types.ArrayType;
import jp.gr.java_conf.koto.notavacc.types.Field;
import jp.gr.java_conf.koto.notavacc.types.NodeType;
import jp.gr.java_conf.koto.notavacc.types.ObjectType;
import jp.gr.java_conf.koto.notavacc.types.TokenType;
import jp.gr.java_conf.koto.notavacc.types.Type;
import jp.gr.java_conf.koto.notavacc.types.TypeSystem;
import jp.gr.java_conf.koto.notavacc.types.UserDefinedType;
import jp.gr.java_conf.koto.notavacc.util.MultiMap;

public class JavaCodeGenerator
extends CodeGenerator {
    private Parser.Root root;
    private DeterministicFiniteAutomaton dfa;
    private LRTable lrTable;
    private double targetVersion;
    private Map replacements = new HashMap();
    private List storePrinted = new LinkedList();
    private SafePrintWriter writer;
    private int indent = 0;
    private int temporalIndent = -1;
    private Map typeToName = new HashMap();
    private static final Object RESERVED_NAME;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$jp$gr$java_conf$koto$notavacc$generator$JavaCodeGenerator;

    public JavaCodeGenerator(Environment env, Parser.Root root, DeterministicFiniteAutomaton dfa, LRTable lrTable, TypeSystem typeSystem, double targetVersion) {
        super(env, root, dfa, lrTable, typeSystem);
        this.root = root;
        this.dfa = dfa;
        this.lrTable = lrTable;
        this.targetVersion = targetVersion;
    }

    private static String encodeForHTML(String image) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < image.length()) {
            char ch = image.charAt(i);
            result.append("&#" + ch + ";");
            ++i;
        }
        return result.toString();
    }

    private static String toHexCode(char ch) {
        String hex = "000" + Integer.toString(ch, 16).toUpperCase(Locale.ENGLISH);
        hex = hex.substring(hex.length() - 4);
        return hex;
    }

    private static String quoted(char ch) {
        StringBuffer quoted = new StringBuffer("'");
        JavaCodeGenerator.quoted(quoted, ch);
        quoted.append("'");
        return quoted.toString();
    }

    private static String quoted(String str) {
        return JavaCodeGenerator.quoted(str, true);
    }

    private static String quoted(String str, boolean quote) {
        StringBuffer quoted = new StringBuffer();
        if (quote) {
            quoted.append("\"");
        }
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            JavaCodeGenerator.quoted(quoted, ch);
            ++i;
        }
        if (quote) {
            quoted.append("\"");
        }
        return quoted.toString();
    }

    private static void quoted(StringBuffer result, char ch) {
        switch (ch) {
            default: {
                if (' ' <= ch && ch <= '~') {
                    result.append(ch);
                    break;
                }
                result.append("\\u").append(JavaCodeGenerator.toHexCode(ch));
                break;
            }
            case '\n': {
                result.append("\\n");
                break;
            }
            case '\t': {
                result.append("\\t");
                break;
            }
            case '\b': {
                result.append("\\b");
                break;
            }
            case '\r': {
                result.append("\\r");
                break;
            }
            case '\f': {
                result.append("\\f");
                break;
            }
            case '\\': {
                result.append("\\\\");
                break;
            }
            case '\'': {
                result.append("\\'");
                break;
            }
            case '\"': {
                result.append("\\\"");
            }
        }
    }

    public void addReplacement(String word, String replacement) {
        this.replacements.put(word, replacement);
    }

    public String replace(String str) {
        StringBuffer result = new StringBuffer();
        int index = 0;
        int mode = -1;
        int i = 0;
        while (true) {
            int nextMode;
            char ch = i < str.length() ? str.charAt(i) : (char)'\u0000';
            boolean identifierPart = Character.isJavaIdentifierPart(ch);
            int n = nextMode = identifierPart ? 0 : 1;
            if (mode != -1 && (ch == '\u0000' || nextMode != mode)) {
                String newSequence;
                String sub = str.substring(index, i);
                if (mode == 0 && (newSequence = (String)this.replacements.get(sub)) != null) {
                    sub = newSequence;
                }
                result.append(sub);
                index = i;
            }
            mode = nextMode;
            if (i >= str.length()) break;
            ++i;
        }
        return result.toString();
    }

    public void println(String str) {
        this.storePrinted.add(str);
    }

    public void flush() throws IOException {
        Iterator it = this.storePrinted.iterator();
        while (it.hasNext()) {
            String str = (String)it.next();
            it.remove();
            str = this.replace(str);
            this.outputLine(str);
        }
    }

    private void outputLine(String str) throws IOException {
        if ((str = str.trim()).startsWith("}")) {
            --this.indent;
        }
        if (this.temporalIndent == -1) {
            this.temporalIndent = this.indent;
        }
        if (str.startsWith("case ") || str.startsWith("default:") || str.startsWith("default ")) {
            --this.temporalIndent;
        }
        int i = 0;
        while (i < this.temporalIndent) {
            this.writer.print("    ");
            ++i;
        }
        this.writer.println(str);
        this.temporalIndent = -1;
        if (str.endsWith("{")) {
            ++this.indent;
        } else if (str.startsWith("if ") || str.startsWith("while ") || str.startsWith("do ") || str.startsWith("for ") || str.startsWith("if(") || str.startsWith("while(") || str.startsWith("do(") || str.startsWith("for(") || str.equals("else") || str.startsWith("else ")) {
            this.temporalIndent = this.indent + 1;
        }
    }

    private String getBaseName(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(".");
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCode(File file, CodeGenerator.Tables tables, boolean dryRun) throws IOException {
        this.writer = !dryRun ? new SafePrintWriter(new FileOutputStream(file)) : new SafePrintWriter(new StringWriter());
        try {
            String name = this.getBaseName(this.environment.processingFile);
            this.generateCode(file, name, tables);
            this.flush();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.writer.close();
            throw throwable;
        }
        this.writer.close();
    }

    private String getTypeName(Type type) {
        String result = (String)this.typeToName.get(type);
        if (result == null) {
            if (type instanceof ArrayType) {
                if (this.targetVersion >= 1.5) {
                    ArrayType arrayType = (ArrayType)type;
                    result = "java.util.List<" + this.getTypeName(arrayType.getComponentType()) + ">";
                } else {
                    result = "java.util.List";
                }
            } else if (type instanceof NodeType) {
                result = "$Parser.$Node";
            } else if (type instanceof TokenType) {
                result = "$Parser.$Token";
            } else if (type instanceof ObjectType) {
                result = "java.lang.Object";
            } else {
                UserDefinedType userDefinedType = (UserDefinedType)type;
                result = "$Parser." + userDefinedType.getName();
            }
            this.typeToName.put(type, result);
        }
        return result;
    }

    private void reserve(String name, MultiMap namespace) {
        namespace.add(name, RESERVED_NAME);
        this.addReplacement("$" + name, name);
    }

    private void allocate(String name, MultiMap namespace) {
        String alocatedName = "__" + name + "__notavacc_reserved";
        namespace.add(alocatedName, RESERVED_NAME);
        this.addReplacement("$" + name, alocatedName);
    }

    private void generateCode(File file, String topLevelClassName, CodeGenerator.Tables tables) throws IOException {
        Object state;
        Type type;
        TypeNonterminal nonterminal;
        Symbol symbol;
        MultiMap topTypeNamespace = new MultiMap();
        MultiMap topFieldNamespace = new MultiMap();
        MultiMap topMethodNamespace = new MultiMap();
        MultiMap nodeFieldNamespace = new MultiMap();
        MultiMap nodeNoArgumentMethodNamespace = new MultiMap();
        MultiMap nodeMethodNamespace = new MultiMap();
        boolean visitorSupport = true;
        boolean replacementSupport = true;
        String packageName = this.root.getPackageName();
        this.addReplacement("$packageName", packageName);
        this.addReplacement("$Parser", topLevelClassName);
        topTypeNamespace.add(topLevelClassName, topLevelClassName);
        topTypeNamespace.add("java", RESERVED_NAME);
        topFieldNamespace.add("java", RESERVED_NAME);
        topMethodNamespace.add("java", RESERVED_NAME);
        nodeFieldNamespace.add("java", RESERVED_NAME);
        nodeNoArgumentMethodNamespace.add("java", RESERVED_NAME);
        nodeMethodNamespace.add("java", RESERVED_NAME);
        if (this.targetVersion >= 1.4) {
            this.addReplacement("$CharSequence", "java.lang.CharSequence");
            this.addReplacement("$AssertionError", "java.lang.AssertionError");
            this.addReplacement("$subSequence", "subSequence");
            this.addReplacement("$final_avoid_jdk12_bug", "final");
            this.addReplacement("$protected_avoid_jdk12_bug", "protected");
            this.addReplacement("$assert", "assert");
        } else {
            this.addReplacement("$CharSequence", "java.lang.StringBuffer");
            this.addReplacement("$AssertionError", "java.lang.RuntimeException");
            this.addReplacement("$subSequence", "substring");
            this.addReplacement("$final_avoid_jdk12_bug", " ");
            this.addReplacement("$protected_avoid_jdk12_bug", "public");
            this.addReplacement("$assert", "// ");
        }
        int labelWordCount = tables.labelWordCount();
        if (packageName != null) {
            this.println("package $packageName;");
        }
        this.println("");
        this.println("/**");
        this.println("* A syntax representation, generated by notavaCC 0.71.  Licensed under GPL.");
        this.println("* <p>");
        ArrayList<UserDefinedType> parsableTypes = new ArrayList<UserDefinedType>(tables.userDefinedTypes().size());
        Iterator it1 = tables.userDefinedTypes().iterator();
        while (it1.hasNext()) {
            UserDefinedType type2 = (UserDefinedType)it1.next();
            LRTable.LRState initialState = (LRTable.LRState)this.lrTable.symbolToInitialState().get(type2.getTypeNonterminal());
            if (initialState == null) continue;
            parsableTypes.add(type2);
        }
        int i = 0;
        while (i < parsableTypes.size()) {
            UserDefinedType type3 = (UserDefinedType)parsableTypes.get(i);
            if (i == parsableTypes.size() - 1) {
                this.println("* {@link $Parser#parse" + type3.getName() + "}");
            } else if (i == parsableTypes.size() - 2) {
                this.println("* {@link $Parser#parse" + type3.getName() + "} and");
            } else {
                this.println("* {@link $Parser#parse" + type3.getName() + "},");
            }
            ++i;
        }
        if (parsableTypes.size() == 1) {
            this.println("* parses a text and generates an abstruct syntax tree.");
        } else if (parsableTypes.size() > 1) {
            this.println("* parse a text and generates an abstruct syntax tree.");
        }
        this.println("* Nodes of the tree is sub-types of {@link $Node}.");
        this.println("* <p>");
        this.println("* The class and any nested classes in the class are <strong>not synchronized</strong>.");
        this.println("*");
        this.println("*/");
        this.println("public class $Parser {");
        if (this.root.hasProtectedConstructor()) {
            this.println("/**");
            this.println("* Constructs a parser.");
            this.println("*/");
            this.println("$Parser() {");
            this.println("}");
        }
        LinkedHashMap<Symbol, String> symbolToWord = new LinkedHashMap<Symbol, String>();
        NamedTerminal traditionalWhiteTerminal = new NamedTerminal("$WHITE_TOKEN");
        Symbol[] symbols = tables.symbols();
        int i2 = 0;
        while (i2 < symbols.length) {
            String word;
            symbol = symbols[i2];
            int index = tables.getIndexOfSymbol(symbol);
            if (symbol instanceof EOFTerminal) {
                word = "EOF_TOKEN";
                symbolToWord.put(symbol, word);
                this.println("/** Describes the EOF. */");
                this.println("public static final int " + word + " = " + index + ";");
                topFieldNamespace.add(word, symbol);
            } else if (symbol.equals(traditionalWhiteTerminal)) {
                word = "WHITE_TOKEN";
                symbolToWord.put(symbol, word);
                this.println("/** Describes the white tokens, which are typically comments or white spaces. */");
                this.println("public static final int " + word + " = " + index + ";");
                topFieldNamespace.add(word, symbol);
            } else if (symbol instanceof NamedTerminal) {
                NamedTerminal terminal = (NamedTerminal)symbol;
                String word2 = "TOKEN_" + terminal.getName();
                symbolToWord.put(symbol, word2);
                this.println("/** Describes the terminal " + symbol + ". */");
                this.println("public static final int " + word2 + " = " + index + ";");
                topFieldNamespace.add(word2, symbol);
            } else if (symbol instanceof TypeNonterminal) {
                TypeNonterminal nonterminal2 = (TypeNonterminal)symbol;
                symbolToWord.put(symbol, nonterminal2.getName() + ".$ID");
            } else {
                if (!($assertionsDisabled || symbol instanceof StringTerminal || symbol instanceof AliasNonterminal || symbol instanceof AnonymousNonterminal)) {
                    throw new AssertionError();
                }
                symbolToWord.put(symbol, Integer.toString(tables.getIndexOfSymbol(symbol)));
            }
            ++i2;
        }
        this.println("");
        LinkedHashMap<String, String> tagToWord = new LinkedHashMap<String, String>();
        String[] tags = tables.tags();
        i2 = 0;
        while (i2 < tags.length) {
            String tag = tags[i2];
            String word = "TAG_" + tag;
            tagToWord.put(tag, word);
            this.println("public static final int " + word + " = " + i2 + ";");
            topFieldNamespace.add(word, tag);
            ++i2;
        }
        this.println("");
        this.println("/**");
        this.println("* Creates a node.  This is a <a href='http://www.google.com/search&#63;q=factory+method'>factory method</a>.");
        this.println("* <p>");
        this.println("* The type of the node to create is described by <code>symbolID</code> as follows.");
        this.println("* <table border=1>");
        this.println("* <tr><th><code>symbolID</code></th><th>type to create</th></tr>");
        Iterator it0 = tables.userDefinedTypes().iterator();
        while (it0.hasNext()) {
            UserDefinedType type4 = (UserDefinedType)it0.next();
            nonterminal = type4.getTypeNonterminal();
            if (nonterminal == null) continue;
            this.println("* <tr>");
            this.println("*   <td><code>" + symbolToWord.get(nonterminal) + "</code></td>");
            this.println("*   <td>{@link " + this.getTypeName(type4) + "}</td>");
            this.println("* </tr>");
        }
        this.println("* </table>");
        this.println("* <p>");
        this.println("* The implementation by the <code>$Parser</code> is equivalent to <code>$createNode(symbolID, parameters, false)</code>.");
        this.println("*");
        this.println("* @param   symbolID");
        this.println("*            the kind of the node to create.");
        this.println("* @param   parameters");
        this.println("*            the parameters to initialize the node.");
        this.println("* @return  a created node.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.reserve("createNode", topMethodNamespace);
        this.println("protected $Node $createNode(int symbolID, $NodeInitializationParameters parameters) throws $ParseException {");
        this.println("return $createNode(symbolID, parameters, false);");
        this.println("}");
        this.println("");
        this.println("/**");
        this.println("* Creates a node.  The created node is a instance of a class in {@link $Parser.$Default}.");
        this.println("*");
        this.println("* @param   symbolID");
        this.println("*      the kind of the node to create.  See {@link #$createNode(int, $Parser.$NodeInitializationParameters)}.");
        this.println("* @param   parameters");
        this.println("*      the parameters to initialize the node.");
        this.println("* @param   compact");
        this.println("*      create a compact node, which have only labeled children.");
        this.println("* @return  a created node.");
        this.println("* @since    notavaCC 1.0");
        this.println("*/");
        this.reserve("createNode", topMethodNamespace);
        this.println("protected final $Parser.$Default.$Node $createNode(int symbolID, $NodeInitializationParameters parameters, boolean compact) {");
        this.println("switch(symbolID) {");
        it0 = tables.userDefinedTypes().iterator();
        while (it0.hasNext()) {
            UserDefinedType type5 = (UserDefinedType)it0.next();
            nonterminal = type5.getTypeNonterminal();
            if (nonterminal == null) continue;
            this.println("case " + symbolToWord.get(nonterminal) + ":");
            this.println("return new $Parser.$Default." + type5.getName() + "(parameters, compact);");
        }
        this.println("}");
        this.println("throw new $AssertionError(\"A node creation was failed.\");");
        this.println("}");
        this.println("");
        this.reserve("getCharSequence", topMethodNamespace);
        if (this.targetVersion >= 1.4) {
            this.println("protected final $CharSequence $getCharSequence(java.io.File file, java.lang.String charsetName) throws java.io.IOException, $ParseException {");
            this.println("java.io.FileInputStream fis = null;");
            this.println("java.io.InputStreamReader reader = null;");
            this.println("java.nio.channels.FileChannel fc = null;");
            this.println("try {");
            this.println("fis = new java.io.FileInputStream(file);");
            this.println("if (charsetName == null)");
            this.println("reader = new java.io.InputStreamReader(fis);");
            this.println("else");
            this.println("reader = new java.io.InputStreamReader(fis, charsetName);");
            this.println("java.nio.charset.Charset charset;");
            this.println("try {");
            this.println("charset = java.nio.charset.Charset.forName(reader.getEncoding());");
            this.println("} catch(java.nio.charset.UnsupportedCharsetException x) {");
            this.println("charset = null;");
            this.println("}");
            this.println("if (charset != null) {");
            this.println("java.nio.charset.CharsetDecoder decoder = charset.newDecoder();");
            this.println("fc = fis.getChannel();");
            this.println("int size = (int) fc.size();");
            this.println("java.nio.MappedByteBuffer bb = fc.map(java.nio.channels.FileChannel.MapMode.READ_ONLY, 0, size);");
            this.println("return decoder.decode(bb);");
            this.println("} else {");
            this.println("long length = file.length();");
            this.println("if (length <= 0)");
            this.println("length = 1;");
            this.println("else if (length > Integer.MAX_VALUE)");
            this.println("length = Integer.MAX_VALUE;");
            this.println("java.lang.StringBuffer result = new java.lang.StringBuffer((int) length);");
            this.println("char[] buffer = new char[1024];");
            this.println("for(;;) {");
            this.println("int size = reader.read(buffer);");
            this.println("if (size < 0)");
            this.println("break;");
            this.println("result.append(buffer, 0, size);");
            this.println("}");
            this.println("return result;");
            this.println("}");
            this.println("} finally {");
            this.println("if (fc != null)");
            this.println("fc.close();");
            this.println("if (reader != null)");
            this.println("reader.close();");
            this.println("else if (fis != null)");
            this.println("fis.close();");
            this.println("}");
            this.println("}");
        } else {
            this.println("protected final $CharSequence $getCharSequence(java.io.File file, java.lang.String charsetName) throws java.io.IOException, $ParseException {");
            this.println("java.io.FileInputStream fis = null;");
            this.println("java.io.InputStreamReader reader = null;");
            this.println("try {");
            this.println("fis = new java.io.FileInputStream(file);");
            this.println("if (charsetName == null)");
            this.println("reader = new java.io.InputStreamReader(fis);");
            this.println("else");
            this.println("reader = new java.io.InputStreamReader(fis, charsetName);");
            this.println("long length = file.length();");
            this.println("if (length <= 0)");
            this.println("length = 1;");
            this.println("else if (length > Integer.MAX_VALUE)");
            this.println("length = Integer.MAX_VALUE;");
            this.println("java.lang.StringBuffer result = new java.lang.StringBuffer((int) length);");
            this.println("char[] buffer = new char[1024];");
            this.println("for(;;) {");
            this.println("int size = reader.read(buffer);");
            this.println("if (size < 0)");
            this.println("break;");
            this.println("result.append(buffer, 0, size);");
            this.println("}");
            this.println("return result;");
            this.println("} finally {");
            this.println("if (reader != null)");
            this.println("reader.close();");
            this.println("else if (fis != null)");
            this.println("fis.close();");
            this.println("}");
            this.println("}");
        }
        this.reserve("getCharSequence", topMethodNamespace);
        this.println("protected final $CharSequence $getCharSequence(java.io.Reader reader) throws java.io.IOException, $ParseException {");
        this.println("java.lang.StringBuffer result = new java.lang.StringBuffer();");
        this.println("char[] buffer = new char[1024];");
        this.println("for(;;) {");
        this.println("int size = reader.read(buffer);");
        this.println("if (size < 0)");
        this.println("break;");
        this.println("result.append(buffer, 0, size);");
        this.println("}");
        this.println("return result;");
        this.println("}");
        this.println("");
        this.reserve("createLexicalAnalyzer", topMethodNamespace);
        this.println("protected $Parser.$LexicalAnalyzer $createLexicalAnalyzer(java.lang.String sourceName, $CharSequence text, int tabStop) throws $ParseException {");
        this.println("return new $Parser.$Default.$LexicalAnalyzer(sourceName, text, tabStop);");
        this.println("}");
        this.println("");
        this.println("/**");
        this.println("* Contains private fields that is used in order to create a node.");
        this.println("* <p>");
        this.println("*");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.reserve("NodeInitializationParameters", topTypeNamespace);
        this.println("$protected_avoid_jdk12_bug static class $NodeInitializationParameters {");
        this.println("private $NodeInitializationParameters() {");
        this.println("}");
        this.println("private $Node[] childNodes;");
        this.println("private java.util.List labelsIDList;");
        this.println("}");
        this.println("");
        this.println("");
        this.println("/**");
        this.println("* A visitor of <a href=\"http://www.google.com/search&#63;q=visitor+design+pattern\">the visitor design pattern</a>.");
        this.println("* <p>");
        this.println("* This class has no method to override because the visit methods are dispatched by reflection.");
        this.println("*");
        this.println("* @see     $Parser.$Node#accept($Parser.$Visitor)");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.reserve("Visitor", topTypeNamespace);
        this.println("public static class $Visitor {");
        this.println("/*");
        this.println("public void visit($Parser.$Node node) {");
        this.println("}");
        this.println("public void visit($Parser.$Token node) {");
        this.println("}");
        it0 = tables.userDefinedTypes().iterator();
        while (it0.hasNext()) {
            UserDefinedType type6 = (UserDefinedType)it0.next();
            this.println("public void visit(" + this.getTypeName(type6) + " node) {");
            this.println("}");
        }
        this.println("*/");
        this.println("");
        this.println("private $final_avoid_jdk12_bug java.util.Map typeToMethod;");
        this.println("public $Visitor() {");
        this.println("typeToMethod = new java.util.HashMap();");
        this.println("java.lang.Class clazz = this.getClass();");
        this.println("java.lang.reflect.Method[] methods = clazz.getMethods();");
        this.println("for (int i = 0; i < methods.length; i++) {");
        this.println("java.lang.reflect.Method method = methods[i];");
        this.println("if (!method.getDeclaringClass().equals($Parser.$Visitor.class)) {");
        this.println("if ((method.getModifiers() & java.lang.reflect.Modifier.PUBLIC) != 0) {");
        this.println("if (method.getName().equals(\"visit\") && method.getExceptionTypes().length == 0) {");
        this.println("java.lang.Class[] parameterTypes = method.getParameterTypes();");
        this.println("if (parameterTypes.length == 1) {");
        this.println("java.lang.Class parameterType = parameterTypes[0];");
        this.println("if ($Parser.$Node.class.isAssignableFrom(parameterType)) {");
        this.println("method.setAccessible(true);");
        this.println("typeToMethod.put(parameterType, method);");
        this.println("}");
        this.println("}");
        this.println("}");
        this.println("}");
        this.println("}");
        this.println("}");
        this.println("");
        this.println("}");
        this.println("private final void visitAll($Parser.$Node node) {");
        this.println("java.lang.Object[] args = null;");
        this.println("java.util.Iterator it = typeToMethod.entrySet().iterator();");
        this.println("while (it.hasNext()) {");
        this.println("java.util.Map.Entry entry = (java.util.Map.Entry) it.next();");
        this.println("java.lang.Class parameterType = (java.lang.Class) entry.getKey();");
        this.println("if (parameterType.isInstance(node)) {");
        this.println("java.lang.reflect.Method method = (java.lang.reflect.Method) entry.getValue();");
        this.println("if (args == null)");
        this.println("args = new java.lang.Object[] { node };");
        this.println("try {");
        this.println("//System.out.println(node.getClass() + \" \" + method);");
        this.println("method.invoke(this, args);");
        this.println("} catch (java.lang.IllegalAccessException x) {");
        this.println("throw new $AssertionError(method + \" and the enclosing class(es) should be public or accessible from $Parser.$Visitor.\"");
        this.println("+ \"  Note that anonymous classes are not public.\");");
        this.println("} catch (java.lang.reflect.InvocationTargetException x) {");
        this.println("java.lang.Throwable targetException = x.getTargetException();");
        this.println("if (targetException instanceof Error) {");
        this.println("throw (java.lang.Error) targetException;");
        this.println("} else {");
        this.println("throw (java.lang.RuntimeException) targetException;");
        this.println("}");
        this.println("}");
        this.println("}");
        this.println("}");
        this.println("}");
        this.println("}");
        this.println("");
        this.println("/**");
        this.println("* A node of the abstract syntax tree that is the result of parsing.");
        this.println("* <p>");
        this.println("*");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.reserve("Node", topTypeNamespace);
        this.println("public static interface $Node {");
        this.println("/**");
        this.println("* Returns the list of the child nodes of <code>this</code>.");
        this.println("* <p>");
        this.println("* The list may or may not be modifiable (It is specified by the subclasses).");
        this.println("* The order of nodes is specified by the subclasses.");
        this.println("*");
        this.println("* @return  the list of the child nodes of <code>this</code>.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.reserve("getChildNodes", nodeNoArgumentMethodNamespace);
        this.println("public java.util.List $getChildNodes();");
        this.println("");
        this.println("/**");
        this.println("* Traverses the (sub-)tree whose root is <code>this</code> node.");
        this.println("* <p>");
        this.println("* <code>this</code> node is passed to the <code>visitor</code>,");
        this.println("* then the child nodes are traversed recursively (preorder traversal).");
        this.println("* A node is passed to the methods of the <code>visitor</code>, using reflection,");
        this.println("* that is public, whose name is <code>visit</code>,");
        this.println("* that have only one argument whose type is compatible with <code>this</code> node,");
        this.println("* and that have no throws clause.");
        this.println("*");
        this.println("* @param   visitor");
        this.println("*      a visitor.");
        this.println("* @since    notavacc 1.0");
        this.println("*/");
        this.reserve("accept", nodeMethodNamespace);
        this.println("public void $accept($Visitor visitor);");
        this.println("");
        this.println("/**");
        this.println("* Returns the parent node of <code>this</code>, or null if and only if <code>this</code> node is the root of the tree.");
        this.println("* <p>");
        this.println("* This method simply returns the value the method {@link $Parser.$Node#$setParentNode} set, so the above specification should be maintained by the user of <code>this</code> object.");
        this.println("*");
        this.println("* @return  the parent node of <code>this</code>, or null if <code>this</code> node is the root of the tree.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.reserve("getParentNode", nodeNoArgumentMethodNamespace);
        this.println("public $Node $getParentNode();");
        this.println("/**");
        this.println("* Sets the returned value of {@link #$getParentNode}.");
        this.println("* <p>");
        this.println("*");
        this.println("*");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.reserve("setParentNode", nodeMethodNamespace);
        this.println("public void $setParentNode($Node parentNode);");
        this.println("} // interface $Node");
        this.println("");
        this.println("/**");
        this.println("* A token, which is a part of a parsed text.");
        this.println("* <p>");
        this.println("* A token is a leaf of an abstract syntax tree.");
        this.println("*");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.reserve("Token", topTypeNamespace);
        this.println("public static interface $Token extends $Node {");
        this.println("/**");
        this.println("* Returns the kind of <code>this</code> token.");
        this.println("* <p>");
        this.println("* The result value should be one of the followings:</p>");
        this.println("* <table border=1>");
        this.println("* <tr><th>value</th><th>described token</th></tr>");
        symbols = tables.symbols();
        i = 0;
        while (i < tables.superiorIndexOfTerminals()) {
            symbol = symbols[i];
            this.println("* <tr>");
            this.println("*   <td><code>" + symbolToWord.get(symbol) + "</code></td>");
            this.println("*   <td><tt>" + JavaCodeGenerator.encodeForHTML(symbol.toString()) + "</tt></td>");
            this.println("* </tr>");
            ++i;
        }
        this.println("* </table>");
        this.println("*");
        this.println("* @return  the kind of <code>this</code> token.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public int getSymbolID();");
        this.println("");
        this.println("/**");
        this.println("* Returnds <code>true</code> if <code>this</code> is a white token. I.e., returns <code>true</code> if and only if <code>getSymbolID()</code> is one of the following:");
        this.println("* <ul>");
        symbols = tables.symbols();
        i = tables.firstIndexOfWhiteTerminals();
        while (i < tables.superiorIndexOfWhiteTerminals()) {
            symbol = symbols[i];
            this.println("*   <li><code>" + symbolToWord.get(symbol) + "</code></li>");
            ++i;
        }
        this.println("* </ul>");
        this.println("*");
        this.println("*/");
        this.println("public boolean isWhite();");
        this.println("");
        this.println("/**");
        this.println("* Returns the string <code>this</code> token corresponds to.");
        this.println("* If the string contains some meta notation like Unicode escapes, the returned value is the string represented by the notations.  If not, the returned value is the same as {@link #getOriginalImage()}.");
        this.println("*");
        this.println("* @return  the string <code>this</code> token corresponds to.");
        this.println("* @see     $Parser.$Token#getOriginalImage()");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public java.lang.String getImage();");
        this.println("");
        this.println("/**");
        this.println("* Returns the string <code>this</code> token corresponds to.");
        this.println("* If the string contains some meta notation like Unicode escapes, the returned value is the notation on the parsed text.  If not, the returned value is the same as {@link #getImage()}.");
        this.println("*");
        this.println("* @return  the string <code>this</code> token corresponds to.");
        this.println("* @see     $Parser.$Token#getImage()");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public java.lang.String getOriginalImage();");
        this.println("");
        this.println("/**");
        this.println("* Returns the source name <code>this</code> token coressponds to.");
        this.println("*");
        this.println("* @return  the source name <code>this</code> token coressponds to.  E.g. the canonical name of the file.");
        this.println("* @throws   java.lang.UnsupportedOperationException");
        this.println("*      if the method is not suported.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public java.lang.String getSourceName() throws java.lang.UnsupportedOperationException;");
        this.println("");
        this.println("/**");
        this.println("* Returns the zero-based index number in the source where <code>this</code> token begins.");
        this.println("*");
        this.println("* @return  the index number in the source where <code>this</code> token begins.");
        this.println("* @throws   java.lang.UnsupportedOperationException");
        this.println("*      if the method is not suported.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public int getIndex() throws java.lang.UnsupportedOperationException;");
        this.println("/**");
        this.println("* Returns the one-based line number in the source where <code>this</code> token begins.");
        this.println("*");
        this.println("* @return  the line number in the source where <code>this</code> token begins.");
        this.println("* @throws   java.lang.UnsupportedOperationException");
        this.println("*      if the method is not suported.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public int getLine() throws java.lang.UnsupportedOperationException;");
        this.println("/**");
        this.println("* Returns the one-based column number in the source where <code>this</code> token begins.");
        this.println("*");
        this.println("* @return  the column number in the source where <code>this</code> token begins.");
        this.println("* @throws   java.lang.UnsupportedOperationException");
        this.println("*      if the method is not suported.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public int getColumn() throws java.lang.UnsupportedOperationException;");
        this.println("");
        this.println("/**");
        this.println("* Returns the {@linkplain #getOriginalImage image} and the parenthesized position of <code>this</code> token if supported.");
        this.println("* E.g. <code>\"'identifier' (line 2, column 3)\"</code> or <code>\"'identifier'\"</code>.");
        this.println("*");
        this.println("* @return  the {@linkplain #getOriginalImage image} and the parenthesized position of <code>this</code> token.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public java.lang.String toString();");
        this.println("} // interface $Token");
        this.println("");
        this.println("");
        int publicParsableTypeCount = 0;
        this.reserve("ID", nodeFieldNamespace);
        Iterator it12 = tables.userDefinedTypes().iterator();
        while (it12.hasNext()) {
            UserDefinedType type7 = (UserDefinedType)it12.next();
            String scope = type7.isProtected() ? "protected" : (type7.isPrivate() ? "private" : "public");
            String methodScope = type7.isProtectedParsable() ? "protected" : "public";
            LRTable.LRState initialState = (LRTable.LRState)this.lrTable.symbolToInitialState().get(type7.getTypeNonterminal());
            if (initialState != null) {
                if (methodScope.equals("public")) {
                    ++publicParsableTypeCount;
                }
                this.println("/**");
                this.println("* parses a <code>" + type7.getName() + "</code>.");
                this.println("*/");
                topMethodNamespace.add("parse" + type7.getName(), type7);
                this.println("" + methodScope + " " + this.getTypeName(type7) + " parse" + type7.getName() + "(java.io.File file) throws java.io.IOException, $ParseException {");
                this.println("return parse" + type7.getName() + "(file.getName(), file, null, 8);");
                this.println("}");
                this.println("/**");
                this.println("* parses a <code>" + type7.getName() + "</code>.");
                this.println("*/");
                this.println("" + methodScope + " " + this.getTypeName(type7) + " parse" + type7.getName() + "(java.lang.String sourceName, java.io.File file, java.lang.String charsetName, int tabStop) throws java.io.IOException, $ParseException {");
                this.println("return parse" + type7.getName() + "(sourceName, $getCharSequence(file, charsetName), tabStop);");
                this.println("}");
                this.println("/**");
                this.println("* parses a <code>" + type7.getName() + "</code>.  <code>reader</code> will not be closed.");
                this.println("*/");
                this.println("" + methodScope + " " + this.getTypeName(type7) + " parse" + type7.getName() + "(java.lang.String sourceName, java.io.Reader reader, int tabStop) throws java.io.IOException, $ParseException {");
                this.println("return parse" + type7.getName() + "(sourceName, $getCharSequence(reader), tabStop);");
                this.println("}");
                this.println("/**");
                this.println("* parses a <code>" + type7.getName() + "</code>.");
                this.println("*/");
                this.println("" + methodScope + " " + this.getTypeName(type7) + " parse" + type7.getName() + "(java.lang.String sourceName, $CharSequence seq, int tabStop) throws $ParseException {");
                this.println("$Parser.$LexicalAnalyzer analyzer = $createLexicalAnalyzer(sourceName, seq, tabStop);");
                this.println("return parse" + type7.getName() + "(analyzer);");
                this.println("}");
                this.println("/**");
                this.println("* parses a <code>" + type7.getName() + "</code>.");
                this.println("*/");
                this.println("" + methodScope + " " + this.getTypeName(type7) + " parse" + type7.getName() + "($Parser.$LexicalAnalyzer analyzer) throws $ParseException {");
                this.println("int initialState = " + tables.getIndexOfState(initialState) + ";");
                this.println("int classSymbolMaximum = " + (tables.superiorIndexOfClassNonterminals() - 1) + ";");
                this.println("return (" + this.getTypeName(type7) + ") $parse($Parser.$lrTable, $Parser.$reductionTable, $Parser.$tagTable, initialState, classSymbolMaximum, analyzer);");
                this.println("}");
            }
            StringBuffer extendedTypes = new StringBuffer();
            boolean first = true;
            Iterator inner = type7.getDirectSuperTypes().iterator();
            while (inner.hasNext()) {
                Type superType = (Type)inner.next();
                if (first) {
                    first = false;
                } else {
                    extendedTypes.append(", ");
                }
                extendedTypes.append(this.getTypeName(superType));
            }
            this.println("/**");
            this.println("* An abstract-syntax-tree node <code>" + type7.getName() + "</code>.");
            this.println("*/");
            topTypeNamespace.add(type7.getName(), type7);
            this.println("" + scope + " static interface " + type7.getName() + " extends " + extendedTypes + " {");
            TypeNonterminal nonterminal3 = type7.getTypeNonterminal();
            if (nonterminal3 != null) {
                this.println("/** The ID value of the type. */");
                this.println("public static final int $ID = " + tables.getIndexOfSymbol(nonterminal3) + ";");
            }
            Iterator it2 = type7.getDeclaredFields().iterator();
            while (it2.hasNext()) {
                Field field = (Field)it2.next();
                String typeName = this.getTypeName(field.getType());
                String name = field.getName();
                if (field.getType() instanceof ArrayType) {
                    ArrayType at = (ArrayType)field.getType();
                    this.println("/**");
                    this.println("* Returns the child nodes labeled by <code>" + name + "</code> in the notavaCC source.");
                    this.println("* If there is not such a one, the resut <code>isEmpty</code>.");
                    this.println("* The element of the result list is {@link " + this.getTypeName(at.getComponentType()) + "}.");
                    this.println("*/");
                } else {
                    this.println("/**");
                    this.println("* Returns the child node labeled by <code>" + name + "</code> in the notavaCC source.");
                    this.println("* If there is not such a one, the resut is <code>null</code>.");
                    this.println("*/");
                }
                nodeNoArgumentMethodNamespace.add(name, name);
                this.println("public " + typeName + " " + name + "();");
            }
            this.println("}");
        }
        this.println("");
        this.println("");
        this.println("/**");
        this.println("* Describes a error of a parsing.");
        this.println("* <p>");
        this.println("*");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.reserve("ParseException", topTypeNamespace);
        this.println("public static class $ParseException extends java.lang.Exception {");
        this.println("private final java.lang.String sourceName;");
        this.println("private final int index;");
        this.println("private final int line;");
        this.println("private final int column;");
        this.println("");
        this.println("/**");
        this.println("* Constructs an exception.");
        this.println("*");
        this.println("* @param   sourceName");
        this.println("*            the source name where the exception occured, or null if not supported.");
        this.println("* @param   index");
        this.println("*            the index number where the exception occured, or -1 if not supported.");
        this.println("* @param   line");
        this.println("*            the line number where the exception occured, or -1 if not supported.");
        this.println("* @param   column");
        this.println("*            the column number where the exception occured, or -1 if not supported.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public $ParseException(java.lang.String msg, java.lang.String sourceName, int index, int line, int column) {");
        this.println("super(msg);");
        this.println("this.sourceName = sourceName;");
        this.println("this.index = index;");
        this.println("this.line = line;");
        this.println("this.column = column;");
        this.println("}");
        this.println("public $ParseException(java.lang.String msg, $Parser.$Token position) {");
        this.println("super(msg);");
        this.println("");
        this.println("java.lang.String sourceName = null;");
        this.println("int index = -1;");
        this.println("int line = -1;");
        this.println("int column = -1;");
        this.println("");
        this.println("try {");
        this.println("sourceName = position.getSourceName();");
        this.println("} catch (java.lang.UnsupportedOperationException x) {");
        this.println("}");
        this.println("try {");
        this.println("index = position.getIndex();");
        this.println("} catch (java.lang.UnsupportedOperationException x) {");
        this.println("}");
        this.println("try {");
        this.println("line = position.getLine();");
        this.println("} catch (java.lang.UnsupportedOperationException x) {");
        this.println("}");
        this.println("try {");
        this.println("column = position.getColumn();");
        this.println("} catch (java.lang.UnsupportedOperationException x) {");
        this.println("}");
        this.println("");
        this.println("this.sourceName = sourceName;");
        this.println("this.index = index;");
        this.println("this.line = line;");
        this.println("this.column = column;");
        this.println("}");
        this.println("");
        this.println("/**");
        this.println("* Returns the source name where the exception occured.");
        this.println("*");
        this.println("* @return  the source name where the exception occured.");
        this.println("* @throws   java.lang.UnsupportedOperationException");
        this.println("*      if the method is not suported.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public final java.lang.String getSourceName() throws java.lang.UnsupportedOperationException {");
        this.println("if (sourceName == null)");
        this.println("throw new java.lang.UnsupportedOperationException();");
        this.println("return sourceName;");
        this.println("}");
        this.println("");
        this.println("/**");
        this.println("* Returns the index number where the exception occured.");
        this.println("*");
        this.println("* @return  the index number where the exception occured.");
        this.println("* @throws   java.lang.UnsupportedOperationException");
        this.println("*      if the method is not suported.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public final int getIndex() throws java.lang.UnsupportedOperationException {");
        this.println("if (index == -1)");
        this.println("throw new java.lang.UnsupportedOperationException();");
        this.println("return index;");
        this.println("}");
        this.println("");
        this.println("/**");
        this.println("* Returns the line number where the exception occured.");
        this.println("*");
        this.println("* @return  the line number where the exception occured.");
        this.println("* @throws   java.lang.UnsupportedOperationException");
        this.println("*      if the method is not suported.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public final int getLine() throws java.lang.UnsupportedOperationException {");
        this.println("if (line == -1)");
        this.println("throw new java.lang.UnsupportedOperationException();");
        this.println("return line;");
        this.println("}");
        this.println("");
        this.println("/**");
        this.println("* Returns the column number where the exception occured.");
        this.println("*");
        this.println("* @return  the column number where the exception occured.");
        this.println("* @throws   java.lang.UnsupportedOperationException");
        this.println("*      if the method is not suported.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public final int getColumn() throws java.lang.UnsupportedOperationException {");
        this.println("if (column == -1)");
        this.println("throw new java.lang.UnsupportedOperationException();");
        this.println("return column;");
        this.println("}");
        this.println("");
        this.println("/**");
        this.println("* Returns the GNU-Compiler-Collection-style string that describes the position of the error.");
        this.println("* <p>");
        this.println("* Throws an UnsupportedOperationException if getSourceName() is not supported.");
        this.println("* Otherwise, returns <code>getSourceName()</code> if getLine() is not supported.");
        this.println("* Otherwise, returns <code>getSourceName() + \":\" + getLine()</code>.");
        this.println("*");
        this.println("* @return");
        this.println("*      the GCC-style string describing the position of the error.");
        this.println("* @throws   UnsupportedOperationException");
        this.println("*      getSourceName() was not suppoted.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public final String getGCCStylePositionString() throws java.lang.UnsupportedOperationException {");
        this.println("if (line == -1) {");
        this.println("return getSourceName();");
        this.println("} else {");
        this.println("return getSourceName() + \":\" + line;");
        this.println("}");
        this.println("}");
        this.println("");
        this.println("/**");
        this.println("* Indicates the source of the notavaCC, which generates this Java program, have ambiguity.");
        this.println("*/");
        this.println("public static class AmbiguousGrammarError extends $AssertionError {");
        this.println("public AmbiguousGrammarError(String message) {");
        this.println("super(message);");
        this.println("}");
        this.println("}");
        this.println("} // class $ParseException");
        this.println("");
        this.println("");
        this.println("/**");
        this.println("* Generates a sequence of {@linkplain $Parser.$Token tokens}.");
        this.println("*");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.reserve("LexicalAnalyzer", topTypeNamespace);
        this.println("public static abstract class $LexicalAnalyzer {");
        this.println("/**");
        this.println("* Returns the next token in the sequence.");
        this.println("* If there is no tokens, the {@linkplain $Parser.$Token#getSymbolID() symbol ID} of the returned value should be {@link $Parser#EOF_TOKEN}, but the {@linkplain $Parser.$Token#getImage() image} or the {@linkplain $Parser.$Token#getIndex() index} etc. are not specified (may be {@linkplain java.lang.UnsupportedOperationException unsupported}).");
        this.println("*");
        this.println("* @return  the next token in the sequence.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public abstract $Token next() throws $ParseException;");
        this.println("} // $LexicalAnalyzer");
        this.println("");
        this.println("");
        this.println("/**");
        this.println("* A namespace for the default implementations of the user-defined types.");
        this.println("*");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.reserve("Default", topTypeNamespace);
        this.println("public static interface $Default {");
        this.println("/**");
        this.println("* Provides a simple implementation of {@link $Parser.$Node}.");
        this.println("*");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public static abstract class $Node implements $Parser.$Node {");
        this.println("private java.util.List childNodes;");
        this.println("/**");
        this.println("* Constucts an instance.");
        this.println("* <p>");
        this.println("* The parent node of <code>childNodes</code> is set to <code>this</code>.");
        this.println("*");
        this.println("* @param   childNodes");
        this.println("*            a list of child nodes, which is not copied and returned by {@link #$getChildNodes()}.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public $Node(java.util.List childNodes) {");
        this.println("this.childNodes = childNodes;");
        this.println("");
        this.println("java.util.Iterator it = childNodes.iterator();");
        this.println("while (it.hasNext()) {");
        this.println("$Parser.$Node node = ($Parser.$Node) it.next();");
        this.println("node.$setParentNode(this);");
        this.println("}");
        this.println("}");
        this.println("/**");
        this.println("* Returns the list given by the constructor.");
        this.println("*");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public java.util.List $getChildNodes() {");
        this.println("return this.childNodes;");
        this.println("}");
        this.println("");
        this.println("public final void $accept($Visitor visitor) {");
        this.println("visitor.visitAll(this);");
        this.println("java.util.Iterator it = $getChildNodes().iterator();");
        this.println("while (it.hasNext()) {");
        this.println("$Parser.$Node node = ($Parser.$Node) it.next();");
        this.println("node.$accept(visitor);");
        this.println("}");
        this.println("}");
        this.println("");
        this.println("private $Parser.$Node parentNode;");
        this.println("public $Parser.$Node $getParentNode() {");
        this.println("return parentNode;");
        this.println("}");
        this.println("public void $setParentNode($Parser.$Node parentNode) {");
        this.println("this.parentNode = parentNode;");
        this.println("}");
        this.println("");
        this.println("/**");
        this.println("* Replaces the child node <code>oldChild</code> with <code>newChild</code>.");
        this.println("* Correctly, the method replaces the sub-tree whose root is <code>oldChild</code>");
        this.println("* with the sub-tree whose root is <code>newChild</code>.");
        this.println("* <p>");
        this.println("* The method dose not replace only the element of {@link $Parser.$Node#$getChildNodes},");
        this.println("* but also the values returned by the methods that are");
        this.println("* defined by the classes in {@link $Parser}");
        this.println("* and that return the child node(s) labeled in the notavaCC source.");
        this.println("* <p>");
        this.println("* The method calls <code>newChild.$setParentNode(this)</code> and <code>oldChild.$setParentNode(null)</code>.");
        this.println("*");
        this.println("* @param   oldChild");
        this.println("*            a replaced child node.");
        this.println("* @param   newChild");
        this.println("*            a child node to replace <code>oldChild</code>.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.reserve("replaceChild", nodeMethodNamespace);
        this.println("protected void $replaceChild($Parser.$Node oldChild, $Parser.$Node newChild) {");
        this.println("if (oldChild != null)");
        this.println("oldChild.$setParentNode(null);");
        this.println("$replaceAll($getChildNodes(), oldChild, newChild);");
        this.println("if (newChild != null)");
        this.println("newChild.$setParentNode(this);");
        this.println("}");
        this.println("");
        this.println("/**");
        this.println("* Replaces the sub-tree whose root is <code>oldNode</code> with the sub-tree whose root is <code>this</code>.");
        this.println("* <p>");
        this.println("* The method calls <code>this.$setParentNode</code> and <code>oldNode.$setParentNode(null)</code>.");
        this.println("* <p>");
        this.println("* Precondition: <code>(oldNode.$getParentNode() instanceof $Default.$Node)</code> sould be <code>true</code>.");
        this.println("*");
        this.println("* @param   oldNode");
        this.println("*            a node to replace.");
        this.println("* @throws  java.lang.IllegalStateException");
        this.println("*            <code>parent == null || !(parent instanceof $Default.$Node)</code>");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.reserve("replace", nodeMethodNamespace);
        this.println("public void $replace($Parser.$Node oldNode) throws java.lang.IllegalStateException {");
        this.println("$Parser.$Node newNode = this;");
        this.println("");
        this.println("$Parser.$Node parent = oldNode.$getParentNode();");
        this.println("if (parent == null || !(parent instanceof $Default.$Node))");
        this.println("throw new java.lang.IllegalStateException(\"oldNode.$getParentNode() should be a $Default.$Node.\");");
        this.println("");
        this.println("$Default.$Node p = ($Default.$Node) parent;");
        this.println("p.$replaceChild(oldNode, newNode);");
        this.println("}");
        this.println("");
        this.println("public java.lang.String toString() {");
        this.println("java.io.StringWriter buffer = new java.io.StringWriter();");
        this.println("java.io.PrintWriter writer = new java.io.PrintWriter(buffer);");
        this.println("");
        this.println("$Parser.$Node node = this;");
        this.println("while (!(node instanceof $Parser.$Token)) {");
        this.println("if (node.getChildNodes().isEmpty()) {");
        this.println("node = null;");
        this.println("break;");
        this.println("}");
        this.println("node = ($Parser.$Node) node.getChildNodes().get(0);");
        this.println("}");
        this.println("if (node != null) {");
        this.println("$Parser.$Token token = ($Parser.$Token) node;");
        this.println("try {");
        this.println("writer.print(token.getSourceName() + \":\");");
        this.println("writer.print(token.getLine() + \":\");");
        this.println("writer.println(token.getOriginalImage());");
        this.println("} catch (UnsupportedOperationException x) {");
        this.println("}");
        this.println("}");
        this.println("");
        this.println("toString(this, 0, writer);");
        this.println("writer.close();");
        this.println("if (writer.checkError())");
        this.println("throw new RuntimeException();");
        this.println("return buffer.toString();");
        this.println("}");
        this.println("private static void toString($Parser.$Node node, int indent, java.io.PrintWriter writer) {");
        this.println("for (int i = 0; i < indent; i++)");
        this.println("writer.print(\"  \");");
        this.println("");
        this.println("if (node instanceof $Token) {");
        this.println("$Token token = ($Token) node;");
        this.println("writer.println(\"token: \" + token.getOriginalImage());");
        this.println("} else {");
        this.println("java.lang.String binaryName = node.getClass().getName();");
        this.println("binaryName = binaryName.substring(binaryName.lastIndexOf(\".\") + 1);");
        this.println("binaryName = binaryName.substring(binaryName.lastIndexOf(\"$\") + 1);");
        this.println("writer.println(binaryName);");
        this.println("indent++;");
        this.println("java.util.Iterator it = node.$getChildNodes().iterator();");
        this.println("while (it.hasNext()) {");
        this.println("$Parser.$Node n = ($Parser.$Node) it.next();");
        this.println("toString(n, indent, writer);");
        this.println("}");
        this.println("}");
        this.println("}");
        this.println("} // $Default.$Node");
        this.println("");
        this.println("/**");
        this.println("* Provides a simple implementation of {@link $Parser.$Token}.");
        this.println("*");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public static class $Token extends $Default.$Node implements $Parser.$Token {");
        this.println("private final int symbolID;");
        this.println("private final java.lang.String image;");
        this.println("private final java.lang.String originalImage;");
        this.println("private final java.lang.String sourceName;");
        this.println("private final int index;");
        this.println("private final int line;");
        this.println("private final int column;");
        this.println("public $Token(int symbolID, java.lang.String image) {");
        this.println("this(symbolID, image, image, null, -1, -1, -1);");
        this.println("}");
        this.println("");
        this.println("/**");
        this.println("* Constructs a token.");
        this.println("* <p>");
        this.println("*");
        this.println("* @param   symbolID");
        this.println("*      the symbol ID of the token, returned by <code>getSymbolID</code>.");
        this.println("* @param   image");
        this.println("*      the image string, returned by <code>getImage</code>.");
        this.println("* @param   originalImage");
        this.println("*      the image string, returned by <code>getOriginalImage</code>.");
        this.println("* @param   sourceName");
        this.println("*      the source name returned by <code>getSourceName</code>, or null if not supported.");
        this.println("* @param   index");
        this.println("*      the index returned by <code>getIndex</code>, or -1 if not supported.");
        this.println("* @param   line");
        this.println("*      the line number returned by <code>getLine</code>, or -1 if not supported.");
        this.println("* @param   column");
        this.println("*      the column number returned by <code>getColumn</code>, or -1 if not supported.");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("public $Token(int symbolID, java.lang.String image, java.lang.String originalImage, java.lang.String sourceName, int index, int line, int column) {");
        this.println("super(java.util.Collections.EMPTY_LIST);");
        this.println("this.symbolID = symbolID;");
        this.println("this.image = image;");
        this.println("this.originalImage = originalImage;");
        this.println("this.sourceName = sourceName;");
        this.println("this.index = index;");
        this.println("this.line = line;");
        this.println("this.column = column;");
        this.println("}");
        this.println("public $Token(int symbolID, java.lang.String image, java.lang.String originalImage, $Parser.$Token token) {");
        this.println("super(java.util.Collections.EMPTY_LIST);");
        this.println("String sourceName = null;");
        this.println("int index = -1;");
        this.println("int line = -1;");
        this.println("int column = -1;");
        this.println("try {");
        this.println("sourceName = token.getSourceName();");
        this.println("} catch (UnsupportedOperationException x) {");
        this.println("}");
        this.println("try {");
        this.println("index = token.getIndex();");
        this.println("} catch (UnsupportedOperationException x) {");
        this.println("}");
        this.println("try {");
        this.println("line = token.getLine();");
        this.println("} catch (UnsupportedOperationException x) {");
        this.println("}");
        this.println("try {");
        this.println("column = token.getColumn();");
        this.println("} catch (UnsupportedOperationException x) {");
        this.println("}");
        this.println("");
        this.println("this.symbolID = symbolID;");
        this.println("this.image = image;");
        this.println("this.originalImage = originalImage;");
        this.println("this.sourceName = sourceName;");
        this.println("this.index = index;");
        this.println("this.line = line;");
        this.println("this.column = column;");
        this.println("}");
        this.println("public int getSymbolID() {");
        this.println("return symbolID;");
        this.println("}");
        this.println("public boolean isWhite() {");
        this.println("return " + tables.firstIndexOfWhiteTerminals() + " <= symbolID && symbolID < " + tables.superiorIndexOfWhiteTerminals() + ";");
        this.println("}");
        this.println("public java.lang.String getImage() {");
        this.println("return image;");
        this.println("}");
        this.println("public java.lang.String getOriginalImage() {");
        this.println("return originalImage;");
        this.println("}");
        this.println("");
        this.println("");
        this.println("public java.lang.String getSourceName() throws java.lang.UnsupportedOperationException {");
        this.println("if (sourceName == null)");
        this.println("throw new java.lang.UnsupportedOperationException();");
        this.println("return sourceName;");
        this.println("}");
        this.println("public int getIndex() throws java.lang.UnsupportedOperationException {");
        this.println("if (index == -1)");
        this.println("throw new java.lang.UnsupportedOperationException();");
        this.println("return index;");
        this.println("}");
        this.println("public int getLine() throws java.lang.UnsupportedOperationException {");
        this.println("if (line == -1)");
        this.println("throw new java.lang.UnsupportedOperationException();");
        this.println("return line;");
        this.println("}");
        this.println("public int getColumn() throws java.lang.UnsupportedOperationException {");
        this.println("if (column == -1)");
        this.println("throw new java.lang.UnsupportedOperationException();");
        this.println("return column;");
        this.println("}");
        this.println("");
        this.println("public java.lang.String toString() {");
        this.println("java.lang.StringBuffer result = new java.lang.StringBuffer();");
        this.println("result.append(\"'\");");
        this.println("result.append(getOriginalImage());");
        this.println("result.append(\"'\");");
        this.println("");
        this.println("if (column != -1 || line != -1) {");
        this.println("result.append(\" (\");");
        this.println("if (line != -1) {");
        this.println("result.append(\"line \");");
        this.println("result.append(getLine());");
        this.println("if (column != -1)");
        this.println("result.append(\", \");");
        this.println("}");
        this.println("if (column != -1) {");
        this.println("result.append(\"column \");");
        this.println("result.append(getColumn());");
        this.println("}");
        this.println("result.append(\")\");");
        this.println("}");
        this.println("return result.toString();");
        this.println("}");
        this.println("} // class $Default.$Token");
        this.println("");
        this.println("public static class $LexicalAnalyzer extends $Parser.$LexicalAnalyzer {");
        this.println("/** The sourceName given to the constructor. */");
        this.println("protected final java.lang.String sourceName;");
        this.println("/** The text given to the constructor. */");
        this.println("protected final $CharSequence text;");
        this.println("/** The end index of the target {@link #text} region. */");
        this.println("protected final int end;");
        this.println("/** The tabStop given to the constructor. */");
        this.println("protected final int tabStop;");
        this.println("/** The table given to the constructor. */");
        this.println("private final int[][] table;");
        this.println("/** The initialState given to the constructor. */");
        this.println("private final int initialState;");
        this.println("/** The zero-based index the {@linkplain #next() next} token begins at. */");
        this.println("protected int index;");
        this.println("/** The zero-based line number the {@linkplain #next() next} token begins at. */");
        this.println("protected int line;");
        this.println("/** The zero-based column number the {@linkplain #next() next} token begins at. */");
        this.println("protected int column;");
        this.println("/**");
        this.println("* Constructs a lexical analyzer with a given table.");
        this.println("* <p>");
        this.println("*");
        this.println("* @param   sourceName");
        this.println("*      the name of the text.");
        this.println("* @param   text");
        this.println("*      the text to parse.");
        this.println("* @param   tabStop");
        this.println("*      the count of columns the tab character expands to.");
        this.println("* @since    notavaCC 1.0");
        this.println("*/");
        this.println("public $LexicalAnalyzer(java.lang.String sourceName, $CharSequence text, int tabStop) {");
        this.println("this(sourceName, text, tabStop, 0, text.length(), 0, 0);");
        this.println("}");
        this.println("public $LexicalAnalyzer(java.lang.String sourceName, $CharSequence text, int tabStop, int start, int end, int line, int column) {");
        this.println("this(sourceName, text, tabStop, start, end, line, column, $Parser.$dfaTable, " + tables.getIndexOfState(this.dfa.initialState()) + ");");
        this.println("}");
        this.println("private $LexicalAnalyzer(java.lang.String sourceName, $CharSequence text, int tabStop, int start, int end, int line, int column, int[][] table, int initialState) {");
        this.println("this.sourceName = sourceName;");
        this.println("this.text = text;");
        this.println("this.end = end;");
        this.println("this.tabStop = tabStop;");
        this.println("this.table = table;");
        this.println("this.initialState = initialState;");
        this.println("this.index = start;");
        this.println("this.line = line;");
        this.println("this.column = column;");
        this.println("}");
        this.println("public $Parser.$Token next() throws $ParseException {");
        this.println("if (index >= end)");
        this.println("return new $Parser.$Default.$Token(EOF_TOKEN, \"\", \"\", sourceName, index, -1, -1);");
        this.println("");
        this.println("int state = initialState;");
        this.println("");
        this.println("final int startIndex = index;");
        this.println("final int startLine = line;");
        this.println("final int startColumn = column;");
        this.println("int lastHitID = -1;");
        this.println("int lastHitIndex = -1;");
        this.println("int lastHitLine = -1;");
        this.println("int lastHitColumn = -1;");
        this.println("int lastHitImageLength = 0;");
        this.println("StringBuffer image = new StringBuffer();");
        this.println("");
        this.println("try {");
        this.println("dfa:");
        this.println("while (index < end) {");
        this.println("char ch = nextChar();");
        this.println("image.append(ch);");
        this.println("");
        this.println("int[] map = table[state];");
        this.println("int base = 1;");
        this.println("int width = (map.length - 1) / 3;");
        String dfaLinearSearchThreshold = this.environment.parameters.getProperty("JavaCodeGenerator.dfaLinearSearchThreshold", "3");
        this.println("while (width > " + dfaLinearSearchThreshold + ") {");
        this.println("int halfWidth = width >> 1;");
        this.println("int mid = base + halfWidth * 3;");
        this.println("if (ch >= map[mid]) {");
        this.println("base = mid;");
        this.println("width -= halfWidth;");
        this.println("} else {");
        this.println("width = halfWidth;");
        this.println("}");
        this.println("}");
        this.println("int i = 0;");
        this.println("for (;;) {");
        this.println("if (i++ >= width)");
        this.println("break dfa;");
        this.println("if (map[base] <= ch & ch <= map[base + 1]) {");
        this.println("state = map[base + 2];");
        this.println("break;");
        this.println("}");
        this.println("base += 3;");
        this.println("}");
        this.println("int hitID = table[state][0];");
        this.println("if (hitID != -1) {");
        this.println("lastHitID = hitID;");
        this.println("lastHitIndex = index;");
        this.println("lastHitLine = line;");
        this.println("lastHitColumn = column;");
        this.println("lastHitImageLength = image.length();");
        this.println("}");
        this.println("}");
        this.println("");
        this.println("if (lastHitID == -1) {");
        this.println("throw new $ParseException(\"An invalid character sequence starting with '\" + text.$subSequence(startIndex, index) + \"' (line \" + (startLine + 1) + \", column \" + (startColumn + 1) + \")\", sourceName, startIndex, startLine + 1, startColumn + 1);");
        this.println("}");
        this.println("} finally {");
        this.println("index = startIndex;");
        this.println("line = startLine;");
        this.println("column = startColumn;");
        this.println("}");
        this.println("");
        this.println("$Parser.$Token result = new $Parser.$Default.$Token(lastHitID, image.substring(0, lastHitImageLength).intern(), text.$subSequence(startIndex, lastHitIndex).toString().intern(), sourceName, startIndex, startLine + 1, startColumn + 1);");
        this.println("");
        this.println("index = lastHitIndex;");
        this.println("line = lastHitLine;");
        this.println("column = lastHitColumn;");
        this.println("");
        this.println("return result;");
        this.println("} // next()");
        this.println("/**");
        this.println("* Returns the next character in the sequence.");
        this.println("* <p>");
        this.println("* This method returns the character starting at {@link #index} in the sequence and updates {@link #index}, {@link #line}, and {@link #column} to point the next character of the returned character.  This method is overridden in order to deal with a string as a character through the input sequence like Unicode escapes of Java.");
        this.println("*");
        this.println("* @return  the next character in the sequence.");
        this.println("* @throws  java.lang.IndexOutOfBoundsException  if <code>index >= end</code>");
        this.println("* @since   notavaCC 1.0");
        this.println("*/");
        this.println("protected char nextChar() throws $ParseException, java.lang.IndexOutOfBoundsException {");
        this.println("return nextExactChar();");
        this.println("}");
        this.println("protected final char nextUnicodeEscapedChar() throws ParseException, java.lang.IndexOutOfBoundsException {");
        this.println("int startIndex = index;");
        this.println("int startLine = line;");
        this.println("int startColumn = column;");
        this.println("int index = startIndex;");
        this.println("if (text.charAt(index) == '\\\\' && index + 1 < end && text.charAt(index + 1) == 'u') {");
        this.println("int count = 0;");
        this.println("while (index >= 0 && text.charAt(index--) == '\\\\')");
        this.println("count++;");
        this.println("if (count % 2 == 0)");
        this.println("return nextExactChar();");
        this.println("} else {");
        this.println("return nextExactChar();");
        this.println("}");
        this.println("");
        this.println("char ch = nextExactChar();");
        this.println("$assert (ch =='\\\\');");
        this.println("ch = nextExactChar();");
        this.println("$assert (ch == 'u');");
        this.println("try {");
        this.println("do {");
        this.println("ch = nextExactChar();");
        this.println("} while (ch == 'u');");
        this.println("StringBuffer number = new StringBuffer(4);");
        this.println("number.append(ch);");
        this.println("number.append(nextExactChar());");
        this.println("number.append(nextExactChar());");
        this.println("number.append(nextExactChar());");
        this.println("int code = Integer.parseInt(number.toString(), 16);");
        this.println("return (char) code;");
        this.println("} catch (NumberFormatException x) {");
        this.println("} catch (IndexOutOfBoundsException x) {");
        this.println("}");
        this.println("throw new ParseException(\"illigal Unicode escape: \" + text.$subSequence(startIndex, index), sourceName, startIndex, startLine, startColumn);");
        this.println("}");
        this.println("private final char nextExactChar() throws $ParseException, java.lang.IndexOutOfBoundsException {");
        this.println("if (index >= end)");
        this.println("throw new java.lang.IndexOutOfBoundsException();");
        this.println("char ch = text.charAt(index++);");
        this.println("switch (ch) {");
        this.println("case '\\r':");
        this.println("if (index < end && text.charAt(index) == '\\n')");
        this.println("break;");
        this.println("case '\\n':");
        this.println("line++;");
        this.println("column = 0;");
        this.println("break;");
        this.println("case '\\t':");
        this.println("if (tabStop >= 1)");
        this.println("column = column - (column % tabStop) + tabStop;");
        this.println("break;");
        this.println("default:");
        this.println("column++;");
        this.println("break;");
        this.println("}");
        this.println("return ch;");
        this.println("}");
        this.println("} // class $Default.$LexicalAnalyzer");
        this.println("");
        this.println("");
        HashSet<Type> defaultClasses = new HashSet<Type>();
        Iterator outer = tables.userDefinedTypes().iterator();
        while (outer.hasNext()) {
            type = (Type)outer.next();
            TypeNonterminal nonterminal4 = ((UserDefinedType)type).getTypeNonterminal();
            if (nonterminal4 == null) continue;
            while (defaultClasses.add(type) && (type = (Type)type.getDirectSuperTypes().iterator().next()) instanceof UserDefinedType) {
            }
        }
        outer = tables.userDefinedTypes().iterator();
        while (outer.hasNext()) {
            type = (UserDefinedType)outer.next();
            if (!defaultClasses.contains(type)) continue;
            boolean isAbstract = ((UserDefinedType)type).getTypeNonterminal() == null;
            String identifier = ((UserDefinedType)type).getName();
            Type superType = (Type)((UserDefinedType)type).getDirectSuperTypes().iterator().next();
            String superTypeString = superType instanceof UserDefinedType ? ((UserDefinedType)superType).getName() : "$Node";
            this.println("/**");
            this.println("* An implementation of <code>" + identifier + "</code> node.");
            this.println("*/");
            this.println("public " + (isAbstract ? "abstract " : "") + "static class " + identifier + " extends $Default." + superTypeString + " implements " + this.getTypeName(type) + " {");
            Iterator it7 = ((UserDefinedType)type).getMapNameToField().values().iterator();
            while (it7.hasNext()) {
                Field field = (Field)it7.next();
                Type fieldType = field.getType();
                Field superField = superType.getField(field.getName());
                if (superField == null) {
                    if (fieldType instanceof ArrayType) {
                        this.println("private " + this.getTypeName(fieldType) + " " + field.getName() + " = new java.util.LinkedList();");
                    } else {
                        this.println("private " + this.getTypeName(fieldType) + " " + field.getName() + " = null;");
                    }
                    this.println("public " + this.getTypeName(fieldType) + " " + field.getName() + "() {");
                    this.println("return " + field.getName() + ";");
                    this.println("}");
                    continue;
                }
                if (fieldType.equals(superField.getType())) continue;
                this.println("public " + this.getTypeName(fieldType) + " " + field.getName() + "() {");
                this.println("return (" + this.getTypeName(fieldType) + ") super." + field.getName() + "();");
                this.println("}");
            }
            this.println("");
            this.println("/**");
            this.println("* Constructs a instance with the child nodes given by <code>source.$getChildNodes()</code> etc.");
            this.println("*");
            this.println("* @param   source");
            this.println("*            the source.");
            this.println("*/");
            this.println("public " + identifier + "(" + this.getTypeName(type) + " source) {");
            if (superType instanceof UserDefinedType) {
                this.println("super(($Parser." + superTypeString + ") source);");
            } else {
                this.println("super(new java.util.LinkedList(source.$getChildNodes()));");
            }
            this.println("");
            Iterator it8 = ((UserDefinedType)type).getMapNameToField().values().iterator();
            while (it8.hasNext()) {
                Field field = (Field)it8.next();
                if (superType.getField(field.getName()) != null) continue;
                Type fieldType = field.getType();
                if (fieldType instanceof ArrayType) {
                    this.println("this." + field.getName() + " = new java.util.LinkedList(source." + field.getName() + "());");
                    continue;
                }
                this.println("this." + field.getName() + " = source." + field.getName() + "();");
            }
            this.println("}");
            this.println("");
            this.println("/**");
            this.println("* Constructs a instance with the child nodes given by <code>parameters</code>.");
            this.println("* <p>");
            this.println("* {@link $Parser.$Node#$getChildNodes} of the node is modifiable and ordered by the position in the parsed text.");
            this.println("*");
            this.println("* @param   parameters");
            this.println("*            the parameters for initialization.");
            this.println("* @param   compact");
            this.println("*            remove the children that is not labeled.");
            this.println("*/");
            this.println("public " + identifier + "($Parser.$NodeInitializationParameters parameters, boolean compact) {");
            if (superType instanceof UserDefinedType) {
                this.println("super(parameters, compact);");
            } else {
                this.println("super(new java.util.LinkedList());");
            }
            this.println("");
            this.println("$Parser.$Node[] childNodes = parameters.childNodes;");
            this.println("java.util.List labelsIDList = parameters.labelsIDList;");
            this.println("");
            this.println("java.util.Iterator it = labelsIDList.iterator();");
            this.println("int size = labelsIDList.size();");
            this.println("for (int i = 0; i < size; i++) {");
            if (labelWordCount == 1) {
                this.println("java.lang.Integer number = (java.lang.Integer) it.next();");
                this.println("int no = number.intValue();");
            } else {
                this.println("java.math.BigInteger number = (java.math.BigInteger) it.next();");
            }
            if (!(superType instanceof UserDefinedType)) {
                if (labelWordCount == 1) {
                    this.println("if (!compact || no != 0)");
                    this.println("$getChildNodes().add(childNodes[i]);");
                } else {
                    this.println("if (!compact || !number.equals(java.math.BigInteger.ZERO))");
                    this.println("$getChildNodes().add(childNodes[i]);");
                }
                this.println("childNodes[i].$setParentNode(this);");
            }
            Iterator it9 = ((UserDefinedType)type).getDeclaredFields().iterator();
            while (it9.hasNext()) {
                Field field = (Field)it9.next();
                if (superType.getField(field.getName()) != null) continue;
                String fiedlTypeName = this.getTypeName(field.getType());
                this.println("");
                int labelNo = tables.getIndexOfLabel(field.getName());
                String match = labelWordCount == 1 ? "(no & (1 << " + labelNo + ")) != 0" : "number.testBit(" + labelNo + ")";
                this.println("if (" + match + ") {");
                if (field.getType() instanceof ArrayType) {
                    this.println("this." + field.getName() + ".add(childNodes[i]);");
                } else {
                    this.println("this." + field.getName() + " = (" + fiedlTypeName + ") childNodes[i];");
                }
                this.println("}");
            }
            this.println("}");
            this.println("}");
            this.println("");
            this.println("protected void $replaceChild($Parser.$Node oldChild, $Parser.$Node newChild) {");
            Iterator it10 = ((UserDefinedType)type).getMapNameToField().values().iterator();
            while (it10.hasNext()) {
                Field field = (Field)it10.next();
                if (superType.getField(field.getName()) != null) continue;
                String fiedlTypeName = this.getTypeName(field.getType());
                if (field.getType() instanceof ArrayType) {
                    this.println("$replaceAll(this." + field.getName() + ", oldChild, newChild);");
                    continue;
                }
                this.println("if (oldChild == null ? this." + field.getName() + " == null : oldChild.equals(this." + field.getName() + "))");
                this.println("this." + field.getName() + " = (" + fiedlTypeName + ") newChild;");
            }
            this.println("super.$replaceChild(oldChild, newChild);");
            this.println("}");
            this.println("} // class " + identifier + "");
        }
        this.println("");
        this.println("");
        this.println("} // $Default");
        this.println("");
        this.allocate("IntegerStack", topTypeNamespace);
        this.println("private static class $IntegerStack {");
        this.println("public static $IntegerStack EMPTY_STACK = new $IntegerStack(null, 0);");
        this.println("");
        this.println("private $IntegerStack previous;");
        this.println("private int value;");
        this.println("private $IntegerStack($IntegerStack previous, int value) {");
        this.println("this.previous = previous;");
        this.println("this.value = value;");
        this.println("}");
        this.println("public boolean isEmpty() {");
        this.println("return previous == null;");
        this.println("}");
        this.println("public static $IntegerStack push($IntegerStack stack, int value) {");
        this.println("return new $IntegerStack(stack, value);");
        this.println("}");
        this.println("public int top() {");
        this.println("return value;");
        this.println("}");
        this.println("public static $IntegerStack pop($IntegerStack stack) {");
        this.println("return stack.previous;");
        this.println("}");
        this.println("}");
        this.allocate("State", topTypeNamespace);
        this.println("private static class $State {");
        this.println("public $IntegerStack stateStack;");
        this.println("public $IntegerStack shiftReduceHistory;");
        this.println("public $State($IntegerStack stateStack, $IntegerStack shiftReduceHistory) {");
        this.println("this.stateStack = stateStack;");
        this.println("this.shiftReduceHistory = shiftReduceHistory;");
        this.println("}");
        this.println("}");
        this.println("");
        if (tables.tags().length > 0) {
            this.reserve("taggedTokenShifted", topMethodNamespace);
            this.println("protected void $taggedTokenShifted($Parser.$LexicalAnalyzer analyzer, $Parser.$Token token, int tag) {");
            this.println("}");
        }
        this.println("");
        this.allocate("parse", topMethodNamespace);
        this.println("private $Node $parse(int[][] lrTable, int[][] reductions, int[] tagTable, int initialState, int classSymbolMaximum, $LexicalAnalyzer analyzer) throws $ParseException {");
        this.println("final int labelWordCount = " + labelWordCount + ";");
        this.println("final int firstIndexOfWhiteTerminals = " + tables.firstIndexOfWhiteTerminals() + ";");
        this.println("final int superiorIndexOfWhiteTerminals = " + tables.superiorIndexOfWhiteTerminals() + ";");
        this.println("java.util.LinkedList tokens = new java.util.LinkedList();");
        this.println("int SHIFT = -1;");
        this.println("java.util.ArrayList states = new java.util.ArrayList();");
        this.println("{");
        this.println("// phase 1:  stamp.");
        this.println("java.util.ArrayList nextStates = new java.util.ArrayList();");
        this.println("states.add(new $State($IntegerStack.push($IntegerStack.EMPTY_STACK, initialState), $IntegerStack.EMPTY_STACK));");
        this.println("tokenLoop:");
        this.println("for (;;) {");
        this.println("$Token nextToken;");
        this.println("int nextTokenID;");
        this.println("do {");
        this.println("nextToken = analyzer.next();");
        this.println("nextTokenID = nextToken.getSymbolID();");
        this.println("if (nextTokenID != EOF_TOKEN)");
        this.println("tokens.addLast(nextToken);");
        this.println("} while (firstIndexOfWhiteTerminals <= nextTokenID && nextTokenID < superiorIndexOfWhiteTerminals);");
        this.println("");
        this.println("int initialStatesSize = states.size();");
        this.println("reduceLoop:");
        this.println("for (int i = 0; i < states.size(); i++) {");
        this.println("final $State state = ($State) states.get(i);");
        this.println("final int stateID = state.stateStack.top();");
        this.println("//System.out.print(stateID + \", \");");
        this.println("int[] tokenIDToReductionID = lrTable[stateID * 3 + 2];");
        this.println("int j = $binarySearch(tokenIDToReductionID, nextTokenID);");
        this.println("for (; j < tokenIDToReductionID.length; j += 2) {");
        this.println("if (tokenIDToReductionID[j] > nextTokenID) {");
        this.println("break;");
        this.println("} else if (tokenIDToReductionID[j] == nextTokenID) {");
        this.println("final int reductionID = tokenIDToReductionID[j + 1];");
        this.println("final int[] reduction = reductions[reductionID];");
        this.println("final int nextSymbolID = reduction[0];");
        this.println("");
        this.println("$IntegerStack stateStack = state.stateStack;");
        this.println("for (int k = reduction.length - 1; k >= 1; k -= labelWordCount)");
        this.println("stateStack = $IntegerStack.pop(stateStack);");
        this.println("");
        this.println("$IntegerStack shiftReduceHistory = state.shiftReduceHistory;");
        this.println("shiftReduceHistory = $IntegerStack.push(shiftReduceHistory, reductionID);");
        this.println("");
        this.println("final int returnedStateID = stateStack.top();");
        this.println("final int[] symbolIDToNextState = lrTable[returnedStateID * 3 + 1];");
        this.println("int k = $binarySearch(symbolIDToNextState, nextSymbolID);");
        this.println("for (; k < symbolIDToNextState.length; k += 2) {");
        this.println("if (symbolIDToNextState[k] > nextSymbolID) {");
        this.println("break;");
        this.println("} else if (symbolIDToNextState[k] == nextSymbolID) {");
        this.println("final int nextStateID = symbolIDToNextState[k + 1];");
        this.println("states.add(new $State($IntegerStack.push(stateStack, nextStateID), shiftReduceHistory));");
        this.println("break;");
        this.println("}");
        this.println("}");
        this.println("}");
        this.println("}");
        this.println("}");
        this.println("//System.out.println();");
        this.println("");
        this.println("shiftLoop:");
        this.println("for (int i = 0; i < states.size(); i++) {");
        this.println("final $State state = ($State) states.get(i);");
        this.println("final int stateID = state.stateStack.top();");
        this.println("");
        this.println("final int[] symbolIDToNextState = lrTable[stateID * 3 + 0];");
        this.println("int k = $binarySearch(symbolIDToNextState, nextTokenID);");
        this.println("for (; k < symbolIDToNextState.length; k += 2) {");
        this.println("if (symbolIDToNextState[k] > nextTokenID) {");
        this.println("break;");
        this.println("} else if (symbolIDToNextState[k] == nextTokenID) {");
        this.println("final int nextStateID = symbolIDToNextState[k + 1];");
        this.println("$IntegerStack stateStack = state.stateStack;");
        this.println("stateStack = $IntegerStack.push(stateStack, nextStateID);");
        this.println("");
        this.println("$IntegerStack shiftReduceHistory = state.shiftReduceHistory;");
        this.println("shiftReduceHistory = $IntegerStack.push(shiftReduceHistory, SHIFT);");
        this.println("");
        this.println("nextStates.add(new $State(stateStack, shiftReduceHistory));");
        this.println("}");
        this.println("}");
        this.println("}");
        this.println("");
        this.println("if (nextStates.isEmpty()) {");
        this.println("if (nextTokenID != EOF_TOKEN)");
        this.println("tokens.removeLast();");
        this.println("states.subList(initialStatesSize, states.size()).clear();");
        this.println("$error(analyzer, lrTable, states, nextToken);");
        this.println("continue tokenLoop;");
        this.println("}");
        this.println("");
        if (tables.tags().length > 0) {
            this.println("for (int i = 0; i < nextStates.size(); i++) {");
            this.println("$State state = ($State) nextStates.get(i);");
            this.println("int stateID = state.stateStack.top();");
            this.println("for (int j = 0; j < tagTable.length; j += 2) {");
            this.println("if (tagTable[j] == stateID) {");
            this.println("if (nextStates.size() > 1)");
            this.println("throw new $ParseException.AmbiguousGrammarError(" + JavaCodeGenerator.quoted(file.getName()) + " + \" has ambiguous tags.\");");
            this.println("else");
            this.println("$taggedTokenShifted(analyzer, nextToken, tagTable[j + 1]);");
            this.println("break;");
            this.println("}");
            this.println("}");
            this.println("}");
        }
        this.println("");
        this.println("if (nextTokenID == EOF_TOKEN) {");
        this.println("states = nextStates;");
        this.println("break tokenLoop;");
        this.println("}");
        this.println("");
        this.println("java.util.ArrayList tmp = states;");
        this.println("states = nextStates;");
        this.println("nextStates = tmp;");
        this.println("nextStates.clear();");
        this.println("}");
        this.println("}");
        this.println("");
        this.println("if (states.size() != 1)");
        this.println("throw new $ParseException.AmbiguousGrammarError(" + JavaCodeGenerator.quoted(file.getName()) + " + \" is ambiguous.\");");
        this.println("$State state = ($State) states.get(0);");
        this.println("");
        this.println("// phase 2:  build a tree.");
        this.println("{");
        this.println("$IntegerStack shiftReduceHistory = state.shiftReduceHistory;");
        this.println("{");
        this.println("shiftReduceHistory = $IntegerStack.pop(shiftReduceHistory); // remove the last shift for EOF.");
        this.println("$IntegerStack tracer = $IntegerStack.EMPTY_STACK;");
        this.println("while (!shiftReduceHistory.isEmpty()) {");
        this.println("tracer = $IntegerStack.push(tracer, shiftReduceHistory.top());");
        this.println("shiftReduceHistory = $IntegerStack.pop(shiftReduceHistory);");
        this.println("}");
        this.println("shiftReduceHistory = tracer;");
        this.println("}");
        if (labelWordCount == 1) {
            this.println("final java.lang.Integer ZERO = new java.lang.Integer(0);");
        } else {
            this.println("final java.math.BigInteger ZERO = java.math.BigInteger.ZERO;");
        }
        this.println("");
        this.println("java.util.Iterator it = tokens.iterator();");
        this.println("java.util.LinkedList stack = new java.util.LinkedList();");
        this.println("mainLoop:");
        this.println("while (!shiftReduceHistory.isEmpty()) {");
        this.println("int shiftReduce = shiftReduceHistory.top();");
        this.println("shiftReduceHistory = $IntegerStack.pop(shiftReduceHistory);");
        this.println("if (shiftReduce == SHIFT) {");
        this.println("$Token token;");
        this.println("do {");
        this.println("token = ($Token) it.next();");
        this.println("stack.addLast(token);");
        this.println("} while (firstIndexOfWhiteTerminals <= token.getSymbolID() && token.getSymbolID() < superiorIndexOfWhiteTerminals);");
        this.println("} else {");
        this.println("final int[] reduction = reductions[shiftReduce];");
        this.println("boolean isFinal = shiftReduceHistory.isEmpty();");
        this.println("if (isFinal) {");
        this.println("while (it.hasNext())");
        this.println("stack.addLast(it.next());");
        this.println("}");
        this.println("java.util.LinkedList list = new java.util.LinkedList();");
        this.println("for (int j = reduction.length - 1; j >= 1; j -= labelWordCount) {");
        this.println("java.lang.Object node;");
        this.println("for (;;) {");
        this.println("node = stack.removeLast();");
        this.println("if (node instanceof $Token) {");
        this.println("$Token token = ($Token) node;");
        this.println("if (firstIndexOfWhiteTerminals <= token.getSymbolID() && token.getSymbolID() < superiorIndexOfWhiteTerminals) {");
        this.println("list.addFirst(ZERO);");
        this.println("list.addFirst(node);");
        this.println("continue;");
        this.println("}");
        this.println("}");
        this.println("break;");
        this.println("}");
        if (labelWordCount == 1) {
            this.println("list.addFirst(new java.lang.Integer(reduction[j]));");
        } else {
            this.println("java.math.BigInteger no = java.math.BigInteger.ZERO;");
            this.println("for (int k = 0; k < labelWordCount; k++)");
            this.println("no = no.or(java.math.BigInteger.valueOf(0xFFFFFFFFL & reduction[j - k]).shiftLeft(k * 32));");
            this.println("list.addFirst(no);");
        }
        this.println("list.addFirst(node);");
        this.println("}");
        this.println("if (isFinal) {");
        this.println("while (!stack.isEmpty()) {");
        this.println("java.lang.Object node = stack.removeLast();");
        this.println("list.addFirst(ZERO);");
        this.println("list.addFirst(node);");
        this.println("}");
        this.println("}");
        this.println("int nodeID = reduction[0];");
        this.println("java.lang.Object node;");
        this.println("if (nodeID <= classSymbolMaximum) {");
        this.println("node = $createNode(nodeID, list);");
        this.println("} else {");
        this.println("node = list;");
        this.println("}");
        this.println("stack.addLast(node);");
        this.println("}");
        this.println("}");
        this.println("return ($Node) stack.getFirst();");
        this.println("}");
        this.println("}");
        this.allocate("binarySearch", topMethodNamespace);
        this.println("private static int $binarySearch(int[] table, int key) {");
        this.println("// Returns the index where table[i] < key for all i < index");
        this.println("int base = 0;");
        this.println("int width = table.length >> 1;");
        String lrgLinearSearchThreshold = this.environment.parameters.getProperty("JavaCodeGenerator.lrgLinearSearchThreshold", "3");
        this.println("while (width > " + lrgLinearSearchThreshold + ") {");
        this.println("int halfWidth = width >> 1;");
        this.println("int mid = base + width & ~1;    // base + halfWidth * 2");
        this.println("if (key <= table[mid]) {");
        this.println("width = halfWidth;");
        this.println("} else {");
        this.println("base = mid;");
        this.println("width -= halfWidth;");
        this.println("}");
        this.println("}");
        this.println("return base;");
        this.println("}");
        this.println("");
        this.reserve("createNode", topMethodNamespace);
        this.println("private $Node $createNode(int symbolID, java.util.List data) throws $ParseException {");
        this.println("java.util.List nodeList = new java.util.LinkedList();");
        this.println("java.util.List labelsIDList = new java.util.LinkedList();");
        if (labelWordCount == 1) {
            this.println("$flatNodes(0, nodeList, labelsIDList, data);");
        } else {
            this.println("$flatNodes(java.math.BigInteger.ZERO, nodeList, labelsIDList, data);");
        }
        this.println("$Node[] childNodes = ($Node[]) nodeList.toArray(new $Node[nodeList.size()]);");
        this.println("$NodeInitializationParameters parameters = new $NodeInitializationParameters();");
        this.println("parameters.childNodes = childNodes;");
        this.println("parameters.labelsIDList = labelsIDList;");
        this.println("$Node result = $createNode(symbolID, parameters);");
        this.println("return result;");
        this.println("}");
        this.println("");
        this.allocate("flatNodes", topMethodNamespace);
        if (labelWordCount == 1) {
            this.println("private static void $flatNodes(int labels, java.util.List nodeList, java.util.List labelsIDList, java.util.List data) {");
            this.println("java.util.Iterator it = data.iterator();");
            this.println("while (it.hasNext()) {");
            this.println("java.lang.Object node = it.next();");
            this.println("java.lang.Integer labelsID = (java.lang.Integer) it.next();");
            this.println("int mergedLabelsID = labelsID.intValue();");
            this.println("if ((mergedLabelsID & 1) != 0) {");
            this.println("mergedLabelsID &= ~1;");
            this.println("mergedLabelsID |= labels;");
            this.println("}");
            this.println("if (node instanceof java.util.List) {");
            this.println("$flatNodes(mergedLabelsID, nodeList, labelsIDList, (java.util.List) node);");
            this.println("} else {");
            this.println("nodeList.add(node);");
            this.println("labelsIDList.add(new java.lang.Integer(mergedLabelsID));");
            this.println("}");
            this.println("}");
            this.println("}");
        } else {
            this.println("private static void $flatNodes(java.math.BigInteger labels, java.util.List nodeList, java.util.List labelsIDList, java.util.List data) {");
            this.println("java.util.Iterator it = data.iterator();");
            this.println("while (it.hasNext()) {");
            this.println("java.lang.Object node = it.next();");
            this.println("java.math.BigInteger labelsID = (java.math.BigInteger) it.next();");
            this.println("java.math.BigInteger mergedLabelsID = labelsID;");
            this.println("if (mergedLabelsID.testBit(0)) {");
            this.println("mergedLabelsID = mergedLabelsID.clearBit(0);");
            this.println("mergedLabelsID = mergedLabelsID.or(labels);");
            this.println("}");
            this.println("if (node instanceof java.util.List) {");
            this.println("$flatNodes(mergedLabelsID, nodeList, labelsIDList, (java.util.List) node);");
            this.println("} else {");
            this.println("nodeList.add(node);");
            this.println("labelsIDList.add(mergedLabelsID);");
            this.println("}");
            this.println("}");
            this.println("}");
        }
        this.println("");
        this.allocate("error", topMethodNamespace);
        this.println("private static void $error($LexicalAnalyzer analyzer, int[][] lrTable, java.util.List states, $Token errorNextToken) throws $ParseException {");
        this.println("java.util.Set nextTokens = new java.util.TreeSet();");
        this.println("java.util.Iterator it = states.iterator();");
        this.println("while (it.hasNext()) {");
        this.println("$State state = ($State) it.next();");
        this.println("int stateID = state.stateStack.top();");
        this.println("");
        this.println("int[] tokenIDToNextState = lrTable[stateID * 3 + 0];");
        this.println("for (int i = 0; i < tokenIDToNextState.length; i += 2) {");
        this.println("nextTokens.add(new java.lang.Integer(tokenIDToNextState[i]));");
        this.println("}");
        this.println("int[] tokenIDToReductionID = lrTable[stateID * 3 + 2];");
        this.println("for (int i = 0; i < tokenIDToReductionID.length; i += 2) {");
        this.println("nextTokens.add(new java.lang.Integer(tokenIDToReductionID[i]));");
        this.println("}");
        this.println("}");
        this.println("int[] selectableTokens = new int[nextTokens.size()];");
        this.println("int index = 0;");
        this.println("java.util.Iterator it11 = nextTokens.iterator();");
        this.println("while (it11.hasNext()) {");
        this.println("java.lang.Integer i = (java.lang.Integer) it11.next();");
        this.println("selectableTokens[index++] = i.intValue();");
        this.println("}");
        this.println("$error(analyzer, errorNextToken, selectableTokens);");
        this.println("}");
        this.println("/**");
        this.println("* Throws or recovers a error.");
        this.println("* <p>");
        this.println("* This method is called when a token is not shiftable.");
        this.println("* If the error is not recoverable, this method throws $ParseException.");
        this.println("* To recover the error, this method dose not throw anything,");
        this.println("* then syntax analyzers ignore the <code>errorNextToken</code>,");
        this.println("* i.e. the last <code>analyzer.{@link $Parser.$LexicalAnalyzer#next() next()}</code> call.");
        this.println("* The next <code>analyzer.{@link $Parser.$LexicalAnalyzer#next() next()}</code> can return a better token.");
        this.println("*");
        this.println("* @param   analyzer");
        this.println("*      the lexical analyzer of the parsing.");
        this.println("* @param   errorNextToken");
        this.println("*      the unshiftable token the last <code>analyzer.{@link $Parser.$LexicalAnalyzer#next() next()}</code> returned.");
        this.println("* @param   selectableNextTokens");
        this.println("*      the shiftable tokens at the situation.");
        this.println("* @throws   $ParseException");
        this.println("*      if the error is not recoverable.");
        this.println("* @since    notavaCC 1.0");
        this.println("*/");
        this.allocate("error", topMethodNamespace);
        this.println("private static void $error($LexicalAnalyzer analyzer, $Token errorNextToken, int[] selectableNextTokens) throws $ParseException {");
        this.println("java.io.StringWriter buffer = new java.io.StringWriter();");
        this.println("java.io.PrintWriter writer = new java.io.PrintWriter(buffer);");
        this.println("");
        this.println("if (errorNextToken.getSymbolID() != EOF_TOKEN) {");
        this.println("writer.println(\"The token \" + errorNextToken + \" should be one of the followings.\");");
        this.println("} else {");
        this.println("writer.println(\"The EOF should be one of the followings.\");");
        this.println("}");
        this.println("");
        this.println("final java.lang.String[] tokenStrings = {");
        Symbol[] symbols2 = tables.symbols();
        int i3 = 0;
        while (i3 < tables.superiorIndexOfTerminals()) {
            Symbol symbol2 = symbols2[i3];
            this.println("" + JavaCodeGenerator.quoted(symbol2.toString()) + ",");
            ++i3;
        }
        this.println("};");
        this.println("");
        this.println("for (int i = 0; i < selectableNextTokens.length; i++) {");
        this.println("int selectableNextToken = selectableNextTokens[i];");
        this.println("writer.print(\"        \");");
        this.println("writer.println(tokenStrings[selectableNextToken]);");
        this.println("}");
        this.println("");
        this.println("writer.close();");
        this.println("if (writer.checkError())");
        this.println("throw new RuntimeException();");
        this.println("throw new $ParseException(buffer.toString(), errorNextToken);");
        this.println("}");
        this.println("");
        int unit = 50;
        Object[] states = tables.dfaStates();
        this.println("private static $final_avoid_jdk12_bug int[][] $dfaTable;");
        this.allocate("dfaTable", topFieldNamespace);
        this.println("static {");
        this.println("$dfaTable = new int[" + states.length + "][];");
        i3 = 0;
        while (i3 < states.length) {
            this.println("initializeDFATable" + i3 + "();");
            i3 += 50;
        }
        this.println("}");
        int i4 = 0;
        while (i4 < states.length) {
            topMethodNamespace.add("initializeDFATable" + i4, RESERVED_NAME);
            this.println("private static void initializeDFATable" + i4 + "() {");
            int j = i4;
            while (j < i4 + 50 && j < states.length) {
                state = states[j];
                this.println("$dfaTable[" + j + "] = new int[] {");
                Terminal symbol3 = state.hitSymbol();
                if (symbol3 == null) {
                    this.println("-1,");
                } else {
                    this.println("" + symbolToWord.get(symbol3) + ",");
                }
                Iterator it = state.getMapInputToNextStates().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    DFAInput input = (DFAInput)entry.getKey();
                    DeterministicFiniteAutomaton.DFAState nextState = (DeterministicFiniteAutomaton.DFAState)entry.getValue();
                    this.println("" + JavaCodeGenerator.quoted(input.lower) + ", " + JavaCodeGenerator.quoted(input.upper) + ", " + tables.getIndexOfState(nextState) + ",");
                }
                this.println("};");
                ++j;
            }
            this.println("}");
            i4 += 50;
        }
        this.println("");
        unit = 20;
        states = tables.lrStates();
        this.println("private static $final_avoid_jdk12_bug int[][] $lrTable;");
        this.allocate("lrTable", topFieldNamespace);
        this.println("static {");
        this.println("$lrTable = new int[" + states.length + " * 3][];");
        i3 = 0;
        while (i3 < states.length) {
            this.println("initializeLRTable" + i3 + "();");
            i3 += 20;
        }
        this.println("}");
        i4 = 0;
        while (i4 < states.length) {
            topMethodNamespace.add("initializeLRTable" + i4, RESERVED_NAME);
            this.println("private static void initializeLRTable" + i4 + "() {");
            int j = i4;
            while (j < i4 + 20 && j < states.length) {
                state = states[j];
                Map teminalToNextState = tables.getMapTeminalToNextState((LRTable.LRState)state);
                Map nonteminalToNextState = tables.getMapNonteminalToNextState((LRTable.LRState)state);
                Map symbolToReductions = tables.getMapSymbolToReduction((LRTable.LRState)state);
                this.println("// LRState " + tables.getIndexOfState((LRTable.LRState)state) + "");
                this.println("$lrTable[" + j + " * 3 + 0] = new int[] {");
                Iterator it3 = teminalToNextState.entrySet().iterator();
                while (it3.hasNext()) {
                    Map.Entry entry = it3.next();
                    Symbol symbol4 = (Symbol)entry.getKey();
                    LRTable.LRState nextState = (LRTable.LRState)entry.getValue();
                    this.println("" + symbolToWord.get(symbol4) + ", " + tables.getIndexOfState(nextState) + ",");
                }
                this.println("};");
                this.println("$lrTable[" + j + " * 3 + 1] = new int[] {");
                Iterator it4 = nonteminalToNextState.entrySet().iterator();
                while (it4.hasNext()) {
                    Map.Entry entry = it4.next();
                    Symbol symbol5 = (Symbol)entry.getKey();
                    LRTable.LRState nextState = (LRTable.LRState)entry.getValue();
                    this.println("" + symbolToWord.get(symbol5) + ", " + tables.getIndexOfState(nextState) + ",");
                }
                this.println("};");
                this.println("$lrTable[" + j + " * 3 + 2] = new int[] {");
                Iterator it5 = symbolToReductions.entrySet().iterator();
                while (it5.hasNext()) {
                    Map.Entry entry = it5.next();
                    Symbol symbol6 = (Symbol)entry.getKey();
                    Set reductions = (Set)entry.getValue();
                    Iterator it6 = reductions.iterator();
                    while (it6.hasNext()) {
                        LRTable.Reduction reduction = (LRTable.Reduction)it6.next();
                        this.println("" + symbolToWord.get(symbol6) + ", " + tables.getIndexOfReduction(reduction) + ",");
                    }
                }
                this.println("};");
                ++j;
            }
            this.println("}");
            i4 += 20;
        }
        this.println("");
        LRTable.Reduction[] reductions = tables.reductions();
        this.allocate("reductionTable", topFieldNamespace);
        this.println("private static final int[][] $reductionTable = {");
        int i5 = 0;
        while (i5 < reductions.length) {
            LRTable.Reduction reduction = reductions[i5];
            this.println("");
            StringBuffer result = new StringBuffer();
            Iterator it = reduction.labelSetList().iterator();
            while (it.hasNext()) {
                Set labels = (Set)it.next();
                BigInteger no = BigInteger.ZERO;
                Iterator innest = labels.iterator();
                while (innest.hasNext()) {
                    String label = (String)innest.next();
                    no = no.setBit(tables.getIndexOfLabel(label));
                }
                String hex = no.toString(16).toUpperCase(Locale.ENGLISH);
                while (hex.length() < labelWordCount * 8) {
                    hex = '0' + hex;
                }
                int j = 0;
                while (j < labelWordCount) {
                    result.append("0x").append(hex.substring(j * 8, j * 8 + 8)).append(",");
                    ++j;
                }
                result.append(" ");
            }
            this.println("{ " + symbolToWord.get(reduction.reducedSymbol()) + ",  " + result + "},");
            ++i5;
        }
        this.println("};");
        this.println("");
        this.allocate("tagTable", topFieldNamespace);
        this.println("private static final int[] $tagTable = {");
        LRTable.LRState[] states2 = tables.lrStates();
        i5 = 0;
        while (i5 < states2.length) {
            LRTable.LRState state2 = states2[i5];
            if (state2.tag() != null) {
                this.println("" + i5 + ", " + tagToWord.get(state2.tag().getImage()) + ",");
            }
            ++i5;
        }
        this.println("};");
        this.println("");
        this.allocate("replaceAll", topMethodNamespace);
        this.println("private static void $replaceAll(java.util.List list, $Node oldValue, $Node newValue) {");
        if (this.targetVersion >= 1.4) {
            this.println("java.util.Collections.replaceAll(list, oldValue, newValue);");
        } else {
            this.println("java.util.ListIterator it = list.listIterator();");
            this.println("if (oldValue == null) {");
            this.println("while (it.hasNext()) {");
            this.println("java.lang.Object old = it.next();");
            this.println("if (oldValue == old)");
            this.println("it.set(newValue);");
            this.println("}");
            this.println("} else {");
            this.println("while (it.hasNext()) {");
            this.println("java.lang.Object old = it.next();");
            this.println("if (oldValue.equals(old))");
            this.println("it.set(newValue);");
            this.println("}");
            this.println("}");
        }
        this.println("}");
        this.println("");
        this.allocate("toHexCode", topMethodNamespace);
        this.println("private static java.lang.String $toHexCode(char ch) {");
        this.println("java.lang.String hex = \"000\" + java.lang.Integer.toString(ch, 16).toUpperCase(java.util.Locale.ENGLISH);");
        this.println("hex = hex.substring(hex.length() - 4);");
        this.println("return hex;");
        this.println("}");
        this.println("");
        if (!this.root.hasProtectedConstructor() && publicParsableTypeCount == 1) {
            this.println("/**");
            this.println("* Parses the given file(s) and prints the abstract syntax tree(s) generated.");
            this.println("*");
            this.println("* @since   notavaCC 1.0");
            this.println("*/");
            this.reserve("main", topMethodNamespace);
            this.println("public static void $main(java.lang.String[] args) {");
            this.println("try {");
            this.println("$Parser p = new $Parser();");
            this.println("for (int i = 0; i < args.length; i++) {");
            this.println("java.io.File file = new java.io.File(args[i]);");
            this.println("System.out.println(file);");
            this.println("");
            Iterator it122 = tables.userDefinedTypes().iterator();
            while (it122.hasNext()) {
                UserDefinedType type8 = (UserDefinedType)it122.next();
                LRTable.LRState initialState = (LRTable.LRState)this.lrTable.symbolToInitialState().get(type8.getTypeNonterminal());
                if (initialState == null) continue;
                this.println("System.out.println(p.parse" + type8.getName() + "(file));");
                break;
            }
            this.println("}");
            this.println("} catch(java.lang.Exception x) {");
            this.println("x.printStackTrace();");
            this.println("}");
            this.println("}");
        }
        this.println("} // class $Parser");
        this.logger.verbosest(this.environment.processingFile, "checking topTypeNamespace");
        this.checkDuplex(topTypeNamespace);
        this.logger.verbosest(this.environment.processingFile, "checking topFieldNamespace");
        this.checkDuplex(topFieldNamespace);
        this.logger.verbosest(this.environment.processingFile, "checking topMethodNamespace");
        this.checkDuplex(topMethodNamespace);
        this.logger.verbosest(this.environment.processingFile, "checking nodeFieldNamespace");
        this.checkDuplex(nodeFieldNamespace);
        this.logger.verbosest(this.environment.processingFile, "checking nodeNoArgumentMethodNamespace");
        this.checkDuplex(nodeNoArgumentMethodNamespace);
        this.logger.verbosest(this.environment.processingFile, "checking nodeMethodNamespace");
        this.checkDuplex(nodeMethodNamespace);
        if (this.logger.hasError()) {
            this.logger.fatal();
        }
    }

    public void checkDuplex(MultiMap namespace) {
        Iterator it13 = namespace.entrySet().iterator();
        while (it13.hasNext()) {
            Map.Entry entry = it13.next();
            String name = (String)entry.getKey();
            Set reservers = (Set)entry.getValue();
            if (reservers.contains(RESERVED_NAME)) {
                this.logger.verbosest(this.environment.processingFile, "checking the reserved name {0}.", (Object)name);
            }
            if (reservers.size() < 2) continue;
            Iterator it14 = reservers.iterator();
            while (it14.hasNext()) {
                Object reserver = it14.next();
                if (reserver.equals(RESERVED_NAME)) continue;
                if (reserver instanceof Symbol) {
                    this.logger.error(this.environment.processingFile, "The reserved name {0} is used.", reserver);
                    continue;
                }
                if (reserver instanceof Type) {
                    this.logger.error(this.environment.processingFile, "The reserved name {0} is used.", reserver);
                    continue;
                }
                this.logger.error(this.environment.processingFile, "The reserved name {0} is used.", reserver);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$generator$JavaCodeGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$generator$JavaCodeGenerator = JavaCodeGenerator.class$("jp.gr.java_conf.koto.notavacc.generator.JavaCodeGenerator")) : class$jp$gr$java_conf$koto$notavacc$generator$JavaCodeGenerator).desiredAssertionStatus();
        RESERVED_NAME = new Object();
    }
}

