/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.notavacc.generator;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.gr.java_conf.koto.notavacc.Environment;
import jp.gr.java_conf.koto.notavacc.Module;
import jp.gr.java_conf.koto.notavacc.dfa.DeterministicFiniteAutomaton;
import jp.gr.java_conf.koto.notavacc.lrg.AliasNonterminal;
import jp.gr.java_conf.koto.notavacc.lrg.LRTable;
import jp.gr.java_conf.koto.notavacc.lrg.NamedTerminal;
import jp.gr.java_conf.koto.notavacc.lrg.Nonterminal;
import jp.gr.java_conf.koto.notavacc.lrg.Symbol;
import jp.gr.java_conf.koto.notavacc.lrg.Terminal;
import jp.gr.java_conf.koto.notavacc.lrg.TypeNonterminal;
import jp.gr.java_conf.koto.notavacc.parser.Original;
import jp.gr.java_conf.koto.notavacc.parser.Parser;
import jp.gr.java_conf.koto.notavacc.types.Type;
import jp.gr.java_conf.koto.notavacc.types.TypeSystem;
import jp.gr.java_conf.koto.notavacc.types.UserDefinedType;
import jp.gr.java_conf.koto.notavacc.util.MultiMap;

public abstract class CodeGenerator
extends Module {
    private Parser.Root root;
    private DeterministicFiniteAutomaton dfa;
    private LRTable lrTable;
    private TypeSystem typeSystem;
    private Tables tables;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$jp$gr$java_conf$koto$notavacc$generator$CodeGenerator;

    public CodeGenerator(Environment env, Parser.Root root, DeterministicFiniteAutomaton dfa, LRTable lrTable, TypeSystem typeSystem) {
        super(env);
        this.root = root;
        this.dfa = dfa;
        this.lrTable = lrTable;
        this.typeSystem = typeSystem;
        this.tables = new Tables();
    }

    public void generate(File file, boolean dryRun) {
        block6: {
            try {
                if (!dryRun) {
                    this.logger.verbose(this.environment.processingFile, "writing to the file ''{0}''.", (Object)file);
                } else {
                    this.logger.verbose(this.environment.processingFile, "dry run: not writing to the file ''{0}''.", (Object)file);
                }
                this.generateCode(file, this.tables, dryRun);
                if (!dryRun) {
                    this.logger.verbose(this.environment.processingFile, "wrote.  {0} bytes.", (Object)new Long(file.length()));
                    break block6;
                }
                this.logger.verbose(this.environment.processingFile, "dry run: did not write.");
            }
            catch (IOException x) {
                this.logger.error(this.environment.processingFile, "An error occured during writing the file ''{0}'': {1}", (Object)file, (Object)x.getLocalizedMessage());
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                x.printStackTrace(printWriter);
                printWriter.close();
                if (!$assertionsDisabled && printWriter.checkError()) {
                    throw new AssertionError();
                }
                this.logger.verbose(this.environment.processingFile, "{0}", (Object)stringWriter.toString());
                this.logger.fatal();
            }
        }
    }

    protected abstract void generateCode(File var1, Tables var2, boolean var3) throws IOException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$generator$CodeGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$generator$CodeGenerator = CodeGenerator.class$("jp.gr.java_conf.koto.notavacc.generator.CodeGenerator")) : class$jp$gr$java_conf$koto$notavacc$generator$CodeGenerator).desiredAssertionStatus();
    }

    protected class Tables {
        private DeterministicFiniteAutomaton.DFAState[] dfaStates;
        private Map dfaStateToIndexNumber;
        private Set whiteTerminals = null;
        private Set blackTerminals = null;
        private Set typeNonterminals = null;
        private Set aliasNonterminals;
        private Symbol[] symbols = null;
        private Map symbolToIndexInteger;
        private int firstIndexOfWhiteTerminals = -1;
        private int firstIndexOfBlackTerminals = -1;
        private int firstIndexOfTypeNonterminals = -1;
        private int firstIndexOfAliasNonterminals = -1;
        private int firstIndexOfAnonymousNonterminals = -1;
        private LRTable.Reduction[] reductions = null;
        private Map reductionToIndexNumber = null;
        private String[] labels;
        private Map labelToIndexNumber;
        private LRTable.LRState[] lrStates;
        private Map lrStateToIndexNumber;
        private Map lrStateToMapTeminalToNextState = new HashMap();
        private Map lrStateToMapNonteminalToNextState = new HashMap();
        private Map lrStateToMapSymbolToReduction = new HashMap();
        private String[] tags = null;
        private MultiMap tagToTaggedStates = null;
        private Map tagToIndexNumber = null;
        private Set types = null;
        private Set userDefinedTypes = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Tables() {
        }

        public DeterministicFiniteAutomaton.DFAState[] dfaStates() {
            if (this.dfaStates == null) {
                LinkedHashSet<DeterministicFiniteAutomaton.DFAState> result = new LinkedHashSet<DeterministicFiniteAutomaton.DFAState>(CodeGenerator.this.dfa.states().size());
                result.add(CodeGenerator.this.dfa.initialState());
                result.addAll(CodeGenerator.this.dfa.states());
                this.dfaStates = result.toArray(new DeterministicFiniteAutomaton.DFAState[result.size()]);
            }
            return this.dfaStates;
        }

        public int getIndexOfState(DeterministicFiniteAutomaton.DFAState state) {
            if (this.dfaStateToIndexNumber == null) {
                this.dfaStateToIndexNumber = new HashMap();
                DeterministicFiniteAutomaton.DFAState[] dfaStates = this.dfaStates();
                int i = 0;
                while (i < dfaStates.length) {
                    this.dfaStateToIndexNumber.put(dfaStates[i], new Integer(i));
                    ++i;
                }
            }
            Integer result = (Integer)this.dfaStateToIndexNumber.get(state);
            return result;
        }

        public Set whiteTerminals() {
            if (this.whiteTerminals == null) {
                this.whiteTerminals = new LinkedHashSet();
                Iterator it0 = CodeGenerator.this.root.whiteTokenReservations().iterator();
                while (it0.hasNext()) {
                    Original.WhiteTokenDefinition definition = (Original.WhiteTokenDefinition)it0.next();
                    String name = CodeGenerator.this.root.getCanonicalName(definition);
                    this.whiteTerminals.add(new NamedTerminal(name));
                }
            }
            return this.whiteTerminals;
        }

        public Set blackTerminals() {
            if (this.blackTerminals == null) {
                this.blackTerminals = new LinkedHashSet();
                Iterator it0 = CodeGenerator.this.root.tokenReservations().iterator();
                while (it0.hasNext()) {
                    Original.TokenReservation reservation = (Original.TokenReservation)it0.next();
                    String name = CodeGenerator.this.root.getCanonicalName(reservation);
                    this.blackTerminals.add(new NamedTerminal(name));
                }
                this.blackTerminals.addAll(CodeGenerator.this.dfa.getTerminals());
                this.blackTerminals.removeAll(this.whiteTerminals());
            }
            return this.blackTerminals;
        }

        public Set typeNonterminals() {
            if (this.typeNonterminals == null) {
                this.typeNonterminals = new LinkedHashSet();
                Iterator it0 = CodeGenerator.this.root.typeDefinitions().iterator();
                while (it0.hasNext()) {
                    Original.TypeDefinition def = (Original.TypeDefinition)it0.next();
                    String name = CodeGenerator.this.root.getCanonicalName(def);
                    this.typeNonterminals.add(new TypeNonterminal(name));
                }
                if (!$assertionsDisabled && !this.typeNonterminals.containsAll(CodeGenerator.this.lrTable.getTypeNonterminals())) {
                    throw new AssertionError();
                }
                this.typeNonterminals.retainAll(CodeGenerator.this.lrTable.getTypeNonterminals());
            }
            return this.typeNonterminals;
        }

        public Set aliasNonterminals() {
            if (this.aliasNonterminals == null) {
                this.aliasNonterminals = new LinkedHashSet();
                Iterator it0 = CodeGenerator.this.root.aliasDefinitions().iterator();
                while (it0.hasNext()) {
                    Original.AliasDefinition def = (Original.AliasDefinition)it0.next();
                    String name = CodeGenerator.this.root.getCanonicalName(def);
                    this.aliasNonterminals.add(new AliasNonterminal(name));
                }
                if (!$assertionsDisabled && !this.aliasNonterminals.containsAll(CodeGenerator.this.lrTable.getAliasNonterminals())) {
                    throw new AssertionError();
                }
                this.aliasNonterminals.retainAll(CodeGenerator.this.lrTable.getAliasNonterminals());
            }
            return this.aliasNonterminals;
        }

        public Set anonymousNonterminals() {
            return CodeGenerator.this.lrTable.getAnonymousNonterminals();
        }

        public Symbol[] symbols() {
            if (this.symbols == null) {
                LinkedHashSet<Terminal> result = new LinkedHashSet<Terminal>();
                result.add(Terminal.EOF);
                this.firstIndexOfWhiteTerminals = result.size();
                result.addAll(this.whiteTerminals());
                this.firstIndexOfBlackTerminals = result.size();
                result.addAll(this.blackTerminals());
                this.firstIndexOfTypeNonterminals = result.size();
                result.addAll(this.typeNonterminals());
                this.firstIndexOfAliasNonterminals = result.size();
                result.addAll(this.aliasNonterminals());
                this.firstIndexOfAnonymousNonterminals = result.size();
                result.addAll(this.anonymousNonterminals());
                this.symbols = result.toArray(new Symbol[result.size()]);
            }
            return this.symbols;
        }

        public int getIndexOfSymbol(Symbol symbol) {
            if (this.symbolToIndexInteger == null) {
                this.symbolToIndexInteger = new HashMap();
                Symbol[] symbols = this.symbols();
                int i = 0;
                while (i < symbols.length) {
                    this.symbolToIndexInteger.put(symbols[i], new Integer(i));
                    ++i;
                }
            }
            Integer integer = (Integer)this.symbolToIndexInteger.get(symbol);
            return integer;
        }

        public int firstIndexOfWhiteTerminals() {
            this.symbols();
            if (!$assertionsDisabled && this.firstIndexOfWhiteTerminals == -1) {
                throw new AssertionError();
            }
            return this.firstIndexOfWhiteTerminals;
        }

        public int superiorIndexOfWhiteTerminals() {
            return this.firstIndexOfBlackTerminals();
        }

        public int firstIndexOfBlackTerminals() {
            this.symbols();
            if (!$assertionsDisabled && this.firstIndexOfBlackTerminals == -1) {
                throw new AssertionError();
            }
            return this.firstIndexOfBlackTerminals;
        }

        public int superiorIndexOfTerminals() {
            return this.superiorIndexOfBlackTerminals();
        }

        public int superiorIndexOfBlackTerminals() {
            return this.firstIndexOfTypeNonterminals();
        }

        public int firstIndexOfTypeNonterminals() {
            this.symbols();
            if (!$assertionsDisabled && this.firstIndexOfTypeNonterminals == -1) {
                throw new AssertionError();
            }
            return this.firstIndexOfTypeNonterminals;
        }

        public int superiorIndexOfClassNonterminals() {
            return this.firstIndexOfAliasNonterminals();
        }

        public int firstIndexOfAliasNonterminals() {
            this.symbols();
            if (!$assertionsDisabled && this.firstIndexOfAliasNonterminals == -1) {
                throw new AssertionError();
            }
            return this.firstIndexOfAliasNonterminals;
        }

        public int superiorIndexOfAliasNonterminals() {
            return this.firstIndexOfAnonymousNonterminals();
        }

        public int firstIndexOfAnonymousNonterminals() {
            this.symbols();
            if (!$assertionsDisabled && this.firstIndexOfAnonymousNonterminals == -1) {
                throw new AssertionError();
            }
            return this.firstIndexOfAnonymousNonterminals;
        }

        public int superiorIndexOfAnonymousNonterminals() {
            return this.symbols().length;
        }

        public LRTable.Reduction[] reductions() {
            if (this.reductions == null) {
                Set tmp = CodeGenerator.this.lrTable.getReductions();
                this.reductions = tmp.toArray(new LRTable.Reduction[tmp.size()]);
            }
            return this.reductions;
        }

        public int getIndexOfReduction(LRTable.Reduction reduction) {
            if (this.reductionToIndexNumber == null) {
                this.reductionToIndexNumber = new HashMap();
                LRTable.Reduction[] reductions = this.reductions();
                int i = 0;
                while (i < reductions.length) {
                    this.reductionToIndexNumber.put(reductions[i], new Integer(i));
                    ++i;
                }
            }
            Integer result = (Integer)this.reductionToIndexNumber.get(reduction);
            return result;
        }

        public String[] labels() {
            if (this.labels == null) {
                TreeSet tmp = new TreeSet();
                LRTable.Reduction[] reductions = this.reductions();
                int i = 0;
                while (i < reductions.length) {
                    LRTable.Reduction reduction = reductions[i];
                    Iterator it1 = reduction.labelSetList().iterator();
                    while (it1.hasNext()) {
                        Set labelSet = (Set)it1.next();
                        tmp.addAll(labelSet);
                    }
                    ++i;
                }
                tmp.remove("$label");
                ArrayList<String> result = new ArrayList<String>(tmp.size() + 1);
                result.add("$label");
                result.addAll(tmp);
                this.labels = result.toArray(new String[result.size()]);
            }
            return this.labels;
        }

        public int getIndexOfLabel(String label) {
            if (this.labelToIndexNumber == null) {
                this.labelToIndexNumber = new HashMap();
                String[] labels = this.labels();
                int i = 0;
                while (i < labels.length) {
                    this.labelToIndexNumber.put(labels[i], new Integer(i));
                    ++i;
                }
            }
            Integer result = (Integer)this.labelToIndexNumber.get(label);
            return result;
        }

        public int labelWordCount() {
            return (this.labels().length + 31) / 32;
        }

        public LRTable.LRState[] lrStates() {
            if (this.lrStates == null) {
                LinkedHashSet<LRTable.LRState> result = new LinkedHashSet<LRTable.LRState>(CodeGenerator.this.lrTable.states().size());
                result.add(CodeGenerator.this.lrTable.finalState());
                result.addAll(CodeGenerator.this.lrTable.symbolToInitialState().values());
                result.addAll(CodeGenerator.this.lrTable.states());
                this.lrStates = result.toArray(new LRTable.LRState[result.size()]);
            }
            return this.lrStates;
        }

        public int getIndexOfState(LRTable.LRState state) {
            if (this.lrStateToIndexNumber == null) {
                this.lrStateToIndexNumber = new HashMap();
                LRTable.LRState[] lrStates = this.lrStates();
                int i = 0;
                while (i < lrStates.length) {
                    this.lrStateToIndexNumber.put(lrStates[i], new Integer(i));
                    ++i;
                }
            }
            Integer result = (Integer)this.lrStateToIndexNumber.get(state);
            return result;
        }

        public Map getMapTeminalToNextState(LRTable.LRState state) {
            LinkedHashMap<Symbol, LRTable.LRState> result = (LinkedHashMap<Symbol, LRTable.LRState>)this.lrStateToMapTeminalToNextState.get(state);
            if (result == null) {
                TreeMap<Integer, LRTable.LRState> map = new TreeMap<Integer, LRTable.LRState>();
                Iterator it3 = state.symbolToNextState().entrySet().iterator();
                while (it3.hasNext()) {
                    Map.Entry entry = it3.next();
                    Symbol symbol = (Symbol)entry.getKey();
                    LRTable.LRState s = (LRTable.LRState)entry.getValue();
                    if (!(symbol instanceof Terminal)) continue;
                    int index = this.getIndexOfSymbol(symbol);
                    map.put(new Integer(index), s);
                }
                result = new LinkedHashMap<Symbol, LRTable.LRState>();
                Iterator it4 = map.entrySet().iterator();
                while (it4.hasNext()) {
                    Map.Entry entry = it4.next();
                    Integer index = (Integer)entry.getKey();
                    LRTable.LRState s = (LRTable.LRState)entry.getValue();
                    result.put(this.symbols()[index], s);
                }
                this.lrStateToMapTeminalToNextState.put(state, result);
            }
            return result;
        }

        public Map getMapNonteminalToNextState(LRTable.LRState state) {
            LinkedHashMap<Symbol, LRTable.LRState> result = (LinkedHashMap<Symbol, LRTable.LRState>)this.lrStateToMapNonteminalToNextState.get(state);
            if (result == null) {
                TreeMap<Integer, LRTable.LRState> map = new TreeMap<Integer, LRTable.LRState>();
                Iterator it3 = state.symbolToNextState().entrySet().iterator();
                while (it3.hasNext()) {
                    Map.Entry entry = it3.next();
                    Symbol symbol = (Symbol)entry.getKey();
                    LRTable.LRState s = (LRTable.LRState)entry.getValue();
                    if (!(symbol instanceof Nonterminal)) continue;
                    int index = this.getIndexOfSymbol(symbol);
                    map.put(new Integer(index), s);
                }
                result = new LinkedHashMap<Symbol, LRTable.LRState>();
                Iterator it4 = map.entrySet().iterator();
                while (it4.hasNext()) {
                    Map.Entry entry = it4.next();
                    Integer index = (Integer)entry.getKey();
                    LRTable.LRState s = (LRTable.LRState)entry.getValue();
                    result.put(this.symbols()[index], s);
                }
                this.lrStateToMapNonteminalToNextState.put(state, result);
            }
            return result;
        }

        public Map getMapSymbolToReduction(LRTable.LRState state) {
            LinkedHashMap<Symbol, Set> result = (LinkedHashMap<Symbol, Set>)this.lrStateToMapSymbolToReduction.get(state);
            if (result == null) {
                TreeMap<Integer, Set> map = new TreeMap<Integer, Set>();
                Iterator it3 = state.symbolToReductions().entrySet().iterator();
                while (it3.hasNext()) {
                    Map.Entry entry = it3.next();
                    Symbol symbol = (Symbol)entry.getKey();
                    Set reductions = (Set)entry.getValue();
                    int index = this.getIndexOfSymbol(symbol);
                    map.put(new Integer(index), reductions);
                }
                result = new LinkedHashMap<Symbol, Set>();
                Iterator it4 = map.entrySet().iterator();
                while (it4.hasNext()) {
                    Map.Entry entry = it4.next();
                    Integer index = (Integer)entry.getKey();
                    Set reductions = (Set)entry.getValue();
                    result.put(this.symbols()[index], reductions);
                }
                this.lrStateToMapSymbolToReduction.put(state, result);
            }
            return result;
        }

        public String[] tags() {
            if (this.tags == null) {
                TreeSet<String> tmp = new TreeSet<String>();
                this.tagToTaggedStates = new MultiMap();
                LRTable.LRState[] lrStates = this.lrStates();
                int i = 0;
                while (i < lrStates.length) {
                    LRTable.LRState lrState = lrStates[i];
                    if (lrState.tag() != null) {
                        String tag = lrState.tag().getImage();
                        tmp.add(tag);
                        this.tagToTaggedStates.add(tag, lrState);
                    }
                    ++i;
                }
                this.tags = tmp.toArray(new String[tmp.size()]);
            }
            return this.tags;
        }

        public int getIndexOfTag(String tag) {
            if (this.tagToIndexNumber == null) {
                this.tagToIndexNumber = new HashMap();
                String[] tags = this.tags();
                int i = 0;
                while (i < tags.length) {
                    this.tagToIndexNumber.put(tags[i], new Integer(i));
                    ++i;
                }
            }
            Integer result = (Integer)this.tagToIndexNumber.get(tag);
            return result;
        }

        public Set getTaggedStates(String tag) {
            if (this.tagToTaggedStates == null) {
                this.tags();
            }
            return this.tagToTaggedStates.getValueSet(tag);
        }

        public Set types() {
            if (this.types == null) {
                this.types = new LinkedHashSet(CodeGenerator.this.typeSystem.getMapNameToType().values());
            }
            return this.types;
        }

        public Set userDefinedTypes() {
            if (this.userDefinedTypes == null) {
                this.userDefinedTypes = new LinkedHashSet();
                Iterator it2 = this.types().iterator();
                while (it2.hasNext()) {
                    Type type = (Type)it2.next();
                    if (!(type instanceof UserDefinedType)) continue;
                    this.userDefinedTypes.add(type);
                }
            }
            return this.userDefinedTypes;
        }

        static {
            $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$generator$CodeGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$generator$CodeGenerator = CodeGenerator.class$("jp.gr.java_conf.koto.notavacc.generator.CodeGenerator")) : class$jp$gr$java_conf$koto$notavacc$generator$CodeGenerator).desiredAssertionStatus();
        }
    }
}

