/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.notavacc.dfa;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedMap;
import jp.gr.java_conf.koto.notavacc.lrg.Terminal;
import jp.gr.java_conf.koto.notavacc.parser.Original;

public abstract class DeterministicFiniteAutomaton {
    private Set states = null;
    private Set terminals = null;

    public abstract DFAState initialState();

    public abstract Terminal getTerminal(Original.StringExpression var1);

    public final Set states() {
        if (this.states == null) {
            this.states = new LinkedHashSet();
            this.getStates(this.states, this.initialState());
        }
        return this.states;
    }

    private void getStates(Set result, DFAState state) {
        if (result.add(state)) {
            Iterator it0 = state.getMapInputToNextStates().values().iterator();
            while (it0.hasNext()) {
                DFAState s = (DFAState)it0.next();
                this.getStates(result, s);
            }
        }
    }

    public final Set getTerminals() {
        if (this.terminals == null) {
            this.terminals = new LinkedHashSet();
            Iterator it1 = this.states().iterator();
            while (it1.hasNext()) {
                DFAState state = (DFAState)it1.next();
                if (state.hitSymbol() == null) continue;
                this.terminals.add(state.hitSymbol());
            }
        }
        return this.terminals;
    }

    public static interface DFAState {
        public Terminal hitSymbol();

        public SortedMap getMapInputToNextStates();
    }
}

