/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.notavacc.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.gr.java_conf.koto.notavacc.Environment;
import jp.gr.java_conf.koto.notavacc.Module;
import jp.gr.java_conf.koto.notavacc.dfa.DFAInput;
import jp.gr.java_conf.koto.notavacc.dfa.DeterministicFiniteAutomaton;
import jp.gr.java_conf.koto.notavacc.lrg.NamedTerminal;
import jp.gr.java_conf.koto.notavacc.lrg.StringTerminal;
import jp.gr.java_conf.koto.notavacc.lrg.Terminal;
import jp.gr.java_conf.koto.notavacc.parser.Original;
import jp.gr.java_conf.koto.notavacc.parser.Parser;
import jp.gr.java_conf.koto.notavacc.util.MultiMap;
import jp.gr.java_conf.koto.notavacc.util.TreeStackSet;

public class DFAGenerator
extends Module {
    private Parser.Root root;
    public static final SortedMap EMPTY_SORTED_MAP;
    static /* synthetic */ Class class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator;
    static /* synthetic */ Class class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator$WrapState;
    static /* synthetic */ Class class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator$IntersectionState;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DFAGenerator(Environment env) {
        super(env);
    }

    public DeterministicFiniteAutomaton generate(final Parser.Root root) {
        this.root = root;
        this.logger.verbose(this.environment.processingFile, "generating DFA.");
        this.rejectSelfEmbedding(root.subtokenDefinitions());
        if (this.logger.hasError()) {
            this.logger.fatal();
        }
        final MultiMap definitionToInitialState = new MultiMap();
        Iterator it1 = root.tokenDefinitions().iterator();
        while (it1.hasNext()) {
            Original.TokenDefinition def = (Original.TokenDefinition)it1.next();
            definitionToInitialState.add(def, this.makeInitialState(def.expression()));
        }
        LinkedHashSet<Original.Expression> targetExpressions = new LinkedHashSet<Original.Expression>();
        Iterator it11 = root.aliasDefinitions().iterator();
        while (it11.hasNext()) {
            Original.AliasDefinition def = (Original.AliasDefinition)it11.next();
            targetExpressions.add(def.expression());
        }
        Iterator it12 = root.typeDefinitions().iterator();
        while (it12.hasNext()) {
            Original.TypeDefinition def = (Original.TypeDefinition)it12.next();
            if (def.abstractKeyword() != null) continue;
            targetExpressions.add(def.expression());
        }
        final HashSet done = new HashSet();
        Iterator it13 = targetExpressions.iterator();
        while (it13.hasNext()) {
            Original.Expression expression = (Original.Expression)it13.next();
            expression.accept(new Original.Visitor(){

                public void visit(Original.Node node) {
                    Original.StringExpression exp;
                    Original.StringLiteral string;
                    String value;
                    if (node instanceof Original.StringExpression && done.add(value = root.getValue(string = (exp = (Original.StringExpression)node).string()))) {
                        StringState state = new StringState(value);
                        definitionToInitialState.add(exp, state);
                    }
                }
            });
        }
        WrapState initialState = new WrapState(definitionToInitialState);
        LinkedHashMap stringToNamedTerminal = new LinkedHashMap();
        Map stateToHitSymbol = this.getMapStateToHitSymbol(initialState, stringToNamedTerminal);
        this.logger.verbose(this.environment.processingFile, "generated.  {0} states.", (Object)new Integer(stateToHitSymbol.size()));
        this.logger.verbose(this.environment.processingFile, "building the minimal form.");
        DFA result = this.buildMinimalForm(initialState, stateToHitSymbol, stringToNamedTerminal);
        this.logger.verbose(this.environment.processingFile, "built.  {0} states.", (Object)new Integer(result.states().size()));
        if (this.logger.verboseLevel() >= 5) {
            this.logger.verbosest(this.environment.processingFile, "----DFA States Report----");
            this.logger.verbosest("    initial state = {0}", result.initialState());
            Iterator it9 = result.states().iterator();
            while (it9.hasNext()) {
                DFAState state = (DFAState)it9.next();
                this.logger.verbosest("-- {0} --", state);
                if (state.hitSymbol != null) {
                    this.logger.verbosest("hit {0}", state.hitSymbol);
                }
                Iterator it10 = state.mapInputToNextStates.entrySet().iterator();
                while (it10.hasNext()) {
                    Map.Entry entry = it10.next();
                    DFAInput input = (DFAInput)entry.getKey();
                    DFAState nextState = (DFAState)entry.getValue();
                    this.logger.verbosest("    {0} ==> x{1}", input, (Object)nextState);
                }
            }
        }
        return result;
    }

    private void rejectSelfEmbedding(List definitions) {
        HashSet reportedDefinitions = new HashSet();
        Iterator it0 = definitions.iterator();
        while (it0.hasNext()) {
            Original.SubtokenDefinition def = (Original.SubtokenDefinition)it0.next();
            this.rejectSelfEmbedding(def, TreeStackSet.EMPTY_SET, reportedDefinitions);
        }
    }

    private void rejectSelfEmbedding(Original.SubtokenDefinition definition, final TreeStackSet openedDefinitions, final Set reportedDefinitions) {
        definition.accept(new Original.Visitor(){

            public void visit(Original.Node node) {
                if (node instanceof Original.IdentifierTokenExpression) {
                    Original.IdentifierTokenExpression ite = (Original.IdentifierTokenExpression)node;
                    Original.SubtokenDefinition def = DFAGenerator.this.root.getDefinition(ite.name());
                    TreeStackSet openedDefs = TreeStackSet.push(openedDefinitions, def);
                    if (openedDefs.size() == openedDefinitions.size() && reportedDefinitions.add(def)) {
                        DFAGenerator.this.logger.error("The terminal {0} is defined using itself {1}.", def.identifier(), (Object)ite.name().identifier());
                    }
                    DFAGenerator.this.rejectSelfEmbedding(def, openedDefs, reportedDefinitions);
                }
            }
        });
    }

    public static SortedMap singletonSortedMap(Object key, Object value) {
        TreeMap<Object, Object> result = new TreeMap<Object, Object>();
        result.put(key, value);
        return result;
    }

    public static MultiMap singletonMultiMap(Object key, Collection values) {
        MultiMap result = new MultiMap();
        result.put(key, new LinkedHashSet(values));
        return result;
    }

    private static DeterministicState toDeterministicState(NondeterministicState ns) {
        if (ns instanceof DeterministicState) {
            return (DeterministicState)ns;
        }
        return new WrapState(ns);
    }

    private NondeterministicState makeInitialState(Original.TokenExpression expression) {
        if (expression instanceof Original.SelectiveTokenExpression) {
            Original.SelectiveTokenExpression exp = (Original.SelectiveTokenExpression)expression;
            if (exp.operands().size() == 0) {
                return FinalState.INSTANCE;
            }
            if (exp.operands().size() == 1) {
                return this.makeInitialState((Original.TokenExpression)exp.operands().iterator().next());
            }
            LinkedHashSet<NondeterministicState> initialStates = new LinkedHashSet<NondeterministicState>();
            Iterator it = exp.operands().iterator();
            while (it.hasNext()) {
                Original.TokenExpression sub = (Original.TokenExpression)it.next();
                initialStates.add(this.makeInitialState(sub));
            }
            return new WrapState(initialStates);
        }
        if (expression instanceof Original.IntersectionTokenExpression) {
            Original.IntersectionTokenExpression exp;
            LinkedHashSet<NondeterministicState> substates = new LinkedHashSet<NondeterministicState>();
            do {
                exp = (Original.IntersectionTokenExpression)expression;
                substates.add(this.makeInitialState(exp.rhs()));
            } while ((expression = exp.lhs()) instanceof Original.IntersectionTokenExpression);
            substates.add(this.makeInitialState(expression));
            return new IntersectionState(substates);
        }
        if (expression instanceof Original.SequentialTokenExpression) {
            Original.SequentialTokenExpression exp = (Original.SequentialTokenExpression)expression;
            if (exp.operands().size() == 0) {
                return FinalState.INSTANCE;
            }
            if (exp.operands().size() == 1) {
                return this.makeInitialState((Original.TokenExpression)exp.operands().iterator().next());
            }
            return new SequentialState(exp.operands());
        }
        if (expression instanceof Original.ComplementaryTokenExpression) {
            Original.ComplementaryTokenExpression exp = (Original.ComplementaryTokenExpression)expression;
            return new ComplementaryState(this.makeInitialState(exp.operand()));
        }
        if (expression instanceof Original.PlusTokenExpression) {
            Original.PlusTokenExpression exp = (Original.PlusTokenExpression)expression;
            return new PlusState(this.makeInitialState(exp.operand()));
        }
        if (expression instanceof Original.IdentifierTokenExpression) {
            Original.IdentifierTokenExpression exp = (Original.IdentifierTokenExpression)expression;
            Original.TokenExpression te = this.root.getDefinition(exp.name()).expression();
            return this.makeInitialState(te);
        }
        if (expression instanceof Original.StringTokenExpression) {
            Original.StringTokenExpression exp = (Original.StringTokenExpression)expression;
            Original.StringLiteral sl = exp.string();
            return new StringState(this.root.getValue(sl));
        }
        if (!$assertionsDisabled && !(expression instanceof Original.CharacterRangeTokenExpression)) {
            throw new AssertionError();
        }
        Original.CharacterRangeTokenExpression exp = (Original.CharacterRangeTokenExpression)expression;
        Original.CharacterLiteral lower = exp.lower();
        Original.CharacterLiteral upper = exp.upper();
        return new CharacterState(this.root.getValue(lower), this.root.getValue(upper));
    }

    private Map getMapStateToHitSymbol(WrapState initialState, Map stringToNamedTerminal) {
        Map.Entry entry;
        Iterator it2 = initialState.labels().iterator();
        while (it2.hasNext()) {
            Original.Node def;
            Object definition = it2.next();
            if (!initialState.isFinal(definition)) continue;
            if (definition instanceof Original.TokenDefinition) {
                def = (Original.TokenDefinition)definition;
                this.logger.error("The terminal {0} should not match the empty string.", def.identifier());
                continue;
            }
            def = (Original.StringExpression)definition;
            this.logger.error("The terminal {0} should not be the empty string.", def.string().token());
        }
        MultiMap definitionToFinalStates = new MultiMap();
        LinkedHashMap result = new LinkedHashMap();
        LinkedList<WrapState> undone = new LinkedList<WrapState>();
        undone.add(initialState);
        while (!undone.isEmpty()) {
            WrapState state = (WrapState)undone.removeFirst();
            if (result.containsKey(state)) continue;
            result.put(state, null);
            Iterator it = state.labels().iterator();
            while (it.hasNext()) {
                Object definition = it.next();
                if (!state.isFinal(definition)) continue;
                definitionToFinalStates.add(definition, state);
            }
            undone.addAll(state.getMapInputToNextState().values());
        }
        MultiMap finalStateSetToDefinitions = new MultiMap();
        Iterator it4 = definitionToFinalStates.entrySet().iterator();
        while (it4.hasNext()) {
            entry = it4.next();
            finalStateSetToDefinitions.add(entry.getValue(), entry.getKey());
        }
        Iterator it6 = finalStateSetToDefinitions.values().iterator();
        while (it6.hasNext()) {
            Original.StringExpression stringExpression;
            Original.TokenDefinition tokenDefinition;
            Set definitions = (Set)it6.next();
            if (definitions.size() != 2) continue;
            Iterator it = definitions.iterator();
            Object d = it.next();
            if (d instanceof Original.TokenDefinition) {
                tokenDefinition = (Original.TokenDefinition)d;
                stringExpression = (Original.StringExpression)it.next();
            } else {
                stringExpression = (Original.StringExpression)d;
                tokenDefinition = (Original.TokenDefinition)it.next();
            }
            String string = this.root.getValue(stringExpression.string());
            NamedTerminal symbol = new NamedTerminal(this.root.getCanonicalName(tokenDefinition));
            stringToNamedTerminal.put(string, symbol);
        }
        HashSet errorReportedDefinitionSets = new HashSet();
        Iterator outer = result.entrySet().iterator();
        while (outer.hasNext()) {
            Terminal hitSymbol;
            Original.Node def;
            Object definition;
            entry = outer.next();
            WrapState state = (WrapState)entry.getKey();
            if (!state.isFinal()) {
                entry.setValue(null);
                continue;
            }
            LinkedHashSet definitions = new LinkedHashSet(state.labels());
            Iterator inner = definitions.iterator();
            while (inner.hasNext()) {
                Original.StringExpression exp;
                String str;
                definition = inner.next();
                if (!state.isFinal(definition)) {
                    inner.remove();
                    continue;
                }
                if (!(definition instanceof Original.StringExpression) || !stringToNamedTerminal.containsKey(str = this.root.getValue((exp = (Original.StringExpression)definition).string()))) continue;
                inner.remove();
            }
            if (!$assertionsDisabled && definitions.isEmpty()) {
                throw new AssertionError();
            }
            if (definitions.size() > 1 && errorReportedDefinitionSets.add(definitions) && !state.equals(initialState)) {
                boolean first = true;
                Iterator it3 = definitions.iterator();
                while (it3.hasNext()) {
                    Original.Token token;
                    Original.Node def2;
                    Object definition2 = it3.next();
                    if (definition2 instanceof Original.TokenDefinition) {
                        def2 = (Original.TokenDefinition)definition2;
                        token = def2.identifier();
                    } else {
                        def2 = (Original.StringExpression)definition2;
                        token = def2.string().token();
                    }
                    if (first) {
                        this.logger.error("The followings match the same string.", token);
                        first = false;
                    }
                    this.logger.error("        {0}", token);
                }
            }
            if ((definition = definitions.iterator().next()) instanceof Original.TokenDefinition) {
                def = (Original.TokenDefinition)definition;
                hitSymbol = new NamedTerminal(this.root.getCanonicalName((Original.Definition)def));
                entry.setValue((NamedTerminal)hitSymbol);
                continue;
            }
            def = (Original.StringExpression)definition;
            hitSymbol = new StringTerminal(this.root.getValue(def.string()));
            entry.setValue((NamedTerminal)hitSymbol);
        }
        return result;
    }

    private DFA buildMinimalForm(DeterministicState initialState, Map stateToHitSymbol, Map stringToNamedTerminal) {
        DeterministicState nextState;
        DFAInput input;
        Map.Entry entry;
        DeterministicState state;
        ArrayList<List> groups = new ArrayList<List>(stateToHitSymbol.size());
        HashMap<DeterministicState, Integer> stateToGroupID = new HashMap<DeterministicState, Integer>();
        HashMap<Terminal, Integer> hitSymbolToGroupID = new HashMap<Terminal, Integer>();
        hitSymbolToGroupID.put(null, new Integer(0));
        groups.add(new LinkedList<DeadState>(Collections.singleton(DeadState.INSTANCE)));
        stateToGroupID.put(DeadState.INSTANCE, new Integer(0));
        Iterator it5 = stateToHitSymbol.entrySet().iterator();
        while (it5.hasNext()) {
            Map.Entry entry2 = it5.next();
            DeterministicState state2 = (DeterministicState)entry2.getKey();
            Terminal hitSymbol = (Terminal)entry2.getValue();
            Integer groupID = (Integer)hitSymbolToGroupID.get(hitSymbol);
            if (groupID == null) {
                groupID = new Integer(groups.size());
                groups.add(new LinkedList());
                hitSymbolToGroupID.put(hitSymbol, groupID);
            }
            List group = (List)groups.get(groupID);
            group.add(state2);
            stateToGroupID.put(state2, groupID);
        }
        int lastMoodifiedIndex = -1;
        int index = 0;
        while (true) {
            if (index >= groups.size()) {
                if (lastMoodifiedIndex == -1) break;
                index -= groups.size();
            }
            if (index == lastMoodifiedIndex) break;
            List group = (List)groups.get(index);
            if (!$assertionsDisabled && group.isEmpty()) {
                throw new AssertionError();
            }
            if (group.size() <= 1) {
                if (index == lastMoodifiedIndex) {
                    break;
                }
            } else {
                LinkedHashMap keyToStateList = new LinkedHashMap();
                Iterator it = group.iterator();
                while (it.hasNext()) {
                    LinkedList<DeterministicState> list;
                    state = (DeterministicState)it.next();
                    SortedMap key = new TreeMap();
                    int prevUpper = -1;
                    Iterator it7 = state.getMapInputToNextState().entrySet().iterator();
                    while (it7.hasNext()) {
                        entry = it7.next();
                        input = (DFAInput)entry.getKey();
                        nextState = (DeterministicState)entry.getValue();
                        if (input.lower > prevUpper + 1) {
                            key.put(new DFAInput(prevUpper + 1, input.lower - '\u0001'), stateToGroupID.get(DeadState.INSTANCE));
                        }
                        key.put(input, stateToGroupID.get(nextState));
                        prevUpper = input.upper;
                    }
                    if (prevUpper < 65535) {
                        key.put(new DFAInput(prevUpper + 1, 65535), stateToGroupID.get(DeadState.INSTANCE));
                    }
                    if ((list = (LinkedList<DeterministicState>)keyToStateList.get(key = this.minimizeMap(key))) == null) {
                        list = new LinkedList<DeterministicState>();
                        keyToStateList.put(key, list);
                    }
                    list.add(state);
                }
                if (keyToStateList.size() <= 1) {
                    if (index == lastMoodifiedIndex) {
                        break;
                    }
                } else {
                    lastMoodifiedIndex = index;
                    Iterator outer = keyToStateList.values().iterator();
                    while (outer.hasNext()) {
                        List newGroup = (List)outer.next();
                        if (outer.hasNext()) {
                            Integer newID = new Integer(groups.size());
                            Iterator inner = newGroup.iterator();
                            while (inner.hasNext()) {
                                DeterministicState state3 = (DeterministicState)inner.next();
                                stateToGroupID.put(state3, newID);
                            }
                            groups.add(newGroup);
                            continue;
                        }
                        groups.set(index, newGroup);
                    }
                }
            }
            ++index;
        }
        Integer deadIndexInteger = (Integer)stateToGroupID.get(DeadState.INSTANCE);
        int deadIndex = deadIndexInteger;
        DFAState[] states = new DFAState[groups.size()];
        int i = 0;
        while (i < states.length) {
            if (i != deadIndex) {
                List group = (List)groups.get(i);
                state = (DeterministicState)group.get(0);
                states[i] = new DFAState((Terminal)stateToHitSymbol.get(state));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < states.length) {
            if (i2 != deadIndex) {
                List group = (List)groups.get(i2);
                DeterministicState state4 = (DeterministicState)group.get(0);
                DFAState newState = states[i2];
                Iterator it8 = state4.getMapInputToNextState().entrySet().iterator();
                while (it8.hasNext()) {
                    entry = it8.next();
                    input = (DFAInput)entry.getKey();
                    nextState = (DeterministicState)entry.getValue();
                    Integer index2 = (Integer)stateToGroupID.get(nextState);
                    if (index2 == deadIndex) continue;
                    newState.mapInputToNextStates.put(input, states[index2]);
                }
                newState.mapInputToNextStates = this.minimizeMap(newState.mapInputToNextStates);
            }
            ++i2;
        }
        Integer initialIndexInteger = (Integer)stateToGroupID.get(initialState);
        int initialIndex = initialIndexInteger;
        DFAState resultInitialState = states[initialIndex];
        if (resultInitialState == null) {
            resultInitialState = new DFAState(null);
        }
        return new DFA(this.root, resultInitialState, stringToNamedTerminal);
    }

    private SortedMap minimizeMap(SortedMap inputToObject) {
        if (inputToObject.size() <= 1) {
            return inputToObject;
        }
        TreeMap result = new TreeMap();
        Iterator it = inputToObject.entrySet().iterator();
        Map.Entry entry = it.next();
        DFAInput input = (DFAInput)entry.getKey();
        Object previousValue = entry.getValue();
        char previousLower = input.lower;
        char previousUpper = input.upper;
        while (it.hasNext()) {
            entry = it.next();
            input = (DFAInput)entry.getKey();
            Object value = entry.getValue();
            if (input.lower > previousUpper + '\u0001' || !(previousValue != null ? previousValue.equals(value) : value == null)) {
                result.put(new DFAInput(previousLower, previousUpper), previousValue);
                previousValue = value;
                previousLower = input.lower;
                previousUpper = input.upper;
                continue;
            }
            previousUpper = input.upper;
        }
        result.put(new DFAInput(previousLower, previousUpper), previousValue);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator = DFAGenerator.class$("jp.gr.java_conf.koto.notavacc.dfa.DFAGenerator")) : class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator).desiredAssertionStatus();
        EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    }

    private static class CharacterState
    extends DeterministicState {
        private final int lower;
        private final int upper;
        static final /* synthetic */ boolean $assertionsDisabled;

        public CharacterState(int lower, int upper) {
            if (!($assertionsDisabled || 0 <= lower && lower <= 65535)) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || 0 <= upper && upper <= 65535)) {
                throw new AssertionError();
            }
            this.lower = lower;
            this.upper = upper;
        }

        public int hashCodeOnce() {
            return this.lower << 16 | this.upper;
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (rhs instanceof CharacterState) {
                return this.equals((CharacterState)rhs);
            }
            return false;
        }

        public boolean equals(CharacterState rhs) {
            return this.lower == rhs.lower && this.upper == rhs.upper;
        }

        public boolean isFinal() {
            return false;
        }

        public SortedMap getMapInputToNextStateOnce() {
            return DFAGenerator.singletonSortedMap(new DFAInput(this.lower, this.upper), FinalState.INSTANCE);
        }

        static {
            $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator = DFAGenerator.class$("jp.gr.java_conf.koto.notavacc.dfa.DFAGenerator")) : class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator).desiredAssertionStatus();
        }
    }

    private static class StringState
    extends DeterministicState {
        private final String string;
        private final int index;

        public StringState(String string) {
            this(string, 0);
        }

        public StringState(String string, int index) {
            this.string = string;
            this.index = index;
        }

        public int hashCodeOnce() {
            return this.string.hashCode() + this.index;
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (rhs instanceof StringState) {
                return this.equals((StringState)rhs);
            }
            return false;
        }

        public boolean equals(StringState rhs) {
            return this.string.equals(rhs.string) && this.index == rhs.index;
        }

        public boolean isFinal() {
            return this.index >= this.string.length();
        }

        public SortedMap getMapInputToNextStateOnce() {
            if (this.index >= this.string.length()) {
                return EMPTY_SORTED_MAP;
            }
            char ch = this.string.charAt(this.index);
            return DFAGenerator.singletonSortedMap(new DFAInput(ch, ch), new StringState(this.string, this.index + 1));
        }

        public String toString() {
            return "StringState('" + this.string + "', " + this.index + ")";
        }
    }

    private static final class PlusState
    extends NondeterministicState {
        private final DeterministicState initialSubstate;
        private final DeterministicState substate;
        private SortedMap mapInputToNextStates = null;

        public PlusState(NondeterministicState substate) {
            this(DFAGenerator.toDeterministicState(substate));
        }

        private PlusState(DeterministicState initialSubstate) {
            this(initialSubstate, initialSubstate);
        }

        private PlusState(DeterministicState initialSubstate, DeterministicState substate) {
            this.initialSubstate = initialSubstate;
            this.substate = substate;
        }

        public int hashCodeOnce() {
            return this.getClass().getName().hashCode() + this.initialSubstate.hashCode() + (this.substate == null ? 0 : this.substate.hashCode());
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (this.getClass().equals(rhs.getClass())) {
                return this.equals((PlusState)rhs);
            }
            return false;
        }

        public boolean equals(PlusState rhs) {
            return this.initialSubstate.equals(rhs.initialSubstate) && (this.substate == null ? this.substate == rhs.substate : this.substate.equals(rhs.substate));
        }

        public boolean isFinal() {
            return this.substate == null;
        }

        public SortedMap getMapInputToNextStates() {
            if (this.mapInputToNextStates == null) {
                this.mapInputToNextStates = new TreeMap();
                if (this.substate != null) {
                    Iterator it = this.substate.getMapInputToNextState().entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        DFAInput input = (DFAInput)entry.getKey();
                        DeterministicState nextSubstate = (DeterministicState)entry.getValue();
                        PlusState nextState = new PlusState(this.initialSubstate, nextSubstate);
                        this.mapInputToNextStates.put(input, Collections.singleton(nextState));
                    }
                }
            }
            return this.mapInputToNextStates;
        }

        public Set getEpsilonMovedStates() {
            if (this.substate == null) {
                return Collections.singleton(new PlusState(this.initialSubstate));
            }
            if (this.substate.isFinal()) {
                return Collections.singleton(new PlusState(this.initialSubstate, null));
            }
            return Collections.EMPTY_SET;
        }
    }

    private class SequentialState
    extends NondeterministicState {
        private final List expressions;
        private final int index;
        private final DeterministicState substate;

        public SequentialState(List expressions) {
            this(expressions, 0);
        }

        public SequentialState(List expressions, int index) {
            this.expressions = expressions instanceof RandomAccess ? expressions : new ArrayList(expressions);
            this.index = index;
            this.substate = DFAGenerator.toDeterministicState(DFAGenerator.this.makeInitialState((Original.TokenExpression)expressions.get(index)));
        }

        public SequentialState(List expressions, int index, DeterministicState substate) {
            this.expressions = expressions;
            this.index = index;
            this.substate = substate;
        }

        public int hashCodeOnce() {
            return this.getClass().getName().hashCode() + this.expressions.hashCode() + this.index + this.substate.hashCode();
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (this.getClass().equals(rhs.getClass())) {
                return this.equals((SequentialState)rhs);
            }
            return false;
        }

        public boolean equals(SequentialState rhs) {
            return this.expressions.equals(rhs.expressions) && this.index == rhs.index && this.substate.equals(rhs.substate);
        }

        public boolean isFinal() {
            return false;
        }

        public SortedMap getMapInputToNextStates() {
            TreeMap<DFAInput, Set<SequentialState>> result = new TreeMap<DFAInput, Set<SequentialState>>();
            SortedMap map = this.substate.getMapInputToNextState();
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                DFAInput input = (DFAInput)entry.getKey();
                DeterministicState state = (DeterministicState)entry.getValue();
                result.put(input, Collections.singleton(new SequentialState(this.expressions, this.index, state)));
            }
            return result;
        }

        public Set getEpsilonMovedStates() {
            if (this.substate.isFinal()) {
                NondeterministicState state = this.index + 1 < this.expressions.size() ? new SequentialState(this.expressions, this.index + 1) : FinalState.INSTANCE;
                return Collections.singleton(state);
            }
            return Collections.EMPTY_SET;
        }
    }

    private static class ComplementaryState
    extends DeterministicState {
        private final DeterministicState substate;

        public ComplementaryState(NondeterministicState substate) {
            this(DFAGenerator.toDeterministicState(substate));
        }

        public ComplementaryState(DeterministicState substate) {
            this.substate = substate;
        }

        public int hashCodeOnce() {
            return ~this.substate.hashCode();
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (rhs instanceof ComplementaryState) {
                return this.equals((ComplementaryState)rhs);
            }
            return false;
        }

        public boolean equals(ComplementaryState rhs) {
            return this.substate.equals(rhs.substate);
        }

        public boolean isFinal() {
            return !this.substate.isFinal();
        }

        public SortedMap getMapInputToNextStateOnce() {
            TreeMap<DFAInput, DeterministicState> result = new TreeMap<DFAInput, DeterministicState>();
            int lower = 0;
            Iterator it = this.substate.getMapInputToNextState().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                DFAInput input = (DFAInput)entry.getKey();
                DeterministicState state = (DeterministicState)entry.getValue();
                if (lower < input.lower) {
                    result.put(new DFAInput(lower, input.lower - '\u0001'), MatchAnyState.INSTANCE);
                }
                result.put(input, new ComplementaryState(state));
                lower = input.upper + '\u0001';
            }
            if (lower <= 65535) {
                result.put(new DFAInput(lower, 65535), MatchAnyState.INSTANCE);
            }
            return result;
        }
    }

    private static class IntersectionState
    extends WrapState {
        private final Set labels;
        static final /* synthetic */ boolean $assertionsDisabled;

        public IntersectionState(Set substates) {
            super(IntersectionState.initialize(substates));
            this.labels = this.labels();
        }

        private static MultiMap initialize(Set substates) {
            MultiMap labelToStates = new MultiMap();
            int i = 0;
            Iterator it = substates.iterator();
            while (it.hasNext()) {
                NondeterministicState substate = (NondeterministicState)it.next();
                labelToStates.add(new Integer(i++), substate);
            }
            return labelToStates;
        }

        private IntersectionState(Set labels, MultiMap labelToStates) {
            super(labelToStates);
            this.labels = labels;
        }

        public boolean equals(WrapState rhs) {
            return this.equals((IntersectionState)rhs);
        }

        public boolean equals(IntersectionState rhs) {
            return super.equals(rhs) && this.labels.equals(rhs.labels);
        }

        public boolean isFinal() {
            Iterator it = this.labels.iterator();
            while (it.hasNext()) {
                Object label = it.next();
                if (this.isFinal(label)) continue;
                return false;
            }
            return true;
        }

        protected WrapState create(MultiMap labelToStates) {
            if (!$assertionsDisabled && !this.getClass().equals(class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator$IntersectionState == null ? (class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator$IntersectionState = DFAGenerator.class$("jp.gr.java_conf.koto.notavacc.dfa.DFAGenerator$IntersectionState")) : class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator$IntersectionState)) {
                throw new AssertionError();
            }
            return new IntersectionState(this.labels, labelToStates);
        }

        static {
            $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator = DFAGenerator.class$("jp.gr.java_conf.koto.notavacc.dfa.DFAGenerator")) : class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator).desiredAssertionStatus();
        }
    }

    private static class WrapState
    extends DeterministicState {
        private final MultiMap labelToStates;
        private Map labelToFlagFinal = new LinkedHashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        public WrapState(NondeterministicState initialState) {
            this(Collections.singleton(initialState));
        }

        public WrapState(Collection initialStates) {
            this(DFAGenerator.singletonMultiMap(null, initialStates));
        }

        public WrapState(MultiMap labelToStates) {
            this.labelToStates = WrapState.doEpsilonMove(labelToStates);
        }

        public Set labels() {
            Set result = this.labelToStates.keySet();
            if (!$assertionsDisabled && (result = Collections.unmodifiableSet(result)) == null) {
                throw new AssertionError();
            }
            return result;
        }

        public int hashCodeOnce() {
            return this.getClass().getName().hashCode() + this.labelToStates.hashCode();
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (this.getClass().equals(rhs.getClass())) {
                return this.equals((WrapState)rhs);
            }
            return false;
        }

        public boolean equals(WrapState rhs) {
            return this.labelToStates.equals(rhs.labelToStates);
        }

        private static MultiMap doEpsilonMove(MultiMap labelToStates) {
            MultiMap result = new MultiMap();
            Iterator outer = labelToStates.entrySet().iterator();
            while (outer.hasNext()) {
                Map.Entry entry = outer.next();
                Object label = entry.getKey();
                Set states = (Set)entry.getValue();
                LinkedHashSet closure = new LinkedHashSet();
                Iterator inner = states.iterator();
                while (inner.hasNext()) {
                    NondeterministicState state = (NondeterministicState)inner.next();
                    closure.addAll(state.getEpsilonClosure());
                }
                result.put(label, closure);
            }
            return result;
        }

        public boolean isFinal() {
            Iterator it = this.labels().iterator();
            while (it.hasNext()) {
                Object label = it.next();
                if (!this.isFinal(label)) continue;
                return true;
            }
            return false;
        }

        protected boolean isFinal(Object label) {
            Boolean result = (Boolean)this.labelToFlagFinal.get(label);
            if (result == null) {
                result = Boolean.FALSE;
                Set states = (Set)this.labelToStates.get(label);
                if (states != null) {
                    Iterator it = states.iterator();
                    while (it.hasNext()) {
                        NondeterministicState state = (NondeterministicState)it.next();
                        if (!state.isFinal()) continue;
                        result = Boolean.TRUE;
                        break;
                    }
                }
                this.labelToFlagFinal.put(label, result);
            }
            return result;
        }

        protected WrapState create(MultiMap labelToStates) {
            if (!$assertionsDisabled && !this.getClass().equals(class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator$WrapState == null ? (class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator$WrapState = DFAGenerator.class$("jp.gr.java_conf.koto.notavacc.dfa.DFAGenerator$WrapState")) : class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator$WrapState)) {
                throw new AssertionError();
            }
            return new WrapState(labelToStates);
        }

        public SortedMap getMapInputToNextStateOnce() {
            TreeMap<DFAInput, WrapState> result = new TreeMap<DFAInput, WrapState>();
            MultiMap labelToNotes = new MultiMap();
            Iterator outer = this.labelToStates.entrySet().iterator();
            while (outer.hasNext()) {
                Map.Entry entry = outer.next();
                Object label = entry.getKey();
                Set states = (Set)entry.getValue();
                LinkedHashSet<Note> notes = new LinkedHashSet<Note>();
                Iterator inner = states.iterator();
                while (inner.hasNext()) {
                    NondeterministicState state = (NondeterministicState)inner.next();
                    notes.add(new Note(label, state));
                }
                labelToNotes.put(label, notes);
            }
            char lower = '\u0000';
            while (lower <= '\uffff') {
                int upper = 65535;
                MultiMap labelToNextInnerStates = new MultiMap();
                Iterator outer2 = labelToNotes.entrySet().iterator();
                while (outer2.hasNext()) {
                    Map.Entry entry = outer2.next();
                    Object label = entry.getKey();
                    Set notes = (Set)entry.getValue();
                    LinkedHashSet nextInnerStates = new LinkedHashSet();
                    Iterator inner = notes.iterator();
                    block4: while (inner.hasNext()) {
                        Note note = (Note)inner.next();
                        Iterator innest = note.mapEntriesInputToNextStates.iterator();
                        while (innest.hasNext()) {
                            Map.Entry e = (Map.Entry)innest.next();
                            DFAInput input = (DFAInput)e.getKey();
                            Set nextStates = (Set)e.getValue();
                            if (input.lower > lower) {
                                upper = Math.min(upper, input.lower - '\u0001');
                                continue block4;
                            }
                            if (input.upper < lower) {
                                innest.remove();
                                continue;
                            }
                            if (!($assertionsDisabled || input.lower <= lower && lower <= input.upper)) {
                                throw new AssertionError();
                            }
                            upper = Math.min(upper, input.upper);
                            nextInnerStates.addAll(nextStates);
                            continue block4;
                        }
                    }
                    if (nextInnerStates.isEmpty()) continue;
                    labelToNextInnerStates.put(label, nextInnerStates);
                }
                if (!labelToNextInnerStates.isEmpty()) {
                    WrapState state = this.create(labelToNextInnerStates);
                    result.put(new DFAInput(lower, upper), state);
                }
                lower = upper + 1;
            }
            return result;
        }

        static {
            $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator == null ? (class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator = DFAGenerator.class$("jp.gr.java_conf.koto.notavacc.dfa.DFAGenerator")) : class$jp$gr$java_conf$koto$notavacc$dfa$DFAGenerator).desiredAssertionStatus();
        }

        private static class Note {
            public final Object label;
            public final NondeterministicState state;
            public final List mapEntriesInputToNextStates;

            public Note(Object label, NondeterministicState state) {
                this.label = label;
                this.state = state;
                this.mapEntriesInputToNextStates = new LinkedList(state.getMapInputToNextStates().entrySet());
            }
        }
    }

    private static final class DeadState
    extends SingletonState {
        public static final DeadState INSTANCE = new DeadState();

        private DeadState() {
        }

        public boolean isFinal() {
            return false;
        }

        public SortedMap getMapInputToNextStateOnce() {
            return DFAGenerator.singletonSortedMap(new DFAInput(0, 65535), this);
        }
    }

    private static final class MatchAnyState
    extends SingletonState {
        public static final MatchAnyState INSTANCE = new MatchAnyState();

        private MatchAnyState() {
        }

        public boolean isFinal() {
            return true;
        }

        public SortedMap getMapInputToNextStateOnce() {
            return DFAGenerator.singletonSortedMap(new DFAInput(0, 65535), this);
        }
    }

    private static final class FinalState
    extends SingletonState {
        public static final FinalState INSTANCE = new FinalState();

        private FinalState() {
        }

        public boolean isFinal() {
            return true;
        }

        public SortedMap getMapInputToNextStateOnce() {
            return EMPTY_SORTED_MAP;
        }
    }

    private static abstract class SingletonState
    extends DeterministicState {
        protected SingletonState() {
        }

        public int hashCodeOnce() {
            return this.getClass().getName().hashCode();
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            return this.getClass().equals(rhs.getClass());
        }

        public abstract boolean isFinal();

        public abstract SortedMap getMapInputToNextStateOnce();
    }

    private static abstract class DeterministicState
    extends NondeterministicState {
        private SortedMap mapInputToNextState = null;
        private SortedMap mapInputToNextStates = null;

        private DeterministicState() {
        }

        public final SortedMap getMapInputToNextState() {
            if (this.mapInputToNextState == null) {
                this.mapInputToNextState = this.getMapInputToNextStateOnce();
            }
            return this.mapInputToNextState;
        }

        public abstract SortedMap getMapInputToNextStateOnce();

        public final SortedMap getMapInputToNextStates() {
            if (this.mapInputToNextStates == null) {
                this.mapInputToNextStates = new TreeMap(this.getMapInputToNextState());
                Iterator it = this.mapInputToNextStates.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    DeterministicState state = (DeterministicState)entry.getValue();
                    entry.setValue(Collections.singleton(state));
                }
            }
            return this.mapInputToNextStates;
        }

        public final Set getEpsilonMovedStates() {
            return Collections.EMPTY_SET;
        }
    }

    private static abstract class NondeterministicState {
        private long hashCode = Long.MIN_VALUE;

        private NondeterministicState() {
        }

        public final int hashCode() {
            if (this.hashCode == Long.MIN_VALUE) {
                this.hashCode = this.hashCodeOnce();
                if (this.hashCode == Long.MIN_VALUE) {
                    this.hashCode = -9223372036854775807L;
                }
            }
            return (int)this.hashCode;
        }

        public abstract int hashCodeOnce();

        public abstract boolean equals(Object var1);

        public abstract boolean isFinal();

        public abstract SortedMap getMapInputToNextStates();

        public Set getEpsilonMovedStates() {
            return Collections.EMPTY_SET;
        }

        public final Set getEpsilonClosure() {
            LinkedHashSet<NondeterministicState> result = new LinkedHashSet<NondeterministicState>();
            LinkedList<NondeterministicState> undone = new LinkedList<NondeterministicState>();
            undone.add(this);
            while (!undone.isEmpty()) {
                NondeterministicState state = (NondeterministicState)undone.removeFirst();
                if (!result.add(state)) continue;
                undone.addAll(state.getEpsilonMovedStates());
            }
            return result;
        }
    }

    private static class DFA
    extends DeterministicFiniteAutomaton {
        private Parser.Root root;
        private DeterministicFiniteAutomaton.DFAState initialState;
        private Map stringToNamedTerminal;

        public DFA(Parser.Root root, DeterministicFiniteAutomaton.DFAState initialState, Map stringToNamedTerminal) {
            this.root = root;
            this.initialState = initialState;
            this.stringToNamedTerminal = stringToNamedTerminal;
        }

        public DeterministicFiniteAutomaton.DFAState initialState() {
            return this.initialState;
        }

        public Terminal getTerminal(Original.StringExpression exp) {
            String str = this.root.getValue(exp.string());
            Terminal result = (Terminal)this.stringToNamedTerminal.get(str);
            if (result == null) {
                result = new StringTerminal(str);
            }
            return result;
        }
    }

    private static class DFAState
    implements DeterministicFiniteAutomaton.DFAState {
        private Terminal hitSymbol;
        public SortedMap mapInputToNextStates = new TreeMap();
        private static int numberOfInstance = 0;
        public final int idNumber = numberOfInstance++;

        public DFAState(Terminal hitSymbol) {
            this.hitSymbol = hitSymbol;
        }

        public Terminal hitSymbol() {
            return this.hitSymbol;
        }

        public SortedMap getMapInputToNextStates() {
            return this.mapInputToNextStates;
        }

        public String toString() {
            return "DFAState" + this.idNumber;
        }
    }
}

