/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.notavacc;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.gr.java_conf.koto.notava.Alphabet;
import jp.gr.java_conf.koto.notavacc.Environment;
import jp.gr.java_conf.koto.notavacc.Logger;
import jp.gr.java_conf.koto.notavacc.dfa.DFAGenerator;
import jp.gr.java_conf.koto.notavacc.dfa.DeterministicFiniteAutomaton;
import jp.gr.java_conf.koto.notavacc.generator.JavaCodeGenerator;
import jp.gr.java_conf.koto.notavacc.lrg.LRTable;
import jp.gr.java_conf.koto.notavacc.lrg.LRTableGenerator;
import jp.gr.java_conf.koto.notavacc.parser.Original;
import jp.gr.java_conf.koto.notavacc.parser.Parser;
import jp.gr.java_conf.koto.notavacc.types.TypeSystem;
import jp.gr.java_conf.koto.notavacc.types.TypeSystemGenerator;
import jp.gr.java_conf.koto.util.CommandLineChecker;
import jp.gr.java_conf.koto.util.CommandLineParameter;

public class Main {
    private static final String NAME;
    private static final String COMMAND_NAME = "notavacc";
    private static final String COPYRIGHT;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$jp$gr$java_conf$koto$notavacc$Main;

    public static String getBaseName(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(".");
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    private static List getRelativePathItems(File base, File file) throws IOException {
        base = base.getCanonicalFile();
        File f = file.getCanonicalFile();
        LinkedList<String> items = new LinkedList<String>();
        do {
            items.addFirst(f.getName());
        } while ((f = f.getParentFile()) != null && !f.equals(base));
        return items;
    }

    public static String getFileName(File file, boolean withoutParentPath) {
        if (withoutParentPath) {
            return file.getName();
        }
        try {
            File userDir = new File(System.getProperty("user.dir"));
            List items = Main.getRelativePathItems(userDir, file);
            File f = null;
            Iterator it0 = items.iterator();
            while (it0.hasNext()) {
                String item = (String)it0.next();
                f = new File(f, item);
            }
            return f.getPath();
        }
        catch (IOException x) {
            return file.toString();
        }
    }

    public static File getReplacedPath(File file, String sourceDir, String destinationDir) throws IOException {
        return Main.getReplacedPath(file, new File(sourceDir), new File(destinationDir));
    }

    public static File getReplacedPath(File file, File sourceDir, File destinationDir) throws IOException {
        File result = destinationDir;
        List items = Main.getRelativePathItems(sourceDir, file);
        Iterator it1 = items.iterator();
        while (it1.hasNext()) {
            String item = (String)it1.next();
            result = new File(result, item);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compile(Environment env, List files) throws Exception {
        int i;
        boolean withoutParentPath = env.commandLine.countOf("x-without-parent-path") > 0;
        String sourceDir = env.commandLine.argumentOf("source-path");
        String destinationDir = env.commandLine.argumentOf("destination-path");
        double targetVersion = 1.4;
        try {
            String version = System.getProperty("java.vm.version");
            boolean priodProcessed = false;
            i = 0;
            while (i < version.length()) {
                char ch = version.charAt(i);
                if (ch == '.') {
                    if (priodProcessed) break;
                    priodProcessed = true;
                } else if ('0' > ch || ch > '9') break;
                ++i;
            }
            targetVersion = Double.parseDouble(version.substring(0, i));
        }
        catch (NumberFormatException x) {
            // empty catch block
        }
        String targetVersionString = env.commandLine.argumentOf("target");
        if (targetVersionString == null) {
            env.logger.warn("--target missing.  The VM version ({0}) is used.", (Object)Double.toString(targetVersion));
        } else {
            try {
                targetVersion = Double.parseDouble(targetVersionString);
                if (targetVersion < 1.2) {
                    env.logger.warn("The target version {0} should be grater than or equal to 1.2.", (Object)Double.toString(targetVersion));
                }
            }
            catch (NumberFormatException x) {
                env.logger.warn("{0} should be the Java varsion of the output. e.g. 1.4", (Object)targetVersionString);
            }
        }
        double[] supportedTargets = new double[]{1.2, 1.3, 1.4};
        i = 0;
        while (i < supportedTargets.length) {
            if (targetVersion == supportedTargets[i]) break;
            ++i;
        }
        if (i >= supportedTargets.length) {
            StringBuffer buffer = new StringBuffer();
            i = 0;
            while (i < supportedTargets.length - 1) {
                buffer.append(supportedTargets[i]);
                buffer.append(", ");
                ++i;
            }
            env.logger.warn("The target version {0} is not supported.  The supported versions are {1}and {2}.", (Object)Double.toString(targetVersion), (Object)buffer, (Object)Double.toString(supportedTargets[i]));
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            Object var22_27;
            Parser.Root root;
            File sourceFile;
            String fileName = (String)it.next();
            env.processingFile = sourceFile = new File(fileName);
            File parentFile = sourceFile.getParentFile();
            File outputFile = destinationDir == null ? new File(parentFile, Main.getBaseName(sourceFile) + ".java") : (sourceDir == null ? new File(destinationDir, Main.getBaseName(sourceFile) + ".java") : Main.getReplacedPath(new File(parentFile, Main.getBaseName(sourceFile) + ".java"), sourceDir, destinationDir));
            if (outputFile.getParentFile() != null) {
                outputFile.getParentFile().mkdirs();
            }
            String sourceFileName = Main.getFileName(sourceFile, withoutParentPath);
            String outputFileName = Main.getFileName(outputFile, withoutParentPath);
            env.logger.inform("generating a parser from ''{0}'' into ''{1}''.", (Object)sourceFileName, (Object)outputFileName);
            try {
                root = (Parser.Root)new Parser(env.logger).parseRoot(sourceFileName, sourceFile, null, 8);
            }
            catch (Original.ParseException x) {
                env.logger.fatal(x.getSourceName(), x.getLine(), "{0}", (Object)x.getLocalizedMessage());
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                root = null;
            }
            DeterministicFiniteAutomaton dfa = new DFAGenerator(env).generate(root);
            LRTable lrTable = new LRTableGenerator(env).generate(root, dfa);
            TypeSystem typeSystem = new TypeSystemGenerator(env, targetVersion >= 1.5).generate(root, lrTable.getTypeNonterminals());
            boolean dryRun = env.commandLine.countOf("dry-run") > 0;
            boolean error = true;
            try {
                if (!env.logger.hasError()) {
                    new JavaCodeGenerator(env, root, dfa, lrTable, typeSystem, targetVersion).generate(outputFile, dryRun);
                    error = false;
                }
                var22_27 = null;
                if (!error || dryRun) continue;
                outputFile.delete();
            }
            catch (Throwable throwable) {
                var22_27 = null;
                if (error && !dryRun) {
                    outputFile.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    public static Throwable process(String[] args) {
        return Main.process(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Throwable process(String[] args, Writer writer) {
        StringWriter stringWriter;
        CommandLineChecker clc = new CommandLineChecker(new CommandLineParameter[]{new CommandLineParameter('v', "verbose", "increase verbosity."), new CommandLineParameter('q', "quiet", "decrease verbosity."), new CommandLineParameter("source-path", "dir", "input from <dir>."), new CommandLineParameter('d', "destination-path", "dir", "output to <dir>."), new CommandLineParameter("target", "type", "output target: version of java"), new CommandLineParameter("dry-run", "output no code."), new CommandLineParameter('X', "experimental", "use experimental algorithms.", true), new CommandLineParameter("debug", "debugging mode for compiler-compiler developers.", true), new CommandLineParameter("x-without-parent-path", "print the file name without the parent path.", true), new CommandLineParameter("version", "show the version."), new CommandLineParameter('h', "help", "display this help.")}, args);
        List files = clc.arguments();
        boolean withoutParentPath = clc.countOf("x-without-parent-path") > 0;
        int verboseLevel = 3 + clc.countOf("verbose") - clc.countOf("quiet");
        boolean usage = clc.countOf("help") > 0 || clc.countOf("version") <= 0 && files.isEmpty();
        boolean version = verboseLevel >= 4 || usage || clc.countOf("version") > 0;
        Logger logger = new Logger(withoutParentPath, verboseLevel, writer);
        Environment env = new Environment(logger, clc);
        if (version) {
            logger.inform(NAME + " Version " + "0.71" + " (" + "November 9 2002" + ")");
            logger.inform(COPYRIGHT);
        }
        if (usage) {
            stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("Usage: notavacc [options] files...");
            clc.printOptionUsage(printWriter, verboseLevel >= 4);
            printWriter.close();
            if (!$assertionsDisabled && printWriter.checkError()) {
                throw new AssertionError();
            }
            logger.inform("{0}", (Object)stringWriter.toString());
        } else {
            Main.compile(env, files);
        }
        if (logger.hasError()) {
            logger.fatal();
        }
        stringWriter = null;
        Object var16_15 = null;
        try {
            logger.close();
        }
        catch (IOException x2) {
            System.err.println("error: cannot write a log (into stdout maybe).");
        }
        return stringWriter;
        catch (Logger.FatalErrorException x) {
            Logger.FatalErrorException printWriter = x;
            Object var16_16 = null;
            try {
                logger.close();
            }
            catch (IOException x2) {
                System.err.println("error: cannot write a log (into stdout maybe).");
            }
            return printWriter;
        }
        catch (Throwable x) {
            if (x instanceof IOException) {
                logger.error("I/O error: {0}", (Object)x.getLocalizedMessage());
            } else {
                logger.error("An exception: {0}", (Object)x.getLocalizedMessage());
            }
            StringWriter stringWriter2 = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter2);
            x.printStackTrace(printWriter);
            printWriter.close();
            if (!$assertionsDisabled && printWriter.checkError()) {
                throw new AssertionError();
            }
            if (x instanceof IOException) {
                logger.verbose("{0}", (Object)stringWriter2.toString());
            } else {
                logger.inform("{0}", (Object)stringWriter2.toString());
            }
            Throwable throwable = x;
            Object var16_17 = null;
            {
                catch (Throwable throwable2) {
                    Object var16_18 = null;
                    try {
                        logger.close();
                    }
                    catch (IOException x2) {
                        System.err.println("error: cannot write a log (into stdout maybe).");
                    }
                    throw throwable2;
                }
            }
            try {
                logger.close();
            }
            catch (IOException x2) {
                System.err.println("error: cannot write a log (into stdout maybe).");
            }
            return throwable;
        }
    }

    public static void main(String[] args) {
        if (Main.process(args) == null) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jp$gr$java_conf$koto$notavacc$Main == null ? (class$jp$gr$java_conf$koto$notavacc$Main = Main.class$("jp.gr.java_conf.koto.notavacc.Main")) : class$jp$gr$java_conf$koto$notavacc$Main).desiredAssertionStatus();
        NAME = Alphabet.J + Alphabet.A + Alphabet.V + Alphabet.A + Alphabet.C + Alphabet.C;
        COPYRIGHT = "Copyright " + Alphabet.NORMAL_COPYRIGHT + " Koto 2001-2002.  Licensed under " + "GPL" + ".";
    }
}

