/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.notavacc;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.gr.java_conf.koto.notavacc.Main;
import jp.gr.java_conf.koto.notavacc.parser.Original;

public final class Logger {
    public static final int LEVEL_FATAL = 0;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_INFORMATION = 3;
    public static final int LEVEL_VERBOSE = 4;
    public static final int LEVEL_VERBOSEST = 5;
    private final String[] informationTypeStrings = new String[]{"", "", "warning: ", "", "verbose information: ", "verboser information: "};
    private final boolean withoutParentPath;
    private final int verboseLevel;
    private final ResourceBundle boundle;
    private final PrintWriter writer;
    private boolean hasError = false;
    private String lineSeparator = System.getProperty("line.separator", "\n");
    private Map formatCache = new HashMap();
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public boolean hasError() {
        return this.hasError;
    }

    public Logger() {
        this(false, 0, null, null);
    }

    public Logger(boolean withoutParentPath, int verboseLevel, Writer writer) {
        this(withoutParentPath, verboseLevel, null, writer);
    }

    public Logger(boolean withoutParentPath, int verboseLevel, ResourceBundle boundle, Writer writer) {
        this.withoutParentPath = withoutParentPath;
        this.verboseLevel = verboseLevel;
        this.boundle = boundle;
        this.writer = writer == null ? new PrintWriter(System.out, true) : (writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer, true));
        if (verboseLevel < 5) {
            this.informationTypeStrings[4] = "";
        }
    }

    public void close() throws IOException {
        this.writer.flush();
        if (this.writer.checkError()) {
            throw new IOException();
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public int verboseLevel() {
        return this.verboseLevel;
    }

    public void report(int level, String sourceName, int line, String message, Object[] params) {
        if (this.verboseLevel >= level) {
            boolean printed = false;
            if (sourceName != null) {
                if (sourceName.indexOf(58) < 0 && sourceName.indexOf(32) < 0) {
                    this.writer.print(sourceName);
                } else {
                    this.writer.print('\"' + sourceName + '\"');
                }
                this.writer.print(":");
                printed = true;
            }
            if (line > 0) {
                this.writer.print(line);
                this.writer.print(":");
                printed = true;
            }
            if (printed) {
                this.writer.print(' ');
            }
            this.writer.print(this.informationTypeStrings[level]);
            MessageFormat format = (MessageFormat)this.formatCache.get(message);
            if (format == null) {
                String s = message;
                if (this.boundle != null) {
                    try {
                        s = this.boundle.getString(s);
                    }
                    catch (MissingResourceException ignored) {
                    }
                    catch (ClassCastException ignored) {
                        // empty catch block
                    }
                }
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < s.length()) {
                    char ch = s.charAt(i);
                    if (ch == '\n') {
                        buffer.append(this.lineSeparator);
                    } else {
                        buffer.append(ch);
                    }
                    ++i;
                }
                format = new MessageFormat(buffer.toString());
                this.formatCache.put(message, format);
            }
            this.writer.print(format.format(params));
            this.writer.println();
        }
        if (level <= 1) {
            this.hasError = true;
        }
        if (level <= 0) {
            this.fatal();
        }
    }

    public void report(int level, Original.Token token, String message, Object[] params) {
        String sourceName = null;
        try {
            sourceName = token.getSourceName();
        }
        catch (UnsupportedOperationException x) {
            // empty catch block
        }
        int line = -1;
        try {
            line = token.getLine();
        }
        catch (UnsupportedOperationException x) {
            // empty catch block
        }
        this.report(level, sourceName, line, message, params);
    }

    public void fatal() {
        throw new FatalErrorException();
    }

    public void report(int level, String message, Object[] params) {
        this.report(level, (String)null, -1, message, params);
    }

    public void report(int level, File file, String message, Object[] params) {
        this.report(level, Main.getFileName(file, this.withoutParentPath), -1, message, params);
    }

    public void report(int level, File file, int line, String message, Object[] params) {
        this.report(level, Main.getFileName(file, this.withoutParentPath), line, message, params);
    }

    public void report(int level, String message) {
        this.report(level, (String)null, -1, message, EMPTY_ARRAY);
    }

    public void report(int level, File file, String message) {
        this.report(level, Main.getFileName(file, this.withoutParentPath), -1, message, EMPTY_ARRAY);
    }

    public void report(int level, File file, int line, String message) {
        this.report(level, Main.getFileName(file, this.withoutParentPath), line, message, EMPTY_ARRAY);
    }

    public void report(int level, String sourceName, int line, String message) {
        this.report(level, sourceName, line, message, EMPTY_ARRAY);
    }

    public void report(int level, Original.Token token, String message) {
        this.report(level, token, message, EMPTY_ARRAY);
    }

    public void report(int level, String message, Object p1) {
        this.report(level, (String)null, -1, message, new Object[]{p1});
    }

    public void report(int level, File file, String message, Object p1) {
        this.report(level, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1});
    }

    public void report(int level, File file, int line, String message, Object p1) {
        this.report(level, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1});
    }

    public void report(int level, String sourceName, int line, String message, Object p1) {
        this.report(level, sourceName, line, message, new Object[]{p1});
    }

    public void report(int level, Original.Token token, String message, Object p1) {
        this.report(level, token, message, new Object[]{p1});
    }

    public void report(int level, String message, Original.Token p1) {
        this.report(level, p1, message, new Object[]{p1});
    }

    public void report(int level, String message, Object p1, Object p2) {
        this.report(level, (String)null, -1, message, new Object[]{p1, p2});
    }

    public void report(int level, File file, String message, Object p1, Object p2) {
        this.report(level, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2});
    }

    public void report(int level, File file, int line, String message, Object p1, Object p2) {
        this.report(level, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2});
    }

    public void report(int level, String sourceName, int line, String message, Object p1, Object p2) {
        this.report(level, sourceName, line, message, new Object[]{p1, p2});
    }

    public void report(int level, Original.Token token, String message, Object p1, Object p2) {
        this.report(level, token, message, new Object[]{p1, p2});
    }

    public void report(int level, String message, Original.Token p1, Object p2) {
        this.report(level, p1, message, new Object[]{p1, p2});
    }

    public void report(int level, String message, Object p1, Object p2, Object p3) {
        this.report(level, (String)null, -1, message, new Object[]{p1, p2, p3});
    }

    public void report(int level, File file, String message, Object p1, Object p2, Object p3) {
        this.report(level, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3});
    }

    public void report(int level, File file, int line, String message, Object p1, Object p2, Object p3) {
        this.report(level, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3});
    }

    public void report(int level, String sourceName, int line, String message, Object p1, Object p2, Object p3) {
        this.report(level, sourceName, line, message, new Object[]{p1, p2, p3});
    }

    public void report(int level, Original.Token token, String message, Object p1, Object p2, Object p3) {
        this.report(level, token, message, new Object[]{p1, p2, p3});
    }

    public void report(int level, String message, Original.Token p1, Object p2, Object p3) {
        this.report(level, p1, message, new Object[]{p1, p2, p3});
    }

    public void report(int level, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(level, (String)null, -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void report(int level, File file, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(level, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void report(int level, File file, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(level, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3, p4});
    }

    public void report(int level, String sourceName, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(level, sourceName, line, message, new Object[]{p1, p2, p3, p4});
    }

    public void report(int level, Original.Token token, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(level, token, message, new Object[]{p1, p2, p3, p4});
    }

    public void report(int level, String message, Original.Token p1, Object p2, Object p3, Object p4) {
        this.report(level, p1, message, new Object[]{p1, p2, p3, p4});
    }

    public void fatal(String message, Object[] params) {
        this.report(0, (String)null, -1, message, params);
    }

    public void fatal(File file, String message, Object[] params) {
        this.report(0, Main.getFileName(file, this.withoutParentPath), -1, message, params);
    }

    public void fatal(File file, int line, String message, Object[] params) {
        this.report(0, Main.getFileName(file, this.withoutParentPath), line, message, params);
    }

    public void fatal(String sourceName, int line, String message, Object[] params) {
        this.report(0, sourceName, line, message, params);
    }

    public void fatal(Original.Token token, String message, Object[] params) {
        this.report(0, token, message, params);
    }

    public void fatal(String message) {
        this.report(0, (String)null, -1, message, EMPTY_ARRAY);
    }

    public void fatal(File file, String message) {
        this.report(0, Main.getFileName(file, this.withoutParentPath), -1, message, EMPTY_ARRAY);
    }

    public void fatal(File file, int line, String message) {
        this.report(0, Main.getFileName(file, this.withoutParentPath), line, message, EMPTY_ARRAY);
    }

    public void fatal(String sourceName, int line, String message) {
        this.report(0, sourceName, line, message, EMPTY_ARRAY);
    }

    public void fatal(Original.Token token, String message) {
        this.report(0, token, message, EMPTY_ARRAY);
    }

    public void fatal(String message, Object p1) {
        this.report(0, (String)null, -1, message, new Object[]{p1});
    }

    public void fatal(File file, String message, Object p1) {
        this.report(0, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1});
    }

    public void fatal(File file, int line, String message, Object p1) {
        this.report(0, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1});
    }

    public void fatal(String sourceName, int line, String message, Object p1) {
        this.report(0, sourceName, line, message, new Object[]{p1});
    }

    public void fatal(Original.Token token, String message, Object p1) {
        this.report(0, token, message, new Object[]{p1});
    }

    public void fatal(String message, Original.Token p1) {
        this.report(0, p1, message, new Object[]{p1});
    }

    public void fatal(String message, Object p1, Object p2) {
        this.report(0, (String)null, -1, message, new Object[]{p1, p2});
    }

    public void fatal(File file, String message, Object p1, Object p2) {
        this.report(0, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2});
    }

    public void fatal(File file, int line, String message, Object p1, Object p2) {
        this.report(0, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2});
    }

    public void fatal(String sourceName, int line, String message, Object p1, Object p2) {
        this.report(0, sourceName, line, message, new Object[]{p1, p2});
    }

    public void fatal(Original.Token token, String message, Object p1, Object p2) {
        this.report(0, token, message, new Object[]{p1, p2});
    }

    public void fatal(String message, Original.Token p1, Object p2) {
        this.report(0, p1, message, new Object[]{p1, p2});
    }

    public void fatal(String message, Object p1, Object p2, Object p3) {
        this.report(0, (String)null, -1, message, new Object[]{p1, p2, p3});
    }

    public void fatal(File file, String message, Object p1, Object p2, Object p3) {
        this.report(0, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3});
    }

    public void fatal(File file, int line, String message, Object p1, Object p2, Object p3) {
        this.report(0, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3});
    }

    public void fatal(String sourceName, int line, String message, Object p1, Object p2, Object p3) {
        this.report(0, sourceName, line, message, new Object[]{p1, p2, p3});
    }

    public void fatal(Original.Token token, String message, Object p1, Object p2, Object p3) {
        this.report(0, token, message, new Object[]{p1, p2, p3});
    }

    public void fatal(String message, Original.Token p1, Object p2, Object p3) {
        this.report(0, p1, message, new Object[]{p1, p2, p3});
    }

    public void fatal(String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(0, (String)null, -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void fatal(File file, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(0, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void fatal(File file, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(0, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3, p4});
    }

    public void fatal(String sourceName, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(0, sourceName, line, message, new Object[]{p1, p2, p3, p4});
    }

    public void fatal(Original.Token token, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(0, token, message, new Object[]{p1, p2, p3, p4});
    }

    public void fatal(String message, Original.Token p1, Object p2, Object p3, Object p4) {
        this.report(0, p1, message, new Object[]{p1, p2, p3, p4});
    }

    public void error(String message, Object[] params) {
        this.report(1, (String)null, -1, message, params);
    }

    public void error(File file, String message, Object[] params) {
        this.report(1, Main.getFileName(file, this.withoutParentPath), -1, message, params);
    }

    public void error(File file, int line, String message, Object[] params) {
        this.report(1, Main.getFileName(file, this.withoutParentPath), line, message, params);
    }

    public void error(String sourceName, int line, String message, Object[] params) {
        this.report(1, sourceName, line, message, params);
    }

    public void error(Original.Token token, String message, Object[] params) {
        this.report(1, token, message, params);
    }

    public void error(String message) {
        this.report(1, (String)null, -1, message, EMPTY_ARRAY);
    }

    public void error(File file, String message) {
        this.report(1, Main.getFileName(file, this.withoutParentPath), -1, message, EMPTY_ARRAY);
    }

    public void error(File file, int line, String message) {
        this.report(1, Main.getFileName(file, this.withoutParentPath), line, message, EMPTY_ARRAY);
    }

    public void error(String sourceName, int line, String message) {
        this.report(1, sourceName, line, message, EMPTY_ARRAY);
    }

    public void error(Original.Token token, String message) {
        this.report(1, token, message, EMPTY_ARRAY);
    }

    public void error(String message, Object p1) {
        this.report(1, (String)null, -1, message, new Object[]{p1});
    }

    public void error(File file, String message, Object p1) {
        this.report(1, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1});
    }

    public void error(File file, int line, String message, Object p1) {
        this.report(1, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1});
    }

    public void error(String sourceName, int line, String message, Object p1) {
        this.report(1, sourceName, line, message, new Object[]{p1});
    }

    public void error(Original.Token token, String message, Object p1) {
        this.report(1, token, message, new Object[]{p1});
    }

    public void error(String message, Original.Token p1) {
        this.report(1, p1, message, new Object[]{p1});
    }

    public void error(String message, Object p1, Object p2) {
        this.report(1, (String)null, -1, message, new Object[]{p1, p2});
    }

    public void error(File file, String message, Object p1, Object p2) {
        this.report(1, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2});
    }

    public void error(File file, int line, String message, Object p1, Object p2) {
        this.report(1, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2});
    }

    public void error(String sourceName, int line, String message, Object p1, Object p2) {
        this.report(1, sourceName, line, message, new Object[]{p1, p2});
    }

    public void error(Original.Token token, String message, Object p1, Object p2) {
        this.report(1, token, message, new Object[]{p1, p2});
    }

    public void error(String message, Original.Token p1, Object p2) {
        this.report(1, p1, message, new Object[]{p1, p2});
    }

    public void error(String message, Object p1, Object p2, Object p3) {
        this.report(1, (String)null, -1, message, new Object[]{p1, p2, p3});
    }

    public void error(File file, String message, Object p1, Object p2, Object p3) {
        this.report(1, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3});
    }

    public void error(File file, int line, String message, Object p1, Object p2, Object p3) {
        this.report(1, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3});
    }

    public void error(String sourceName, int line, String message, Object p1, Object p2, Object p3) {
        this.report(1, sourceName, line, message, new Object[]{p1, p2, p3});
    }

    public void error(Original.Token token, String message, Object p1, Object p2, Object p3) {
        this.report(1, token, message, new Object[]{p1, p2, p3});
    }

    public void error(String message, Original.Token p1, Object p2, Object p3) {
        this.report(1, p1, message, new Object[]{p1, p2, p3});
    }

    public void error(String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(1, (String)null, -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void error(File file, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(1, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void error(File file, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(1, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3, p4});
    }

    public void error(String sourceName, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(1, sourceName, line, message, new Object[]{p1, p2, p3, p4});
    }

    public void error(Original.Token token, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(1, token, message, new Object[]{p1, p2, p3, p4});
    }

    public void error(String message, Original.Token p1, Object p2, Object p3, Object p4) {
        this.report(1, p1, message, new Object[]{p1, p2, p3, p4});
    }

    public void warn(String message, Object[] params) {
        this.report(2, (String)null, -1, message, params);
    }

    public void warn(File file, String message, Object[] params) {
        this.report(2, Main.getFileName(file, this.withoutParentPath), -1, message, params);
    }

    public void warn(File file, int line, String message, Object[] params) {
        this.report(2, Main.getFileName(file, this.withoutParentPath), line, message, params);
    }

    public void warn(String sourceName, int line, String message, Object[] params) {
        this.report(2, sourceName, line, message, params);
    }

    public void warn(Original.Token token, String message, Object[] params) {
        this.report(2, token, message, params);
    }

    public void warn(String message) {
        this.report(2, (String)null, -1, message, EMPTY_ARRAY);
    }

    public void warn(File file, String message) {
        this.report(2, Main.getFileName(file, this.withoutParentPath), -1, message, EMPTY_ARRAY);
    }

    public void warn(File file, int line, String message) {
        this.report(2, Main.getFileName(file, this.withoutParentPath), line, message, EMPTY_ARRAY);
    }

    public void warn(String sourceName, int line, String message) {
        this.report(2, sourceName, line, message, EMPTY_ARRAY);
    }

    public void warn(Original.Token token, String message) {
        this.report(2, token, message, EMPTY_ARRAY);
    }

    public void warn(String message, Object p1) {
        this.report(2, (String)null, -1, message, new Object[]{p1});
    }

    public void warn(File file, String message, Object p1) {
        this.report(2, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1});
    }

    public void warn(File file, int line, String message, Object p1) {
        this.report(2, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1});
    }

    public void warn(String sourceName, int line, String message, Object p1) {
        this.report(2, sourceName, line, message, new Object[]{p1});
    }

    public void warn(Original.Token token, String message, Object p1) {
        this.report(2, token, message, new Object[]{p1});
    }

    public void warn(String message, Original.Token p1) {
        this.report(2, p1, message, new Object[]{p1});
    }

    public void warn(String message, Object p1, Object p2) {
        this.report(2, (String)null, -1, message, new Object[]{p1, p2});
    }

    public void warn(File file, String message, Object p1, Object p2) {
        this.report(2, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2});
    }

    public void warn(File file, int line, String message, Object p1, Object p2) {
        this.report(2, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2});
    }

    public void warn(String sourceName, int line, String message, Object p1, Object p2) {
        this.report(2, sourceName, line, message, new Object[]{p1, p2});
    }

    public void warn(Original.Token token, String message, Object p1, Object p2) {
        this.report(2, token, message, new Object[]{p1, p2});
    }

    public void warn(String message, Original.Token p1, Object p2) {
        this.report(2, p1, message, new Object[]{p1, p2});
    }

    public void warn(String message, Object p1, Object p2, Object p3) {
        this.report(2, (String)null, -1, message, new Object[]{p1, p2, p3});
    }

    public void warn(File file, String message, Object p1, Object p2, Object p3) {
        this.report(2, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3});
    }

    public void warn(File file, int line, String message, Object p1, Object p2, Object p3) {
        this.report(2, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3});
    }

    public void warn(String sourceName, int line, String message, Object p1, Object p2, Object p3) {
        this.report(2, sourceName, line, message, new Object[]{p1, p2, p3});
    }

    public void warn(Original.Token token, String message, Object p1, Object p2, Object p3) {
        this.report(2, token, message, new Object[]{p1, p2, p3});
    }

    public void warn(String message, Original.Token p1, Object p2, Object p3) {
        this.report(2, p1, message, new Object[]{p1, p2, p3});
    }

    public void warn(String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(2, (String)null, -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void warn(File file, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(2, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void warn(File file, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(2, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3, p4});
    }

    public void warn(String sourceName, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(2, sourceName, line, message, new Object[]{p1, p2, p3, p4});
    }

    public void warn(Original.Token token, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(2, token, message, new Object[]{p1, p2, p3, p4});
    }

    public void warn(String message, Original.Token p1, Object p2, Object p3, Object p4) {
        this.report(2, p1, message, new Object[]{p1, p2, p3, p4});
    }

    public void inform(String message, Object[] params) {
        this.report(3, (String)null, -1, message, params);
    }

    public void inform(File file, String message, Object[] params) {
        this.report(3, Main.getFileName(file, this.withoutParentPath), -1, message, params);
    }

    public void inform(File file, int line, String message, Object[] params) {
        this.report(3, Main.getFileName(file, this.withoutParentPath), line, message, params);
    }

    public void inform(String sourceName, int line, String message, Object[] params) {
        this.report(3, sourceName, line, message, params);
    }

    public void inform(Original.Token token, String message, Object[] params) {
        this.report(3, token, message, params);
    }

    public void inform(String message) {
        this.report(3, (String)null, -1, message, EMPTY_ARRAY);
    }

    public void inform(File file, String message) {
        this.report(3, Main.getFileName(file, this.withoutParentPath), -1, message, EMPTY_ARRAY);
    }

    public void inform(File file, int line, String message) {
        this.report(3, Main.getFileName(file, this.withoutParentPath), line, message, EMPTY_ARRAY);
    }

    public void inform(String sourceName, int line, String message) {
        this.report(3, sourceName, line, message, EMPTY_ARRAY);
    }

    public void inform(Original.Token token, String message) {
        this.report(3, token, message, EMPTY_ARRAY);
    }

    public void inform(String message, Object p1) {
        this.report(3, (String)null, -1, message, new Object[]{p1});
    }

    public void inform(File file, String message, Object p1) {
        this.report(3, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1});
    }

    public void inform(File file, int line, String message, Object p1) {
        this.report(3, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1});
    }

    public void inform(String sourceName, int line, String message, Object p1) {
        this.report(3, sourceName, line, message, new Object[]{p1});
    }

    public void inform(Original.Token token, String message, Object p1) {
        this.report(3, token, message, new Object[]{p1});
    }

    public void inform(String message, Original.Token p1) {
        this.report(3, p1, message, new Object[]{p1});
    }

    public void inform(String message, Object p1, Object p2) {
        this.report(3, (String)null, -1, message, new Object[]{p1, p2});
    }

    public void inform(File file, String message, Object p1, Object p2) {
        this.report(3, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2});
    }

    public void inform(File file, int line, String message, Object p1, Object p2) {
        this.report(3, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2});
    }

    public void inform(String sourceName, int line, String message, Object p1, Object p2) {
        this.report(3, sourceName, line, message, new Object[]{p1, p2});
    }

    public void inform(Original.Token token, String message, Object p1, Object p2) {
        this.report(3, token, message, new Object[]{p1, p2});
    }

    public void inform(String message, Original.Token p1, Object p2) {
        this.report(3, p1, message, new Object[]{p1, p2});
    }

    public void inform(String message, Object p1, Object p2, Object p3) {
        this.report(3, (String)null, -1, message, new Object[]{p1, p2, p3});
    }

    public void inform(File file, String message, Object p1, Object p2, Object p3) {
        this.report(3, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3});
    }

    public void inform(File file, int line, String message, Object p1, Object p2, Object p3) {
        this.report(3, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3});
    }

    public void inform(String sourceName, int line, String message, Object p1, Object p2, Object p3) {
        this.report(3, sourceName, line, message, new Object[]{p1, p2, p3});
    }

    public void inform(Original.Token token, String message, Object p1, Object p2, Object p3) {
        this.report(3, token, message, new Object[]{p1, p2, p3});
    }

    public void inform(String message, Original.Token p1, Object p2, Object p3) {
        this.report(3, p1, message, new Object[]{p1, p2, p3});
    }

    public void inform(String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(3, (String)null, -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void inform(File file, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(3, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void inform(File file, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(3, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3, p4});
    }

    public void inform(String sourceName, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(3, sourceName, line, message, new Object[]{p1, p2, p3, p4});
    }

    public void inform(Original.Token token, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(3, token, message, new Object[]{p1, p2, p3, p4});
    }

    public void inform(String message, Original.Token p1, Object p2, Object p3, Object p4) {
        this.report(3, p1, message, new Object[]{p1, p2, p3, p4});
    }

    public void verbose(String message, Object[] params) {
        this.report(4, (String)null, -1, message, params);
    }

    public void verbose(File file, String message, Object[] params) {
        this.report(4, Main.getFileName(file, this.withoutParentPath), -1, message, params);
    }

    public void verbose(File file, int line, String message, Object[] params) {
        this.report(4, Main.getFileName(file, this.withoutParentPath), line, message, params);
    }

    public void verbose(String sourceName, int line, String message, Object[] params) {
        this.report(4, sourceName, line, message, params);
    }

    public void verbose(Original.Token token, String message, Object[] params) {
        this.report(4, token, message, params);
    }

    public void verbose(String message) {
        this.report(4, (String)null, -1, message, EMPTY_ARRAY);
    }

    public void verbose(File file, String message) {
        this.report(4, Main.getFileName(file, this.withoutParentPath), -1, message, EMPTY_ARRAY);
    }

    public void verbose(File file, int line, String message) {
        this.report(4, Main.getFileName(file, this.withoutParentPath), line, message, EMPTY_ARRAY);
    }

    public void verbose(String sourceName, int line, String message) {
        this.report(4, sourceName, line, message, EMPTY_ARRAY);
    }

    public void verbose(Original.Token token, String message) {
        this.report(4, token, message, EMPTY_ARRAY);
    }

    public void verbose(String message, Object p1) {
        this.report(4, (String)null, -1, message, new Object[]{p1});
    }

    public void verbose(File file, String message, Object p1) {
        this.report(4, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1});
    }

    public void verbose(File file, int line, String message, Object p1) {
        this.report(4, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1});
    }

    public void verbose(String sourceName, int line, String message, Object p1) {
        this.report(4, sourceName, line, message, new Object[]{p1});
    }

    public void verbose(Original.Token token, String message, Object p1) {
        this.report(4, token, message, new Object[]{p1});
    }

    public void verbose(String message, Original.Token p1) {
        this.report(4, p1, message, new Object[]{p1});
    }

    public void verbose(String message, Object p1, Object p2) {
        this.report(4, (String)null, -1, message, new Object[]{p1, p2});
    }

    public void verbose(File file, String message, Object p1, Object p2) {
        this.report(4, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2});
    }

    public void verbose(File file, int line, String message, Object p1, Object p2) {
        this.report(4, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2});
    }

    public void verbose(String sourceName, int line, String message, Object p1, Object p2) {
        this.report(4, sourceName, line, message, new Object[]{p1, p2});
    }

    public void verbose(Original.Token token, String message, Object p1, Object p2) {
        this.report(4, token, message, new Object[]{p1, p2});
    }

    public void verbose(String message, Original.Token p1, Object p2) {
        this.report(4, p1, message, new Object[]{p1, p2});
    }

    public void verbose(String message, Object p1, Object p2, Object p3) {
        this.report(4, (String)null, -1, message, new Object[]{p1, p2, p3});
    }

    public void verbose(File file, String message, Object p1, Object p2, Object p3) {
        this.report(4, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3});
    }

    public void verbose(File file, int line, String message, Object p1, Object p2, Object p3) {
        this.report(4, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3});
    }

    public void verbose(String sourceName, int line, String message, Object p1, Object p2, Object p3) {
        this.report(4, sourceName, line, message, new Object[]{p1, p2, p3});
    }

    public void verbose(Original.Token token, String message, Object p1, Object p2, Object p3) {
        this.report(4, token, message, new Object[]{p1, p2, p3});
    }

    public void verbose(String message, Original.Token p1, Object p2, Object p3) {
        this.report(4, p1, message, new Object[]{p1, p2, p3});
    }

    public void verbose(String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(4, (String)null, -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void verbose(File file, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(4, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void verbose(File file, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(4, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3, p4});
    }

    public void verbose(String sourceName, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(4, sourceName, line, message, new Object[]{p1, p2, p3, p4});
    }

    public void verbose(Original.Token token, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(4, token, message, new Object[]{p1, p2, p3, p4});
    }

    public void verbose(String message, Original.Token p1, Object p2, Object p3, Object p4) {
        this.report(4, p1, message, new Object[]{p1, p2, p3, p4});
    }

    public void verbosest(String message, Object[] params) {
        this.report(5, (String)null, -1, message, params);
    }

    public void verbosest(File file, String message, Object[] params) {
        this.report(5, Main.getFileName(file, this.withoutParentPath), -1, message, params);
    }

    public void verbosest(File file, int line, String message, Object[] params) {
        this.report(5, Main.getFileName(file, this.withoutParentPath), line, message, params);
    }

    public void verbosest(String sourceName, int line, String message, Object[] params) {
        this.report(5, sourceName, line, message, params);
    }

    public void verbosest(Original.Token token, String message, Object[] params) {
        this.report(5, token, message, params);
    }

    public void verbosest(String message) {
        this.report(5, (String)null, -1, message, EMPTY_ARRAY);
    }

    public void verbosest(File file, String message) {
        this.report(5, Main.getFileName(file, this.withoutParentPath), -1, message, EMPTY_ARRAY);
    }

    public void verbosest(File file, int line, String message) {
        this.report(5, Main.getFileName(file, this.withoutParentPath), line, message, EMPTY_ARRAY);
    }

    public void verbosest(String sourceName, int line, String message) {
        this.report(5, sourceName, line, message, EMPTY_ARRAY);
    }

    public void verbosest(Original.Token token, String message) {
        this.report(5, token, message, EMPTY_ARRAY);
    }

    public void verbosest(String message, Object p1) {
        this.report(5, (String)null, -1, message, new Object[]{p1});
    }

    public void verbosest(File file, String message, Object p1) {
        this.report(5, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1});
    }

    public void verbosest(File file, int line, String message, Object p1) {
        this.report(5, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1});
    }

    public void verbosest(String sourceName, int line, String message, Object p1) {
        this.report(5, sourceName, line, message, new Object[]{p1});
    }

    public void verbosest(Original.Token token, String message, Object p1) {
        this.report(5, token, message, new Object[]{p1});
    }

    public void verbosest(String message, Original.Token p1) {
        this.report(5, p1, message, new Object[]{p1});
    }

    public void verbosest(String message, Object p1, Object p2) {
        this.report(5, (String)null, -1, message, new Object[]{p1, p2});
    }

    public void verbosest(File file, String message, Object p1, Object p2) {
        this.report(5, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2});
    }

    public void verbosest(File file, int line, String message, Object p1, Object p2) {
        this.report(5, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2});
    }

    public void verbosest(String sourceName, int line, String message, Object p1, Object p2) {
        this.report(5, sourceName, line, message, new Object[]{p1, p2});
    }

    public void verbosest(Original.Token token, String message, Object p1, Object p2) {
        this.report(5, token, message, new Object[]{p1, p2});
    }

    public void verbosest(String message, Original.Token p1, Object p2) {
        this.report(5, p1, message, new Object[]{p1, p2});
    }

    public void verbosest(String message, Object p1, Object p2, Object p3) {
        this.report(5, (String)null, -1, message, new Object[]{p1, p2, p3});
    }

    public void verbosest(File file, String message, Object p1, Object p2, Object p3) {
        this.report(5, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3});
    }

    public void verbosest(File file, int line, String message, Object p1, Object p2, Object p3) {
        this.report(5, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3});
    }

    public void verbosest(String sourceName, int line, String message, Object p1, Object p2, Object p3) {
        this.report(5, sourceName, line, message, new Object[]{p1, p2, p3});
    }

    public void verbosest(Original.Token token, String message, Object p1, Object p2, Object p3) {
        this.report(5, token, message, new Object[]{p1, p2, p3});
    }

    public void verbosest(String message, Original.Token p1, Object p2, Object p3) {
        this.report(5, p1, message, new Object[]{p1, p2, p3});
    }

    public void verbosest(String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(5, (String)null, -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void verbosest(File file, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(5, Main.getFileName(file, this.withoutParentPath), -1, message, new Object[]{p1, p2, p3, p4});
    }

    public void verbosest(File file, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(5, Main.getFileName(file, this.withoutParentPath), line, message, new Object[]{p1, p2, p3, p4});
    }

    public void verbosest(String sourceName, int line, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(5, sourceName, line, message, new Object[]{p1, p2, p3, p4});
    }

    public void verbosest(Original.Token token, String message, Object p1, Object p2, Object p3, Object p4) {
        this.report(5, token, message, new Object[]{p1, p2, p3, p4});
    }

    public void verbosest(String message, Original.Token p1, Object p2, Object p3, Object p4) {
        this.report(5, p1, message, new Object[]{p1, p2, p3, p4});
    }

    public static class FatalErrorException
    extends RuntimeException {
        private FatalErrorException() {
            super("fatal error");
        }
    }
}

