/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.notavacc;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import jp.gr.java_conf.koto.notavacc.Main;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class AntTask
extends MatchingTask {
    private File base;
    private File destination;
    private Commandline cmdl = new Commandline();

    public void setSrcdir(File dir) {
        this.base = dir;
    }

    public void setCaseSensitive(boolean value) {
        this.fileset.setCaseSensitive(value);
    }

    public void setDestdir(File dir) {
        this.destination = dir;
    }

    public Commandline.Argument createArg() {
        return this.cmdl.createArgument();
    }

    public void execute() throws BuildException {
        if (this.base == null) {
            throw new BuildException("'srcdir' attribute required.");
        }
        LinkedList<String> arguments = new LinkedList<String>(Arrays.asList(this.cmdl.getArguments()));
        try {
            arguments.add("--source-path");
            arguments.add(this.base.getCanonicalPath());
            if (this.destination != null) {
                arguments.add("--destination-path");
                arguments.add(this.destination.getCanonicalPath());
            }
            String[] filenames = this.getDirectoryScanner(this.base).getIncludedFiles();
            GlobPatternMapper mapper = new GlobPatternMapper();
            mapper.setFrom("*.notavacc");
            mapper.setTo("*.java");
            filenames = new SourceFileScanner((Task)this).restrict(filenames, this.base, this.destination != null ? this.destination : this.base, (FileNameMapper)mapper);
            if (filenames.length == 0) {
                return;
            }
            int i = 0;
            while (i < filenames.length) {
                String filename = filenames[i];
                File src = new File(this.base, filename);
                arguments.add(src.getCanonicalPath());
                ++i;
            }
        }
        catch (Exception x) {
            if (x instanceof BuildException) {
                throw (BuildException)x;
            }
            throw new BuildException((Throwable)x);
        }
        Throwable result = Main.process(arguments.toArray(new String[arguments.size()]));
        if (result != null) {
            throw new BuildException(result);
        }
    }
}

