/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.koto.io;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class SafePrintWriter
extends Writer {
    protected final Writer out;
    private final boolean autoFlush;
    private final String lineSeparator;
    private final int lineNumber = 1;

    public SafePrintWriter(Writer out) {
        this(out, false);
    }

    public SafePrintWriter(Writer out, boolean autoFlush) {
        super((Object)out);
        this.out = out;
        this.autoFlush = autoFlush;
        this.lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    public SafePrintWriter(OutputStream out) {
        this(out, false);
    }

    public SafePrintWriter(OutputStream out, boolean autoFlush) {
        this(new OutputStreamWriter(out instanceof FileOutputStream ? new BufferedOutputStream(out) : out), autoFlush);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void write(int c) throws IOException {
        this.out.write(c);
        if (this.autoFlush && (c == 10 || c == 13)) {
            this.flush();
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(cbuf, off, len);
        if (this.autoFlush) {
            int i = 0;
            while (i < len) {
                char ch = cbuf[i + off];
                if (ch == '\n' || ch == '\r') {
                    this.flush();
                    return;
                }
                ++i;
            }
        }
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(String s, int off, int len) throws IOException {
        this.out.write(s, off, len);
        if (this.autoFlush) {
            int i = 0;
            while (i < len) {
                char ch = s.charAt(i + off);
                if (ch == '\n' || ch == '\r') {
                    this.flush();
                    return;
                }
                ++i;
            }
        }
    }

    public void write(String s) throws IOException {
        this.write(s, 0, s.length());
    }

    public void print(boolean b) throws IOException {
        this.out.write(String.valueOf(b));
    }

    public void print(char c) throws IOException {
        this.write(c);
    }

    public void print(int i) throws IOException {
        this.out.write(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.out.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.out.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.out.write(String.valueOf(d));
    }

    public void print(char[] s) throws IOException {
        this.write(s);
    }

    public void print(String s) throws IOException {
        this.write(s);
    }

    public void print(Object obj) throws IOException {
        this.write(obj.toString());
    }

    public void println() throws IOException {
        this.out.write(this.lineSeparator);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void println(boolean x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(char x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(int x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(long x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(float x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(double x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(char[] x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(String x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(Object x) throws IOException {
        this.print(x);
        this.println();
    }
}

