/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import parser.Parser;
import parser.Syntax;

public class Main {
    private final Map nameToHTML = new LinkedHashMap();

    public String get(String name) {
        return (String)this.nameToHTML.get(name);
    }

    public Main(File input) throws Exception {
        this(input, null);
    }

    public Main(File input, PrintWriter output) throws Exception {
        Syntax.Root root = new Parser().parseRoot(input);
        root.accept(new Syntax.Visitor(){

            public void visit(Syntax.Node node) {
                if (node instanceof Syntax.TypeDefinition) {
                    Syntax.TypeDefinition def = (Syntax.TypeDefinition)node;
                    if (def.abstractKeyword() == null) {
                        this.pick(def, def.expression());
                    }
                } else if (node instanceof Syntax.AliasDefinition) {
                    Syntax.AliasDefinition def = (Syntax.AliasDefinition)node;
                    this.pick(def, def.expression());
                }
            }

            public void pick(Syntax.Definition def, Syntax.Expression expression) {
                String name = def.identifier().getImage();
                String html = Main.getHTML(name, expression);
                Main.this.nameToHTML.put(name, html);
            }
        });
        if (output != null) {
            output.println("<!doctype html public \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            output.println("<html>");
            output.println("<head>");
            output.println("<meta http-equiv='Content-Script-Type' content='text/javascript'>");
            output.println("<title>" + Main.encode(input.getName()) + "</title>");
            output.println("<script type='text/javascript'><!--");
            output.println("var oldDecoration = \"none\";\nfunction getTarget(element) {\n  if (document.all) {\n    var id = null;\n    if (element.href != null) {\n      id = element.href;\n      var index = id.indexOf(\"#\");\n      if (index < 0)\n        id = null;\n      else\n        id = id.substring(index + 1);\n    }\n    if (id != null) {\n      var target = document.all.item(id, 0);\n      if (target != null) {\n        return target;\n      }\n    }\n  }\n  return null;\n}\nfunction highlightTarget(element) {\n  var target = getTarget(element);\n  if (target != null) {\n    oldDecoration = target.style.textDecoration;\n    target.style.textDecoration = \"underline\";\n  }\n}\nfunction unhighlightTarget(element) {\n  var target = getTarget(element);\n  if (target != null) {\n    target.style.textDecoration = oldDecoration;\n  }\n}\n");
            output.println("//--></script>");
            output.println("</head>");
            output.println("<body>");
            output.println("<pre>");
            Iterator it1 = this.nameToHTML.values().iterator();
            while (it1.hasNext()) {
                String html = (String)it1.next();
                output.println(html);
            }
            output.println("</pre>");
            output.println("</body></html>");
            output.flush();
        }
    }

    public static String getHTML(String name, Syntax.Expression expression) {
        StringBuffer result = new StringBuffer();
        result.append("<a id='syntax:" + Main.encode(name) + "' name='syntax:" + Main.encode(name) + "' class='syntax'>");
        result.append(Main.encode(name));
        result.append("</a>");
        result.append(" ");
        result.append("::=");
        result.append(" ");
        Main.getHTML(result, 0, expression);
        return result.toString();
    }

    private static void getHTML(StringBuffer buffer, int level, Syntax.Expression expression) {
        Syntax.Expression operand;
        Syntax.Expression exp;
        if (expression instanceof Syntax.IdentifierExpression) {
            Syntax.IdentifierExpression exp2 = (Syntax.IdentifierExpression)expression;
            String name = exp2.name().identifier().getImage();
            buffer.append("<a href='#syntax:" + Main.encode(name) + "' class='syntax' onMouseOver='highlightTarget(this)' onMouseOut='unhighlightTarget(this)'>");
            buffer.append(Main.encode(name));
            buffer.append("</a>");
            return;
        }
        if (expression instanceof Syntax.StringExpression) {
            Syntax.StringExpression exp3 = (Syntax.StringExpression)expression;
            buffer.append(Main.encode(exp3.string().token().getImage()));
            return;
        }
        if (expression instanceof Syntax.PlusExpression) {
            Syntax.PlusExpression exp4 = (Syntax.PlusExpression)expression;
            if (level > 2) {
                buffer.append("( ");
            }
            Main.getHTML(buffer, 2, exp4.operand());
            buffer.append(Main.encode("+"));
            if (level > 2) {
                buffer.append(" )");
            }
            return;
        }
        if (expression instanceof Syntax.SelectiveExpression) {
            Syntax.Expression operand2;
            exp = (Syntax.SelectiveExpression)expression;
            boolean hitsEmpty = false;
            ArrayList<Syntax.Expression> nonemptyOperans = new ArrayList<Syntax.Expression>(exp.operands().size());
            Iterator it2 = exp.operands().iterator();
            while (it2.hasNext()) {
                operand2 = (Syntax.Expression)it2.next();
                boolean e = false;
                if (operand2 instanceof Syntax.SequentialExpression && ((Syntax.SequentialExpression)operand2).operands().isEmpty()) {
                    e = true;
                }
                if (e) {
                    hitsEmpty = true;
                    continue;
                }
                nonemptyOperans.add(operand2);
            }
            if (hitsEmpty) {
                if (nonemptyOperans.isEmpty()) {
                    return;
                }
                if (nonemptyOperans.size() == 1) {
                    operand2 = (Syntax.Expression)nonemptyOperans.get(0);
                    if (operand2 instanceof Syntax.PlusExpression) {
                        Syntax.PlusExpression pex = (Syntax.PlusExpression)operand2;
                        if (level > 2) {
                            buffer.append("( ");
                        }
                        Main.getHTML(buffer, 2, pex.operand());
                        buffer.append(Main.encode("*"));
                        if (level > 2) {
                            buffer.append(" )");
                        }
                    } else {
                        Main.getHTML(buffer, 2, operand2);
                        buffer.append(Main.encode("?"));
                    }
                    return;
                }
                buffer.append("( ");
                Iterator it0 = nonemptyOperans.iterator();
                while (it0.hasNext()) {
                    Syntax.Expression operand3 = (Syntax.Expression)it0.next();
                    Main.getHTML(buffer, 1, operand3);
                    if (!it0.hasNext()) continue;
                    buffer.append(" ");
                }
                buffer.append(" )");
                buffer.append(Main.encode("?"));
                return;
            }
        }
        if (expression instanceof Syntax.SequentialExpression) {
            exp = (Syntax.SequentialExpression)expression;
            if (exp.operands().isEmpty()) {
                return;
            }
            if (exp.operands().size() == 1) {
                Main.getHTML(buffer, level, (Syntax.Expression)exp.operands().get(0));
                return;
            }
            if (level > 1) {
                buffer.append("( ");
            }
            Iterator it0 = exp.operands().iterator();
            while (it0.hasNext()) {
                operand = (Syntax.Expression)it0.next();
                Main.getHTML(buffer, 1, operand);
                if (!it0.hasNext()) continue;
                buffer.append(" ");
            }
            if (level > 1) {
                buffer.append(" )");
            }
            return;
        }
        if (expression instanceof Syntax.SelectiveExpression) {
            exp = (Syntax.SelectiveExpression)expression;
            if (exp.operands().isEmpty()) {
                return;
            }
            if (exp.operands().size() == 1) {
                Main.getHTML(buffer, level, (Syntax.Expression)exp.operands().get(0));
                return;
            }
            if (level > 0) {
                buffer.append("( ");
            }
            Iterator it0 = exp.operands().iterator();
            while (it0.hasNext()) {
                operand = (Syntax.Expression)it0.next();
                Main.getHTML(buffer, 0, operand);
                if (!it0.hasNext()) continue;
                buffer.append(" | ");
            }
            if (level > 0) {
                buffer.append(" )");
            }
            return;
        }
        throw new AssertionError();
    }

    private static String encode(String image) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < image.length()) {
            char ch = image.charAt(i);
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9') {
                result.append(ch);
            } else if (ch == '_') {
                result.append(ch);
            } else {
                result.append("&#" + ch + ";");
            }
            ++i;
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("usage: notavacc2html <file>");
                return;
            }
            PrintWriter output = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
            try {
                new Main(new File(args[0]), output);
                Object var3_3 = null;
                output.close();
                if (!output.checkError()) return;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                output.close();
                if (!output.checkError()) throw throwable;
                throw new IOException();
            }
            throw new IOException();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

